/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.backend.expression.MVELExpressionEvaluator;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mvel2.CompileException;

public class MVELExpressionEvaluatorTest {
    MVELExpressionEvaluator evaluator = new MVELExpressionEvaluator(MVELExpressionEvaluatorTest.class.getClassLoader());

    @Test
    public void evaluateUnaryExpression() {
        Assert.assertTrue((boolean)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression("java.util.Objects.equals(actualValue, \"Test\")"), (Object)"Test", String.class));
        Assert.assertFalse((boolean)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression("java.util.Objects.equals(actualValue, \"Test\")"), (Object)"Test1", String.class));
        Assert.assertTrue((boolean)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression("1"), (Object)1, Integer.class));
        Assert.assertFalse((boolean)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression("2"), (Object)1, Integer.class));
        Assert.assertTrue((boolean)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression(""), null, String.class));
        Assert.assertFalse((boolean)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression(""), (Object)"", String.class));
        Assert.assertTrue((boolean)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression(null), null, String.class));
        Assert.assertFalse((boolean)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression(null), (Object)"null", String.class));
        Assert.assertTrue((boolean)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression("\"\""), (Object)"", String.class));
        Assert.assertFalse((boolean)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression(null), (Object)"", String.class));
        Assert.assertTrue((boolean)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression("actualValue == 123"), (Object)123, Integer.class));
        Assert.assertTrue((boolean)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression("actualValue != 123"), (Object)321, Integer.class));
        Assert.assertFalse((boolean)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression("actualValue == 123"), (Object)321, Integer.class));
        Assert.assertFalse((boolean)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression("actualValue != 123"), (Object)123, Integer.class));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.evaluator.evaluateUnaryExpression(null, (Object)"", String.class)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Malformed MVEL expression");
    }

    @Test
    public void evaluateLiteralExpression() {
        Assert.assertEquals((Object)1, (Object)this.evaluator.evaluateLiteralExpression(MVELExpressionEvaluatorTest.mvelExpression("1"), Integer.class.getCanonicalName(), Collections.emptyList()));
        Assert.assertEquals((Object)"Value", (Object)this.evaluator.evaluateLiteralExpression(MVELExpressionEvaluatorTest.mvelExpression("\"Value\""), String.class.getCanonicalName(), Collections.emptyList()));
        Assert.assertEquals((Object)6, (Object)this.evaluator.evaluateLiteralExpression(MVELExpressionEvaluatorTest.mvelExpression("2 * 3"), Integer.class.getCanonicalName(), Collections.emptyList()));
        Assert.assertEquals((Object)14, (Object)this.evaluator.evaluateLiteralExpression(MVELExpressionEvaluatorTest.mvelExpression("-1 + (3 * 5)"), Integer.class.getCanonicalName(), Collections.emptyList()));
        Assert.assertEquals(Arrays.asList("Jim"), (Object)this.evaluator.evaluateLiteralExpression(MVELExpressionEvaluatorTest.mvelExpression("[\"Jim\"]"), ArrayList.class.getCanonicalName(), Collections.emptyList()));
        Assert.assertEquals(Collections.emptyList(), (Object)this.evaluator.evaluateLiteralExpression(MVELExpressionEvaluatorTest.mvelExpression("[]"), ArrayList.class.getCanonicalName(), Collections.emptyList()));
        Assertions.assertThat((Object)this.evaluator.evaluateLiteralExpression(MVELExpressionEvaluatorTest.mvelExpression("\"abc..\"[2]"), Character.class.getCanonicalName(), Collections.emptyList())).isEqualTo((Object)Character.valueOf('c'));
        Assertions.assertThat((Object)this.evaluator.evaluateLiteralExpression(MVELExpressionEvaluatorTest.mvelExpression("1.234B"), BigDecimal.class.getCanonicalName(), Collections.emptyList())).isEqualTo((Object)new BigDecimal("1.234"));
        Assertions.assertThat((Object)this.evaluator.evaluateLiteralExpression(MVELExpressionEvaluatorTest.mvelExpression("1.234d"), Double.class.getCanonicalName(), Collections.emptyList())).isEqualTo((Object)Double.valueOf("1.234"));
        Assert.assertEquals((Object)"Value", (Object)this.evaluator.evaluateLiteralExpression("# \"Value\"", String.class.getCanonicalName(), Collections.emptyList()));
        Assert.assertEquals((Object)3, (Object)this.evaluator.evaluateLiteralExpression("# a = 1; b = 2; a+b;", Integer.class.getCanonicalName(), Collections.emptyList()));
        Assert.assertEquals((Object)"Test", (Object)this.evaluator.evaluateLiteralExpression("# a = \"Te\"; b = \"st\"; a+b;", String.class.getCanonicalName(), Collections.emptyList()));
        Assertions.assertThatThrownBy(() -> this.evaluator.evaluateLiteralExpression("# a = 1 b = 2 a+b;", Integer.class.getCanonicalName(), Collections.emptyList())).isInstanceOf(CompileException.class);
        Assertions.assertThatThrownBy(() -> this.evaluator.evaluateLiteralExpression("# a = 1; a+b;", Integer.class.getCanonicalName(), Collections.emptyList())).isInstanceOf(CompileException.class);
        Assertions.assertThatThrownBy(() -> this.evaluator.evaluateLiteralExpression("1+", String.class.getCanonicalName(), Collections.emptyList())).isInstanceOf(RuntimeException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.evaluator.evaluateLiteralExpression(MVELExpressionEvaluatorTest.mvelExpression("1"), String.class.getCanonicalName(), Collections.emptyList())).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot assign a 'java.lang.Integer");
    }

    @Ignore(value="https://issues.redhat.com/browse/DROOLS-4649")
    @Test
    public void evaluateLiteralExpression_Array() {
        Assertions.assertThat((Object)this.evaluator.evaluateLiteralExpression(MVELExpressionEvaluatorTest.mvelExpression("{\"Jim\", \"Michael\"}"), Object[].class.getCanonicalName(), Collections.emptyList())).isEqualTo((Object)new String[]{"Jim", "Michael"});
        Assertions.assertThat((Object)this.evaluator.evaluateLiteralExpression(MVELExpressionEvaluatorTest.mvelExpression("{ }"), Object[].class.getCanonicalName(), Collections.emptyList())).isEqualTo((Object)new String[0]);
    }

    @Test
    public void fromObjectToExpression() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.evaluator.fromObjectToExpression(null)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("The condition has not been satisfied");
    }

    @Test
    public void cleanExpression() {
        Assert.assertEquals((Object)"test", (Object)this.evaluator.cleanExpression("#test"));
        Assert.assertEquals((Object)" test", (Object)this.evaluator.cleanExpression("# test"));
        Assert.assertEquals((Object)" # test", (Object)this.evaluator.cleanExpression("# # test"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.evaluator.cleanExpression("test")).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Malformed MVEL expression");
    }

    private static String mvelExpression(String expression) {
        return "# " + expression;
    }
}

