/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import com.fasterxml.jackson.databind.node.TextNode;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.backend.expression.DMNFeelExpressionEvaluator;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.runtime.events.FEELEventBase;
import org.kie.dmn.feel.runtime.events.SyntaxErrorEvent;

public class DMNFeelExpressionEvaluatorTest {
    DMNFeelExpressionEvaluator expressionEvaluator = new DMNFeelExpressionEvaluator(this.getClass().getClassLoader());

    @Test
    public void evaluateUnaryExpression() {
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression("not( true )", (Object)false, Boolean.TYPE));
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression(">2, >5", (Object)BigDecimal.valueOf(6L), BigDecimal.class));
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression("abs(-1)", (Object)BigDecimal.valueOf(1L), BigDecimal.class));
        Assert.assertFalse((boolean)this.expressionEvaluator.evaluateUnaryExpression("abs(-1)", (Object)BigDecimal.valueOf(-1L), BigDecimal.class));
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression("max(1, ?) > 1", (Object)BigDecimal.valueOf(2L), BigDecimal.class));
        Assert.assertFalse((boolean)this.expressionEvaluator.evaluateUnaryExpression("max(1, ?) < 1", (Object)BigDecimal.valueOf(2L), BigDecimal.class));
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression("? = 2", (Object)BigDecimal.valueOf(2L), BigDecimal.class));
        Assert.assertFalse((boolean)this.expressionEvaluator.evaluateUnaryExpression("? > 2", (Object)BigDecimal.valueOf(2L), BigDecimal.class));
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression("? + 1 > ?", (Object)BigDecimal.valueOf(2L), BigDecimal.class));
        Map<String, BigDecimal> contextValue = Collections.singletonMap("key_a", BigDecimal.valueOf(1L));
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression("{key_a : 1}", contextValue, Map.class));
        Assert.assertFalse((boolean)this.expressionEvaluator.evaluateUnaryExpression("{key_a : 2}", contextValue, Map.class));
        List<BigDecimal> contextListValue = Collections.singletonList(BigDecimal.valueOf(23L));
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("23").toString(), contextListValue, List.class));
        Assert.assertFalse((boolean)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("2").toString(), contextListValue, List.class));
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("? = [23]").toString(), contextListValue, List.class));
        Assert.assertFalse((boolean)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("? = [2]").toString(), contextListValue, List.class));
        List<BigDecimal> contextListValue2 = Arrays.asList(BigDecimal.valueOf(23L), BigDecimal.valueOf(32L));
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression(new TextNode(" ? = [23, 32]").toString(), contextListValue2, List.class));
        Assert.assertFalse((String)"Collection unary expression needs to start with ?", (boolean)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("[23, 32]").toString(), contextListValue2, List.class));
        Assert.assertFalse((boolean)this.expressionEvaluator.evaluateUnaryExpression(new TextNode(" ? = [23, 32, 123]").toString(), contextListValue2, List.class));
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression(new TextNode(" ?[1] = 23").toString(), contextListValue2, List.class));
        Assert.assertFalse((boolean)this.expressionEvaluator.evaluateUnaryExpression(new TextNode(" ?[1] = 32").toString(), contextListValue2, List.class));
        HashMap<String, Object> firstMap = new HashMap<String, Object>();
        firstMap.put("Price", new BigDecimal(2000));
        firstMap.put("Name", "PC");
        HashMap<String, Object> secondMap = new HashMap<String, Object>();
        secondMap.put("Price", new BigDecimal(3300));
        secondMap.put("Name", "CAR");
        String firstParameter = "{Price: 2000,Name:\"PC\"}";
        String secondParameter = "{Price:3300, Name:\"CAR\"}";
        List<Map> context = Arrays.asList(firstMap, secondMap);
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("?=[" + firstParameter + ", " + secondParameter + "]").toString(), context, List.class));
        Assert.assertFalse((boolean)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("?=[{Price: 2001,Name:\"PC\"}, {Price:3301,Name:\"CAR\"}]").toString(), context, List.class));
        Assert.assertFalse((boolean)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("?=[{Price: 2000, Name:\"PCA\"}, {Price:3300,Name:\"CARE\"}]").toString(), context, List.class));
        Assert.assertFalse((boolean)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("?=[{Pric: 2000, Name:\"PC\"}, {Price:3300,Names:\"CARE\"}]").toString(), context, List.class));
        Assert.assertFalse((boolean)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("?=[" + secondParameter + ", " + firstParameter + "]").toString(), context, List.class));
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression(new TextNode(firstParameter + " in ?").toString(), context, List.class));
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression(new TextNode(secondParameter + " in ?").toString(), context, List.class));
        Assert.assertFalse((boolean)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("{Price: 2001,Name:\"PC\"} in ?").toString(), context, List.class));
        Assert.assertFalse((boolean)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("{Price: 3300,Name:\"CARE\"} in ?").toString(), context, List.class));
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("(" + firstParameter + " in ?) and (" + secondParameter + " in ?)").toString(), context, List.class));
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("(" + secondParameter + " in ?) and (" + firstParameter + " in ?)").toString(), context, List.class));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.expressionEvaluator.evaluateUnaryExpression("variable", null, null)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Error during evaluation:");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.expressionEvaluator.evaluateUnaryExpression("! true", null, null)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Syntax error:");
        Assertions.assertThatThrownBy(() -> this.expressionEvaluator.evaluateUnaryExpression("? > 2", null, BigDecimal.class)).isInstanceOf(NullPointerException.class);
    }

    @Test
    public void evaluateLiteralExpression() {
        Assert.assertEquals((Object)BigDecimal.valueOf(5L), (Object)this.expressionEvaluator.evaluateLiteralExpression("2 + 3", BigDecimal.class.getCanonicalName(), null));
        Map parsedValue = (Map)this.expressionEvaluator.evaluateLiteralExpression("{key_a : 1}", Map.class.getCanonicalName(), Collections.emptyList());
        Assert.assertTrue((boolean)parsedValue.containsKey("key_a"));
        Assert.assertEquals(parsedValue.get("key_a"), (Object)BigDecimal.valueOf(1L));
        List parsedValueListExpression = (List)this.expressionEvaluator.evaluateLiteralExpression(new TextNode("[10, 12]").toString(), List.class.getCanonicalName(), Collections.emptyList());
        Assert.assertTrue((parsedValueListExpression.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)BigDecimal.valueOf(10L), parsedValueListExpression.get(0));
        Assert.assertEquals((Object)BigDecimal.valueOf(12L), parsedValueListExpression.get(1));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.expressionEvaluator.evaluateLiteralExpression("SPEED", String.class.getCanonicalName(), null)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Error during evaluation:");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.expressionEvaluator.evaluateLiteralExpression("\"SPEED", String.class.getCanonicalName(), null)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Syntax error:");
    }

    @Test
    public void expressionTest() {
        String listJsonString = "[{\"name\": \"\\\"John\\\"\"}, {\"name\": \"\\\"John\\\"\", \"names\" : [{\"value\": \"\\\"Anna\\\"\"}, {\"value\": \"\\\"Mario\\\"\"}]}]";
        List parsedValue = (List)this.expressionEvaluator.convertResult(listJsonString, List.class.getCanonicalName(), Collections.singletonList(Map.class.getCanonicalName()));
        Assert.assertEquals((long)2L, (long)parsedValue.size());
        Assert.assertEquals((long)2L, (long)((List)((Map)parsedValue.get(1)).get("names")).size());
        Assert.assertTrue((boolean)((List)((Map)parsedValue.get(1)).get("names")).contains("Anna"));
        String mapJsonString = "{\"first\": {\"name\": \"\\\"John\\\"\"}}";
        Map parsedMap = (Map)this.expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), Arrays.asList(String.class.getCanonicalName(), Object.class.getCanonicalName()));
        Assert.assertEquals((long)1L, (long)parsedMap.size());
        Assert.assertEquals((Object)"John", ((Map)parsedMap.get("first")).get("name"));
        mapJsonString = "{\"first\": {\"siblings\": [{\"name\" : \"\\\"John\\\"\"}]}}";
        parsedMap = (Map)this.expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), Arrays.asList(String.class.getCanonicalName(), Object.class.getCanonicalName()));
        Assert.assertEquals((long)1L, (long)parsedMap.size());
        Assert.assertEquals((Object)"John", ((Map)((List)((Map)parsedMap.get("first")).get("siblings")).get(0)).get("name"));
        mapJsonString = "{\"first\": {\"phones\": {\"number\" : \"1\"}}}";
        parsedMap = (Map)this.expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), Arrays.asList(String.class.getCanonicalName(), Object.class.getCanonicalName()));
        Assert.assertEquals((long)1L, (long)parsedMap.size());
        Assert.assertEquals((Object)BigDecimal.valueOf(1L), ((Map)((Map)parsedMap.get("first")).get("phones")).get("number"));
    }

    @Test
    public void fromObjectToExpressionTest() {
        Assert.assertEquals((Object)"\"Test\"", (Object)this.expressionEvaluator.fromObjectToExpression((Object)"Test"));
        Assert.assertEquals((Object)"false", (Object)this.expressionEvaluator.fromObjectToExpression((Object)false));
        Assert.assertEquals((Object)"1", (Object)this.expressionEvaluator.fromObjectToExpression((Object)BigDecimal.valueOf(1L)));
        Assert.assertEquals((Object)"date( \"2019-05-13\" )", (Object)this.expressionEvaluator.fromObjectToExpression((Object)LocalDate.of(2019, 5, 13)));
        Assert.assertEquals((Object)"null", (Object)this.expressionEvaluator.fromObjectToExpression(null));
    }

    @Test
    public void listenerTest() {
        SyntaxErrorEvent syntaxErrorEvent = new SyntaxErrorEvent(FEELEvent.Severity.ERROR, "test", null, 0, 0, null);
        FEELEventBase genericError = new FEELEventBase(FEELEvent.Severity.ERROR, "error", null);
        FEELEventBase notError = new FEELEventBase(FEELEvent.Severity.INFO, "info", null);
        AtomicReference error = new AtomicReference();
        FEEL feel = this.expressionEvaluator.newFeelEvaluator(error);
        this.applyEvents(Collections.singletonList(syntaxErrorEvent), feel);
        Assert.assertEquals((Object)syntaxErrorEvent, error.get());
        error.set(null);
        this.applyEvents(Arrays.asList(genericError, syntaxErrorEvent), feel);
        Assert.assertEquals((Object)syntaxErrorEvent, error.get());
        error.set(null);
        this.applyEvents(Arrays.asList(syntaxErrorEvent, genericError), feel);
        Assert.assertEquals((Object)syntaxErrorEvent, error.get());
        error.set(null);
        this.applyEvents(Collections.singletonList(notError), feel);
        Assert.assertNull(error.get());
    }

    private void applyEvents(List<FEELEvent> events, FEEL feel) {
        for (FEELEvent event : events) {
            feel.getListeners().forEach(listener -> listener.onEvent(event));
        }
    }

    @Test
    public void expressionListTest() {
        String expressionCollectionJsonString = new TextNode("[ 1, 10 ]").toString();
        List result = (List)this.expressionEvaluator.convertResult(expressionCollectionJsonString, List.class.getCanonicalName(), Collections.EMPTY_LIST);
        Assert.assertTrue((result.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)BigDecimal.ONE, result.get(0));
        Assert.assertEquals((Object)BigDecimal.TEN, result.get(1));
    }

    @Test
    public void expressionObjectListTest() {
        String expressionCollectionJsonString = new TextNode("[{age:10},{name:\"John\"}]").toString();
        List result = (List)this.expressionEvaluator.convertResult(expressionCollectionJsonString, List.class.getCanonicalName(), Collections.EMPTY_LIST);
        Assert.assertTrue((result.size() == 2 ? 1 : 0) != 0);
        Assertions.assertThat((Map)((Map)result.get(0))).containsOnly(new Map.Entry[]{Assertions.entry((Object)"age", (Object)BigDecimal.TEN)});
        Assertions.assertThat((Map)((Map)result.get(1))).containsOnly(new Map.Entry[]{Assertions.entry((Object)"name", (Object)"John")});
    }

    @Test(expected=IllegalArgumentException.class)
    public void expressionListTest_Wrong() {
        String expressionCollectionJsonString = new TextNode("[ 1 : 234").toString();
        this.expressionEvaluator.convertResult(expressionCollectionJsonString, List.class.getCanonicalName(), Collections.EMPTY_LIST);
    }

    @Test
    public void expressionMapTest() {
        String expressionCollectionJsonString = new TextNode("{ x : 5, y : 3 }").toString();
        Map result = (Map)this.expressionEvaluator.convertResult(expressionCollectionJsonString, Map.class.getCanonicalName(), Collections.EMPTY_LIST);
        Assert.assertTrue((result.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)BigDecimal.valueOf(5L), result.get("x"));
        Assert.assertEquals((Object)BigDecimal.valueOf(3L), result.get("y"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void expressionMapTest_Wrong() {
        String expressionCollectionJsonString = new TextNode(": 5 y : 3 }").toString();
        this.expressionEvaluator.convertResult(expressionCollectionJsonString, Map.class.getCanonicalName(), Collections.EMPTY_LIST);
    }

    @Test
    public void expressionListVerifyResultTest() {
        String expressionCollectionJsonString = new TextNode("10").toString();
        List<BigDecimal> contextValue = Collections.singletonList(BigDecimal.valueOf(10L));
        Assert.assertTrue((boolean)this.expressionEvaluator.verifyResult(expressionCollectionJsonString, contextValue, List.class));
    }

    @Test
    public void expressionMapVerifyResultTest() {
        String expressionCollectionJsonString = new TextNode("{key_a : 1}").toString();
        Map<String, BigDecimal> contextValue = Collections.singletonMap("key_a", BigDecimal.valueOf(1L));
        Assert.assertTrue((boolean)this.expressionEvaluator.verifyResult(expressionCollectionJsonString, contextValue, Map.class));
    }

    @Test
    public void isStructuredInput() {
        Assert.assertTrue((boolean)this.expressionEvaluator.isStructuredInput(List.class.getCanonicalName()));
        Assert.assertTrue((boolean)this.expressionEvaluator.isStructuredInput(ArrayList.class.getCanonicalName()));
        Assert.assertTrue((boolean)this.expressionEvaluator.isStructuredInput(LinkedList.class.getCanonicalName()));
        Assert.assertFalse((boolean)this.expressionEvaluator.isStructuredInput(Map.class.getCanonicalName()));
        Assert.assertFalse((boolean)this.expressionEvaluator.isStructuredInput(HashMap.class.getCanonicalName()));
        Assert.assertFalse((boolean)this.expressionEvaluator.isStructuredInput(LinkedHashMap.class.getCanonicalName()));
        Assert.assertFalse((boolean)this.expressionEvaluator.isStructuredInput(Set.class.getCanonicalName()));
        Assert.assertFalse((boolean)this.expressionEvaluator.isStructuredInput(Integer.class.getCanonicalName()));
        Assert.assertFalse((boolean)this.expressionEvaluator.isStructuredInput(String.class.getCanonicalName()));
    }
}

