/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.scenariosimulation.api.model.AuditLog;
import org.drools.scenariosimulation.api.model.AuditLogLine;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.SimulationRunMetadata;
import org.drools.scenariosimulation.backend.TestUtils;
import org.drools.scenariosimulation.backend.runner.SimulationRunMetadataBuilder;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNMessage;

public class SimulationRunMetadataBuilderTest {
    @Test
    public void build() {
        ScenarioWithIndex scenarioWithIndex1 = new ScenarioWithIndex(1, new Scenario());
        ScenarioResultMetadata result1 = new ScenarioResultMetadata(scenarioWithIndex1);
        result1.addExecuted("d1");
        result1.addExecuted("d2");
        result1.addAvailable("d1");
        result1.addAvailable("d2");
        result1.addAvailable("d3");
        List<DMNMessage> messagesResult1decision1 = TestUtils.getRandomlyGeneratedDMNMessageList();
        List<DMNMessage> messagesResult1decision2 = TestUtils.getRandomlyGeneratedDMNMessageList();
        Map<Integer, List<String>> expectedResult1Decision1 = this.fillAuditMessagesForDecision(result1, messagesResult1decision1, "d1");
        Map<Integer, List<String>> expectedResult1Decision2 = this.fillAuditMessagesForDecision(result1, messagesResult1decision2, "d2");
        ScenarioResultMetadata result2 = new ScenarioResultMetadata(new ScenarioWithIndex(2, new Scenario()));
        List<String> expectedDecisionsResult2 = Arrays.asList("d1", "d3");
        result2.addExecuted(expectedDecisionsResult2.get(0));
        result2.addExecuted(expectedDecisionsResult2.get(1));
        result2.addAvailable("d1");
        result2.addAvailable("d2");
        result2.addAvailable("d3");
        List<DMNMessage> messagesResult2decision1 = TestUtils.getRandomlyGeneratedDMNMessageList();
        List<DMNMessage> messagesResult2decision3 = TestUtils.getRandomlyGeneratedDMNMessageList();
        Map<Integer, List<String>> expectedResult2Decision1 = this.fillAuditMessagesForDecision(result1, messagesResult2decision1, "d1");
        Map<Integer, List<String>> expectedResult2Decision3 = this.fillAuditMessagesForDecision(result1, messagesResult2decision3, "d3");
        SimulationRunMetadataBuilder builder = SimulationRunMetadataBuilder.create();
        builder.addScenarioResultMetadata(result1);
        builder.addScenarioResultMetadata(result2);
        SimulationRunMetadata build = builder.build();
        Assert.assertEquals((long)3L, (long)build.getAvailable());
        Assert.assertEquals((long)3L, (long)build.getExecuted());
        Assert.assertEquals((double)100.0, (double)build.getCoveragePercentage(), (double)0.1);
        Assert.assertEquals((double)2.0, (double)((Integer)build.getOutputCounter().get("d1")).intValue(), (double)0.1);
        Assert.assertEquals((double)1.0, (double)((Integer)build.getOutputCounter().get("d2")).intValue(), (double)0.1);
        Assert.assertEquals((double)2.0, (double)((Map)build.getScenarioCounter().get(scenarioWithIndex1)).size(), (double)0.1);
        AuditLog retrieved = build.getAuditLog();
        Assert.assertNotNull((Object)retrieved);
        List auditLogLines = retrieved.getAuditLogLines();
        Assert.assertNotNull((Object)auditLogLines);
        Assert.assertEquals((long)auditLogLines.size(), (long)(messagesResult1decision1.size() + messagesResult1decision2.size() + messagesResult2decision1.size() + messagesResult2decision3.size()));
        this.checkAuditLogLine(auditLogLines, expectedResult1Decision1, expectedResult1Decision2, expectedResult2Decision1, expectedResult2Decision3);
    }

    private void checkAuditLogLine(List<AuditLogLine> auditLogLines, Map<Integer, List<String>> ... expectedDecisionResults) {
        int auditLineCounter = 0;
        for (int externalCounter = 0; externalCounter < expectedDecisionResults.length; ++externalCounter) {
            Map<Integer, List<String>> expectedDecisionResult = expectedDecisionResults[externalCounter];
            for (int internalCounter = 0; internalCounter < expectedDecisionResult.size(); ++internalCounter) {
                List<String> expectedMessageParameters = expectedDecisionResult.get(internalCounter + 1);
                if (expectedMessageParameters.size() == 3) {
                    TestUtils.commonCheckAuditLogLine(auditLogLines.get(auditLineCounter), expectedMessageParameters.get(0), expectedMessageParameters.get(1), expectedMessageParameters.get(2));
                } else {
                    TestUtils.commonCheckAuditLogLine(auditLogLines.get(auditLineCounter), expectedMessageParameters.get(0), expectedMessageParameters.get(1), null);
                }
                ++auditLineCounter;
            }
        }
    }

    private Map<Integer, List<String>> fillAuditMessagesForDecision(ScenarioResultMetadata scenarioResultMetadata, List<DMNMessage> messages, String decisionName) {
        HashMap<Integer, List<String>> expectedMessageParameters = new HashMap<Integer, List<String>>();
        AtomicInteger counter = new AtomicInteger(0);
        messages.forEach(message -> {
            ArrayList<String> parameters = new ArrayList<String>();
            int i = counter.addAndGet(1);
            DMNDecisionResult.DecisionEvaluationStatus status = DMNDecisionResult.DecisionEvaluationStatus.values()[new Random().nextInt(DMNDecisionResult.DecisionEvaluationStatus.values().length)];
            if (new Random().nextBoolean()) {
                scenarioResultMetadata.addAuditMessage(i, decisionName, status.toString());
                parameters.addAll(Arrays.asList(decisionName, status.toString()));
            } else {
                String messageContent = message.getLevel().name() + ": " + message.getText();
                scenarioResultMetadata.addAuditMessage(i, decisionName, status.toString(), messageContent);
                parameters.addAll(Arrays.asList(decisionName, status.toString(), messageContent));
            }
            expectedMessageParameters.put(i, parameters);
        });
        return expectedMessageParameters;
    }
}

