/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorFactory;
import org.drools.scenariosimulation.backend.runner.AbstractRunnerHelper;
import org.drools.scenariosimulation.backend.runner.AbstractScenarioRunner;
import org.drools.scenariosimulation.backend.runner.IndexedScenarioAssertionError;
import org.drools.scenariosimulation.backend.runner.IndexedScenarioException;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.ScenarioRunnerProvider;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerDTO;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.drools.scenariosimulation.backend.util.ScenarioSimulationServerMessages;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.kie.api.runtime.KieContainer;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class AbstractScenarioRunnerTest {
    private static final int SCENARIO_DATA = 5;
    @Mock
    protected KieContainer kieContainerMock;
    protected AbstractScenarioRunner abstractScenarioRunnerLocal;
    protected Settings settingsLocal;
    private ScenarioRunnerDTO scenarioRunnerDTOLocal;

    @Before
    public void setup() {
        this.settingsLocal = new Settings();
        this.scenarioRunnerDTOLocal = this.getScenarioRunnerDTO();
        this.abstractScenarioRunnerLocal = (AbstractScenarioRunner)Mockito.spy((Object)new AbstractScenarioRunner(this.kieContainerMock, this.scenarioRunnerDTOLocal, ExpressionEvaluatorFactory.create((ClassLoader)this.getClass().getClassLoader(), (ScenarioSimulationModel.Type)ScenarioSimulationModel.Type.RULE)){

            protected AbstractRunnerHelper newRunnerHelper() {
                return null;
            }
        });
    }

    @Test
    public void getDescriptionForSimulationByClassNameAndSimulation() {
        Description retrieved = AbstractScenarioRunner.getDescriptionForSimulation(Optional.empty(), (List)this.scenarioRunnerDTOLocal.getScenarioWithIndices());
        this.commonVerifyDescriptionForSimulation(retrieved, AbstractScenarioRunner.class.getSimpleName());
        retrieved = AbstractScenarioRunner.getDescriptionForSimulation(Optional.of("src/test/Test.scesim"), (List)this.scenarioRunnerDTOLocal.getScenarioWithIndices());
        this.commonVerifyDescriptionForSimulation(retrieved, "Test");
    }

    @Test
    public void getDescriptionForScenario() {
        Scenario scenario = (Scenario)((ScenarioWithIndex)this.scenarioRunnerDTOLocal.getScenarioWithIndices().get(2)).getScesimData();
        Description retrieved = AbstractScenarioRunner.getDescriptionForScenario(Optional.empty(), (int)1, (String)scenario.getDescription());
        this.commonVerifyDescriptionForScenario(retrieved, 1, scenario.getDescription(), AbstractScenarioRunner.class.getSimpleName());
        retrieved = AbstractScenarioRunner.getDescriptionForScenario(Optional.of("src/test/Test.scesim"), (int)1, (String)scenario.getDescription());
        this.commonVerifyDescriptionForScenario(retrieved, 1, scenario.getDescription(), "Test");
    }

    @Test
    public void getSpecificRunnerProvider() {
        for (ScenarioSimulationModel.Type value : ScenarioSimulationModel.Type.values()) {
            ScenarioRunnerProvider retrieved = AbstractScenarioRunner.getSpecificRunnerProvider((ScenarioSimulationModel.Type)value);
            Assert.assertNotNull((Object)retrieved);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void getSpecificRunnerProviderNullType() {
        this.settingsLocal.setType(null);
        AbstractScenarioRunner.getSpecificRunnerProvider(null);
    }

    @Test
    public void testRun() {
        ArgumentCaptor failureArgumentCaptor = ArgumentCaptor.forClass(Failure.class);
        ((AbstractScenarioRunner)Mockito.doThrow((Throwable[])new Throwable[]{new ScenarioException("Failed assertion", true)}).when((Object)this.abstractScenarioRunnerLocal)).internalRunScenario((ScenarioWithIndex)ArgumentMatchers.eq(this.scenarioRunnerDTOLocal.getScenarioWithIndices().get(0)), (ScenarioRunnerData)ArgumentMatchers.isA(ScenarioRunnerData.class), (Settings)ArgumentMatchers.any(), (Background)ArgumentMatchers.any());
        ((AbstractScenarioRunner)Mockito.doThrow((Throwable[])new Throwable[]{new ScenarioException("Generic exception")}).when((Object)this.abstractScenarioRunnerLocal)).internalRunScenario((ScenarioWithIndex)ArgumentMatchers.eq(this.scenarioRunnerDTOLocal.getScenarioWithIndices().get(1)), (ScenarioRunnerData)ArgumentMatchers.isA(ScenarioRunnerData.class), (Settings)ArgumentMatchers.any(), (Background)ArgumentMatchers.any());
        ((AbstractScenarioRunner)Mockito.doThrow((Throwable[])new Throwable[]{new ScenarioException((Throwable)new IllegalArgumentException("Wrong argument"))}).when((Object)this.abstractScenarioRunnerLocal)).internalRunScenario((ScenarioWithIndex)ArgumentMatchers.eq(this.scenarioRunnerDTOLocal.getScenarioWithIndices().get(2)), (ScenarioRunnerData)ArgumentMatchers.isA(ScenarioRunnerData.class), (Settings)ArgumentMatchers.any(), (Background)ArgumentMatchers.any());
        ((AbstractScenarioRunner)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Unknown exception")}).when((Object)this.abstractScenarioRunnerLocal)).internalRunScenario((ScenarioWithIndex)ArgumentMatchers.eq(this.scenarioRunnerDTOLocal.getScenarioWithIndices().get(3)), (ScenarioRunnerData)ArgumentMatchers.isA(ScenarioRunnerData.class), (Settings)ArgumentMatchers.any(), (Background)ArgumentMatchers.any());
        Assert.assertNull((Object)this.abstractScenarioRunnerLocal.simulationRunMetadataBuilder);
        RunNotifier runNotifier = (RunNotifier)Mockito.spy((Object)new RunNotifier());
        this.abstractScenarioRunnerLocal.run(runNotifier);
        Assert.assertNotNull((Object)this.abstractScenarioRunnerLocal.simulationRunMetadataBuilder);
        ((RunNotifier)Mockito.verify((Object)runNotifier, (VerificationMode)Mockito.times((int)7))).fireTestStarted((Description)ArgumentMatchers.isA(Description.class));
        ((RunNotifier)Mockito.verify((Object)runNotifier, (VerificationMode)Mockito.times((int)5))).fireTestFailure((Failure)failureArgumentCaptor.capture());
        ((RunNotifier)Mockito.verify((Object)runNotifier, (VerificationMode)Mockito.times((int)5))).fireTestFinished((Description)ArgumentMatchers.isA(Description.class));
        List capturedFailures = failureArgumentCaptor.getAllValues();
        Assert.assertEquals((Object)ScenarioSimulationServerMessages.getIndexedScenarioMessage((String)"Failed assertion", (int)1, (String)"INDEX-0", (String)"test"), (Object)((Failure)capturedFailures.get(0)).getException().getMessage());
        Assert.assertTrue((boolean)(((Failure)capturedFailures.get(0)).getException() instanceof IndexedScenarioAssertionError));
        Assert.assertEquals((Object)ScenarioSimulationServerMessages.getIndexedScenarioMessage((String)"Generic exception", (int)2, (String)"INDEX-1", (String)"test"), (Object)((Failure)capturedFailures.get(1)).getException().getMessage());
        Assert.assertTrue((boolean)(((Failure)capturedFailures.get(1)).getException() instanceof IndexedScenarioException));
        Assert.assertEquals((Object)ScenarioSimulationServerMessages.getIndexedScenarioMessage((String)"Wrong argument", (int)3, (String)"INDEX-2", (String)"test"), (Object)((Failure)capturedFailures.get(2)).getException().getMessage());
        Assert.assertTrue((boolean)(((Failure)capturedFailures.get(2)).getException() instanceof IndexedScenarioException));
        Assert.assertEquals((Object)ScenarioSimulationServerMessages.getIndexedScenarioMessage((String)"Unknown exception", (int)4, (String)"INDEX-3", (String)"test"), (Object)((Failure)capturedFailures.get(3)).getException().getMessage());
        Assert.assertTrue((boolean)(((Failure)capturedFailures.get(3)).getException() instanceof IndexedScenarioException));
    }

    @Test
    public void getScesimFileName() {
        Assert.assertEquals((Object)"Test", (Object)AbstractScenarioRunner.getScesimFileName((String)"src/test/Test.scesim"));
        Assert.assertEquals((Object)"Test", (Object)AbstractScenarioRunner.getScesimFileName((String)"Test.scesim"));
        Assert.assertEquals((Object)"Test", (Object)AbstractScenarioRunner.getScesimFileName((String)"Test"));
        Assert.assertEquals((Object)"Test.1", (Object)AbstractScenarioRunner.getScesimFileName((String)"src/test/Test.1.scesim"));
        Assert.assertEquals(null, (Object)AbstractScenarioRunner.getScesimFileName(null));
    }

    private void commonVerifyDescriptionForSimulation(Description retrieved, String className) {
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)className, (Object)retrieved.getDisplayName());
        Assert.assertEquals((long)5L, (long)retrieved.getChildren().size());
        Assert.assertNull((Object)retrieved.getTestClass());
        Assert.assertEquals((Object)className, (Object)retrieved.getClassName());
        IntStream.range(0, 5).forEach(index -> {
            Description description = (Description)retrieved.getChildren().get(index);
            this.commonVerifyDescriptionForScenario(description, index + 1, ((Scenario)((ScenarioWithIndex)this.scenarioRunnerDTOLocal.getScenarioWithIndices().get(index)).getScesimData()).getDescription(), className);
        });
    }

    private void commonVerifyDescriptionForScenario(Description description, int index, String scenarioDescription, String className) {
        String expected = String.format("#%1$d: %2$s(%3$s)", index, scenarioDescription, className);
        Assert.assertEquals((Object)expected, (Object)description.getDisplayName());
    }

    private ScenarioRunnerDTO getScenarioRunnerDTO() {
        Simulation simulation = new Simulation();
        IntStream.range(0, 5).forEach(index -> {
            Scenario scenario = (Scenario)simulation.addData();
            scenario.setDescription("INDEX-" + index);
        });
        ScenarioSimulationModel model = new ScenarioSimulationModel();
        model.setSimulation(simulation);
        return new ScenarioRunnerDTO(model, "test.scesim");
    }
}

