/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.fluent;

import java.util.Arrays;
import java.util.Collections;
import java.util.function.Function;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.backend.fluent.FactCheckerHandle;
import org.drools.scenariosimulation.backend.fluent.ValidateFactCommand;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.drools.scenariosimulation.backend.runner.model.ValueWrapper;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.internal.command.RegistryContext;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ValidateFactCommandTest {
    @Mock
    private KieSession kieSession;
    @Mock
    private ScenarioResult scenarioResult;
    @Mock
    private FactMappingValue factMappingValue;
    @Mock
    private RegistryContext registryContext;

    @Test
    public void executeTest() {
        Mockito.when((Object)this.registryContext.lookup(KieSession.class)).thenReturn((Object)this.kieSession);
        Function<Object, ValueWrapper> alwaysMatchFunction = ValueWrapper::of;
        ValidateFactCommand validateFactCommand = new ValidateFactCommand(Arrays.asList(new FactCheckerHandle(String.class, alwaysMatchFunction, this.scenarioResult)));
        Mockito.when((Object)this.kieSession.getObjects((ObjectFilter)Mockito.any(ObjectFilter.class))).thenReturn(Collections.singleton(null));
        validateFactCommand.execute((Context)this.registryContext);
        ((ScenarioResult)Mockito.verify((Object)this.scenarioResult, (VerificationMode)Mockito.times((int)1))).setResult(Mockito.anyBoolean());
        Mockito.reset((Object[])new ScenarioResult[]{this.scenarioResult});
        Mockito.when((Object)this.kieSession.getObjects((ObjectFilter)Mockito.any(ObjectFilter.class))).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.scenarioResult.getFactMappingValue()).thenReturn((Object)this.factMappingValue);
        validateFactCommand.execute((Context)this.registryContext);
        ((ScenarioResult)Mockito.verify((Object)this.scenarioResult, (VerificationMode)Mockito.times((int)0))).setResult(Mockito.anyBoolean());
    }
}

