/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.AuditLogLine;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.BackgroundData;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;
import org.drools.scenariosimulation.api.model.FactMappingValueType;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.backend.TestUtils;
import org.drools.scenariosimulation.backend.expression.BaseExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorFactory;
import org.drools.scenariosimulation.backend.fluent.AbstractRuleCoverageTest;
import org.drools.scenariosimulation.backend.fluent.CoverageAgendaListener;
import org.drools.scenariosimulation.backend.fluent.RuleScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.model.Dispute;
import org.drools.scenariosimulation.backend.model.Person;
import org.drools.scenariosimulation.backend.runner.RuleScenarioRunnerHelper;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.InstanceGiven;
import org.drools.scenariosimulation.backend.runner.model.ScenarioExpect;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.drools.scenariosimulation.backend.runner.model.ValueWrapper;
import org.drools.scenariosimulation.backend.util.ScenarioSimulationServerMessages;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.KieContainer;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class RuleScenarioRunnerHelperTest
extends AbstractRuleCoverageTest {
    @Mock
    protected RuleScenarioExecutableBuilder ruleScenarioExecutableBuilderMock;
    @Mock
    protected KieContainer kieContainerMock;
    private static final String NAME = "NAME";
    private static final String AMOUNT = "10";
    private static final String TEST_DESCRIPTION = "Test description";
    private static final ClassLoader classLoader = RuleScenarioRunnerHelperTest.class.getClassLoader();
    private static final ExpressionEvaluatorFactory expressionEvaluatorFactory = ExpressionEvaluatorFactory.create((ClassLoader)classLoader, (ScenarioSimulationModel.Type)ScenarioSimulationModel.Type.RULE);
    private static final ExpressionEvaluator expressionEvaluator = new BaseExpressionEvaluator(classLoader);
    private final RuleScenarioRunnerHelper runnerHelper = new RuleScenarioRunnerHelper(){

        protected RuleScenarioExecutableBuilder createBuilderWrapper(KieContainer kieContainer, Settings settings) {
            return RuleScenarioRunnerHelperTest.this.ruleScenarioExecutableBuilderMock;
        }
    };
    private Simulation simulation;
    private Background background;
    private Settings settings;
    private FactIdentifier personFactIdentifier;
    private ExpressionIdentifier firstNameGivenExpressionIdentifier;
    private FactMapping firstNameGivenFactMapping;
    private FactMapping backgroundFirstNameGivenFactMapping;
    private Scenario scenario1;
    private Scenario scenario2;
    private BackgroundData backgroundData1;
    private BackgroundData backgroundData2;
    private ExpressionIdentifier firstNameExpectedExpressionIdentifier;
    private FactMapping firstNameExpectedFactMapping;
    private FactIdentifier disputeFactIdentifier;
    private ExpressionIdentifier amountGivenExpressionIdentifier;
    private FactMapping amountNameGivenFactMapping;
    private FactMapping backgroundAmountNameGivenFactMapping;
    private ExpressionIdentifier amountExpectedExpressionIdentifier;
    private FactMapping amountNameExpectedFactMapping;
    private FactMappingValue amountNameExpectedFactMappingValue;
    private FactMapping disputeExpressionGivenFactMapping;
    private ExpressionIdentifier expressionGivenExpressionIdentifier;

    @Before
    public void setup() {
        Mockito.when((Object)this.kieContainerMock.getClassLoader()).thenReturn((Object)classLoader);
        this.simulation = new Simulation();
        this.background = new Background();
        this.settings = new Settings();
        this.settings.setType(ScenarioSimulationModel.Type.RULE);
        this.personFactIdentifier = FactIdentifier.create((String)"Fact 1", (String)Person.class.getCanonicalName());
        this.firstNameGivenExpressionIdentifier = ExpressionIdentifier.create((String)"First Name Given", (FactMappingType)FactMappingType.GIVEN);
        this.firstNameGivenFactMapping = this.simulation.getScesimModelDescriptor().addFactMapping(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier);
        this.firstNameGivenFactMapping.addExpressionElement("Fact 1", String.class.getCanonicalName());
        this.firstNameGivenFactMapping.addExpressionElement("firstName", String.class.getCanonicalName());
        this.disputeFactIdentifier = FactIdentifier.create((String)"Fact 2", (String)Dispute.class.getCanonicalName());
        this.amountGivenExpressionIdentifier = ExpressionIdentifier.create((String)"Amount Given", (FactMappingType)FactMappingType.GIVEN);
        this.amountNameGivenFactMapping = this.simulation.getScesimModelDescriptor().addFactMapping(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier);
        this.amountNameGivenFactMapping.addExpressionElement("Fact 2", Double.class.getCanonicalName());
        this.amountNameGivenFactMapping.addExpressionElement("amount", Double.class.getCanonicalName());
        this.firstNameExpectedExpressionIdentifier = ExpressionIdentifier.create((String)"First Name Expected", (FactMappingType)FactMappingType.EXPECT);
        this.firstNameExpectedFactMapping = this.simulation.getScesimModelDescriptor().addFactMapping(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier);
        this.firstNameExpectedFactMapping.addExpressionElement("Fact 1", String.class.getCanonicalName());
        this.firstNameExpectedFactMapping.addExpressionElement("firstName", String.class.getCanonicalName());
        this.amountExpectedExpressionIdentifier = ExpressionIdentifier.create((String)"Amount Expected", (FactMappingType)FactMappingType.EXPECT);
        this.amountNameExpectedFactMapping = this.simulation.getScesimModelDescriptor().addFactMapping(this.disputeFactIdentifier, this.amountExpectedExpressionIdentifier);
        this.amountNameExpectedFactMapping.addExpressionElement("Fact 2", Double.class.getCanonicalName());
        this.amountNameExpectedFactMapping.addExpressionElement("amount", Double.class.getCanonicalName());
        this.expressionGivenExpressionIdentifier = ExpressionIdentifier.create((String)"directMapping", (FactMappingType)FactMappingType.GIVEN);
        this.disputeExpressionGivenFactMapping = this.simulation.getScesimModelDescriptor().addFactMapping(this.disputeFactIdentifier, this.expressionGivenExpressionIdentifier);
        this.disputeExpressionGivenFactMapping.setFactMappingValueType(FactMappingValueType.EXPRESSION);
        this.disputeExpressionGivenFactMapping.addExpressionElement("Dispute", Dispute.class.getCanonicalName());
        this.scenario1 = (Scenario)this.simulation.addData();
        this.scenario1.setDescription(TEST_DESCRIPTION);
        this.scenario1.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)NAME);
        this.scenario1.addMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)NAME);
        this.scenario2 = (Scenario)this.simulation.addData();
        this.scenario2.setDescription(TEST_DESCRIPTION);
        this.scenario2.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)NAME);
        this.scenario2.addMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)NAME);
        this.scenario2.addMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)AMOUNT);
        this.amountNameExpectedFactMappingValue = this.scenario2.addMappingValue(this.disputeFactIdentifier, this.amountExpectedExpressionIdentifier, (Object)AMOUNT);
        this.backgroundFirstNameGivenFactMapping = this.background.getScesimModelDescriptor().addFactMapping(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier);
        this.backgroundFirstNameGivenFactMapping.addExpressionElement("Person", String.class.getCanonicalName());
        this.backgroundFirstNameGivenFactMapping.addExpressionElement("firstName", String.class.getCanonicalName());
        this.backgroundAmountNameGivenFactMapping = this.background.getScesimModelDescriptor().addFactMapping(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier);
        this.backgroundAmountNameGivenFactMapping.addExpressionElement("Dispute", Double.class.getCanonicalName());
        this.backgroundAmountNameGivenFactMapping.addExpressionElement("amount", Double.class.getCanonicalName());
        this.backgroundData1 = (BackgroundData)this.background.addData();
        this.backgroundData1.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)NAME);
        this.backgroundData1.addMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)AMOUNT);
        this.backgroundData2 = (BackgroundData)this.background.addData();
        this.backgroundData2.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)NAME);
    }

    @Test
    public void extractGivenValuesTest() {
        List scenario1Inputs = this.runnerHelper.extractGivenValues(this.simulation.getScesimModelDescriptor(), this.scenario1.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluatorFactory);
        Assertions.assertThat((int)scenario1Inputs.size()).isEqualTo(1);
        List scenario2Inputs = this.runnerHelper.extractGivenValues(this.simulation.getScesimModelDescriptor(), this.scenario2.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluatorFactory);
        Assertions.assertThat((int)scenario2Inputs.size()).isEqualTo(2);
        this.scenario2.addOrUpdateMappingValue(this.disputeFactIdentifier, this.expressionGivenExpressionIdentifier, (Object)"# new org.drools.scenariosimulation.backend.model.Dispute(\"dispute description\", 10)");
        scenario2Inputs = this.runnerHelper.extractGivenValues(this.simulation.getScesimModelDescriptor(), this.scenario2.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluatorFactory);
        Assertions.assertThat((int)scenario2Inputs.size()).isEqualTo(2);
        Optional<Dispute> disputeGivenOptional = scenario2Inputs.stream().filter(elem -> elem.getValue() instanceof Dispute).map(elem -> (Dispute)elem.getValue()).findFirst();
        Assertions.assertThat((boolean)disputeGivenOptional.isPresent()).isTrue();
        Assertions.assertThat((String)disputeGivenOptional.get().getDescription()).isEqualTo("dispute description");
        this.scenario2.addOrUpdateMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)"WrongValue");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runnerHelper.extractGivenValues(this.simulation.getScesimModelDescriptor(), this.scenario2.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluatorFactory)).isInstanceOf(ScenarioException.class)).hasMessage("Error in GIVEN data");
    }

    @Test
    public void extractExpectedValuesTest() {
        List scenario1Outputs = this.runnerHelper.extractExpectedValues(this.scenario1.getUnmodifiableFactMappingValues());
        Assertions.assertThat((int)scenario1Outputs.size()).isEqualTo(1);
        this.scenario2.addOrUpdateMappingValue(FactIdentifier.create((String)"TEST", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"TEST", (FactMappingType)FactMappingType.EXPECT), (Object)"TEST");
        List scenario2Outputs = this.runnerHelper.extractExpectedValues(this.scenario2.getUnmodifiableFactMappingValues());
        Assertions.assertThat((int)scenario2Outputs.size()).isEqualTo(3);
        Assertions.assertThat((long)scenario2Outputs.stream().filter(ScenarioExpect::isNewFact).count()).isEqualTo(1L);
        this.scenario2.addOrUpdateMappingValue(FactIdentifier.create((String)"TEST", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"TEST", (FactMappingType)FactMappingType.GIVEN), null);
        List scenario2aOutputs = this.runnerHelper.extractExpectedValues(this.scenario2.getUnmodifiableFactMappingValues());
        Assertions.assertThat((int)scenario2aOutputs.size()).isEqualTo(3);
        Assertions.assertThat((long)scenario2aOutputs.stream().filter(ScenarioExpect::isNewFact).count()).isEqualTo(1L);
    }

    @Test
    public void verifyConditionsTest() {
        List scenario1Inputs = this.runnerHelper.extractGivenValues(this.simulation.getScesimModelDescriptor(), this.scenario1.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluatorFactory);
        List scenario1Outputs = this.runnerHelper.extractExpectedValues(this.scenario1.getUnmodifiableFactMappingValues());
        ScenarioRunnerData scenarioRunnerData1 = new ScenarioRunnerData();
        scenario1Inputs.forEach(arg_0 -> ((ScenarioRunnerData)scenarioRunnerData1).addGiven(arg_0));
        scenario1Outputs.forEach(arg_0 -> ((ScenarioRunnerData)scenarioRunnerData1).addExpect(arg_0));
        this.runnerHelper.verifyConditions(this.simulation.getScesimModelDescriptor(), scenarioRunnerData1, expressionEvaluatorFactory, null);
        Assertions.assertThat((int)scenarioRunnerData1.getResults().size()).isEqualTo(1);
        List scenario2Inputs = this.runnerHelper.extractGivenValues(this.simulation.getScesimModelDescriptor(), this.scenario2.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluatorFactory);
        List scenario2Outputs = this.runnerHelper.extractExpectedValues(this.scenario2.getUnmodifiableFactMappingValues());
        ScenarioRunnerData scenarioRunnerData2 = new ScenarioRunnerData();
        scenario2Inputs.forEach(arg_0 -> ((ScenarioRunnerData)scenarioRunnerData2).addGiven(arg_0));
        scenario2Outputs.forEach(arg_0 -> ((ScenarioRunnerData)scenarioRunnerData2).addExpect(arg_0));
        this.runnerHelper.verifyConditions(this.simulation.getScesimModelDescriptor(), scenarioRunnerData2, expressionEvaluatorFactory, null);
        Assertions.assertThat((int)scenarioRunnerData2.getResults().size()).isEqualTo(2);
    }

    @Test
    public void getScenarioResultsTest() {
        List scenario1Inputs = this.runnerHelper.extractGivenValues(this.simulation.getScesimModelDescriptor(), this.scenario1.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluatorFactory);
        List scenario1Outputs = this.runnerHelper.extractExpectedValues(this.scenario1.getUnmodifiableFactMappingValues());
        Assertions.assertThat((scenario1Inputs.size() > 0 ? 1 : 0) != 0).isTrue();
        InstanceGiven input1 = (InstanceGiven)scenario1Inputs.get(0);
        scenario1Outputs = scenario1Outputs.stream().filter(elem -> elem.getFactIdentifier().equals((Object)input1.getFactIdentifier())).collect(Collectors.toList());
        List scenario1Results = this.runnerHelper.getScenarioResultsFromGivenFacts(this.simulation.getScesimModelDescriptor(), scenario1Outputs, input1, expressionEvaluatorFactory);
        Assertions.assertThat((int)scenario1Results.size()).isEqualTo(1);
        Assertions.assertThat((Comparable)((FactMappingValue)((ScenarioExpect)scenario1Outputs.get(0)).getExpectedResult().get(0)).getStatus()).isEqualTo((Object)FactMappingValueStatus.SUCCESS);
        List scenario2Inputs = this.runnerHelper.extractGivenValues(this.simulation.getScesimModelDescriptor(), this.scenario2.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluatorFactory);
        List scenario2Outputs = this.runnerHelper.extractExpectedValues(this.scenario2.getUnmodifiableFactMappingValues());
        Assertions.assertThat((scenario2Inputs.size() > 0 ? 1 : 0) != 0).isTrue();
        InstanceGiven input2 = (InstanceGiven)scenario2Inputs.get(0);
        scenario2Outputs = scenario2Outputs.stream().filter(elem -> elem.getFactIdentifier().equals((Object)input2.getFactIdentifier())).collect(Collectors.toList());
        List scenario2Results = this.runnerHelper.getScenarioResultsFromGivenFacts(this.simulation.getScesimModelDescriptor(), scenario2Outputs, input2, expressionEvaluatorFactory);
        Assertions.assertThat((int)scenario2Results.size()).isEqualTo(1);
        Assertions.assertThat((Comparable)((FactMappingValue)((ScenarioExpect)scenario1Outputs.get(0)).getExpectedResult().get(0)).getStatus()).isEqualTo((Object)FactMappingValueStatus.SUCCESS);
        List<ScenarioExpect> newFact = Collections.singletonList(new ScenarioExpect(this.personFactIdentifier, Collections.emptyList(), true));
        List scenario2NoResults = this.runnerHelper.getScenarioResultsFromGivenFacts(this.simulation.getScesimModelDescriptor(), newFact, input2, expressionEvaluatorFactory);
        Assertions.assertThat((int)scenario2NoResults.size()).isEqualTo(0);
        Person person = new Person();
        person.setFirstName("ANOTHER STRING");
        InstanceGiven newInput = new InstanceGiven(this.personFactIdentifier, (Object)person);
        List scenario3Results = this.runnerHelper.getScenarioResultsFromGivenFacts(this.simulation.getScesimModelDescriptor(), scenario1Outputs, newInput, expressionEvaluatorFactory);
        Assertions.assertThat((Comparable)((FactMappingValue)((ScenarioExpect)scenario1Outputs.get(0)).getExpectedResult().get(0)).getStatus()).isEqualTo((Object)FactMappingValueStatus.FAILED_WITH_ERROR);
        Assertions.assertThat((int)scenario3Results.size()).isEqualTo(1);
        Assertions.assertThat(((ScenarioResult)scenario3Results.get(0)).getResultValue().get()).isEqualTo((Object)person.getFirstName());
        Assertions.assertThat((Object)((ScenarioResult)scenario3Results.get(0)).getFactMappingValue().getRawValue()).isEqualTo((Object)NAME);
    }

    @Test
    public void validateAssertionTest() {
        ArrayList<ScenarioResult> scenarioFailResult = new ArrayList<ScenarioResult>();
        scenarioFailResult.add(new ScenarioResult(this.amountNameExpectedFactMappingValue, (Object)"SOMETHING_ELSE"));
        try {
            this.runnerHelper.validateAssertion(scenarioFailResult, this.simulation.getScesimModelDescriptor());
            Assertions.fail((String)"Unexpected execution path");
        }
        catch (IllegalStateException exception) {
            Assertions.assertThat((String)exception.getMessage()).isEqualTo("Illegal FactMappingValue status");
        }
        this.amountNameExpectedFactMappingValue.resetStatus();
        this.amountNameExpectedFactMappingValue.setErrorValue((Object)"Error");
        scenarioFailResult.add(new ScenarioResult(this.amountNameExpectedFactMappingValue, (Object)"SOMETHING_ELSE"));
        try {
            this.runnerHelper.validateAssertion(scenarioFailResult, this.simulation.getScesimModelDescriptor());
            Assertions.fail((String)"Unexpected execution path");
        }
        catch (ScenarioException exception) {
            Assertions.assertThat((boolean)exception.isFailedAssertion()).isTrue();
            Assertions.assertThat((String)exception.getMessage()).isEqualTo(ScenarioSimulationServerMessages.getFactWithWrongValueExceptionMessage((String)"Fact 2.amount", (Object)this.amountNameExpectedFactMappingValue.getRawValue(), (Object)this.amountNameExpectedFactMappingValue.getErrorValue()));
        }
        String exceptionMessage = "Message";
        this.amountNameExpectedFactMappingValue.resetStatus();
        this.amountNameExpectedFactMappingValue.setExceptionMessage(exceptionMessage);
        scenarioFailResult.add(new ScenarioResult(this.amountNameExpectedFactMappingValue, (Object)"SOMETHING_ELSE"));
        try {
            this.runnerHelper.validateAssertion(scenarioFailResult, this.simulation.getScesimModelDescriptor());
            Assertions.fail((String)"Unexpected execution path");
        }
        catch (ScenarioException exception) {
            Assertions.assertThat((boolean)exception.isFailedAssertion()).isFalse();
            Assertions.assertThat((String)exception.getMessage()).isEqualTo(ScenarioSimulationServerMessages.getGenericScenarioExceptionMessage((String)exceptionMessage));
        }
        List<String> pathToValue = Arrays.asList("Item #2");
        this.amountNameExpectedFactMappingValue.resetStatus();
        this.amountNameExpectedFactMappingValue.setCollectionPathToValue(pathToValue);
        scenarioFailResult.add(new ScenarioResult(this.amountNameExpectedFactMappingValue, (Object)"SOMETHING_ELSE"));
        try {
            this.runnerHelper.validateAssertion(scenarioFailResult, this.simulation.getScesimModelDescriptor());
            Assertions.fail((String)"Unexpected execution path");
        }
        catch (ScenarioException exception) {
            Assertions.assertThat((boolean)exception.isFailedAssertion()).isTrue();
            Assertions.assertThat((String)exception.getMessage()).isEqualTo(ScenarioSimulationServerMessages.getCollectionFactExceptionMessage((String)"Fact 2.amount", pathToValue, (Object)this.amountNameExpectedFactMappingValue.getErrorValue()));
        }
        ArrayList<ScenarioResult> scenarioSuccessResult = new ArrayList<ScenarioResult>();
        scenarioSuccessResult.add(new ScenarioResult(this.amountNameExpectedFactMappingValue, this.amountNameExpectedFactMappingValue.getRawValue()).setResult(true));
        this.runnerHelper.validateAssertion(scenarioSuccessResult, this.simulation.getScesimModelDescriptor());
    }

    @Test
    public void groupByFactIdentifierAndFilterTest() {
        Map scenario1Given = this.runnerHelper.groupByFactIdentifierAndFilter(this.scenario1.getUnmodifiableFactMappingValues(), FactMappingType.GIVEN);
        Map scenario1Expected = this.runnerHelper.groupByFactIdentifierAndFilter(this.scenario1.getUnmodifiableFactMappingValues(), FactMappingType.EXPECT);
        Map scenario2Given = this.runnerHelper.groupByFactIdentifierAndFilter(this.scenario2.getUnmodifiableFactMappingValues(), FactMappingType.GIVEN);
        Map scenario2Expected = this.runnerHelper.groupByFactIdentifierAndFilter(this.scenario2.getUnmodifiableFactMappingValues(), FactMappingType.EXPECT);
        Assertions.assertThat((int)scenario1Given.keySet().size()).isEqualTo(1);
        Assertions.assertThat((int)scenario1Expected.keySet().size()).isEqualTo(1);
        Assertions.assertThat((int)scenario2Given.keySet().size()).isEqualTo(2);
        Assertions.assertThat((int)scenario2Expected.keySet().size()).isEqualTo(2);
        Assertions.assertThat((int)((List)scenario1Given.get(this.personFactIdentifier)).size()).isEqualTo(1);
        Assertions.assertThat((int)((List)scenario1Expected.get(this.personFactIdentifier)).size()).isEqualTo(1);
        Assertions.assertThat((int)((List)scenario2Given.get(this.disputeFactIdentifier)).size()).isEqualTo(1);
        Assertions.assertThat((int)((List)scenario2Expected.get(this.disputeFactIdentifier)).size()).isEqualTo(1);
        Scenario scenario = new Scenario();
        scenario.addMappingValue(FactIdentifier.EMPTY, ExpressionIdentifier.DESCRIPTION, null);
        Assertions.assertThat((int)this.runnerHelper.groupByFactIdentifierAndFilter(scenario.getUnmodifiableFactMappingValues(), FactMappingType.GIVEN).size()).isEqualTo(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void groupByFactIdentifierAndFilterFailTest() {
        ArrayList<FactMappingValue> fail = new ArrayList<FactMappingValue>();
        FactMappingValue factMappingValue = new FactMappingValue();
        factMappingValue.setRawValue((Object)"TEST");
        fail.add(factMappingValue);
        this.runnerHelper.groupByFactIdentifierAndFilter(fail, FactMappingType.GIVEN);
    }

    @Test
    public void createExtractorFunctionTest() {
        String personName = "Test";
        FactMappingValue factMappingValue = new FactMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)personName);
        Function extractorFunction = this.runnerHelper.createExtractorFunction(expressionEvaluator, factMappingValue, this.simulation.getScesimModelDescriptor());
        Person person = new Person();
        person.setFirstName(personName);
        Assertions.assertThat((boolean)((ValueWrapper)extractorFunction.apply(person)).isValid()).isTrue();
        person.setFirstName("OtherString");
        Assertions.assertThat((boolean)((ValueWrapper)extractorFunction.apply(person)).isValid()).isFalse();
        Function extractorFunction1 = this.runnerHelper.createExtractorFunction(expressionEvaluator, new FactMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, null), this.simulation.getScesimModelDescriptor());
        ValueWrapper nullValue = (ValueWrapper)extractorFunction1.apply(new Person());
        Assertions.assertThat((boolean)nullValue.isValid()).isTrue();
        Assertions.assertThat((Object)nullValue.getValue()).isNull();
    }

    @Test
    public void getParamsForBeanTest() {
        ArrayList<FactMappingValue> factMappingValues = new ArrayList<FactMappingValue>();
        FactMappingValue factMappingValue1 = (FactMappingValue)Mockito.spy((Object)new FactMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)"NOT PARSABLE"));
        FactMappingValue factMappingValue2 = (FactMappingValue)Mockito.spy((Object)new FactMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)"NOT PARSABLE"));
        FactMappingValue factMappingValue3 = (FactMappingValue)Mockito.spy((Object)new FactMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)"1"));
        factMappingValues.add(factMappingValue1);
        factMappingValues.add(factMappingValue2);
        factMappingValues.add(factMappingValue3);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runnerHelper.getParamsForBean(this.simulation.getScesimModelDescriptor(), this.disputeFactIdentifier, factMappingValues, expressionEvaluatorFactory)).isInstanceOf(ScenarioException.class)).hasMessage("Error in one or more input values");
        factMappingValues.forEach(fmv -> ((FactMappingValue)Mockito.verify((Object)fmv, (VerificationMode)Mockito.times((int)2))).getRawValue());
        Assertions.assertThat((Comparable)factMappingValue1.getStatus()).isEqualTo((Object)FactMappingValueStatus.FAILED_WITH_EXCEPTION);
        Assertions.assertThat((Comparable)factMappingValue2.getStatus()).isEqualTo((Object)FactMappingValueStatus.FAILED_WITH_EXCEPTION);
        Assertions.assertThat((Comparable)factMappingValue3.getStatus()).isEqualTo((Object)FactMappingValueStatus.SUCCESS);
    }

    @Test
    public void directMappingTest() {
        HashMap paramsToSet = new HashMap();
        paramsToSet.put(Collections.emptyList(), "Test");
        Assertions.assertThat((Object)this.runnerHelper.getDirectMapping(paramsToSet).getValue()).isEqualTo((Object)"Test");
        paramsToSet.clear();
        paramsToSet.put(Collections.emptyList(), 1);
        Assertions.assertThat((Object)this.runnerHelper.getDirectMapping(paramsToSet).getValue()).isEqualTo((Object)1);
        paramsToSet.clear();
        paramsToSet.put(Collections.emptyList(), null);
        Assertions.assertThat((Object)this.runnerHelper.getDirectMapping(paramsToSet).getValue()).isNull();
        paramsToSet.clear();
        ValueWrapper directMapping = this.runnerHelper.getDirectMapping(paramsToSet);
        Assertions.assertThat((boolean)directMapping.isValid()).isFalse();
        Assertions.assertThat((String)((String)directMapping.getErrorMessage().get())).isEqualTo("No direct mapping available");
    }

    @Test
    public void createObject() {
        HashMap<List<String>, Object> params = new HashMap<List<String>, Object>();
        params.put(Collections.singletonList("firstName"), "TestName");
        params.put(Collections.singletonList("age"), 10);
        ValueWrapper initialInstance = this.runnerHelper.getDirectMapping(params);
        Object objectRaw = this.runnerHelper.createObject(initialInstance, Person.class.getCanonicalName(), params, this.getClass().getClassLoader());
        Assertions.assertThat((boolean)(objectRaw instanceof Person)).isTrue();
        Person object = (Person)objectRaw;
        Assertions.assertThat((int)object.getAge()).isEqualTo(10);
        Assertions.assertThat((String)object.getFirstName()).isEqualTo("TestName");
    }

    @Test
    public void createObjectDirectMappingSimpleType() {
        HashMap params = new HashMap();
        String directMappingSimpleTypeValue = "TestName";
        params.put(Collections.emptyList(), directMappingSimpleTypeValue);
        ValueWrapper initialInstance = this.runnerHelper.getDirectMapping(params);
        Object objectRaw = this.runnerHelper.createObject(initialInstance, String.class.getCanonicalName(), params, this.getClass().getClassLoader());
        Assertions.assertThat((boolean)(objectRaw instanceof String)).isTrue();
        Assertions.assertThat((Object)objectRaw).isEqualTo((Object)directMappingSimpleTypeValue);
    }

    @Test
    public void createObjectDirectMappingSimpleTypeNull() {
        HashMap params = new HashMap();
        params.put(Collections.emptyList(), null);
        ValueWrapper initialInstance = this.runnerHelper.getDirectMapping(params);
        Object objectRaw = this.runnerHelper.createObject(initialInstance, String.class.getCanonicalName(), params, this.getClass().getClassLoader());
        Assertions.assertThat((Object)objectRaw).isNull();
    }

    @Test
    public void createObjectDirectMappingComplexType() {
        HashMap<List<Object>, Object> params = new HashMap<List<Object>, Object>();
        Person directMappingComplexTypeValue = new Person();
        directMappingComplexTypeValue.setFirstName("TestName");
        params.put(Collections.emptyList(), directMappingComplexTypeValue);
        params.put(Collections.singletonList("age"), 10);
        ValueWrapper initialInstance = this.runnerHelper.getDirectMapping(params);
        Object objectRaw = this.runnerHelper.createObject(initialInstance, Map.class.getCanonicalName(), params, this.getClass().getClassLoader());
        Assertions.assertThat((boolean)(objectRaw instanceof Person)).isTrue();
        Person object = (Person)objectRaw;
        Assertions.assertThat((int)object.getAge()).isEqualTo(10);
        Assertions.assertThat((String)object.getFirstName()).isEqualTo("TestName");
    }

    @Test
    public void extractResultMetadata() {
        LinkedHashMap<String, Integer> coverageData = new LinkedHashMap<String, Integer>();
        coverageData.put("rule1", 2);
        coverageData.put("rule2", 2);
        CoverageAgendaListener coverageAgendaListenerMock = this.createCoverageAgendaListenerWithData(coverageData);
        ScenarioWithIndex scenarioWithIndexMock = (ScenarioWithIndex)Mockito.mock(ScenarioWithIndex.class);
        Scenario scenarioMock = (Scenario)Mockito.mock(Scenario.class);
        Mockito.when((Object)scenarioMock.getDescription()).thenReturn((Object)"DESCRIPTION");
        Mockito.when((Object)((Scenario)scenarioWithIndexMock.getScesimData())).thenReturn((Object)scenarioMock);
        LinkedHashMap<String, Object> requestContext = new LinkedHashMap<String, Object>();
        requestContext.put("COVERAGE_LISTENER", coverageAgendaListenerMock);
        requestContext.put("RULES_AVAILABLE", coverageData.keySet());
        ScenarioResultMetadata scenarioResultMetadata = this.runnerHelper.extractResultMetadata(requestContext, scenarioWithIndexMock);
        Assertions.assertThat((Object)scenarioResultMetadata.getScenarioWithIndex()).isEqualTo((Object)scenarioWithIndexMock);
        Assertions.assertThat((int)scenarioResultMetadata.getAvailable().size()).isEqualTo(2);
        Assertions.assertThat((int)scenarioResultMetadata.getExecuted().size()).isEqualTo(2);
        Assertions.assertThat((Integer)((Integer)scenarioResultMetadata.getExecutedWithCounter().get("rule1"))).isEqualTo((Object)2);
        Assertions.assertThat((Integer)((Integer)scenarioResultMetadata.getExecutedWithCounter().get("rule2"))).isEqualTo((Object)2);
        ArrayList<String> expectedMessages = new ArrayList<String>();
        this.commonAddMessageString(Arrays.asList("rule1", "rule2"), expectedMessages);
        List auditLogLines = scenarioResultMetadata.getAuditLogLines();
        Assertions.assertThat((int)auditLogLines.size()).isEqualTo(expectedMessages.size());
        for (int i = 0; i < expectedMessages.size(); ++i) {
            TestUtils.commonCheckAuditLogLine((AuditLogLine)auditLogLines.get(i), (String)expectedMessages.get(i), "EXECUTED", null);
        }
    }

    @Test
    public void extractBackgroundValues() {
        Background emptyBackground = new Background();
        List emptyBackgroundGivens = this.runnerHelper.extractBackgroundValues(emptyBackground, classLoader, expressionEvaluatorFactory);
        Assertions.assertThat((int)emptyBackgroundGivens.size()).isEqualTo(0);
        emptyBackground.addData();
        emptyBackgroundGivens = this.runnerHelper.extractBackgroundValues(emptyBackground, classLoader, expressionEvaluatorFactory);
        Assertions.assertThat((int)emptyBackgroundGivens.size()).isEqualTo(0);
        List backgroundGivens = this.runnerHelper.extractBackgroundValues(this.background, classLoader, expressionEvaluatorFactory);
        Assertions.assertThat((int)backgroundGivens.size()).isEqualTo(3);
        for (InstanceGiven backgroundGiven : backgroundGivens) {
            if (backgroundGiven.getFactIdentifier().equals((Object)this.personFactIdentifier)) {
                Assertions.assertThat((Object)backgroundGiven.getFactIdentifier()).isEqualTo((Object)this.personFactIdentifier);
                Person person = (Person)backgroundGiven.getValue();
                Assertions.assertThat((String)person.getFirstName()).isEqualTo(NAME);
                continue;
            }
            if (backgroundGiven.getFactIdentifier().equals((Object)this.disputeFactIdentifier)) {
                Assertions.assertThat((Object)backgroundGiven.getFactIdentifier()).isEqualTo((Object)this.disputeFactIdentifier);
                Dispute dispute = (Dispute)backgroundGiven.getValue();
                double parsedAmount = Double.parseDouble(AMOUNT);
                Assertions.assertThat((double)dispute.getAmount()).isCloseTo(parsedAmount, Assertions.within((Double)0.1));
                continue;
            }
            Assertions.fail((String)"Unexpected execution path");
        }
        String notValid = "notValid";
        FactMappingValue notValid1 = this.backgroundData1.addOrUpdateMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)notValid);
        FactMappingValue notValid2 = this.backgroundData2.addOrUpdateMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)notValid);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runnerHelper.extractBackgroundValues(this.background, classLoader, expressionEvaluatorFactory)).isInstanceOf(ScenarioException.class)).hasMessage("Error in BACKGROUND data");
        Assertions.assertThat((Comparable)notValid1.getStatus()).isEqualTo((Object)FactMappingValueStatus.FAILED_WITH_EXCEPTION);
        Assertions.assertThat((boolean)notValid1.getExceptionMessage().startsWith("Impossible to parse")).isTrue();
        Assertions.assertThat((Comparable)notValid2.getStatus()).isEqualTo((Object)FactMappingValueStatus.FAILED_WITH_EXCEPTION);
        Assertions.assertThat((boolean)notValid2.getExceptionMessage().startsWith("Impossible to parse")).isTrue();
    }

    @Test
    public void executeScenario() {
        ArgumentCaptor insertCaptor = ArgumentCaptor.forClass(Object.class);
        ScenarioRunnerData scenarioRunnerData = new ScenarioRunnerData();
        scenarioRunnerData.addBackground(new InstanceGiven(this.personFactIdentifier, (Object)new Person()));
        scenarioRunnerData.addBackground(new InstanceGiven(this.disputeFactIdentifier, (Object)new Dispute()));
        scenarioRunnerData.addGiven(new InstanceGiven(this.personFactIdentifier, (Object)new Person()));
        FactMappingValue factMappingValue = new FactMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)NAME);
        scenarioRunnerData.addExpect(new ScenarioExpect(this.personFactIdentifier, Collections.singletonList(factMappingValue), false));
        scenarioRunnerData.addExpect(new ScenarioExpect(this.personFactIdentifier, Collections.singletonList(factMappingValue), true));
        int inputObjects = scenarioRunnerData.getBackgrounds().size() + scenarioRunnerData.getGivens().size();
        String ruleFlowGroup = "ruleFlowGroup";
        this.settings.setRuleFlowGroup(ruleFlowGroup);
        this.runnerHelper.executeScenario(this.kieContainerMock, scenarioRunnerData, expressionEvaluatorFactory, this.simulation.getScesimModelDescriptor(), this.settings);
        ((RuleScenarioExecutableBuilder)Mockito.verify((Object)this.ruleScenarioExecutableBuilderMock, (VerificationMode)Mockito.times((int)1))).setActiveRuleFlowGroup(ruleFlowGroup);
        ((RuleScenarioExecutableBuilder)Mockito.verify((Object)this.ruleScenarioExecutableBuilderMock, (VerificationMode)Mockito.times((int)inputObjects))).insert(insertCaptor.capture());
        for (Object value : insertCaptor.getAllValues()) {
            Assertions.assertThat((value instanceof Person || value instanceof Dispute ? 1 : 0) != 0).isTrue();
        }
        ((RuleScenarioExecutableBuilder)Mockito.verify((Object)this.ruleScenarioExecutableBuilderMock, (VerificationMode)Mockito.times((int)1))).addInternalCondition((Class)ArgumentMatchers.eq(Person.class), (Function)ArgumentMatchers.any(), (ScenarioResult)ArgumentMatchers.any());
        ((RuleScenarioExecutableBuilder)Mockito.verify((Object)this.ruleScenarioExecutableBuilderMock, (VerificationMode)Mockito.times((int)1))).run();
        Assertions.assertThat((int)scenarioRunnerData.getResults().size()).isEqualTo(1);
        this.settings.setType(ScenarioSimulationModel.Type.DMN);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runnerHelper.executeScenario(this.kieContainerMock, scenarioRunnerData, expressionEvaluatorFactory, this.simulation.getScesimModelDescriptor(), this.settings)).isInstanceOf(ScenarioException.class)).hasMessageStartingWith("Impossible to run");
    }

    private void commonAddMessageString(List<String> ruleNames, List<String> expectedMessages) {
        ruleNames.forEach(ruleName -> IntStream.range(1, 3).forEach(index -> expectedMessages.add((String)ruleName)));
    }
}

