/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner.model;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.AuditLogLine;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.backend.TestUtils;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.mockito.Mockito;

public class ScenarioResultMetadataTest {
    private ScenarioResultMetadata scenarioResultMetadata;
    private ScenarioWithIndex scenarioWithIndex;
    private Scenario scenarioMock;
    private int SCENARIO_INDEX = 0;

    @Before
    public void setup() {
        this.scenarioMock = (Scenario)Mockito.mock(Scenario.class);
        this.scenarioWithIndex = new ScenarioWithIndex(this.SCENARIO_INDEX, this.scenarioMock);
        this.scenarioResultMetadata = new ScenarioResultMetadata(this.scenarioWithIndex);
    }

    @Test
    public void addAuditMessage() {
        Assertions.assertThat((boolean)this.scenarioResultMetadata.getAuditLogLines().isEmpty()).isTrue();
        int index = 1;
        String decisionName = "decisionName";
        String result = DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED.toString();
        this.scenarioResultMetadata.addAuditMessage(index, decisionName, result);
        List retrieved = this.scenarioResultMetadata.getAuditLogLines();
        Assertions.assertThat((int)retrieved.size()).isEqualTo(1);
        TestUtils.commonCheckAuditLogLine((AuditLogLine)retrieved.get(0), decisionName, result, null);
    }

    @Test
    public void addAuditMessageWithErrorMessage() {
        Assertions.assertThat((boolean)this.scenarioResultMetadata.getAuditLogLines().isEmpty()).isTrue();
        int index = 1;
        String decisionName = "decisionName";
        String result = DMNDecisionResult.DecisionEvaluationStatus.FAILED.toString();
        String message = "Message";
        this.scenarioResultMetadata.addAuditMessage(index, decisionName, result, message);
        List retrieved = this.scenarioResultMetadata.getAuditLogLines();
        Assertions.assertThat((int)retrieved.size()).isEqualTo(1);
        TestUtils.commonCheckAuditLogLine((AuditLogLine)retrieved.get(0), decisionName, result, message);
    }
}

