/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.ValueWrapper;
import org.drools.scenariosimulation.backend.util.ScenarioBeanWrapper;

public class ScenarioBeanUtil {
    private static final Map<String, Class<?>> primitiveMap = new HashMap();

    private ScenarioBeanUtil() {
    }

    public static <T> T fillBean(String className, Map<List<String>, Object> params, ClassLoader classLoader) {
        return ScenarioBeanUtil.fillBean(ValueWrapper.errorEmptyMessage(), className, params, classLoader);
    }

    public static <T> T fillBean(ValueWrapper<Object> initialInstance, String className, Map<List<String>, Object> params, ClassLoader classLoader) {
        Object beanToFill = initialInstance.orElseGet(() -> ScenarioBeanUtil.newInstance(ScenarioBeanUtil.loadClass(className, classLoader)));
        for (Map.Entry<List<String>, Object> param : params.entrySet()) {
            if (param.getKey().isEmpty()) continue;
            try {
                ScenarioBeanUtil.fillProperty(beanToFill, param.getKey(), param.getValue());
            }
            catch (ReflectiveOperationException e) {
                throw new ScenarioException("Impossible to fill " + className + " with the provided properties", e);
            }
            catch (IllegalArgumentException e) {
                throw new ScenarioException(e.getMessage(), e);
            }
        }
        return (T)beanToFill;
    }

    private static <T> void fillProperty(T beanToFill, List<String> steps, Object propertyValue) throws ReflectiveOperationException {
        List<String> pathToProperty = steps.subList(0, steps.size() - 1);
        String lastStep = steps.get(steps.size() - 1);
        Object currentObject = beanToFill;
        if (!pathToProperty.isEmpty()) {
            ScenarioBeanWrapper<?> scenarioBeanWrapper = ScenarioBeanUtil.navigateToObject(beanToFill, pathToProperty, true);
            currentObject = scenarioBeanWrapper.getBean();
        }
        Field last = ScenarioBeanUtil.getField(currentObject.getClass(), lastStep);
        last.setAccessible(true);
        last.set(currentObject, propertyValue);
    }

    public static ScenarioBeanWrapper<?> navigateToObject(Object rootObject, List<String> steps) {
        return ScenarioBeanUtil.navigateToObject(rootObject, steps, true);
    }

    public static ScenarioBeanWrapper<?> navigateToObject(Object rootObject, List<String> steps, boolean createIfNull) {
        Class<?> currentClass = rootObject != null ? rootObject.getClass() : null;
        Object currentObject = rootObject;
        for (String step : steps) {
            if (currentObject == null) {
                throw new ScenarioException("Impossible to reach field " + step + " because a step is not instantiated");
            }
            Field declaredField = ScenarioBeanUtil.getField(currentClass, step);
            declaredField.setAccessible(true);
            currentClass = declaredField.getType();
            try {
                currentObject = ScenarioBeanUtil.getFieldValue(declaredField, currentObject, createIfNull);
            }
            catch (ReflectiveOperationException e) {
                throw new ScenarioException("Impossible to get or create class " + currentClass.getCanonicalName());
            }
        }
        return new ScenarioBeanWrapper(currentObject, currentClass);
    }

    private static Object getFieldValue(Field declaredField, Object currentObject, boolean createIfNull) throws ReflectiveOperationException {
        Object value = declaredField.get(currentObject);
        if (value == null && createIfNull) {
            value = ScenarioBeanUtil.newInstance(declaredField.getType());
            declaredField.set(currentObject, value);
        }
        return value;
    }

    private static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new ScenarioException("Class " + clazz.getCanonicalName() + " has no empty constructor", e);
        }
    }

    public static Object convertValue(String className, Object cleanValue, ClassLoader classLoader) {
        Object object = cleanValue = "null".equals(cleanValue) ? null : cleanValue;
        if (!ScenarioBeanUtil.isPrimitive(className) && cleanValue == null) {
            return null;
        }
        Class clazz = ScenarioBeanUtil.loadClass(className, classLoader);
        if (!(cleanValue instanceof String)) {
            if (clazz.isInstance(cleanValue)) {
                return cleanValue;
            }
            throw new IllegalArgumentException("Object " + cleanValue + " is not a String or an instance of " + className);
        }
        String value = (String)cleanValue;
        try {
            if (clazz.isAssignableFrom(String.class)) {
                return value;
            }
            if (clazz.isAssignableFrom(BigDecimal.class)) {
                return ScenarioBeanUtil.parseBigDecimal(value);
            }
            if (clazz.isAssignableFrom(BigInteger.class)) {
                return ScenarioBeanUtil.parseBigInteger(value);
            }
            if (clazz.isAssignableFrom(Boolean.class) || clazz.isAssignableFrom(Boolean.TYPE)) {
                return ScenarioBeanUtil.parseBoolean(value);
            }
            if (clazz.isAssignableFrom(Byte.class) || clazz.isAssignableFrom(Byte.TYPE)) {
                return Byte.parseByte(value);
            }
            if (clazz.isAssignableFrom(Character.class) || clazz.isAssignableFrom(Character.TYPE)) {
                return Character.valueOf(ScenarioBeanUtil.parseChar(value));
            }
            if (clazz.isAssignableFrom(Double.class) || clazz.isAssignableFrom(Double.TYPE)) {
                return Double.parseDouble(ScenarioBeanUtil.cleanStringForNumberParsing(value));
            }
            if (clazz.isAssignableFrom(Float.class) || clazz.isAssignableFrom(Float.TYPE)) {
                return Float.valueOf(Float.parseFloat(ScenarioBeanUtil.cleanStringForNumberParsing(value)));
            }
            if (clazz.isAssignableFrom(Integer.class) || clazz.isAssignableFrom(Integer.TYPE)) {
                return Integer.parseInt(ScenarioBeanUtil.cleanStringForNumberParsing(value));
            }
            if (clazz.isAssignableFrom(LocalDate.class)) {
                return LocalDate.parse(value, DateTimeFormatter.ISO_LOCAL_DATE);
            }
            if (clazz.isAssignableFrom(LocalDateTime.class)) {
                return LocalDateTime.parse(value, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }
            if (clazz.isAssignableFrom(LocalTime.class)) {
                return LocalTime.parse(value, DateTimeFormatter.ISO_LOCAL_TIME);
            }
            if (clazz.isAssignableFrom(Long.class) || clazz.isAssignableFrom(Long.TYPE)) {
                return Long.parseLong(ScenarioBeanUtil.cleanStringForNumberParsing(value));
            }
            if (clazz.isAssignableFrom(Short.class) || clazz.isAssignableFrom(Short.TYPE)) {
                return Short.parseShort(ScenarioBeanUtil.cleanStringForNumberParsing(value));
            }
            if (Enum.class.isAssignableFrom(clazz)) {
                return Enum.valueOf(clazz, value);
            }
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Impossible to parse '" + value + "' as " + className + " [" + e.getMessage() + "]");
        }
        throw new IllegalArgumentException("Class " + className + " is not natively supported. Please use an MVEL expression to use it.");
    }

    public static String revertValue(Object cleanValue) {
        if (cleanValue == null) {
            return "null";
        }
        Class<Object> clazz = cleanValue.getClass();
        if (clazz.isAssignableFrom(String.class)) {
            return String.valueOf(cleanValue);
        }
        if (clazz.isAssignableFrom(BigDecimal.class)) {
            return String.valueOf(cleanValue);
        }
        if (clazz.isAssignableFrom(BigInteger.class)) {
            return String.valueOf(cleanValue);
        }
        if (clazz.isAssignableFrom(Boolean.class) || clazz.isAssignableFrom(Boolean.TYPE)) {
            return Boolean.toString((Boolean)cleanValue);
        }
        if (clazz.isAssignableFrom(Byte.class) || clazz.isAssignableFrom(Byte.TYPE)) {
            return String.valueOf(cleanValue);
        }
        if (clazz.isAssignableFrom(Character.class) || clazz.isAssignableFrom(Character.TYPE)) {
            return String.valueOf(cleanValue);
        }
        if (clazz.isAssignableFrom(Double.class) || clazz.isAssignableFrom(Double.TYPE)) {
            return ScenarioBeanUtil.revertDouble((Double)cleanValue);
        }
        if (clazz.isAssignableFrom(Float.class) || clazz.isAssignableFrom(Float.TYPE)) {
            return cleanValue + "f";
        }
        if (clazz.isAssignableFrom(Integer.class) || clazz.isAssignableFrom(Integer.TYPE)) {
            return Integer.toString((Integer)cleanValue);
        }
        if (clazz.isAssignableFrom(LocalDate.class)) {
            LocalDate localDate = (LocalDate)cleanValue;
            return String.format("%04d-%02d-%02d", localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
        }
        if (clazz.isAssignableFrom(LocalDateTime.class)) {
            return ScenarioBeanUtil.formatLocalDateTime((LocalDateTime)cleanValue);
        }
        if (clazz.isAssignableFrom(LocalTime.class)) {
            return ScenarioBeanUtil.formatLocalTime((LocalTime)cleanValue);
        }
        if (clazz.isAssignableFrom(Long.class) || clazz.isAssignableFrom(Long.TYPE)) {
            return Long.toString((Long)cleanValue);
        }
        if (clazz.isAssignableFrom(Short.class) || clazz.isAssignableFrom(Short.TYPE)) {
            return String.valueOf(cleanValue);
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return String.valueOf(cleanValue);
        }
        return String.valueOf(cleanValue);
    }

    public static String formatLocalDateTime(LocalDateTime ldt) {
        String commonFormat = "%04d-%02d-%02dT%02d:%02d:%02d";
        String nanoFormat = commonFormat + ".%09d";
        if (ldt.getNano() == 0) {
            return String.format(commonFormat, ldt.getYear(), ldt.getMonthValue(), ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond());
        }
        return String.format(nanoFormat, ldt.getYear(), ldt.getMonthValue(), ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond(), ldt.getNano());
    }

    public static String formatLocalTime(LocalTime lt) {
        String commonFormat = "%02d:%02d:%02d";
        String nanoFormat = commonFormat + ".%09d";
        if (lt.getNano() == 0) {
            return String.format(commonFormat, lt.getHour(), lt.getMinute(), lt.getSecond());
        }
        return String.format(nanoFormat, lt.getHour(), lt.getMinute(), lt.getSecond(), lt.getNano());
    }

    public static <T> Class<T> loadClass(String className, ClassLoader classLoader) {
        if (ScenarioBeanUtil.isPrimitive(className)) {
            return primitiveMap.get(className);
        }
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException | NullPointerException e) {
            throw new ScenarioException("Impossible to load class " + className, e);
        }
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        return ScenarioBeanUtil.internalGetField(clazz.getCanonicalName(), clazz, fieldName);
    }

    private static Field internalGetField(String canonicalClassName, Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() != null) {
                return ScenarioBeanUtil.internalGetField(canonicalClassName, clazz.getSuperclass(), fieldName);
            }
            throw new ScenarioException("Impossible to find field with name '" + fieldName + "' in class " + canonicalClassName);
        }
    }

    private static boolean isPrimitive(String className) {
        return primitiveMap.containsKey(className);
    }

    private static BigDecimal parseBigDecimal(String value) {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance();
        df.setParseBigDecimal(true);
        try {
            return (BigDecimal)df.parse(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static BigInteger parseBigInteger(String value) {
        return ScenarioBeanUtil.parseBigDecimal(value).toBigInteger();
    }

    private static boolean parseBoolean(String value) {
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        throw new IllegalArgumentException("Impossible to parse as boolean " + value);
    }

    private static char parseChar(String value) {
        if (value == null || value.length() != 1) {
            throw new IllegalArgumentException("Impossible to transform " + value + " as char");
        }
        return value.charAt(0);
    }

    private static String cleanStringForNumberParsing(String rawValue) {
        return rawValue.replaceAll("(-)\\s*([0-9])", "$1$2");
    }

    private static String revertDouble(Double doubleValue) {
        if (Double.isInfinite(doubleValue) || Double.isNaN(doubleValue)) {
            return String.valueOf(doubleValue);
        }
        return doubleValue + "d";
    }

    static {
        primitiveMap.put("boolean", Boolean.TYPE);
        primitiveMap.put("int", Integer.TYPE);
        primitiveMap.put("long", Long.TYPE);
        primitiveMap.put("double", Double.TYPE);
        primitiveMap.put("float", Float.TYPE);
        primitiveMap.put("char", Character.TYPE);
        primitiveMap.put("byte", Byte.TYPE);
        primitiveMap.put("short", Short.TYPE);
    }
}

