/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import junit.framework.TestCase;
import org.drools.scenariosimulation.backend.util.JsonUtils;
import org.junit.Assert;
import org.junit.Test;

public class JsonUtilsTest {
    @Test
    public void convertFromStringToJSONNode() {
        Assert.assertFalse((boolean)JsonUtils.convertFromStringToJSONNode(null).isPresent());
        Assert.assertFalse((boolean)JsonUtils.convertFromStringToJSONNode((String)"Not json").isPresent());
        Assert.assertFalse((boolean)JsonUtils.convertFromStringToJSONNode((String)"\"Not json").isPresent());
        Assert.assertFalse((boolean)JsonUtils.convertFromStringToJSONNode((String)"key : notJson\"").isPresent());
        Assert.assertFalse((boolean)JsonUtils.convertFromStringToJSONNode((String)"[key : 100]").isPresent());
        Assert.assertFalse((boolean)JsonUtils.convertFromStringToJSONNode((String)"{\"key\" : 100{").isPresent());
        Assert.assertFalse((boolean)JsonUtils.convertFromStringToJSONNode((String)"{key : 100}").isPresent());
        TestCase.assertTrue((boolean)JsonUtils.convertFromStringToJSONNode((String)"\"Json\"").isPresent());
        TestCase.assertTrue((boolean)JsonUtils.convertFromStringToJSONNode((String)"\"key : Json\"").isPresent());
        TestCase.assertTrue((boolean)JsonUtils.convertFromStringToJSONNode((String)"{ \"id\": 2, \"username\": \"user\", \"num\": 12, \"name\": \"Mr Yellow\"\n }").isPresent());
        TestCase.assertTrue((boolean)JsonUtils.convertFromStringToJSONNode((String)"{ \"users\": [\n\t\t{ \"id\": 3, \"username\": \"user45\", \"num\": 24, \"name\": \"Mr White\" },\n\t\t{ \"id\": 4, \"username\": \"user65\", \"num\": 32, \"name\": \"Mr Red\" }\n\t]}").isPresent());
        TestCase.assertTrue((boolean)JsonUtils.convertFromStringToJSONNode((String)"[{\"name\": \"\\\"John\\\"\"}, {\"name\": \"\\\"John\\\"\", \"names\" : [{\"value\": \"\\\"Anna\\\"\"}, {\"value\": \"\\\"Mario\\\"\"}]}]").isPresent());
        TestCase.assertTrue((boolean)JsonUtils.convertFromStringToJSONNode((String)"[1,2,3]").isPresent());
        TestCase.assertTrue((boolean)JsonUtils.convertFromStringToJSONNode((String)"{\"id\": 23, \"num\": 34, \"time\" : 56}").isPresent());
        TestCase.assertTrue((String)"Combine three data types in object", (boolean)JsonUtils.convertFromStringToJSONNode((String)"{\"married\":true, \"num\":34, \"name\": \"john\"}").isPresent());
        TestCase.assertTrue((String)"Combine three data types in array", (boolean)JsonUtils.convertFromStringToJSONNode((String)"[{\"married\":true,\"num\":34,\"name\":\"john\"},{\"married\":false,\"num\":43,\"name\":\"jane\"}]").isPresent());
        TestCase.assertTrue((String)"Whitespaces", (boolean)JsonUtils.convertFromStringToJSONNode((String)"{\"is married\":\"yes, is\"}").isPresent());
    }
}

