/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import java.util.Arrays;
import java.util.Collection;
import org.drools.scenariosimulation.backend.expression.BaseExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorResult;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ParameterizedBaseExpressionEvaluatorTest {
    private static final ClassLoader classLoader = ParameterizedBaseExpressionEvaluatorTest.class.getClassLoader();
    private static final BaseExpressionEvaluator baseExpressionEvaluator = new BaseExpressionEvaluator(classLoader);
    @Parameterized.Parameter(value=0)
    public ExpressionEvaluatorResult expectedResult;
    @Parameterized.Parameter(value=1)
    public Object resultValue;
    @Parameterized.Parameter(value=2)
    public String exprToTest;
    @Parameterized.Parameter(value=3)
    public Class<?> clazz;

    @Parameterized.Parameters(name="{index}: Expr \"{0} {1}\" should be true")
    public static Collection<Object[]> data() {
        return Arrays.asList({ExpressionEvaluatorResult.ofSuccessful(), 1, "1", Integer.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), 2, "!= 1", Integer.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), -1, "- 1", Integer.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), -2, "< -  1", Integer.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), -2L, "< -  1", Long.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), -2.0, "< -  1", Double.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), Float.valueOf(-2.0f), "< -  1", Float.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), (short)-2, "< - 1", Short.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), "String", "<> Test", String.class}, {ExpressionEvaluatorResult.ofSuccessful(), "Test", "= Test", String.class}, {ExpressionEvaluatorResult.ofSuccessful(), 1, "<2", Integer.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), 1, "<2; >0", Integer.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), 2, " <= 2 ", Integer.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), 2, " >= 2", Integer.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), 1, "[ 1, 2 ,3]", Integer.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), 2, "[ 1, 2 ,3]", Integer.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), "3", "[ 1, 2 ,3]", String.class}, {ExpressionEvaluatorResult.ofSuccessful(), 4, "![ 1, 2 ,3]", Integer.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), 4, "! < 1", Integer.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), 1, "> -1", Integer.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), 10, "!= <10;!= >11", Integer.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), 10, "= 10; >9", Integer.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), null, null, Integer.class}, {ExpressionEvaluatorResult.ofSuccessful(), null, "!1", Integer.class}, {ExpressionEvaluatorResult.ofSuccessful(), Character.valueOf('b'), "!a", Character.class}, {ExpressionEvaluatorResult.ofSuccessful(), "0".getBytes()[0], "![47, 49, 50]", Byte.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), "0".getBytes()[0], ">40; <60", Byte.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), "0".getBytes()[0], ">30; <100", Byte.class}, {ExpressionEvaluatorResult.ofSuccessful(), "0".getBytes()[0], "[48, 49, 50]", Byte.class}, {ExpressionEvaluatorResult.ofSuccessful(), (short)1, ">0", Short.class}, {ExpressionEvaluatorResult.ofSuccessful(), null, "[ !false]", Boolean.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), null, "[! false, ! true]", Boolean.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), 10, "[> 1]", Integer.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), 10, "[< 1, > 1]", Integer.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), "", ";", String.class}, {ExpressionEvaluatorResult.ofFailed(), null, ";", String.class}, {ExpressionEvaluatorResult.ofFailed(), null, "=", String.class}, {ExpressionEvaluatorResult.ofFailed(), null, "[]", String.class}, {ExpressionEvaluatorResult.ofSuccessful(), Error.class, ";", Boolean.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), Error.class, "[]", Boolean.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), Error.class, "=", Boolean.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), Error.class, "!= false; <> false, ! false", Boolean.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), Error.class, "<> false, ! false", Boolean.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), Error.class, "! tru", Void.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), Error.class, "fals", Void.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), Error.class, "!= fals", Void.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), Error.class, "tru", Void.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), Error.class, "<> fals", Void.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), Error.class, "tru", Void.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), Error.class, "!m= false", Void.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), Error.class, ">> 3", Void.TYPE}, {ExpressionEvaluatorResult.ofSuccessful(), Error.class, "< - 1 1", Integer.TYPE});
    }

    @Test
    public void evaluateUnaryExpression() {
        if (!(this.resultValue instanceof Class)) {
            Assert.assertEquals((Object)this.expectedResult.isSuccessful(), (Object)baseExpressionEvaluator.evaluateUnaryExpression(this.exprToTest, this.resultValue, this.clazz).isSuccessful());
        } else {
            try {
                baseExpressionEvaluator.evaluateUnaryExpression(this.exprToTest, (Object)true, this.clazz);
                Assert.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

