/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.fluent;

import java.util.Map;
import java.util.stream.IntStream;
import org.drools.scenariosimulation.backend.fluent.CoverageAgendaListener;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.runtime.rule.Match;
import org.kie.internal.definition.rule.InternalRule;
import org.mockito.Mockito;

public abstract class AbstractRuleCoverageTest {
    protected CoverageAgendaListener createCoverageAgendaListenerWithData(Map<String, Integer> rulesToNumberOfTimes) {
        CoverageAgendaListener coverageAgendaListener = new CoverageAgendaListener();
        for (Map.Entry<String, Integer> ruleToNumberOfTimes : rulesToNumberOfTimes.entrySet()) {
            BeforeMatchFiredEvent beforeMatchFiredEventMock = this.createBeforeMatchFiredEventMock(ruleToNumberOfTimes.getKey());
            IntStream.range(0, ruleToNumberOfTimes.getValue()).forEach(i -> coverageAgendaListener.beforeMatchFired(beforeMatchFiredEventMock));
        }
        return coverageAgendaListener;
    }

    protected BeforeMatchFiredEvent createBeforeMatchFiredEventMock(String ruleName) {
        BeforeMatchFiredEvent eventMock = (BeforeMatchFiredEvent)Mockito.mock(BeforeMatchFiredEvent.class);
        Match matchMock = (Match)Mockito.mock(Match.class);
        InternalRule ruleMock = (InternalRule)Mockito.mock(InternalRule.class);
        Mockito.when((Object)ruleMock.getName()).thenReturn((Object)ruleName);
        Mockito.when((Object)ruleMock.getPackageName()).thenReturn((Object)"");
        Mockito.when((Object)matchMock.getRule()).thenReturn((Object)ruleMock);
        Mockito.when((Object)eventMock.getMatch()).thenReturn((Object)matchMock);
        return eventMock;
    }
}

