/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.backend.runner.AbstractScenarioRunner;
import org.drools.scenariosimulation.backend.runner.ScenarioJunitActivator;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerDTO;
import org.drools.scenariosimulation.backend.util.ScenarioSimulationXMLPersistence;
import org.drools.util.ResourceHelper;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.kie.api.runtime.KieContainer;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ScenarioJunitActivatorTest {
    @Mock
    private ScenarioSimulationXMLPersistence xmlReaderMock;
    @Mock
    private KieContainer kieContainerMock;
    @Mock
    private AbstractScenarioRunner runnerMock;
    @Mock
    private ScenarioRunnerDTO scenarioRunnerDTOMock;
    @Mock
    private ScenarioSimulationModel scenarioSimulationModelMock;
    @Mock
    private RunNotifier runNotifierMock;
    private Simulation simulationLocal;
    private Settings settingsLocal;

    @Before
    public void setup() throws Exception {
        this.simulationLocal = new Simulation();
        this.settingsLocal = new Settings();
        this.settingsLocal.setSkipFromBuild(true);
        Mockito.when((Object)this.xmlReaderMock.unmarshal((String)ArgumentMatchers.any())).thenReturn((Object)this.scenarioSimulationModelMock);
        Mockito.when((Object)this.scenarioSimulationModelMock.getSimulation()).thenReturn((Object)this.simulationLocal);
        Mockito.when((Object)this.scenarioSimulationModelMock.getSettings()).thenReturn((Object)this.settingsLocal);
    }

    @Test
    public void getChildrenTest() throws InitializationError {
        Assertions.assertThat((int)this.getScenarioJunitActivator().getChildren().size()).isEqualTo(0);
        this.settingsLocal.setSkipFromBuild(false);
        Assertions.assertThat((int)this.getScenarioJunitActivator().getChildren().size()).isEqualTo(1);
    }

    @Test
    public void runChildTest() throws InitializationError {
        this.getScenarioJunitActivator().runChild(this.scenarioRunnerDTOMock, this.runNotifierMock);
        ((AbstractScenarioRunner)Mockito.verify((Object)this.runnerMock, (VerificationMode)Mockito.times((int)1))).run(this.runNotifierMock);
    }

    private ScenarioJunitActivator getScenarioJunitActivator() throws InitializationError {
        return new ScenarioJunitActivator(ScenarioJunitActivator.class){

            ScenarioSimulationXMLPersistence getXmlReader() {
                return ScenarioJunitActivatorTest.this.xmlReaderMock;
            }

            Stream<String> getResources() {
                return ResourceHelper.getResourcesByExtension((String)"txt").stream();
            }

            KieContainer getKieContainer() {
                return ScenarioJunitActivatorTest.this.kieContainerMock;
            }

            AbstractScenarioRunner newRunner(KieContainer kieContainer, ScenarioRunnerDTO scenarioRunnerDTO) {
                return ScenarioJunitActivatorTest.this.runnerMock;
            }
        };
    }
}

