/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.backend.model.Dispute;
import org.drools.scenariosimulation.backend.model.NotEmptyConstructor;
import org.drools.scenariosimulation.backend.model.Person;
import org.drools.scenariosimulation.backend.model.SubPerson;
import org.drools.scenariosimulation.backend.runner.RuleScenarioRunnerHelperTest;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.ValueWrapper;
import org.drools.scenariosimulation.backend.util.ScenarioBeanUtil;
import org.drools.scenariosimulation.backend.util.ScenarioBeanWrapper;
import org.drools.scenariosimulation.backend.util.model.EnumTest;
import org.junit.Test;

public class ScenarioBeanUtilTest {
    private static String FIRST_NAME = "firstNameToSet";
    private static int AGE = 10;
    private static ClassLoader classLoader = ScenarioBeanUtilTest.class.getClassLoader();

    @Test
    public void fillBeanTest() {
        HashMap<List<String>, Object> paramsToSet = new HashMap<List<String>, Object>();
        paramsToSet.put(Arrays.asList("creator", "firstName"), FIRST_NAME);
        paramsToSet.put(Arrays.asList("creator", "age"), AGE);
        Object result = ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.errorEmptyMessage(), (String)Dispute.class.getCanonicalName(), paramsToSet, (ClassLoader)classLoader);
        Assertions.assertThat((boolean)(result instanceof Dispute)).isTrue();
        Dispute dispute = (Dispute)result;
        Assertions.assertThat((String)FIRST_NAME).isEqualTo(dispute.getCreator().getFirstName());
        Assertions.assertThat((int)AGE).isEqualTo(dispute.getCreator().getAge());
    }

    @Test
    public void fillBeanTestWithInitialInstanceTest() {
        Dispute dispute = new Dispute();
        HashMap<List<String>, Object> paramsToSet = new HashMap<List<String>, Object>();
        paramsToSet.put(Arrays.asList("creator", "firstName"), FIRST_NAME);
        paramsToSet.put(Arrays.asList("creator", "age"), AGE);
        Object result = ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.of((Object)dispute), (String)Dispute.class.getCanonicalName(), paramsToSet, (ClassLoader)classLoader);
        Assertions.assertThat((boolean)(result instanceof Dispute)).isTrue();
        Assertions.assertThat((Object)result).isSameAs((Object)dispute);
        Assertions.assertThat((String)FIRST_NAME).isEqualTo(dispute.getCreator().getFirstName());
        Assertions.assertThat((int)AGE).isEqualTo(dispute.getCreator().getAge());
    }

    @Test(expected=ScenarioException.class)
    public void fillBeanLoadClassTest() {
        ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.errorEmptyMessage(), (String)"FakeCanonicalName", new HashMap(), (ClassLoader)classLoader);
    }

    @Test(expected=ScenarioException.class)
    public void fillBeanFailNotEmptyConstructorTest() {
        HashMap<List<String>, Object> paramsToSet = new HashMap<List<String>, Object>();
        paramsToSet.put(Collections.singletonList("name"), null);
        ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.errorEmptyMessage(), (String)NotEmptyConstructor.class.getCanonicalName(), paramsToSet, (ClassLoader)classLoader);
    }

    @Test(expected=ScenarioException.class)
    public void fillBeanFailTest() {
        HashMap<List<String>, Object> paramsToSet = new HashMap<List<String>, Object>();
        paramsToSet.put(Collections.singletonList("fakeField"), null);
        ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.errorEmptyMessage(), (String)Dispute.class.getCanonicalName(), paramsToSet, (ClassLoader)classLoader);
    }

    @Test(expected=ScenarioException.class)
    public void fillBeanFailNullClassTest() {
        HashMap<List<String>, Object> paramsToSet = new HashMap<List<String>, Object>();
        paramsToSet.put(Collections.singletonList("fakeField"), null);
        ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.errorEmptyMessage(), null, paramsToSet, (ClassLoader)classLoader);
    }

    @Test(expected=ScenarioException.class)
    public void fillBeanFailWrongTypeTest() {
        HashMap paramsToSet = new HashMap();
        paramsToSet.put(Collections.singletonList("description"), new ArrayList());
        ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.errorEmptyMessage(), (String)Dispute.class.getCanonicalName(), paramsToSet, (ClassLoader)classLoader);
    }

    @Test
    public void fillBeanEmptyValueTest() {
        HashMap paramsToSet = new HashMap();
        paramsToSet.put(Collections.emptyList(), null);
        Assertions.assertThat((String)((String)ScenarioBeanUtil.fillBean((ValueWrapper)ValueWrapper.of(null), (String)String.class.getCanonicalName(), paramsToSet, (ClassLoader)classLoader))).isNull();
    }

    @Test
    public void navigateToObjectTest() {
        Dispute dispute = new Dispute();
        Person creator = new Person();
        creator.setFirstName(FIRST_NAME);
        dispute.setCreator(creator);
        List<String> pathToProperty = Arrays.asList("creator", "firstName");
        ScenarioBeanWrapper scenarioBeanWrapper = ScenarioBeanUtil.navigateToObject((Object)dispute, pathToProperty, (boolean)true);
        Object targetObject = scenarioBeanWrapper.getBean();
        Assertions.assertThat((String)FIRST_NAME).isEqualTo(targetObject);
        Assertions.assertThat((Object)ScenarioBeanUtil.navigateToObject(null, Collections.emptyList()).getBean()).isNull();
    }

    @Test
    public void navigateToObjectFakeFieldTest() {
        Dispute dispute = new Dispute();
        List<String> pathToProperty = Collections.singletonList("fakeField");
        String message = "Impossible to find field with name 'fakeField' in class " + Dispute.class.getCanonicalName();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.navigateToObject((Object)dispute, (List)pathToProperty, (boolean)true)).isInstanceOf(ScenarioException.class)).hasMessage(message);
    }

    @Test
    public void navigateToObjectNoStepCreationTest() {
        Dispute dispute = new Dispute();
        List<String> pathToProperty = Arrays.asList("creator", "firstName");
        String message = "Impossible to reach field firstName because a step is not instantiated";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.navigateToObject((Object)dispute, (List)pathToProperty, (boolean)false)).isInstanceOf(ScenarioException.class)).hasMessage(message);
    }

    @Test
    public void convertValueTest() {
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)String.class.getCanonicalName(), (Object)"Test", (ClassLoader)classLoader)).isEqualTo((Object)"Test");
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)BigDecimal.class.getCanonicalName(), (Object)"13.33", (ClassLoader)classLoader)).isEqualTo((Object)BigDecimal.valueOf(13.33));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)BigDecimal.class.getCanonicalName(), (Object)"13", (ClassLoader)classLoader)).isEqualTo((Object)BigDecimal.valueOf(13L));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)BigDecimal.class.getCanonicalName(), (Object)"1,232,113.33", (ClassLoader)classLoader)).isEqualTo((Object)BigDecimal.valueOf(1232113.33));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)BigDecimal.class.getCanonicalName(), (Object)"1232113.33", (ClassLoader)classLoader)).isEqualTo((Object)BigDecimal.valueOf(1232113.33));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)BigInteger.class.getCanonicalName(), (Object)"13.33", (ClassLoader)classLoader)).isEqualTo((Object)BigInteger.valueOf(13L));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)BigInteger.class.getCanonicalName(), (Object)"13", (ClassLoader)classLoader)).isEqualTo((Object)BigInteger.valueOf(13L));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)BigInteger.class.getCanonicalName(), (Object)"1,232,113.33", (ClassLoader)classLoader)).isEqualTo((Object)BigInteger.valueOf(1232113L));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)BigInteger.class.getCanonicalName(), (Object)"1232113", (ClassLoader)classLoader)).isEqualTo((Object)BigInteger.valueOf(1232113L));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Boolean.TYPE.getCanonicalName(), (Object)"false", (ClassLoader)classLoader)).isEqualTo((Object)false);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Boolean.class.getCanonicalName(), (Object)"true", (ClassLoader)classLoader)).isEqualTo((Object)true);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Integer.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)).isEqualTo((Object)1);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Integer.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)).isEqualTo((Object)1);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Long.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)).isEqualTo((Object)1L);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Long.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)).isEqualTo((Object)1L);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)).isEqualTo((Object)Float.valueOf(1.0f));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)).isEqualTo((Object)Float.valueOf(1.0f));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader)).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader)).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader)).isEqualTo((Object)Float.valueOf(1.0f));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader)).isEqualTo((Object)Float.valueOf(1.0f));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1.0d", (ClassLoader)classLoader)).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1.0d", (ClassLoader)classLoader)).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1.0f", (ClassLoader)classLoader)).isEqualTo((Object)Float.valueOf(1.0f));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1.0f", (ClassLoader)classLoader)).isEqualTo((Object)Float.valueOf(1.0f));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1.0D", (ClassLoader)classLoader)).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1.0D", (ClassLoader)classLoader)).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1.0F", (ClassLoader)classLoader)).isEqualTo((Object)Float.valueOf(1.0f));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1.0F", (ClassLoader)classLoader)).isEqualTo((Object)Float.valueOf(1.0f));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Character.TYPE.getCanonicalName(), (Object)"a", (ClassLoader)classLoader)).isEqualTo((Object)Character.valueOf('a'));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Character.class.getCanonicalName(), (Object)"a", (ClassLoader)classLoader)).isEqualTo((Object)Character.valueOf('a'));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Short.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)).isEqualTo((Object)1);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Short.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader)).isEqualTo((Object)1);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Byte.TYPE.getCanonicalName(), (Object)Byte.toString("0".getBytes()[0]), (ClassLoader)classLoader)).isEqualTo((Object)"0".getBytes()[0]);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Byte.class.getCanonicalName(), (Object)Byte.toString("0".getBytes()[0]), (ClassLoader)classLoader)).isEqualTo((Object)"0".getBytes()[0]);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)LocalDate.class.getCanonicalName(), (Object)"2018-05-20", (ClassLoader)classLoader)).isEqualTo((Object)LocalDate.of(2018, 5, 20));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)LocalDateTime.class.getCanonicalName(), (Object)"2017-02-18T10:30", (ClassLoader)classLoader)).isEqualTo((Object)LocalDateTime.of(2017, 2, 18, 10, 30));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)LocalDateTime.class.getCanonicalName(), (Object)"1982-04-04T00:20", (ClassLoader)classLoader)).isEqualTo((Object)LocalDateTime.of(1982, 4, 4, 0, 20, 0));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)LocalDateTime.class.getCanonicalName(), (Object)"1982-10-13T02:09:00.999999999", (ClassLoader)classLoader)).isEqualTo((Object)LocalDateTime.of(1982, 10, 13, 2, 9, 0, 999999999));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)LocalTime.class.getCanonicalName(), (Object)"01:09:00", (ClassLoader)classLoader)).isEqualTo((Object)LocalTime.of(1, 9, 0));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)LocalTime.class.getCanonicalName(), (Object)"04:59:07.009999999", (ClassLoader)classLoader)).isEqualTo((Object)LocalTime.of(4, 59, 7, 9999999));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)LocalTime.class.getCanonicalName(), (Object)"23:45", (ClassLoader)classLoader)).isEqualTo((Object)LocalTime.of(23, 45));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)LocalTime.class.getCanonicalName(), (Object)"01:09:00", (ClassLoader)classLoader)).isEqualTo((Object)LocalTime.of(1, 9, 0));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)LocalTime.class.getCanonicalName(), (Object)"04:59:07.009999999", (ClassLoader)classLoader)).isEqualTo((Object)LocalTime.of(4, 59, 7, 9999999));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)EnumTest.class.getCanonicalName(), (Object)"FIRST", (ClassLoader)classLoader)).isEqualTo((Object)EnumTest.FIRST);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), null, (ClassLoader)classLoader)).isNull();
    }

    @Test
    public void revertValueTest() {
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)"Test")).isEqualTo("Test");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)BigDecimal.valueOf(10000.83))).isEqualTo("10000.83");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)BigDecimal.valueOf(10000L))).isEqualTo("10000");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)BigInteger.valueOf(10000L))).isEqualTo("10000");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)Boolean.FALSE)).isEqualTo("false");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)Boolean.TRUE)).isEqualTo("true");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)false)).isEqualTo("false");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)true)).isEqualTo("true");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)1)).isEqualTo("1");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)new Integer(1))).isEqualTo("1");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)1L)).isEqualTo("1");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)new Long(1L))).isEqualTo("1");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)1.1)).isEqualTo("1.1d");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)new Double(1.1))).isEqualTo("1.1d");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)Double.NaN)).isEqualTo("NaN");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)Double.POSITIVE_INFINITY)).isEqualTo("Infinity");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)Double.NEGATIVE_INFINITY)).isEqualTo("-Infinity");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)Float.valueOf(1.1f))).isEqualTo("1.1f");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)new Float(1.1))).isEqualTo("1.1f");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)Character.valueOf('a'))).isEqualTo("a");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)new Character('a'))).isEqualTo("a");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)1)).isEqualTo("1");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)"0".getBytes()[0])).isEqualTo(String.valueOf("0".getBytes()[0]));
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)new Byte("0".getBytes()[0]))).isEqualTo(String.valueOf("0".getBytes()[0]));
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue(null)).isEqualTo("null");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)LocalDate.of(2018, 10, 20))).isEqualTo("2018-10-20");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)LocalDateTime.of(2018, 10, 20, 2, 13))).isEqualTo("2018-10-20T02:13:00");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)LocalDateTime.of(2018, 10, 20, 2, 13, 3))).isEqualTo("2018-10-20T02:13:03");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)LocalDateTime.of(2018, 10, 20, 2, 13, 3, 9999))).isEqualTo("2018-10-20T02:13:03.000009999");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)LocalTime.of(2, 13))).isEqualTo("02:13:00");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)LocalTime.of(2, 13, 3))).isEqualTo("02:13:03");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)LocalTime.of(2, 13, 3, 9999))).isEqualTo("02:13:03.000009999");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)((Object)EnumTest.FIRST))).isEqualTo("FIRST");
    }

    @Test
    public void convertAndRevertValue() {
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)String.class.getCanonicalName(), (Object)"Test", (ClassLoader)classLoader))).isEqualTo("Test");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Boolean.TYPE.getCanonicalName(), (Object)"false", (ClassLoader)classLoader))).isEqualTo("false");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Boolean.class.getCanonicalName(), (Object)"true", (ClassLoader)classLoader))).isEqualTo("true");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)BigDecimal.class.getCanonicalName(), (Object)"1000", (ClassLoader)classLoader))).isEqualTo("1000");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)BigDecimal.class.getCanonicalName(), (Object)"1000.23", (ClassLoader)classLoader))).isEqualTo("1000.23");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)BigDecimal.class.getCanonicalName(), (Object)"1,000.23", (ClassLoader)classLoader))).isEqualTo("1000.23");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)BigInteger.class.getCanonicalName(), (Object)"1000", (ClassLoader)classLoader))).isEqualTo("1000");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)BigInteger.class.getCanonicalName(), (Object)"1000.23", (ClassLoader)classLoader))).isEqualTo("1000");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)BigInteger.class.getCanonicalName(), (Object)"1,000.23", (ClassLoader)classLoader))).isEqualTo("1000");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Integer.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader))).isEqualTo("1");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Integer.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader))).isEqualTo("1");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Long.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader))).isEqualTo("1");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Long.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader))).isEqualTo("1");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader))).isEqualTo("1.0d");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader))).isEqualTo("1.0d");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"NaN", (ClassLoader)classLoader))).isEqualTo("NaN");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"NaN", (ClassLoader)classLoader))).isEqualTo("NaN");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"Infinity", (ClassLoader)classLoader))).isEqualTo("Infinity");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"Infinity", (ClassLoader)classLoader))).isEqualTo("Infinity");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"-Infinity", (ClassLoader)classLoader))).isEqualTo("-Infinity");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"-Infinity", (ClassLoader)classLoader))).isEqualTo("-Infinity");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader))).isEqualTo("1.0f");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader))).isEqualTo("1.0f");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader))).isEqualTo("1.0d");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader))).isEqualTo("1.0d");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader))).isEqualTo("1.0f");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader))).isEqualTo("1.0f");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1.0d", (ClassLoader)classLoader))).isEqualTo("1.0d");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1.0d", (ClassLoader)classLoader))).isEqualTo("1.0d");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1.0f", (ClassLoader)classLoader))).isEqualTo("1.0f");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1.0f", (ClassLoader)classLoader))).isEqualTo("1.0f");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1.0D", (ClassLoader)classLoader))).isEqualTo("1.0d");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1.0D", (ClassLoader)classLoader))).isEqualTo("1.0d");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1.0F", (ClassLoader)classLoader))).isEqualTo("1.0f");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1.0F", (ClassLoader)classLoader))).isEqualTo("1.0f");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Character.TYPE.getCanonicalName(), (Object)"a", (ClassLoader)classLoader))).isEqualTo("a");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Character.class.getCanonicalName(), (Object)"a", (ClassLoader)classLoader))).isEqualTo("a");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Short.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader))).isEqualTo("1");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Short.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader))).isEqualTo("1");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Byte.TYPE.getCanonicalName(), (Object)Byte.toString("0".getBytes()[0]), (ClassLoader)classLoader))).isEqualTo(Byte.toString("0".getBytes()[0]));
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Byte.class.getCanonicalName(), (Object)Byte.toString("0".getBytes()[0]), (ClassLoader)classLoader))).isEqualTo(Byte.toString("0".getBytes()[0]));
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)LocalDate.class.getCanonicalName(), (Object)"2018-05-20", (ClassLoader)classLoader))).isEqualTo("2018-05-20");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)LocalDateTime.class.getCanonicalName(), (Object)"2018-05-20T03:04", (ClassLoader)classLoader))).isEqualTo("2018-05-20T03:04:00");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)LocalDateTime.class.getCanonicalName(), (Object)"2018-05-20T03:04:01", (ClassLoader)classLoader))).isEqualTo("2018-05-20T03:04:01");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)LocalDateTime.class.getCanonicalName(), (Object)"2018-05-20T03:04:01.000009999", (ClassLoader)classLoader))).isEqualTo("2018-05-20T03:04:01.000009999");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)LocalTime.class.getCanonicalName(), (Object)"03:04", (ClassLoader)classLoader))).isEqualTo("03:04:00");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)LocalTime.class.getCanonicalName(), (Object)"03:04:01", (ClassLoader)classLoader))).isEqualTo("03:04:01");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)LocalTime.class.getCanonicalName(), (Object)"03:04:01.000009999", (ClassLoader)classLoader))).isEqualTo("03:04:01.000009999");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)EnumTest.class.getCanonicalName(), (Object)"FIRST", (ClassLoader)classLoader))).isEqualTo("FIRST");
        Assertions.assertThat((String)ScenarioBeanUtil.revertValue((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), null, (ClassLoader)classLoader))).isEqualTo("null");
    }

    @Test
    public void revertAndConvertValueTest() {
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)String.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)"Test"), (ClassLoader)classLoader)).isEqualTo((Object)"Test");
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Boolean.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)false), (ClassLoader)classLoader)).isEqualTo((Object)false);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Boolean.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)Boolean.TRUE), (ClassLoader)classLoader)).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)BigInteger.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)BigInteger.valueOf(1000L)), (ClassLoader)classLoader)).isEqualTo((Object)BigInteger.valueOf(1000L));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)BigDecimal.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)BigDecimal.valueOf(1000L)), (ClassLoader)classLoader)).isEqualTo((Object)BigDecimal.valueOf(1000L));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)BigDecimal.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)BigDecimal.valueOf(1000.13)), (ClassLoader)classLoader)).isEqualTo((Object)BigDecimal.valueOf(1000.13));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Integer.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader)).isEqualTo((Object)1);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Integer.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader)).isEqualTo((Object)1);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Long.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1L), (ClassLoader)classLoader)).isEqualTo((Object)1L);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Long.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1L), (ClassLoader)classLoader)).isEqualTo((Object)1L);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader)).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader)).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader)).isEqualTo((Object)Float.valueOf(1.0f));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader)).isEqualTo((Object)Float.valueOf(1.0f));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader)).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader)).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader)).isEqualTo((Object)Float.valueOf(1.0f));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader)).isEqualTo((Object)Float.valueOf(1.0f));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader)).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader)).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)Float.valueOf(1.0f)), (ClassLoader)classLoader)).isEqualTo((Object)Float.valueOf(1.0f));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)Float.valueOf(1.0f)), (ClassLoader)classLoader)).isEqualTo((Object)Float.valueOf(1.0f));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader)).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1.0), (ClassLoader)classLoader)).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)Float.valueOf(1.0f)), (ClassLoader)classLoader)).isEqualTo((Object)Float.valueOf(1.0f));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)Float.valueOf(1.0f)), (ClassLoader)classLoader)).isEqualTo((Object)Float.valueOf(1.0f));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Character.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)Character.valueOf('a')), (ClassLoader)classLoader)).isEqualTo((Object)Character.valueOf('a'));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Character.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)Character.valueOf('a')), (ClassLoader)classLoader)).isEqualTo((Object)Character.valueOf('a'));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Short.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader)).isEqualTo((Object)1);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Short.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)1), (ClassLoader)classLoader)).isEqualTo((Object)1);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Byte.TYPE.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)"0".getBytes()[0]), (ClassLoader)classLoader)).isEqualTo((Object)"0".getBytes()[0]);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)Byte.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)"0".getBytes()[0]), (ClassLoader)classLoader)).isEqualTo((Object)"0".getBytes()[0]);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)LocalDate.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)LocalDate.of(2018, 10, 20)), (ClassLoader)classLoader)).isEqualTo((Object)LocalDate.of(2018, 10, 20));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)LocalDateTime.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)LocalDateTime.of(2018, 10, 20, 2, 3)), (ClassLoader)classLoader)).isEqualTo((Object)LocalDateTime.of(2018, 10, 20, 2, 3));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)LocalDateTime.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)LocalDateTime.of(2018, 10, 20, 2, 3, 1)), (ClassLoader)classLoader)).isEqualTo((Object)LocalDateTime.of(2018, 10, 20, 2, 3, 1));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)LocalDateTime.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)LocalDateTime.of(2018, 10, 20, 2, 3, 1, 9999)), (ClassLoader)classLoader)).isEqualTo((Object)LocalDateTime.of(2018, 10, 20, 2, 3, 1, 9999));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)LocalTime.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)LocalTime.of(2, 3)), (ClassLoader)classLoader)).isEqualTo((Object)LocalTime.of(2, 3));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)LocalTime.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)LocalTime.of(2, 3, 1)), (ClassLoader)classLoader)).isEqualTo((Object)LocalTime.of(2, 3, 1));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)LocalTime.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)LocalTime.of(2, 3, 1, 9999)), (ClassLoader)classLoader)).isEqualTo((Object)LocalTime.of(2, 3, 1, 9999));
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)EnumTest.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue((Object)((Object)EnumTest.FIRST)), (ClassLoader)classLoader)).isEqualTo((Object)EnumTest.FIRST);
        Assertions.assertThat((Object)ScenarioBeanUtil.convertValue((String)String.class.getCanonicalName(), (Object)ScenarioBeanUtil.revertValue(null), (ClassLoader)classLoader)).isNull();
    }

    @Test
    public void convertValueFailLoadClassTest() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.convertValue((String)"my.NotExistingClass", (Object)"Test", (ClassLoader)classLoader)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Impossible to load ");
    }

    @Test
    public void convertValueFailUnsupportedTest() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.convertValue((String)RuleScenarioRunnerHelperTest.class.getCanonicalName(), (Object)"Test", (ClassLoader)classLoader)).isInstanceOf(IllegalArgumentException.class)).hasMessageEndingWith("Please use an MVEL expression to use it.");
    }

    @Test
    public void convertValueFailPrimitiveNullTest() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.convertValue((String)"int", null, (ClassLoader)classLoader)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(" is not a String or an instance of");
    }

    @Test
    public void convertValueFailNotStringOrTypeTest() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.convertValue((String)RuleScenarioRunnerHelperTest.class.getCanonicalName(), (Object)1, (ClassLoader)classLoader)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Object 1 is not a String or an instance of");
    }

    @Test
    public void convertValueFailParsing() {
        String integerCanonicalName = Integer.class.getCanonicalName();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.convertValue((String)integerCanonicalName, (Object)"wrongValue", (ClassLoader)classLoader)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Impossible to parse 'wrongValue' as " + integerCanonicalName);
    }

    @Test
    public void convertValueEnumWrongValue() {
        String enumTestCanonicalName = EnumTest.class.getCanonicalName();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.convertValue((String)EnumTest.class.getCanonicalName(), (Object)"FIRS", (ClassLoader)classLoader)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Impossible to parse 'FIRS' as " + enumTestCanonicalName);
    }

    @Test
    public void loadClassTest() {
        Assertions.assertThat((Class)ScenarioBeanUtil.loadClass((String)String.class.getCanonicalName(), (ClassLoader)classLoader)).isEqualTo(String.class);
        Assertions.assertThat((Class)ScenarioBeanUtil.loadClass((String)Integer.TYPE.getCanonicalName(), (ClassLoader)classLoader)).isEqualTo(Integer.TYPE);
        Assertions.assertThat((Class)ScenarioBeanUtil.loadClass((String)RuleScenarioRunnerHelperTest.class.getCanonicalName(), (ClassLoader)classLoader)).isEqualTo(RuleScenarioRunnerHelperTest.class);
        Assertions.assertThat((Class)ScenarioBeanUtil.loadClass((String)EnumTest.class.getCanonicalName(), (ClassLoader)classLoader)).isEqualTo(EnumTest.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.loadClass(null, (ClassLoader)classLoader)).isInstanceOf(ScenarioException.class)).hasMessage("Impossible to load class null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.loadClass((String)"NotExistingClass", (ClassLoader)classLoader)).isInstanceOf(ScenarioException.class)).hasMessage("Impossible to load class NotExistingClass");
    }

    @Test
    public void getFieldTest() {
        Assertions.assertThat((Object)ScenarioBeanUtil.getField(Person.class, (String)"firstName")).isNotNull();
        Assertions.assertThat((Object)ScenarioBeanUtil.getField(SubPerson.class, (String)"firstName")).isNotNull();
        Assertions.assertThat((Object)ScenarioBeanUtil.getField(SubPerson.class, (String)"additionalField")).isNotNull();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.getField(Person.class, (String)"notExistingField")).isInstanceOf(ScenarioException.class)).hasMessageStartingWith("Impossible to find field with name ");
    }
}

