/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import com.fasterxml.jackson.databind.node.TextNode;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.backend.expression.AbstractExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.BaseExpressionEvaluator;
import org.drools.scenariosimulation.backend.model.ListMapClass;
import org.junit.Test;

public class BaseExpressionEvaluatorTest {
    private static final ClassLoader classLoader = BaseExpressionEvaluatorTest.class.getClassLoader();
    private static final AbstractExpressionEvaluator expressionEvaluator = new BaseExpressionEvaluator(classLoader);

    @Test
    public void evaluateLiteralExpression() {
        String raw = "";
        Assertions.assertThat((Object)expressionEvaluator.evaluateLiteralExpression(raw, Object.class.getCanonicalName(), Collections.emptyList())).isEqualTo((Object)raw);
        raw = "SimpleString";
        Assertions.assertThat((Object)expressionEvaluator.evaluateLiteralExpression(raw, String.class.getCanonicalName(), Collections.emptyList())).isEqualTo((Object)raw);
        raw = "= SimpleString";
        Assertions.assertThat((Object)expressionEvaluator.evaluateLiteralExpression(raw, String.class.getCanonicalName(), Collections.emptyList())).isEqualTo((Object)"SimpleString");
        Assertions.assertThat((Object)expressionEvaluator.evaluateLiteralExpression(null, String.class.getCanonicalName(), Collections.emptyList())).isNull();
    }

    @Test
    public void createObjectTest() {
        Assertions.assertThat((Object)expressionEvaluator.createObject(String.class.getCanonicalName(), Collections.emptyList())).isNotNull();
        Assertions.assertThat((boolean)(expressionEvaluator.createObject(Map.class.getCanonicalName(), Arrays.asList(String.class.getCanonicalName(), String.class.getCanonicalName())) instanceof Map)).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> expressionEvaluator.createObject("com.invalid.class.Name", Collections.emptyList())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Impossible to instantiate com.invalid.class.Name");
    }

    @Test
    public void verifyNullTest() {
        Assertions.assertThat((boolean)expressionEvaluator.verifyResult("[]", null, null).isSuccessful()).isTrue();
        Assertions.assertThat((boolean)expressionEvaluator.verifyResult("[{\"value\" : \"result\"}]", null, null).isSuccessful()).isFalse();
    }

    @Test
    public void nullResultTest() {
        Assertions.assertThat((boolean)expressionEvaluator.evaluateUnaryExpression("> 1", null, null).isSuccessful()).isFalse();
        Assertions.assertThat((boolean)expressionEvaluator.evaluateUnaryExpression("", null, null).isSuccessful()).isTrue();
        Assertions.assertThat((boolean)expressionEvaluator.evaluateUnaryExpression(null, null, null).isSuccessful()).isTrue();
        Assertions.assertThat((boolean)expressionEvaluator.evaluateUnaryExpression("{}", null, Map.class).isSuccessful()).isTrue();
        Assertions.assertThat((boolean)expressionEvaluator.evaluateUnaryExpression("[]", null, List.class).isSuccessful()).isTrue();
        String mapOfListJson = "{\"key1\" : [{\"value\" : \"value1\"}, {\"value\" : \"value2\"}]}";
        HashMap mapOfListToCheck = new HashMap();
        Assertions.assertThat((boolean)expressionEvaluator.evaluateUnaryExpression(mapOfListJson, mapOfListToCheck, Map.class).isSuccessful()).isFalse();
    }

    @Test
    public void mapOfSimpleTypeTest() {
        String givenWorkbenchMapString = "{ \"Home\": { \"value\": \"123 Any Street\" } }";
        ArrayList<String> genericClasses = new ArrayList<String>();
        genericClasses.add(String.class.getCanonicalName());
        genericClasses.add(String.class.getCanonicalName());
        Map parsedWorkbench = (Map)expressionEvaluator.convertResult(givenWorkbenchMapString, Map.class.getCanonicalName(), genericClasses);
        Assertions.assertThat((int)parsedWorkbench.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)parsedWorkbench.get("Home"))).isNotNull();
        Assertions.assertThat((String)((String)parsedWorkbench.get("Home"))).isEqualTo("123 Any Street");
        String givenWorkbenchMapInteger = "{ \"Home\": { \"value\": \"100\" } }";
        genericClasses.clear();
        genericClasses.add(String.class.getCanonicalName());
        genericClasses.add(Integer.class.getCanonicalName());
        Map parsedIntegerFromMap = (Map)expressionEvaluator.convertResult(givenWorkbenchMapInteger, Map.class.getCanonicalName(), genericClasses);
        Assertions.assertThat((int)parsedIntegerFromMap.size()).isEqualTo(1);
        Assertions.assertThat((Integer)((Integer)parsedIntegerFromMap.get("Home"))).isNotNull();
        Assertions.assertThat((int)((Integer)parsedIntegerFromMap.get("Home"))).isEqualTo(100);
        String expectWorkbenchMapInteger = "{ \"Home\": { \"value\": \"> 100\" } }";
        genericClasses.clear();
        genericClasses.add(String.class.getCanonicalName());
        genericClasses.add(Integer.class.getCanonicalName());
        HashMap<String, Integer> resultToTest = new HashMap<String, Integer>();
        resultToTest.put("Home", 120);
        Assertions.assertThat((boolean)expressionEvaluator.verifyResult(expectWorkbenchMapInteger, resultToTest, null).isSuccessful()).isTrue();
        resultToTest.put("Home", 20);
        Assertions.assertThat((boolean)expressionEvaluator.verifyResult(expectWorkbenchMapInteger, resultToTest, null).isSuccessful()).isFalse();
        String mapOfStringJson = "{\"key1\" : {\"value\" : \"value1\"}, \"key2\" : {\"value\" : \"value2\"}}";
        HashMap<String, String> mapStringStringToCheck = new HashMap<String, String>();
        mapStringStringToCheck.put("key1", "value1");
        Assertions.assertThat((boolean)expressionEvaluator.evaluateUnaryExpression(mapOfStringJson, mapStringStringToCheck, Map.class).isSuccessful()).isFalse();
        mapStringStringToCheck.put("key2", "value2");
        Assertions.assertThat((boolean)expressionEvaluator.evaluateUnaryExpression(mapOfStringJson, mapStringStringToCheck, Map.class).isSuccessful()).isTrue();
        String mapOfStringJson1 = "{\"key1\" : {\"value\" : \"\"}}";
        HashMap<String, String> mapStringStringToCheck1 = new HashMap<String, String>();
        Assertions.assertThat((boolean)expressionEvaluator.evaluateUnaryExpression(mapOfStringJson1, mapStringStringToCheck1, Map.class).isSuccessful()).isTrue();
        mapStringStringToCheck1.put("key1", "value1");
        Assertions.assertThat((boolean)expressionEvaluator.evaluateUnaryExpression(mapOfStringJson1, mapStringStringToCheck1, Map.class).isSuccessful()).isTrue();
    }

    @Test
    public void mapOfComplexTypeTest() {
        String mapJsonString = "{\"first\": {\"name\": \"John\"}}";
        Map parsedMap = (Map)expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), Collections.singletonList(ListMapClass.class.getCanonicalName()));
        Assertions.assertThat((int)parsedMap.size()).isEqualTo(1);
        Assertions.assertThat((String)((ListMapClass)parsedMap.get("first")).getName()).isEqualTo("John");
        mapJsonString = "{\"first\": {\"siblings\": [{\"name\" : \"John\"}]}}";
        parsedMap = (Map)expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), Collections.singletonList(ListMapClass.class.getCanonicalName()));
        Assertions.assertThat((int)parsedMap.size()).isEqualTo(1);
        Assertions.assertThat((String)((ListMapClass)parsedMap.get("first")).getSiblings().get(0).getName()).isEqualTo("John");
        mapJsonString = "{\"first\": {\"phones\": {\"number\" : \"1\"}}}";
        parsedMap = (Map)expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), Collections.singletonList(ListMapClass.class.getCanonicalName()));
        Assertions.assertThat((int)parsedMap.size()).isEqualTo(1);
        Assertions.assertThat((Integer)((ListMapClass)parsedMap.get("first")).getPhones().get("number")).isEqualTo((Object)1);
        mapJsonString = "{\"first\": {\"phones\": {\"number\" : \"> 1\"}}}";
        HashMap<String, ListMapClass> toCheck = new HashMap<String, ListMapClass>();
        ListMapClass element = new ListMapClass();
        HashMap<String, Integer> phones = new HashMap<String, Integer>();
        phones.put("number", 10);
        element.setPhones(phones);
        toCheck.put("first", element);
        Assertions.assertThat((boolean)expressionEvaluator.verifyResult(mapJsonString, toCheck, null).isSuccessful()).isTrue();
        phones.put("number", -1);
        Assertions.assertThat((boolean)expressionEvaluator.verifyResult(mapJsonString, toCheck, null).isSuccessful()).isFalse();
    }

    @Test
    public void listOfComplexTypeTest() {
        String listJsonString = "[{\"name\": \"John\"}, {\"name\": \"John\", \"names\" : [{\"value\": \"Anna\"}, {\"value\": \"Mario\"}]}]";
        List parsedValue = (List)expressionEvaluator.convertResult(listJsonString, List.class.getCanonicalName(), Collections.singletonList(ListMapClass.class.getCanonicalName()));
        Assertions.assertThat((int)parsedValue.size()).isEqualTo(2);
        Assertions.assertThat((int)((ListMapClass)parsedValue.get(1)).getNames().size()).isEqualTo(2);
        Assertions.assertThat((boolean)((ListMapClass)parsedValue.get(1)).getNames().contains("Anna")).isTrue();
        Assertions.assertThat((boolean)expressionEvaluator.verifyResult(listJsonString, (Object)parsedValue, null).isSuccessful()).isTrue();
        ((ListMapClass)parsedValue.get(1)).setNames(new ArrayList<String>());
        Assertions.assertThat((boolean)expressionEvaluator.verifyResult(listJsonString, (Object)parsedValue, null).isSuccessful()).isFalse();
    }

    @Test
    public void listOfSimpleTypeTest() {
        String listJsonString = "[{\"value\" : \"10\"}, {\"value\" : \"12\"}]";
        List result = (List)expressionEvaluator.convertResult(listJsonString, List.class.getCanonicalName(), Collections.singletonList(Integer.class.getCanonicalName()));
        Assertions.assertThat((int)result.size()).isEqualTo(2);
        Assertions.assertThat((boolean)result.contains(10)).isTrue();
        listJsonString = "[{\"value\" : \"> 10\"}]";
        List<Integer> toCheck = Collections.singletonList(13);
        Assertions.assertThat((boolean)expressionEvaluator.verifyResult(listJsonString, toCheck, null).isSuccessful()).isTrue();
        listJsonString = "[{\"value\" : \"> 100\"}]";
        Assertions.assertThat((boolean)expressionEvaluator.verifyResult(listJsonString, toCheck, null).isSuccessful()).isFalse();
        listJsonString = "[{\"value\" : \"\"}]";
        Assertions.assertThat((boolean)expressionEvaluator.verifyResult(listJsonString, toCheck, null).isSuccessful()).isTrue();
    }

    @Test(expected=IllegalArgumentException.class)
    public void expressionListVerifyResultTest() {
        String expressionCollectionJsonString = new TextNode("10").toString();
        List<BigDecimal> contextValue = Collections.singletonList(BigDecimal.valueOf(10L));
        Assertions.assertThat((boolean)expressionEvaluator.verifyResult(expressionCollectionJsonString, contextValue, List.class).isSuccessful()).isTrue();
    }

    @Test(expected=IllegalArgumentException.class)
    public void expressionMapVerifyResultTest() {
        String expressionCollectionJsonString = new TextNode("{key_a : 1}").toString();
        Map<String, BigDecimal> contextValue = Collections.singletonMap("key_a", BigDecimal.valueOf(1L));
        Assertions.assertThat((boolean)expressionEvaluator.verifyResult(expressionCollectionJsonString, contextValue, Map.class).isSuccessful()).isTrue();
    }
}

