/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.backend.util.JsonUtils;
import org.junit.Test;

public class JsonUtilsTest {
    @Test
    public void convertFromStringToJSONNode() {
        Assertions.assertThat((boolean)JsonUtils.convertFromStringToJSONNode(null).isPresent()).isFalse();
        Assertions.assertThat((boolean)JsonUtils.convertFromStringToJSONNode((String)"Not json").isPresent()).isFalse();
        Assertions.assertThat((boolean)JsonUtils.convertFromStringToJSONNode((String)"\"Not json").isPresent()).isFalse();
        Assertions.assertThat((boolean)JsonUtils.convertFromStringToJSONNode((String)"key : notJson\"").isPresent()).isFalse();
        Assertions.assertThat((boolean)JsonUtils.convertFromStringToJSONNode((String)"[key : 100]").isPresent()).isFalse();
        Assertions.assertThat((boolean)JsonUtils.convertFromStringToJSONNode((String)"{\"key\" : 100{").isPresent()).isFalse();
        Assertions.assertThat((boolean)JsonUtils.convertFromStringToJSONNode((String)"{key : 100}").isPresent()).isFalse();
        Assertions.assertThat((boolean)JsonUtils.convertFromStringToJSONNode((String)"\"Json\"").isPresent()).isTrue();
        Assertions.assertThat((boolean)JsonUtils.convertFromStringToJSONNode((String)"\"key : Json\"").isPresent()).isTrue();
        Assertions.assertThat((boolean)JsonUtils.convertFromStringToJSONNode((String)"{ \"id\": 2, \"username\": \"user\", \"num\": 12, \"name\": \"Mr Yellow\"\n }").isPresent()).isTrue();
        Assertions.assertThat((boolean)JsonUtils.convertFromStringToJSONNode((String)"{ \"users\": [\n\t\t{ \"id\": 3, \"username\": \"user45\", \"num\": 24, \"name\": \"Mr White\" },\n\t\t{ \"id\": 4, \"username\": \"user65\", \"num\": 32, \"name\": \"Mr Red\" }\n\t]}").isPresent()).isTrue();
        Assertions.assertThat((boolean)JsonUtils.convertFromStringToJSONNode((String)"[{\"name\": \"\\\"John\\\"\"}, {\"name\": \"\\\"John\\\"\", \"names\" : [{\"value\": \"\\\"Anna\\\"\"}, {\"value\": \"\\\"Mario\\\"\"}]}]").isPresent()).isTrue();
        Assertions.assertThat((boolean)JsonUtils.convertFromStringToJSONNode((String)"[1,2,3]").isPresent()).isTrue();
        Assertions.assertThat((boolean)JsonUtils.convertFromStringToJSONNode((String)"{\"id\": 23, \"num\": 34, \"time\" : 56}").isPresent()).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)JsonUtils.convertFromStringToJSONNode((String)"{\"married\":true, \"num\":34, \"name\": \"john\"}").isPresent()).as("Combine three data types in object", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)JsonUtils.convertFromStringToJSONNode((String)"[{\"married\":true,\"num\":34,\"name\":\"john\"},{\"married\":false,\"num\":43,\"name\":\"jane\"}]").isPresent()).as("Combine three data types in array", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)JsonUtils.convertFromStringToJSONNode((String)"{\"is married\":\"yes, is\"}").isPresent()).as("Whitespaces", new Object[0])).isTrue();
    }
}

