/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import java.time.LocalDate;
import java.util.Arrays;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.backend.expression.BaseExpressionOperator;
import org.junit.Test;

public class BaseExpressionOperatorTest {
    private static final ClassLoader classLoader = BaseExpressionOperatorTest.class.getClassLoader();

    @Test
    public void evaluateLiteralExpression() {
        Arrays.stream(BaseExpressionOperator.values()).filter(e -> !BaseExpressionOperator.EQUALS.equals(e)).forEach(operator -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> operator.evaluateLiteralExpression(String.class.getCanonicalName(), " Test ", classLoader)).isInstanceOf(IllegalStateException.class)).hasMessageEndingWith(" operator cannot be used in a GIVEN clause"));
        Assertions.assertThat((Object)BaseExpressionOperator.EQUALS.evaluateLiteralExpression(String.class.getName(), "= Test", classLoader)).isEqualTo((Object)"Test");
        Assertions.assertThat((Object)BaseExpressionOperator.EQUALS.evaluateLiteralExpression(String.class.getName(), "= ", classLoader)).isEqualTo((Object)"");
        Assertions.assertThat((Object)BaseExpressionOperator.EQUALS.evaluateLiteralExpression(Integer.class.getName(), "= 1", classLoader)).isEqualTo((Object)1);
        Assertions.assertThat((Object)BaseExpressionOperator.EQUALS.evaluateLiteralExpression(Integer.class.getName(), "= 2", classLoader)).isNotEqualTo((Object)1);
        Assertions.assertThat((Object)BaseExpressionOperator.EQUALS.evaluateLiteralExpression(TestEnum.class.getName(), "= TEST_1", classLoader)).isEqualTo((Object)TestEnum.TEST_1);
        Assertions.assertThat((Object)BaseExpressionOperator.EQUALS.evaluateLiteralExpression(TestEnum.class.getName(), "= TEST_1", classLoader)).isNotEqualTo((Object)TestEnum.TEST_2);
        Assertions.assertThat((Object)BaseExpressionOperator.EQUALS.evaluateLiteralExpression(OuterClass.InnerEnum.class.getName(), "= INNER_1", classLoader)).isEqualTo((Object)OuterClass.InnerEnum.INNER_1);
        Assertions.assertThat((Object)BaseExpressionOperator.EQUALS.evaluateLiteralExpression(OuterClass.InnerEnum.class.getName(), "= INNER_1", classLoader)).isNotEqualTo((Object)OuterClass.InnerEnum.INNER_2);
        Assertions.assertThat((Object)BaseExpressionOperator.EQUALS.evaluateLiteralExpression(String.class.getName(), "null", classLoader)).isNull();
        Assertions.assertThat((Object)BaseExpressionOperator.EQUALS.evaluateLiteralExpression(String.class.getName(), "= null", classLoader)).isNull();
        Assertions.assertThat((Object)BaseExpressionOperator.EQUALS.evaluateLiteralExpression(String.class.getName(), null, classLoader)).isNull();
    }

    @Test
    public void findOperator() {
        Assertions.assertThat((Comparable)BaseExpressionOperator.findOperator((String)"Test")).isEqualTo((Object)BaseExpressionOperator.EQUALS);
        Assertions.assertThat((Comparable)BaseExpressionOperator.findOperator((String)" Test ")).isEqualTo((Object)BaseExpressionOperator.EQUALS);
        Assertions.assertThat((Comparable)BaseExpressionOperator.findOperator((String)"= Test ")).isEqualTo((Object)BaseExpressionOperator.EQUALS);
        Assertions.assertThat((Comparable)BaseExpressionOperator.findOperator((String)"!= Test ")).isEqualTo((Object)BaseExpressionOperator.NOT_EQUALS);
    }

    @Test
    public void equalsTest() {
        String test1 = "2019-12-02";
        LocalDate test2 = LocalDate.of(2019, 12, 2);
        Assertions.assertThat((boolean)BaseExpressionOperator.EQUALS.eval(test1, (Object)test2, test2.getClass(), classLoader)).isTrue();
        Assertions.assertThat((boolean)BaseExpressionOperator.EQUALS.eval(test1, (Object)test2.plusDays(1L), test2.getClass(), classLoader)).isFalse();
        Assertions.assertThat((boolean)BaseExpressionOperator.EQUALS.eval("1", (Object)1, Integer.TYPE, classLoader)).isTrue();
        Assertions.assertThat((boolean)BaseExpressionOperator.EQUALS.eval(null, null, null, classLoader)).isTrue();
    }

    @Test
    public void notEqualsTest() {
        String test1 = "2019-12-02";
        LocalDate test2 = LocalDate.of(2019, 12, 2);
        Assertions.assertThat((boolean)BaseExpressionOperator.NOT_EQUALS.eval(test1, (Object)test2, test2.getClass(), classLoader)).isFalse();
        Assertions.assertThat((boolean)BaseExpressionOperator.NOT_EQUALS.eval(test1, (Object)test2.plusDays(1L), test2.getClass(), classLoader)).isTrue();
        Assertions.assertThat((boolean)BaseExpressionOperator.NOT_EQUALS.eval("<> 1", (Object)2, Integer.TYPE, classLoader)).isTrue();
        Assertions.assertThat((boolean)BaseExpressionOperator.NOT_EQUALS.eval(null, null, null, classLoader)).isFalse();
        Assertions.assertThat((boolean)BaseExpressionOperator.NOT_EQUALS.eval("! <1", (Object)2, Integer.TYPE, classLoader)).isTrue();
        Assertions.assertThat((boolean)BaseExpressionOperator.NOT_EQUALS.eval("! [1, 3]", (Object)2, Integer.TYPE, classLoader)).isTrue();
    }

    @Test
    public void rangeTest() {
        Assertions.assertThat((boolean)BaseExpressionOperator.RANGE.eval("", (Object)"test", String.class, classLoader)).isFalse();
        Assertions.assertThat((boolean)BaseExpressionOperator.RANGE.eval(">2", (Object)3, Integer.TYPE, classLoader)).isTrue();
    }

    @Test
    public void listOfValuesTest() {
        Assertions.assertThat((boolean)BaseExpressionOperator.LIST_OF_VALUES.eval("", (Object)"test", String.class, classLoader)).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BaseExpressionOperator.LIST_OF_VALUES.eval("[ 2", (Object)"", String.class, classLoader)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Malformed expression: [ 2");
        Assertions.assertThat((boolean)BaseExpressionOperator.LIST_OF_VALUES.eval("[ Test, Another Test]", (Object)"Another Test", String.class, classLoader)).isTrue();
    }

    @Test
    public void listOfConditionsTest() {
        Assertions.assertThat((boolean)BaseExpressionOperator.LIST_OF_CONDITION.eval("", (Object)"test", String.class, classLoader)).isFalse();
        Assertions.assertThat((boolean)BaseExpressionOperator.LIST_OF_CONDITION.eval("=1; ![2, 3]; <10", (Object)1, Integer.TYPE, classLoader)).isTrue();
        Assertions.assertThat((boolean)BaseExpressionOperator.LIST_OF_CONDITION.eval(null, (Object)1, Integer.TYPE, classLoader)).isFalse();
    }

    private static class OuterClass {
        private OuterClass() {
        }

        public static enum InnerEnum {
            INNER_1,
            INNER_2;

        }
    }

    private static enum TestEnum {
        TEST_1,
        TEST_2;

    }
}

