/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import com.fasterxml.jackson.databind.node.TextNode;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.drools.scenariosimulation.backend.expression.DMNFeelExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorResult;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.runtime.events.FEELEventBase;
import org.kie.dmn.feel.runtime.events.SyntaxErrorEvent;

public class DMNFeelExpressionEvaluatorTest {
    private Condition<ExpressionEvaluatorResult> successful = new Condition(x -> x.isSuccessful(), "isSuccessful", new Object[0]);
    private Condition<ExpressionEvaluatorResult> notSuccessful = new Condition(x -> !x.isSuccessful(), "isNotSuccessful", new Object[0]);
    private DMNFeelExpressionEvaluator expressionEvaluator;

    @Before
    public void setUp() {
        this.expressionEvaluator = new DMNFeelExpressionEvaluator(this.getClass().getClassLoader());
    }

    @Test
    public void evaluateUnaryExpression_simpleResult() {
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression("not( true )", (Object)false, Boolean.TYPE)).is(this.successful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(">2, >5", (Object)BigDecimal.valueOf(6L), BigDecimal.class)).is(this.successful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression("abs(-1)", (Object)BigDecimal.valueOf(1L), BigDecimal.class)).is(this.successful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression("abs(-1)", (Object)BigDecimal.valueOf(-1L), BigDecimal.class)).is(this.notSuccessful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression("max(1, ?) > 1", (Object)BigDecimal.valueOf(2L), BigDecimal.class)).is(this.successful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression("max(1, ?) < 1", (Object)BigDecimal.valueOf(2L), BigDecimal.class)).is(this.notSuccessful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression("? = 2", (Object)BigDecimal.valueOf(2L), BigDecimal.class)).is(this.successful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression("? > 2", (Object)BigDecimal.valueOf(2L), BigDecimal.class)).is(this.notSuccessful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression("? + 1 > ?", (Object)BigDecimal.valueOf(2L), BigDecimal.class)).is(this.successful);
    }

    @Test
    public void evaluateUnaryExpression_structuredResult_map() {
        Map<String, BigDecimal> contextValue = Map.of("key_a", BigDecimal.valueOf(1L));
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression("{key_a : 1}", contextValue, Map.class)).is(this.successful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression("{key_a : 2}", contextValue, Map.class)).is(this.notSuccessful);
    }

    @Test
    public void evaluateUnaryExpression_structuredResult_list() {
        List<BigDecimal> contextListValue = List.of(BigDecimal.valueOf(23L));
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("23").toString(), contextListValue, List.class)).is(this.successful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("2").toString(), contextListValue, List.class)).is(this.notSuccessful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("? = [23]").toString(), contextListValue, List.class)).is(this.successful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("? = [2]").toString(), contextListValue, List.class)).is(this.notSuccessful);
        List<BigDecimal> contextListValue2 = List.of(BigDecimal.valueOf(23L), BigDecimal.valueOf(32L));
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(new TextNode(" ? = [23, 32]").toString(), contextListValue2, List.class)).is(this.successful);
        ((ObjectAssert)Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("[23, 32]").toString(), contextListValue2, List.class)).as("Collection unary expression needs to start with ?", new Object[0])).is(this.notSuccessful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(new TextNode(" ? = [23, 32, 123]").toString(), contextListValue2, List.class)).is(this.notSuccessful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(new TextNode(" ?[1] = 23").toString(), contextListValue2, List.class)).is(this.successful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(new TextNode(" ?[1] = 32").toString(), contextListValue2, List.class)).is(this.notSuccessful);
    }

    @Test
    public void evaluateUnaryExpression_structuredResult_listOfMaps() {
        Map<String, String> firstMap = Map.of("Price", new BigDecimal(2000), "Name", "PC");
        Map<String, String> secondMap = Map.of("Price", new BigDecimal(3300), "Name", "CAR");
        List<Map<String, String>> context = List.of(firstMap, secondMap);
        String firstParameter = "{Price: 2000,Name:\"PC\"}";
        String secondParameter = "{Price:3300, Name:\"CAR\"}";
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("?=[" + firstParameter + ", " + secondParameter + "]").toString(), context, List.class)).is(this.successful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("?=[{Price: 2001,Name:\"PC\"}, {Price:3301,Name:\"CAR\"}]").toString(), context, List.class)).is(this.notSuccessful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("?=[{Price: 2000, Name:\"PCA\"}, {Price:3300,Name:\"CARE\"}]").toString(), context, List.class)).is(this.notSuccessful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("?=[{Pric: 2000, Name:\"PC\"}, {Price:3300,Names:\"CARE\"}]").toString(), context, List.class)).is(this.notSuccessful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("?=[" + secondParameter + ", " + firstParameter + "]").toString(), context, List.class)).is(this.notSuccessful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(new TextNode(firstParameter + " in ?").toString(), context, List.class)).is(this.successful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(new TextNode(secondParameter + " in ?").toString(), context, List.class)).is(this.successful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("{Price: 2001,Name:\"PC\"} in ?").toString(), context, List.class)).is(this.notSuccessful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("{Price: 3300,Name:\"CARE\"} in ?").toString(), context, List.class)).is(this.notSuccessful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("(" + firstParameter + " in ?) and (" + secondParameter + " in ?)").toString(), context, List.class)).is(this.successful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(new TextNode("(" + secondParameter + " in ?) and (" + firstParameter + " in ?)").toString(), context, List.class)).is(this.successful);
    }

    @Test
    public void evaluateUnaryExpression_exceptions() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.expressionEvaluator.evaluateUnaryExpression("variable", null, null)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Error during evaluation:");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.expressionEvaluator.evaluateUnaryExpression("! true", null, null)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Syntax error:");
        Assertions.assertThatThrownBy(() -> this.expressionEvaluator.evaluateUnaryExpression("? > 2", null, BigDecimal.class)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void evaluateLiteralExpression_arithmeticExpression() {
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateLiteralExpression("2 + 3", BigDecimal.class.getCanonicalName(), null)).isEqualTo((Object)BigDecimal.valueOf(5L));
    }

    @Test
    public void evaluateLiteralExpression_listExpression() {
        List parsedValueListExpression = (List)this.expressionEvaluator.evaluateLiteralExpression(new TextNode("[10, 12]").toString(), List.class.getCanonicalName(), List.of());
        ((ListAssert)Assertions.assertThat((List)parsedValueListExpression).hasSize(2)).containsExactly((Object[])new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(12L)});
    }

    @Test
    public void evaluateLiteralExpression_mapExpression() {
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateLiteralExpression("2 + 3", BigDecimal.class.getCanonicalName(), null)).isEqualTo((Object)BigDecimal.valueOf(5L));
        Map parsedValue = (Map)this.expressionEvaluator.evaluateLiteralExpression("{key_a : 1}", Map.class.getCanonicalName(), List.of());
        Assertions.assertThat((Map)parsedValue).containsEntry((Object)"key_a", (Object)BigDecimal.valueOf(1L));
    }

    @Test
    public void evaluateLiteralExpression_exceptions() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.expressionEvaluator.evaluateLiteralExpression("SPEED", String.class.getCanonicalName(), null)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Error during evaluation:");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.expressionEvaluator.evaluateLiteralExpression("\"SPEED", String.class.getCanonicalName(), null)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Syntax error:");
    }

    @Test
    public void evaluateLiteralExpression_now() {
        ZonedDateTime now = (ZonedDateTime)this.expressionEvaluator.evaluateLiteralExpression("now()", ZonedDateTime.class.getCanonicalName(), List.of());
        Assertions.assertThat((ZonedDateTime)now).isNotNull();
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression("now() > ?", (Object)now.minusDays(1L), ZonedDateTime.class)).is(this.successful);
    }

    @Test
    public void evaluateLiteralExpression_today() {
        LocalDate today = (LocalDate)this.expressionEvaluator.evaluateLiteralExpression("today()", LocalDate.class.getCanonicalName(), List.of());
        Assertions.assertThat((LocalDate)today).isNotNull();
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression("today() > ?", (Object)today.minusDays(1L), LocalDate.class)).is(this.successful);
    }

    @Test
    public void convertResult_list() {
        String listJsonString = new TextNode("[ 1, 10 ]").toString();
        List result = (List)this.expressionEvaluator.convertResult(listJsonString, List.class.getCanonicalName(), List.of());
        ((ListAssert)Assertions.assertThat((List)result).hasSize(2)).containsExactly((Object[])new BigDecimal[]{BigDecimal.ONE, BigDecimal.TEN});
    }

    @Test
    public void convertResult_map() {
        String expressionCollectionJsonString = new TextNode("{ x : 5, y : 3 }").toString();
        Map result = (Map)this.expressionEvaluator.convertResult(expressionCollectionJsonString, Map.class.getCanonicalName(), List.of());
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)result).hasSize(2)).containsEntry((Object)"x", (Object)BigDecimal.valueOf(5L))).containsEntry((Object)"y", (Object)BigDecimal.valueOf(3L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void convertResult_map_fail() {
        String expressionCollectionJsonString = new TextNode(": 5 y : 3 }").toString();
        this.expressionEvaluator.convertResult(expressionCollectionJsonString, Map.class.getCanonicalName(), List.of());
    }

    @Test
    public void convertResult_listOfMaps() {
        String listOfMapsJsonString = new TextNode("[{age:10},{name:\"John\"}]").toString();
        List result = (List)this.expressionEvaluator.convertResult(listOfMapsJsonString, List.class.getCanonicalName(), List.of());
        Assertions.assertThat((List)result).hasSize(2);
        Assertions.assertThat((Map)((Map)result.get(0))).containsOnly(new Map.Entry[]{Assertions.entry((Object)"age", (Object)BigDecimal.TEN)});
        Assertions.assertThat((Map)((Map)result.get(1))).containsOnly(new Map.Entry[]{Assertions.entry((Object)"name", (Object)"John")});
    }

    @Test
    public void convertResult_listOfMaps_complexValues() {
        String listJsonString = "[{\"name\": \"\\\"John\\\"\"}, {\"name\": \"\\\"John\\\"\", \"names\" : [{\"value\": \"\\\"Anna\\\"\"}, {\"value\": \"\\\"Mario\\\"\"}]}]";
        List parsedValue = (List)this.expressionEvaluator.convertResult(listJsonString, List.class.getCanonicalName(), List.of(Map.class.getCanonicalName()));
        Assertions.assertThat((List)parsedValue).hasSize(2);
        ((MapAssert)Assertions.assertThat((Map)((Map)parsedValue.get(0))).hasSize(1)).containsEntry((Object)"name", (Object)"John");
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)((Map)parsedValue.get(1))).hasSize(2)).containsEntry((Object)"name", (Object)"John")).containsEntry((Object)"names", List.of("Anna", "Mario"));
    }

    @Test
    public void convertResult_mapOfMaps() {
        String mapJsonString = "{\"first\": {\"name\": \"\\\"John\\\"\"}}";
        Map parsedMap = (Map)this.expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), List.of(String.class.getCanonicalName(), Object.class.getCanonicalName()));
        Assertions.assertThat((Map)parsedMap).hasSize(1);
        Assertions.assertThat((Map)((Map)parsedMap.get("first"))).containsEntry((Object)"name", (Object)"John");
    }

    @Test
    public void convertResult_mapOfMapsWithListOfMaps() {
        String mapJsonString = "{\"first\": {\"siblings\": [{\"name\" : \"\\\"John\\\"\"}]}}";
        Map parsedMap = (Map)this.expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), List.of(String.class.getCanonicalName(), Object.class.getCanonicalName()));
        Assertions.assertThat((Map)parsedMap).hasSize(1);
        Assertions.assertThat((Map)((Map)((List)((Map)parsedMap.get("first")).get("siblings")).get(0))).containsEntry((Object)"name", (Object)"John");
    }

    @Test
    public void convertResult_mapOfMapsOfMaps() {
        String mapJsonString = "{\"first\": {\"phones\": {\"number\" : \"1\"}}}";
        Map parsedMap = (Map)this.expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), List.of(String.class.getCanonicalName(), Object.class.getCanonicalName()));
        Assertions.assertThat((Map)parsedMap).hasSize(1);
        Assertions.assertThat(((Map)((Map)parsedMap.get("first")).get("phones")).get("number")).isEqualTo((Object)BigDecimal.valueOf(1L));
    }

    @Test
    public void convertResult_list_fail() {
        String expressionCollectionJsonString = new TextNode("[ 1 : 234").toString();
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.expressionEvaluator.convertResult(expressionCollectionJsonString, List.class.getCanonicalName(), List.of()));
    }

    @Test
    public void fromObjectToExpression() {
        Assertions.assertThat((String)this.expressionEvaluator.fromObjectToExpression((Object)"Test")).isEqualTo("\"Test\"");
        Assertions.assertThat((String)this.expressionEvaluator.fromObjectToExpression((Object)false)).isEqualTo("false");
        Assertions.assertThat((String)this.expressionEvaluator.fromObjectToExpression((Object)BigDecimal.valueOf(1L))).isEqualTo("1");
        Assertions.assertThat((String)this.expressionEvaluator.fromObjectToExpression((Object)LocalDate.of(2019, 5, 13))).isEqualTo("date( \"2019-05-13\" )");
        Assertions.assertThat((String)this.expressionEvaluator.fromObjectToExpression(null)).isEqualTo("null");
    }

    @Test
    public void listener_notError() {
        FEELEventBase notError = new FEELEventBase(FEELEvent.Severity.INFO, "info", null);
        AtomicReference error = new AtomicReference();
        FEEL feel = this.expressionEvaluator.newFeelEvaluator(error);
        this.applyEvents(List.of(notError), feel);
        Assertions.assertThat((Object)((FEELEvent)error.get())).isNull();
    }

    @Test
    public void listener_singleSyntaxError() {
        SyntaxErrorEvent syntaxErrorEvent = new SyntaxErrorEvent(FEELEvent.Severity.ERROR, "test", null, 0, 0, null);
        AtomicReference error = new AtomicReference();
        FEEL feel = this.expressionEvaluator.newFeelEvaluator(error);
        this.applyEvents(List.of(syntaxErrorEvent), feel);
        Assertions.assertThat((Object)((FEELEvent)error.get())).isEqualTo((Object)syntaxErrorEvent);
    }

    @Test
    public void listener_sintaxErrorAsFirst() {
        SyntaxErrorEvent syntaxErrorEvent = new SyntaxErrorEvent(FEELEvent.Severity.ERROR, "test", null, 0, 0, null);
        FEELEventBase genericError = new FEELEventBase(FEELEvent.Severity.ERROR, "error", null);
        AtomicReference error = new AtomicReference();
        FEEL feel = this.expressionEvaluator.newFeelEvaluator(error);
        this.applyEvents(List.of(syntaxErrorEvent, genericError), feel);
        Assertions.assertThat((Object)((FEELEvent)error.get())).isEqualTo((Object)syntaxErrorEvent);
    }

    @Test
    public void listener_syntaxErrorAsSecond() {
        SyntaxErrorEvent syntaxErrorEvent = new SyntaxErrorEvent(FEELEvent.Severity.ERROR, "test", null, 0, 0, null);
        FEELEventBase genericError = new FEELEventBase(FEELEvent.Severity.ERROR, "error", null);
        AtomicReference error = new AtomicReference();
        FEEL feel = this.expressionEvaluator.newFeelEvaluator(error);
        this.applyEvents(List.of(genericError, syntaxErrorEvent), feel);
        Assertions.assertThat((Object)((FEELEvent)error.get())).isEqualTo((Object)syntaxErrorEvent);
    }

    private void applyEvents(List<FEELEvent> events, FEEL feel) {
        for (FEELEvent event : events) {
            feel.getListeners().forEach(listener -> listener.onEvent(event));
        }
    }

    @Test
    public void verifyResult_listResult() {
        String expressionCollectionJsonString = new TextNode("10").toString();
        List<BigDecimal> contextValue = List.of(BigDecimal.valueOf(10L));
        Assertions.assertThat((Object)this.expressionEvaluator.verifyResult(expressionCollectionJsonString, contextValue, List.class)).is(this.successful);
    }

    @Test
    public void verifyResult_mapResult() {
        String expressionCollectionJsonString = new TextNode("{key_a : 1}").toString();
        Map<String, BigDecimal> contextValue = Map.of("key_a", BigDecimal.valueOf(1L));
        Assertions.assertThat((Object)this.expressionEvaluator.verifyResult(expressionCollectionJsonString, contextValue, Map.class)).is(this.successful);
    }

    @Test
    public void isStructuredInput() {
        Assertions.assertThat((boolean)this.expressionEvaluator.isStructuredInput(List.class.getCanonicalName())).isTrue();
        Assertions.assertThat((boolean)this.expressionEvaluator.isStructuredInput(ArrayList.class.getCanonicalName())).isTrue();
        Assertions.assertThat((boolean)this.expressionEvaluator.isStructuredInput(LinkedList.class.getCanonicalName())).isTrue();
        Assertions.assertThat((boolean)this.expressionEvaluator.isStructuredInput(Map.class.getCanonicalName())).isFalse();
        Assertions.assertThat((boolean)this.expressionEvaluator.isStructuredInput(HashMap.class.getCanonicalName())).isFalse();
        Assertions.assertThat((boolean)this.expressionEvaluator.isStructuredInput(LinkedHashMap.class.getCanonicalName())).isFalse();
        Assertions.assertThat((boolean)this.expressionEvaluator.isStructuredInput(Set.class.getCanonicalName())).isFalse();
        Assertions.assertThat((boolean)this.expressionEvaluator.isStructuredInput(Integer.class.getCanonicalName())).isFalse();
        Assertions.assertThat((boolean)this.expressionEvaluator.isStructuredInput(String.class.getCanonicalName())).isFalse();
    }
}

