/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import com.fasterxml.jackson.databind.node.TextNode;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorResult;
import org.drools.scenariosimulation.backend.expression.MVELExpressionEvaluator;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mvel2.CompileException;

public class MVELExpressionEvaluatorTest {
    private Condition<ExpressionEvaluatorResult> successful = new Condition(x -> x.isSuccessful(), "isSuccessful", new Object[0]);
    private Condition<ExpressionEvaluatorResult> notSuccessful = new Condition(x -> !x.isSuccessful(), "isSuccessful", new Object[0]);
    private MVELExpressionEvaluator evaluator;

    @Before
    public void setUp() {
        this.evaluator = new MVELExpressionEvaluator(MVELExpressionEvaluatorTest.class.getClassLoader());
    }

    @Test
    public void evaluateUnaryExpression() {
        Assertions.assertThat((Object)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression("java.util.Objects.equals(actualValue, \"Test\")"), (Object)"Test", String.class)).is(this.successful);
        Assertions.assertThat((Object)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression("java.util.Objects.equals(actualValue, \"Test\")"), (Object)"Test1", String.class)).is(this.notSuccessful);
        Assertions.assertThat((Object)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression("1"), (Object)1, Integer.class)).is(this.successful);
        Assertions.assertThat((Object)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression("2"), (Object)1, Integer.class)).is(this.notSuccessful);
        Assertions.assertThat((Object)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression(""), null, String.class)).is(this.successful);
        Assertions.assertThat((Object)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression(""), (Object)"", String.class)).is(this.notSuccessful);
        Assertions.assertThat((Object)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression(null), null, String.class)).is(this.successful);
        Assertions.assertThat((Object)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression(null), (Object)"null", String.class)).is(this.notSuccessful);
        Assertions.assertThat((Object)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression("\"\""), (Object)"", String.class)).is(this.successful);
        Assertions.assertThat((Object)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression(null), (Object)"", String.class)).is(this.notSuccessful);
        Assertions.assertThat((Object)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression("actualValue == 123"), (Object)123, Integer.class)).is(this.successful);
        Assertions.assertThat((Object)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression("actualValue != 123"), (Object)321, Integer.class)).is(this.successful);
        Assertions.assertThat((Object)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression("actualValue == 123"), (Object)321, Integer.class)).is(this.notSuccessful);
        Assertions.assertThat((Object)this.evaluator.evaluateUnaryExpression(MVELExpressionEvaluatorTest.mvelExpression("actualValue != 123"), (Object)123, Integer.class)).is(this.notSuccessful);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.evaluator.evaluateUnaryExpression(null, (Object)"", String.class)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Malformed MVEL expression");
    }

    @Test
    public void evaluateLiteralExpression_many() {
        Assertions.assertThat((Object)this.evaluateLiteralExpression("1", Integer.class)).isEqualTo((Object)1);
        Assertions.assertThat((Object)this.evaluateLiteralExpression("\"Value\"", String.class)).isEqualTo((Object)"Value");
        Assertions.assertThat((Object)this.evaluateLiteralExpression("2 * 3", Integer.class)).isEqualTo((Object)6);
        Assertions.assertThat((Object)this.evaluateLiteralExpression("-1 + (3 * 5)", Integer.class)).isEqualTo((Object)14);
        Assertions.assertThat((Object)this.evaluateLiteralExpression("[\"Jim\"]", ArrayList.class)).isEqualTo(List.of("Jim"));
        Assertions.assertThat((Object)this.evaluateLiteralExpression("[]", ArrayList.class)).isEqualTo(List.of());
        Assertions.assertThat((Object)this.evaluateLiteralExpression("\"abc..\"[2]", Character.class)).isEqualTo((Object)Character.valueOf('c'));
        Assertions.assertThat((Object)this.evaluateLiteralExpression("1.234B", BigDecimal.class)).isEqualTo((Object)new BigDecimal("1.234"));
        Assertions.assertThat((Object)this.evaluateLiteralExpression("1.234d", Double.class)).isEqualTo((Object)Double.valueOf("1.234"));
        Assertions.assertThat((Object)this.evaluateLiteralExpression("\"Value\"", String.class)).isEqualTo((Object)"Value");
        Assertions.assertThat((Object)this.evaluateLiteralExpression("a = 1; b = 2; a+b;", Integer.class)).isEqualTo((Object)3);
        Assertions.assertThat((Object)this.evaluateLiteralExpression("a = \"Te\"; b = \"st\"; a+b;", String.class)).isEqualTo((Object)"Test");
        Assertions.assertThatThrownBy(() -> this.evaluateLiteralExpression("a = 1 b = 2 a+b;", Integer.class)).isInstanceOf(CompileException.class);
        Assertions.assertThatThrownBy(() -> this.evaluateLiteralExpression("a = 1; a+b;", Integer.class)).isInstanceOf(CompileException.class);
        Assertions.assertThat((Object)this.evaluateLiteralExpression("a = \"Bob\";\ntest = new java.util.ArrayList();\ntest.add(a);\ntest.add(\"Michael\");\ntest;", ArrayList.class)).isEqualTo(List.of("Bob", "Michael"));
        Map<String, String> expectedMap = Map.of("Jim", "Person");
        Assertions.assertThat((Object)this.evaluateLiteralExpression("[\"Jim\" : \"Person\"]", HashMap.class)).isEqualTo(expectedMap);
        Assertions.assertThat((Object)this.evaluateLiteralExpression("a = \"Person\";\ntest = new java.util.HashMap();\ntest.put(\"Jim\", a);\ntest;", HashMap.class)).isEqualTo(expectedMap);
        Assertions.assertThat((Object)this.evaluateLiteralExpression("a = \"Person\";test = new java.util.HashMap();test.put(\"Jim\", a);test;", HashMap.class)).isEqualTo(expectedMap);
        Assertions.assertThat((Object)this.evaluateLiteralExpression("a = \"Person\";\ntest = new java.util.HashMap();\ntest.put(\"Jim\", a);\ntest;\ntest.clear();\ntest;", HashMap.class)).isEqualTo(Map.of());
        Assertions.assertThatThrownBy(() -> this.evaluateLiteralExpression("1+", String.class)).isInstanceOf(RuntimeException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.evaluateLiteralExpression("1", String.class)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot assign a 'java.lang.Integer");
    }

    @Ignore(value="https://issues.redhat.com/browse/DROOLS-4649")
    @Test
    public void evaluateLiteralExpression_Array() {
        Assertions.assertThat((Object)this.evaluateLiteralExpression("{\"Jim\", \"Michael\"}", Object[].class)).isEqualTo((Object)new String[]{"Jim", "Michael"});
        Assertions.assertThat((Object)this.evaluateLiteralExpression("{ }", Object[].class)).isEqualTo((Object)new String[0]);
    }

    private Object evaluateLiteralExpression(String rawExpression, Class klass) {
        return this.evaluator.evaluateLiteralExpression(MVELExpressionEvaluatorTest.mvelExpression(rawExpression), klass.getCanonicalName(), List.of());
    }

    @Test
    public void fromObjectToExpression() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.evaluator.fromObjectToExpression(null)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("The condition has not been satisfied");
    }

    @Test
    public void cleanExpression() {
        Assertions.assertThat((String)this.evaluator.cleanExpression("#test")).isEqualTo("test");
        Assertions.assertThat((String)this.evaluator.cleanExpression("# test")).isEqualTo(" test");
        Assertions.assertThat((String)this.evaluator.cleanExpression("# # test")).isEqualTo(" # test");
        Assertions.assertThat((String)this.evaluator.cleanExpression(new TextNode("#test").toString())).isEqualTo("test");
        Assertions.assertThat((String)this.evaluator.cleanExpression(new TextNode("# test").toString())).isEqualTo(" test");
        Assertions.assertThat((String)this.evaluator.cleanExpression(new TextNode("# # test").toString())).isEqualTo(" # test");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.evaluator.cleanExpression("test")).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Malformed MVEL expression");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.evaluator.cleanExpression(new TextNode("test").toString())).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Malformed MVEL expression");
    }

    private static String mvelExpression(String expression) {
        return "# " + expression;
    }
}

