/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.fluent;

import java.util.List;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.backend.fluent.ConditionFilter;
import org.drools.scenariosimulation.backend.fluent.FactCheckerHandle;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.drools.scenariosimulation.backend.runner.model.ValueWrapper;
import org.junit.Test;

public class ConditionFilterTest {
    @Test
    public void accept() {
        ConditionFilter conditionFilter = this.createConditionFilter(ValueWrapper::of);
        Assertions.assertThat((boolean)conditionFilter.accept((Object)1)).isFalse();
        Assertions.assertThat((boolean)conditionFilter.accept((Object)"String")).isTrue();
    }

    @Test
    public void acceptWithFailure() {
        ConditionFilter conditionFilterFail = this.createConditionFilter(object -> ValueWrapper.errorWithValidValue(null, null));
        Assertions.assertThat((boolean)conditionFilterFail.accept((Object)"String")).isFalse();
    }

    private ConditionFilter createConditionFilter(Function<Object, ValueWrapper> matchFunction) {
        FactMappingValue factMappingValue = new FactMappingValue(FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION, (Object)"Test");
        ScenarioResult scenarioResult = new ScenarioResult(factMappingValue);
        return new ConditionFilter(List.of(new FactCheckerHandle(String.class, matchFunction, scenarioResult)));
    }
}

