/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.fluent;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.commands.fluent.Batch;
import org.drools.commands.runtime.rule.AgendaGroupSetFocusCommand;
import org.drools.commands.runtime.rule.FireAllRulesCommand;
import org.drools.commands.runtime.rule.InsertElementsCommand;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.backend.fluent.AddCoverageListenerCommand;
import org.drools.scenariosimulation.backend.fluent.RuleStatelessScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.fluent.ValidateFactCommand;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.StatelessKieSession;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class RuleStatelessScenarioExecutableBuilderTest {
    @Mock
    private KieContainer kieContainerMock;
    @Mock
    private StatelessKieSession statelessKieSessionMock;
    @Mock
    private KieBase kieBaseMock;

    @Test
    public void testBuilder() {
        Mockito.when((Object)this.kieContainerMock.newStatelessKieSession(ArgumentMatchers.anyString())).thenReturn((Object)this.statelessKieSessionMock);
        Mockito.when((Object)this.statelessKieSessionMock.getKieBase()).thenReturn((Object)this.kieBaseMock);
        Mockito.when((Object)this.kieBaseMock.getKiePackages()).thenReturn(List.of());
        String sessionName = "sessionName";
        RuleStatelessScenarioExecutableBuilder builder = new RuleStatelessScenarioExecutableBuilder(this.kieContainerMock, sessionName);
        Map result = builder.run();
        ((KieContainer)Mockito.verify((Object)this.kieContainerMock, (VerificationMode)Mockito.times((int)1))).newStatelessKieSession((String)ArgumentMatchers.eq((Object)sessionName));
        Assertions.assertThat((Map)result).containsKeys((Object[])new String[]{"COVERAGE_LISTENER", "RULES_AVAILABLE"});
    }

    @Test
    public void generateCommands_twoCommands() {
        RuleStatelessScenarioExecutableBuilder builder = new RuleStatelessScenarioExecutableBuilder(null, null);
        Command batchCommand = builder.generateCommands(null);
        Assertions.assertThat((List)((Batch)batchCommand).getCommands()).hasSize(2);
        Assertions.assertThat((Object)((Command)((Batch)batchCommand).getCommands().get(0))).isInstanceOf(AddCoverageListenerCommand.class);
        Assertions.assertThat((Object)((Command)((Batch)batchCommand).getCommands().get(1))).isInstanceOf(FireAllRulesCommand.class);
    }

    @Test
    public void generateCommands_threeCommands() {
        RuleStatelessScenarioExecutableBuilder builder = new RuleStatelessScenarioExecutableBuilder(null, null);
        builder.setActiveAgendaGroup("test");
        Command batchCommand = builder.generateCommands(null);
        Assertions.assertThat((List)((Batch)batchCommand).getCommands()).hasSize(3);
        Assertions.assertThat((Object)((Command)((Batch)batchCommand).getCommands().get(0))).isInstanceOf(AddCoverageListenerCommand.class);
        Assertions.assertThat((Object)((Command)((Batch)batchCommand).getCommands().get(1))).isInstanceOf(AgendaGroupSetFocusCommand.class);
        Assertions.assertThat((Object)((Command)((Batch)batchCommand).getCommands().get(2))).isInstanceOf(FireAllRulesCommand.class);
    }

    @Test
    public void generateCommands_fourCommands() {
        RuleStatelessScenarioExecutableBuilder builder = new RuleStatelessScenarioExecutableBuilder(null, null);
        builder.setActiveAgendaGroup("test");
        builder.insert(new Object());
        Command batchCommand = builder.generateCommands(null);
        Assertions.assertThat((List)((Batch)batchCommand).getCommands()).hasSize(4);
        Assertions.assertThat((Object)((Command)((Batch)batchCommand).getCommands().get(0))).isInstanceOf(AddCoverageListenerCommand.class);
        Assertions.assertThat((Object)((Command)((Batch)batchCommand).getCommands().get(1))).isInstanceOf(AgendaGroupSetFocusCommand.class);
        Assertions.assertThat((Object)((Command)((Batch)batchCommand).getCommands().get(2))).isInstanceOf(InsertElementsCommand.class);
        Assertions.assertThat((Object)((Command)((Batch)batchCommand).getCommands().get(3))).isInstanceOf(FireAllRulesCommand.class);
    }

    @Test
    public void generateCommands_fiveCommands() {
        RuleStatelessScenarioExecutableBuilder builder = new RuleStatelessScenarioExecutableBuilder(null, null);
        builder.setActiveAgendaGroup("test");
        builder.insert(new Object());
        FactMappingValue emptyFMV = new FactMappingValue(FactIdentifier.EMPTY, ExpressionIdentifier.DESCRIPTION, null);
        builder.addInternalCondition(String.class, obj -> null, new ScenarioResult(emptyFMV, null));
        Command batchCommand = builder.generateCommands(null);
        Assertions.assertThat((List)((Batch)batchCommand).getCommands()).hasSize(5);
        Assertions.assertThat((Object)((Command)((Batch)batchCommand).getCommands().get(0))).isInstanceOf(AddCoverageListenerCommand.class);
        Assertions.assertThat((Object)((Command)((Batch)batchCommand).getCommands().get(1))).isInstanceOf(AgendaGroupSetFocusCommand.class);
        Assertions.assertThat((Object)((Command)((Batch)batchCommand).getCommands().get(2))).isInstanceOf(InsertElementsCommand.class);
        Assertions.assertThat((Object)((Command)((Batch)batchCommand).getCommands().get(3))).isInstanceOf(FireAllRulesCommand.class);
        Assertions.assertThat((Object)((Command)((Batch)batchCommand).getCommands().get(4))).isInstanceOf(ValidateFactCommand.class);
    }
}

