/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.fluent;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.backend.fluent.FactCheckerHandle;
import org.drools.scenariosimulation.backend.fluent.ValidateFactCommand;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.drools.scenariosimulation.backend.runner.model.ValueWrapper;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.internal.command.RegistryContext;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ValidateFactCommandTest {
    @Mock
    private KieSession kieSession;
    @Mock
    private ScenarioResult scenarioResult;
    @Mock
    private FactMappingValue factMappingValue;
    @Mock
    private RegistryContext registryContext;
    private ValidateFactCommand validateFactCommand;

    @Before
    public void setUp() {
        Mockito.when((Object)((KieSession)this.registryContext.lookup(KieSession.class))).thenReturn((Object)this.kieSession);
        Function<Object, ValueWrapper> alwaysMatchFunction = ValueWrapper::of;
        this.validateFactCommand = new ValidateFactCommand(List.of(new FactCheckerHandle(String.class, alwaysMatchFunction, this.scenarioResult)));
    }

    @Test
    public void execute_setResultIsCalled() {
        Mockito.when((Object)this.kieSession.getObjects((ObjectFilter)Mockito.any(ObjectFilter.class))).thenReturn(Collections.singleton(null));
        this.validateFactCommand.execute((Context)this.registryContext);
        ((ScenarioResult)Mockito.verify((Object)this.scenarioResult, (VerificationMode)Mockito.times((int)1))).setResult(Mockito.anyBoolean());
    }

    @Test
    public void execute_setResultIsNotCalled() {
        Mockito.when((Object)this.kieSession.getObjects((ObjectFilter)Mockito.any(ObjectFilter.class))).thenReturn(List.of());
        Mockito.when((Object)this.scenarioResult.getFactMappingValue()).thenReturn((Object)this.factMappingValue);
        this.validateFactCommand.execute((Context)this.registryContext);
        ((ScenarioResult)Mockito.verify((Object)this.scenarioResult, (VerificationMode)Mockito.times((int)0))).setResult(Mockito.anyBoolean());
    }
}

