/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.backend.expression.BaseExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorFactory;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorResult;
import org.drools.scenariosimulation.backend.runner.AbstractRunnerHelper;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.drools.scenariosimulation.backend.runner.model.ValueWrapper;
import org.junit.Test;
import org.kie.api.runtime.KieContainer;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AbstractRunnerHelperTest {
    AbstractRunnerHelper abstractRunnerHelper = new AbstractRunnerHelper(){

        protected ScenarioResultMetadata extractResultMetadata(Map<String, Object> requestContext, ScenarioWithIndex scenarioWithIndex) {
            return null;
        }

        protected Map<String, Object> executeScenario(KieContainer kieContainer, ScenarioRunnerData scenarioRunnerData, ExpressionEvaluatorFactory expressionEvaluatorFactory, ScesimModelDescriptor scesimModelDescriptor, Settings settings) {
            return null;
        }

        protected void verifyConditions(ScesimModelDescriptor scesimModelDescriptor, ScenarioRunnerData scenarioRunnerData, ExpressionEvaluatorFactory expressionEvaluatorFactory, Map<String, Object> requestContext) {
        }

        protected Object createObject(ValueWrapper<Object> initialInstance, String className, Map<List<String>, Object> params, ClassLoader classLoader) {
            return null;
        }
    };

    @Test
    public void isFactMappingValueToSkip() {
        FactIdentifier factIdentifier = FactIdentifier.create((String)"MyInstance", (String)String.class.getCanonicalName());
        ExpressionIdentifier expressionIdentifier = ExpressionIdentifier.create((String)"MyProperty", (FactMappingType)FactMappingType.GIVEN);
        FactMappingValue factMappingValueWithValidValue = new FactMappingValue(factIdentifier, expressionIdentifier, (Object)"value");
        Assertions.assertThat((boolean)this.abstractRunnerHelper.isFactMappingValueToSkip(factMappingValueWithValidValue)).isFalse();
        FactMappingValue factMappingValueWithoutValue = new FactMappingValue(factIdentifier, expressionIdentifier, null);
        Assertions.assertThat((boolean)this.abstractRunnerHelper.isFactMappingValueToSkip(factMappingValueWithoutValue)).isTrue();
    }

    @Test
    public void fillResult() {
        FactIdentifier factIdentifier = FactIdentifier.create((String)"MyInstance", (String)String.class.getCanonicalName());
        ExpressionIdentifier expressionIdentifier = ExpressionIdentifier.create((String)"MyProperty", (FactMappingType)FactMappingType.GIVEN);
        FactMappingValue expectedResultSpy = (FactMappingValue)Mockito.spy((Object)new FactMappingValue(factIdentifier, expressionIdentifier, (Object)"value"));
        AtomicReference<ValueWrapper> resultWrapperAtomicReference = new AtomicReference<ValueWrapper>();
        Supplier<ValueWrapper> resultWrapperSupplier = resultWrapperAtomicReference::get;
        BaseExpressionEvaluator expressionEvaluator = new BaseExpressionEvaluator(AbstractRunnerHelper.class.getClassLoader());
        resultWrapperAtomicReference.set(ValueWrapper.of((Object)"value"));
        Assertions.assertThat((boolean)this.abstractRunnerHelper.fillResult(expectedResultSpy, resultWrapperSupplier, (ExpressionEvaluator)expressionEvaluator).getResult()).isTrue();
        ((FactMappingValue)Mockito.verify((Object)expectedResultSpy, (VerificationMode)Mockito.times((int)1))).resetStatus();
        Mockito.reset((Object[])new FactMappingValue[]{expectedResultSpy});
        resultWrapperAtomicReference.set(ValueWrapper.errorWithValidValue((Object)"value", (Object)"value1"));
        Assertions.assertThat((boolean)this.abstractRunnerHelper.fillResult(expectedResultSpy, resultWrapperSupplier, (ExpressionEvaluator)expressionEvaluator).getResult()).isFalse();
        ((FactMappingValue)Mockito.verify((Object)expectedResultSpy, (VerificationMode)Mockito.times((int)1))).setErrorValue((Object)"value");
        Mockito.reset((Object[])new FactMappingValue[]{expectedResultSpy});
        resultWrapperAtomicReference.set(ValueWrapper.errorWithValidValue((Object)"value", (Object)"value1"));
        ExpressionEvaluator expressionEvaluatorMock = (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class);
        Mockito.when((Object)expressionEvaluatorMock.fromObjectToExpression(ArgumentMatchers.any())).thenThrow(new Throwable[]{new IllegalArgumentException("Error")});
        Assertions.assertThat((boolean)this.abstractRunnerHelper.fillResult(expectedResultSpy, resultWrapperSupplier, expressionEvaluatorMock).getResult()).isFalse();
        ((FactMappingValue)Mockito.verify((Object)expectedResultSpy, (VerificationMode)Mockito.times((int)1))).setExceptionMessage("Error");
        Mockito.reset((Object[])new FactMappingValue[]{expectedResultSpy});
        List<String> pathToValue = List.of("field1", "fields2");
        resultWrapperAtomicReference.set(ValueWrapper.errorWithCollectionPathToValue((Object)"value", pathToValue));
        Assertions.assertThat((boolean)this.abstractRunnerHelper.fillResult(expectedResultSpy, resultWrapperSupplier, (ExpressionEvaluator)expressionEvaluator).getResult()).isFalse();
        ((FactMappingValue)Mockito.verify((Object)expectedResultSpy, (VerificationMode)Mockito.times((int)1))).setCollectionPathToValue(pathToValue);
        ((FactMappingValue)Mockito.verify((Object)expectedResultSpy, (VerificationMode)Mockito.times((int)1))).setErrorValue((Object)"value");
        resultWrapperAtomicReference.set(ValueWrapper.errorWithMessage((String)"detailedError"));
        Assertions.assertThat((boolean)this.abstractRunnerHelper.fillResult(expectedResultSpy, resultWrapperSupplier, (ExpressionEvaluator)expressionEvaluator).getResult()).isFalse();
        ((FactMappingValue)Mockito.verify((Object)expectedResultSpy, (VerificationMode)Mockito.times((int)1))).setExceptionMessage("detailedError");
    }

    @Test
    public void getResultWrapper() {
        ExpressionEvaluator expressionEvaluatorMock = (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class);
        String resultRaw = "test";
        String expectedResultRaw = "";
        String collectionWrongValue = "value";
        String collectionValuePath = "Item #: 1";
        String genericErrorMessage = "errorMessage";
        Mockito.when((Object)expressionEvaluatorMock.evaluateUnaryExpression((String)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)ExpressionEvaluatorResult.ofSuccessful());
        ValueWrapper valueWrapper = this.abstractRunnerHelper.getResultWrapper(String.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, String.class);
        Assertions.assertThat((boolean)valueWrapper.isValid()).isTrue();
        Assertions.assertThat((List)valueWrapper.getCollectionPathToValue()).isNull();
        Mockito.when((Object)expressionEvaluatorMock.evaluateUnaryExpression((String)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)ExpressionEvaluatorResult.ofFailed());
        valueWrapper = this.abstractRunnerHelper.getResultWrapper(String.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, String.class);
        Assertions.assertThat((boolean)valueWrapper.isValid()).isFalse();
        Assertions.assertThat((Object)valueWrapper.getValue()).isEqualTo((Object)resultRaw);
        Assertions.assertThat((List)valueWrapper.getCollectionPathToValue()).isNull();
        valueWrapper = this.abstractRunnerHelper.getResultWrapper(List.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, List.class);
        Assertions.assertThat((Optional)valueWrapper.getErrorMessage()).isNotPresent();
        Assertions.assertThat((List)valueWrapper.getCollectionPathToValue()).isEmpty();
        Assertions.assertThat((Object)valueWrapper.getValue()).isNull();
        valueWrapper = this.abstractRunnerHelper.getResultWrapper(Map.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, Map.class);
        Assertions.assertThat((Optional)valueWrapper.getErrorMessage()).isNotPresent();
        Assertions.assertThat((List)valueWrapper.getCollectionPathToValue()).isEmpty();
        Assertions.assertThat((Object)valueWrapper.getValue()).isNull();
        ExpressionEvaluatorResult result = ExpressionEvaluatorResult.ofFailed((String)collectionWrongValue, (String)collectionValuePath);
        Mockito.when((Object)expressionEvaluatorMock.evaluateUnaryExpression((String)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)result);
        valueWrapper = this.abstractRunnerHelper.getResultWrapper(List.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, List.class);
        Assertions.assertThat((Optional)valueWrapper.getErrorMessage()).isNotPresent();
        Assertions.assertThat((List)valueWrapper.getCollectionPathToValue()).hasSize(1);
        Assertions.assertThat((Object)valueWrapper.getValue()).isEqualTo((Object)collectionWrongValue);
        valueWrapper = this.abstractRunnerHelper.getResultWrapper(Map.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, Map.class);
        Assertions.assertThat((Optional)valueWrapper.getErrorMessage()).isNotPresent();
        Assertions.assertThat((List)valueWrapper.getCollectionPathToValue()).hasSize(1);
        Assertions.assertThat((Object)valueWrapper.getValue()).isEqualTo((Object)collectionWrongValue);
        result = ExpressionEvaluatorResult.ofFailed(null, (String)collectionValuePath);
        Mockito.when((Object)expressionEvaluatorMock.evaluateUnaryExpression((String)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)result);
        valueWrapper = this.abstractRunnerHelper.getResultWrapper(List.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, List.class);
        Assertions.assertThat((Optional)valueWrapper.getErrorMessage()).isNotPresent();
        Assertions.assertThat((List)valueWrapper.getCollectionPathToValue()).hasSize(1);
        Assertions.assertThat((Object)valueWrapper.getValue()).isNull();
        valueWrapper = this.abstractRunnerHelper.getResultWrapper(Map.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, Map.class);
        Assertions.assertThat((Optional)valueWrapper.getErrorMessage()).isNotPresent();
        Assertions.assertThat((List)valueWrapper.getCollectionPathToValue()).hasSize(1);
        Assertions.assertThat((Object)valueWrapper.getValue()).isNull();
        Mockito.when((Object)expressionEvaluatorMock.evaluateUnaryExpression((String)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.any(Class.class))).thenThrow(new Throwable[]{new IllegalArgumentException(genericErrorMessage)});
        FactMappingValue expectedResult5 = new FactMappingValue();
        valueWrapper = this.abstractRunnerHelper.getResultWrapper(Map.class.getCanonicalName(), expectedResult5, expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, Map.class);
        Assertions.assertThat((String)((String)valueWrapper.getErrorMessage().get())).isEqualTo(genericErrorMessage);
        Assertions.assertThat((String)expectedResult5.getExceptionMessage()).isEqualTo(genericErrorMessage);
    }
}

