/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.backend.util.DMNSimulationUtils;
import org.drools.scenariosimulation.backend.util.ImpossibleToFindDMNException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.io.Resource;
import org.kie.dmn.api.core.DMNModel;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNSimulationUtilsTest {
    @Test
    public void findDMNModel() {
        List<String> pathToFind = List.of(new StringBuilder("to/find").reverse().toString().split("/"));
        List<DMNModel> models = List.of(this.createDMNModelMock("this/should/not/match"), this.createDMNModelMock("find"), this.createDMNModelMock("something/to/find"));
        DMNSimulationUtils.findDMNModel(models, pathToFind, (int)1);
        List<String> impossibleToFind = List.of(new StringBuilder("not/find").reverse().toString().split("/"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DMNSimulationUtils.findDMNModel((List)models, (List)impossibleToFind, (int)1)).isInstanceOf(ImpossibleToFindDMNException.class)).hasMessage("Retrieving the DMNModel has failed. Make sure the used DMN asset does not produce any compilation errors and that the project does not contain multiple DMN assets with the same name and namespace. In addition, check if the reference to the DMN file is correct in the Settings panel. After addressing the issues, build the project again.");
    }

    private DMNModel createDMNModelMock(String path) {
        DMNModel modelMock = (DMNModel)Mockito.mock(DMNModel.class);
        Resource resourceMock = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)resourceMock.getSourcePath()).thenReturn((Object)path);
        Mockito.when((Object)modelMock.getResource()).thenReturn((Object)resourceMock);
        return modelMock;
    }
}

