/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.drools.scenariosimulation.backend.util.JsonUtils;
import org.junit.Test;

public class JsonUtilsTest {
    @Test
    public void convertFromStringToJSONNode_manyCases() {
        Assertions.assertThat((Optional)JsonUtils.convertFromStringToJSONNode(null)).isNotPresent();
        Assertions.assertThat((Optional)JsonUtils.convertFromStringToJSONNode((String)"Not json")).isNotPresent();
        Assertions.assertThat((Optional)JsonUtils.convertFromStringToJSONNode((String)"\"Not json")).isNotPresent();
        Assertions.assertThat((Optional)JsonUtils.convertFromStringToJSONNode((String)"key : notJson\"")).isNotPresent();
        Assertions.assertThat((Optional)JsonUtils.convertFromStringToJSONNode((String)"[key : 100]")).isNotPresent();
        Assertions.assertThat((Optional)JsonUtils.convertFromStringToJSONNode((String)"{\"key\" : 100{")).isNotPresent();
        Assertions.assertThat((Optional)JsonUtils.convertFromStringToJSONNode((String)"{key : 100}")).isNotPresent();
        Assertions.assertThat((Optional)JsonUtils.convertFromStringToJSONNode((String)"\"Json\"")).isPresent();
        Assertions.assertThat((Optional)JsonUtils.convertFromStringToJSONNode((String)"\"key : Json\"")).isPresent();
        Assertions.assertThat((Optional)JsonUtils.convertFromStringToJSONNode((String)"{ \"id\": 2, \"username\": \"user\", \"num\": 12, \"name\": \"Mr Yellow\"\n }")).isPresent();
        Assertions.assertThat((Optional)JsonUtils.convertFromStringToJSONNode((String)"{ \"users\": [\n\t\t{ \"id\": 3, \"username\": \"user45\", \"num\": 24, \"name\": \"Mr White\" },\n\t\t{ \"id\": 4, \"username\": \"user65\", \"num\": 32, \"name\": \"Mr Red\" }\n\t]}")).isPresent();
        Assertions.assertThat((Optional)JsonUtils.convertFromStringToJSONNode((String)"[{\"name\": \"\\\"John\\\"\"}, {\"name\": \"\\\"John\\\"\", \"names\" : [{\"value\": \"\\\"Anna\\\"\"}, {\"value\": \"\\\"Mario\\\"\"}]}]")).isPresent();
        Assertions.assertThat((Optional)JsonUtils.convertFromStringToJSONNode((String)"[1,2,3]")).isPresent();
        Assertions.assertThat((Optional)JsonUtils.convertFromStringToJSONNode((String)"{\"id\": 23, \"num\": 34, \"time\" : 56}")).isPresent();
        ((OptionalAssert)Assertions.assertThat((Optional)JsonUtils.convertFromStringToJSONNode((String)"{\"married\":true, \"num\":34, \"name\": \"john\"}")).as("Combine three data types in object", new Object[0])).isPresent();
        ((OptionalAssert)Assertions.assertThat((Optional)JsonUtils.convertFromStringToJSONNode((String)"[{\"married\":true,\"num\":34,\"name\":\"john\"},{\"married\":false,\"num\":43,\"name\":\"jane\"}]")).as("Combine three data types in array", new Object[0])).isPresent();
        ((OptionalAssert)Assertions.assertThat((Optional)JsonUtils.convertFromStringToJSONNode((String)"{\"is married\":\"yes, is\"}")).as("Whitespaces", new Object[0])).isPresent();
    }
}

