/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.MapAssert;
import org.drools.scenariosimulation.backend.expression.AbstractExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorResult;
import org.drools.scenariosimulation.backend.expression.FakeExpressionEvaluator;
import org.junit.Before;
import org.junit.Test;

public class AbstractExpressionEvaluatorTest {
    private static final JsonNodeFactory factory = JsonNodeFactory.instance;
    private AbstractExpressionEvaluator expressionEvaluator;
    private Condition<ExpressionEvaluatorResult> successful = new Condition(x -> x.isSuccessful(), "isSuccessful", new Object[0]);
    private Condition<ExpressionEvaluatorResult> notSuccessful = new Condition(x -> !x.isSuccessful(), "isSuccessful", new Object[0]);

    @Before
    public void setUp() {
        this.expressionEvaluator = new FakeExpressionEvaluator();
    }

    @Test
    public void evaluateLiteralExpression() {
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateLiteralExpression(null, String.class.getCanonicalName(), null)).isNull();
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateLiteralExpression(null, List.class.getCanonicalName(), null)).isNull();
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateLiteralExpression(null, Map.class.getCanonicalName(), null)).isNull();
    }

    @Test
    public void evaluateUnaryExpression() {
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(null, null, String.class)).is(this.successful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(null, null, Map.class)).is(this.successful);
        Assertions.assertThat((Object)this.expressionEvaluator.evaluateUnaryExpression(null, null, List.class)).is(this.successful);
    }

    @Test
    public void convertList() {
        ArrayNode jsonNodes = new ArrayNode(factory);
        ObjectNode objectNode = new ObjectNode(factory);
        objectNode.put("value", "data");
        jsonNodes.add((JsonNode)objectNode);
        List objects = this.expressionEvaluator.createAndFillList(jsonNodes, new ArrayList(), List.class.getCanonicalName(), List.of(String.class.getCanonicalName()));
        Assertions.assertThat((List)objects).containsExactly(new Object[]{"data"});
    }

    @Test
    public void convertObject_simpleList() {
        ObjectNode objectNode = new ObjectNode(factory);
        objectNode.put("key1", "Polissena");
        objectNode.put("key2", "Antonia");
        Object result = this.expressionEvaluator.createAndFillObject(objectNode, new HashMap(), Map.class.getCanonicalName(), List.of(String.class.getCanonicalName()));
        Assertions.assertThat((Object)result).isInstanceOf(Map.class);
        Map resultMap = (Map)result;
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)resultMap).hasSize(2)).containsEntry((Object)"key1", (Object)"Polissena")).containsEntry((Object)"key2", (Object)"Antonia");
    }

    @Test
    public void convertObject_singleLevel() {
        ObjectNode objectNode = new ObjectNode(factory);
        objectNode.put("age", "1");
        objectNode.put("name", "FS");
        Object result = this.expressionEvaluator.createAndFillObject(objectNode, new HashMap(), Map.class.getCanonicalName(), List.of(String.class.getCanonicalName()));
        Assertions.assertThat((Object)result).isInstanceOf(Map.class);
        Map resultMap = (Map)result;
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)resultMap).hasSize(2)).containsEntry((Object)"age", (Object)"1")).containsEntry((Object)"name", (Object)"FS");
    }

    @Test
    public void convertObject_nestedObject() {
        ObjectNode objectNode = new ObjectNode(factory);
        ObjectNode nestedObject = new ObjectNode(factory);
        objectNode.set("nested", (JsonNode)nestedObject);
        nestedObject.put("field", "fieldValue");
        Object result = this.expressionEvaluator.createAndFillObject(objectNode, new HashMap(), String.class.getCanonicalName(), List.of());
        Assertions.assertThat((Object)result).isInstanceOf(Map.class);
        Map resultMap = (Map)result;
        Assertions.assertThat((Map)resultMap).hasSize(1);
        Map nested = (Map)resultMap.get("nested");
        ((MapAssert)Assertions.assertThat((Map)nested).hasSize(1)).containsEntry((Object)"field", (Object)"fieldValue");
    }

    @Test
    public void convertObject_nestedList() {
        ObjectNode objectNode = new ObjectNode(factory);
        ArrayNode jsonNodes = new ArrayNode(factory);
        objectNode.set("listField", (JsonNode)jsonNodes);
        ObjectNode nestedObject = new ObjectNode(factory);
        nestedObject.put("field", "fieldValue");
        jsonNodes.add((JsonNode)nestedObject);
        Object result = this.expressionEvaluator.createAndFillObject(objectNode, new HashMap(), String.class.getCanonicalName(), List.of());
        Assertions.assertThat((Object)result).isInstanceOf(Map.class);
        Map resultMap = (Map)result;
        Assertions.assertThat((Map)resultMap).hasSize(1);
        List nestedList = (List)resultMap.get("listField");
        Assertions.assertThat((List)nestedList).hasSize(1);
        Assertions.assertThat((Map)((Map)nestedList.get(0))).containsEntry((Object)"field", (Object)"fieldValue");
    }

    @Test
    public void isSimpleTypeNode_emptyNode() {
        Assertions.assertThat((boolean)this.expressionEvaluator.isSimpleTypeNode((JsonNode)new ArrayNode(factory))).isFalse();
    }

    @Test
    public void isSimpleTypeNode_nodeWithValueField() {
        ObjectNode jsonNode = new ObjectNode(factory);
        jsonNode.set("value", (JsonNode)new TextNode("test"));
        Assertions.assertThat((boolean)this.expressionEvaluator.isSimpleTypeNode((JsonNode)jsonNode)).isTrue();
    }

    @Test
    public void isSimpleTypeNode_nodeWithValueFieldAndOtherField() {
        ObjectNode jsonNode = new ObjectNode(factory);
        jsonNode.set("value", (JsonNode)new TextNode("test"));
        Assertions.assertThat((boolean)this.expressionEvaluator.isSimpleTypeNode((JsonNode)jsonNode)).isTrue();
    }

    @Test
    public void isSimpleTypeNode_nodeWithOtherField() {
        ObjectNode jsonNode = new ObjectNode(factory);
        jsonNode.set("otherField", (JsonNode)new TextNode("testValue"));
        jsonNode.set("value", (JsonNode)new TextNode("test"));
        Assertions.assertThat((boolean)this.expressionEvaluator.isSimpleTypeNode((JsonNode)jsonNode)).isFalse();
    }

    @Test
    public void getSimpleTypeNodeTextValue_noSimpleTypeCausesException() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.expressionEvaluator.getSimpleTypeNodeTextValue((JsonNode)new ArrayNode(factory))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter does not contains a simple type");
    }

    @Test
    public void getSimpleTypeNodeTextValue_textNode() {
        ObjectNode jsonNode = new ObjectNode(factory);
        jsonNode.set("value", (JsonNode)new TextNode("testValue"));
        Assertions.assertThat((String)this.expressionEvaluator.getSimpleTypeNodeTextValue((JsonNode)jsonNode)).isEqualTo("testValue");
    }

    @Test
    public void getSimpleTypeNodeTextValue_intNode() {
        ObjectNode jsonNode = new ObjectNode(factory);
        jsonNode.set("value", (JsonNode)new IntNode(10));
        Assertions.assertThat((String)this.expressionEvaluator.getSimpleTypeNodeTextValue((JsonNode)jsonNode)).isNull();
    }

    @Test
    public void isNodeEmpty_objectNode() {
        ObjectNode objectNode = new ObjectNode(factory);
        Assertions.assertThat((boolean)this.expressionEvaluator.isNodeEmpty((JsonNode)objectNode)).isTrue();
    }

    @Test
    public void isNodeEmpty_arrayNode() {
        ArrayNode arrayNode = new ArrayNode(factory);
        Assertions.assertThat((boolean)this.expressionEvaluator.isNodeEmpty((JsonNode)arrayNode)).isTrue();
    }

    @Test
    public void isNodeEmpty_objectNodeWithArrayNode() {
        ObjectNode objectNode = new ObjectNode(factory);
        objectNode.set("empty array", (JsonNode)new ArrayNode(factory));
        Assertions.assertThat((boolean)this.expressionEvaluator.isNodeEmpty((JsonNode)objectNode)).isTrue();
    }

    @Test
    public void isNodeEmpty_objectNodeWithTextNode() {
        ObjectNode objectNode = new ObjectNode(factory);
        objectNode.set("key", (JsonNode)new TextNode("value"));
        Assertions.assertThat((boolean)this.expressionEvaluator.isNodeEmpty((JsonNode)objectNode)).isFalse();
    }

    @Test
    public void isNodeEmpty_arrayNodeWithTextNode() {
        ArrayNode arrayNode = new ArrayNode(factory);
        arrayNode.add((JsonNode)new TextNode("value"));
        Assertions.assertThat((boolean)this.expressionEvaluator.isNodeEmpty((JsonNode)arrayNode)).isFalse();
    }

    @Test
    public void isNodeEmpty_textNode() {
        Assertions.assertThat((boolean)this.expressionEvaluator.isNodeEmpty((JsonNode)new TextNode(""))).isTrue();
        Assertions.assertThat((boolean)this.expressionEvaluator.isNodeEmpty((JsonNode)new TextNode(null))).isTrue();
        Assertions.assertThat((boolean)this.expressionEvaluator.isNodeEmpty((JsonNode)new TextNode("value"))).isFalse();
    }

    @Test
    public void isListEmpty_noNode() {
        ArrayNode json = new ArrayNode(factory);
        Assertions.assertThat((boolean)this.expressionEvaluator.isListEmpty(json)).isTrue();
    }

    @Test
    public void isListEmpty_emptyNode() {
        ArrayNode json = new ArrayNode(factory);
        ObjectNode nestedNode = new ObjectNode(factory);
        json.add((JsonNode)nestedNode);
        Assertions.assertThat((boolean)this.expressionEvaluator.isListEmpty(json)).isTrue();
    }

    @Test
    public void isListEmpty_nodeWithEmptyField() {
        ArrayNode json = new ArrayNode(factory);
        ObjectNode nestedNode = new ObjectNode(factory);
        json.add((JsonNode)nestedNode);
        nestedNode.set("emptyField", (JsonNode)new TextNode(""));
        Assertions.assertThat((boolean)this.expressionEvaluator.isListEmpty(json)).isTrue();
    }

    @Test
    public void isListEmpty_nodeWithNonEmptyField() {
        ArrayNode json = new ArrayNode(factory);
        ObjectNode nestedNode = new ObjectNode(factory);
        json.add((JsonNode)nestedNode);
        nestedNode.set("notEmptyField", (JsonNode)new TextNode("text"));
        Assertions.assertThat((boolean)this.expressionEvaluator.isListEmpty(json)).isFalse();
    }

    @Test
    public void isObjectEmpty_nodeWithNoField() {
        ObjectNode json = new ObjectNode(factory);
        Assertions.assertThat((boolean)this.expressionEvaluator.isObjectEmpty(json)).isTrue();
    }

    @Test
    public void isObjectEmpty_nodeWithEmptyField() {
        ObjectNode json = new ObjectNode(factory);
        ObjectNode nestedNode = new ObjectNode(factory);
        json.set("emptyField", (JsonNode)nestedNode);
        Assertions.assertThat((boolean)this.expressionEvaluator.isObjectEmpty(json)).isTrue();
    }

    @Test
    public void isObjectEmpty_nodeWithNonEmptyField() {
        ObjectNode json = new ObjectNode(factory);
        ObjectNode nestedNode = new ObjectNode(factory);
        json.set("emptyField", (JsonNode)nestedNode);
        nestedNode.set("notEmptyField", (JsonNode)new TextNode("text"));
        Assertions.assertThat((boolean)this.expressionEvaluator.isObjectEmpty(json)).isFalse();
    }

    @Test
    public void isEmptyText() {
        Assertions.assertThat((boolean)this.expressionEvaluator.isEmptyText((JsonNode)new TextNode(""))).isTrue();
        Assertions.assertThat((boolean)this.expressionEvaluator.isEmptyText((JsonNode)new TextNode("value"))).isFalse();
        Assertions.assertThat((boolean)this.expressionEvaluator.isEmptyText((JsonNode)new ObjectNode(factory))).isTrue();
    }

    @Test
    public void isStructuredInput() {
        Assertions.assertThat((boolean)this.expressionEvaluator.isStructuredInput(List.class.getCanonicalName())).isTrue();
        Assertions.assertThat((boolean)this.expressionEvaluator.isStructuredInput(ArrayList.class.getCanonicalName())).isTrue();
        Assertions.assertThat((boolean)this.expressionEvaluator.isStructuredInput(LinkedList.class.getCanonicalName())).isTrue();
        Assertions.assertThat((boolean)this.expressionEvaluator.isStructuredInput(Map.class.getCanonicalName())).isTrue();
        Assertions.assertThat((boolean)this.expressionEvaluator.isStructuredInput(HashMap.class.getCanonicalName())).isTrue();
        Assertions.assertThat((boolean)this.expressionEvaluator.isStructuredInput(LinkedHashMap.class.getCanonicalName())).isTrue();
        Assertions.assertThat((boolean)this.expressionEvaluator.isStructuredInput(Set.class.getCanonicalName())).isFalse();
        Assertions.assertThat((boolean)this.expressionEvaluator.isStructuredInput(Integer.class.getCanonicalName())).isFalse();
        Assertions.assertThat((boolean)this.expressionEvaluator.isStructuredInput(String.class.getCanonicalName())).isFalse();
    }
}

