/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.fluent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.drools.base.definitions.rule.impl.QueryImpl;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.scenariosimulation.backend.fluent.RuleScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.fluent.RuleStatefulScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.fluent.RuleStatelessScenarioExecutableBuilder;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.mockito.Mockito;

public class RuleScenarioExecutableBuilderTest {
    @Test
    public void createBuilder() {
        RuleScenarioExecutableBuilder statelessBuilder = RuleScenarioExecutableBuilder.createBuilder(null, null, (boolean)true);
        Assertions.assertThat((Object)statelessBuilder).isInstanceOf(RuleStatelessScenarioExecutableBuilder.class);
        RuleScenarioExecutableBuilder statefulBuilder1 = RuleScenarioExecutableBuilder.createBuilder(null, null, (boolean)false);
        Assertions.assertThat((Object)statefulBuilder1).isInstanceOf(RuleStatefulScenarioExecutableBuilder.class);
        RuleScenarioExecutableBuilder statefulBuilder2 = RuleScenarioExecutableBuilder.createBuilder(null);
        Assertions.assertThat((Object)statefulBuilder2).isInstanceOf(RuleStatefulScenarioExecutableBuilder.class);
    }

    @Test
    public void getAvailableRules() {
        Map<String, List<String>> packagesToRules = Map.of("package1", List.of("rule1", "rule2", "rule3"), "package2", List.of("rule4", "rule5", "rule6"));
        Map<String, List<String>> queryToRules = Map.of("package1", List.of("query1", "query2"), "package2", List.of());
        Map<String, String> ruleToAgendaGroup = Map.of("rule1", "agenda1", "rule2", "agenda1", "rule3", "agenda1", "rule4", "agenda2");
        RuleScenarioExecutableBuilder builder = RuleScenarioExecutableBuilder.createBuilder(null, null, (boolean)false);
        Set agenda1 = builder.getAvailableRules(this.createKieBaseMock(packagesToRules, ruleToAgendaGroup, queryToRules), "agenda1");
        Assertions.assertThat((Collection)agenda1).hasSize(5);
        Set agenda2 = builder.getAvailableRules(this.createKieBaseMock(packagesToRules, ruleToAgendaGroup, queryToRules), "agenda2");
        Assertions.assertThat((Collection)agenda2).hasSize(3);
        Set noAgenda = builder.getAvailableRules(this.createKieBaseMock(packagesToRules, ruleToAgendaGroup, queryToRules), null);
        Assertions.assertThat((Collection)noAgenda).hasSize(2);
    }

    private KieBase createKieBaseMock(Map<String, List<String>> packagesToRules, Map<String, String> ruleToAgendaGroup, Map<String, List<String>> packagesToQueries) {
        KieBase kieBaseMock = (KieBase)Mockito.mock(KieBase.class);
        ArrayList<KiePackage> kiePackagesMock = new ArrayList<KiePackage>();
        Mockito.when((Object)kieBaseMock.getKiePackages()).thenReturn(kiePackagesMock);
        for (Map.Entry<String, List<String>> packageToRule : packagesToRules.entrySet()) {
            kiePackagesMock.add(this.createKiePackageMock(packageToRule.getKey(), packageToRule.getValue(), ruleToAgendaGroup, packagesToQueries.get(packageToRule.getKey())));
        }
        return kieBaseMock;
    }

    private KiePackage createKiePackageMock(String packageName, List<String> ruleNames, Map<String, String> ruleToAgendaGroup, List<String> queries) {
        KiePackage kiePackageMock = (KiePackage)Mockito.mock(KiePackage.class);
        Mockito.when((Object)kiePackageMock.getName()).thenReturn((Object)packageName);
        ArrayList<Object> ruleListMock = new ArrayList<Object>();
        Mockito.when((Object)kiePackageMock.getRules()).thenReturn(ruleListMock);
        for (String ruleName : ruleNames) {
            ruleListMock.add(this.createRuleMock(ruleName, ruleToAgendaGroup.get(ruleName)));
        }
        for (String queryName : queries) {
            ruleListMock.add(this.createQueryImplMock(queryName));
        }
        return kiePackageMock;
    }

    private RuleImpl createRuleMock(String fullName, String agendaGroup) {
        RuleImpl ruleMock = (RuleImpl)Mockito.mock(RuleImpl.class);
        Mockito.when((Object)ruleMock.getName()).thenReturn((Object)fullName);
        Mockito.when((Object)ruleMock.getPackageName()).thenReturn((Object)"");
        Mockito.when((Object)ruleMock.isMainAgendaGroup()).thenReturn((Object)(agendaGroup == null ? 1 : 0));
        Mockito.when((Object)ruleMock.getAgendaGroup()).thenReturn((Object)agendaGroup);
        Mockito.when((Object)ruleMock.getKnowledgeType()).thenCallRealMethod();
        return ruleMock;
    }

    private QueryImpl createQueryImplMock(String fullName) {
        QueryImpl queryImplMock = (QueryImpl)Mockito.mock(QueryImpl.class);
        Mockito.when((Object)queryImplMock.getName()).thenReturn((Object)fullName);
        Mockito.when((Object)queryImplMock.getPackageName()).thenReturn((Object)"");
        Mockito.when((Object)queryImplMock.getKnowledgeType()).thenCallRealMethod();
        return queryImplMock;
    }
}

