/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner.model;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.AuditLogLine;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.backend.TestUtils;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.mockito.Mockito;

public class ScenarioResultMetadataTest {
    private ScenarioResultMetadata scenarioResultMetadata;
    private ScenarioWithIndex scenarioWithIndex;
    private Scenario scenarioMock;
    private int SCENARIO_INDEX = 0;

    @Before
    public void setup() {
        this.scenarioMock = (Scenario)Mockito.mock(Scenario.class);
        this.scenarioWithIndex = new ScenarioWithIndex(this.SCENARIO_INDEX, this.scenarioMock);
        this.scenarioResultMetadata = new ScenarioResultMetadata(this.scenarioWithIndex);
    }

    @Test
    public void noLogLinesAtTheStart() {
        Assertions.assertThat((List)this.scenarioResultMetadata.getAuditLogLines()).isEmpty();
    }

    @Test
    public void addAuditMessage() {
        this.scenarioResultMetadata.addAuditMessage(1, "decisionName", DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED.toString());
        Assertions.assertThat((List)this.scenarioResultMetadata.getAuditLogLines()).hasSize(1);
        TestUtils.commonCheckAuditLogLine((AuditLogLine)this.scenarioResultMetadata.getAuditLogLines().get(0), "decisionName", DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED.toString());
    }

    @Test
    public void addAuditMessageWithErrorMessage() {
        this.scenarioResultMetadata.addAuditMessage(1, "decisionName", DMNDecisionResult.DecisionEvaluationStatus.FAILED.toString(), "Message");
        Assertions.assertThat((List)this.scenarioResultMetadata.getAuditLogLines()).hasSize(1);
        TestUtils.commonCheckAuditLogLine((AuditLogLine)this.scenarioResultMetadata.getAuditLogLines().get(0), "decisionName", DMNDecisionResult.DecisionEvaluationStatus.FAILED.toString(), "Message");
    }
}

