/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import com.fasterxml.jackson.databind.node.TextNode;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.backend.expression.BaseExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.DMNFeelExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorFactory;
import org.drools.scenariosimulation.backend.expression.MVELExpressionEvaluator;
import org.junit.Test;

public class ExpressionEvaluatorFactoryTest {
    ClassLoader classLoader = ExpressionEvaluatorFactoryTest.class.getClassLoader();

    @Test
    public void create() {
        Assertions.assertThat((Object)ExpressionEvaluatorFactory.create((ClassLoader)this.classLoader, (ScenarioSimulationModel.Type)ScenarioSimulationModel.Type.RULE)).isNotNull();
    }

    @Test
    public void getOrCreate() {
        FactMappingValue simpleFMV = new FactMappingValue(FactIdentifier.INDEX, ExpressionIdentifier.INDEX, (Object)"10");
        FactMappingValue objectFMV = new FactMappingValue(FactIdentifier.INDEX, ExpressionIdentifier.INDEX, (Object)"10");
        FactMappingValue mvelFMV = new FactMappingValue(FactIdentifier.INDEX, ExpressionIdentifier.INDEX, (Object)"# 10");
        FactMappingValue mvelWithSpacesFMV = new FactMappingValue(FactIdentifier.INDEX, ExpressionIdentifier.INDEX, (Object)"     # 10");
        FactMappingValue mvelCollectionExpressionFMV = new FactMappingValue(FactIdentifier.INDEX, ExpressionIdentifier.INDEX, (Object)new TextNode("# 10").textValue());
        FactMappingValue mvelCollectionExpressionWithSpacesFMV = new FactMappingValue(FactIdentifier.INDEX, ExpressionIdentifier.INDEX, (Object)new TextNode("     # 10").textValue());
        FactMappingValue mvelCollectionExpressionWitoutMVELEscapeSymbolFMV = new FactMappingValue(FactIdentifier.INDEX, ExpressionIdentifier.INDEX, (Object)new TextNode(" 10").textValue());
        ExpressionEvaluatorFactory ruleEvaluatorFactory = ExpressionEvaluatorFactory.create((ClassLoader)this.classLoader, (ScenarioSimulationModel.Type)ScenarioSimulationModel.Type.RULE);
        ExpressionEvaluatorFactory dmnEvaluatorFactory = ExpressionEvaluatorFactory.create((ClassLoader)this.classLoader, (ScenarioSimulationModel.Type)ScenarioSimulationModel.Type.DMN);
        Assertions.assertThat((Object)ruleEvaluatorFactory.getOrCreate(simpleFMV)).isInstanceOf(BaseExpressionEvaluator.class);
        Assertions.assertThat((Object)ruleEvaluatorFactory.getOrCreate(objectFMV)).isInstanceOf(BaseExpressionEvaluator.class);
        Assertions.assertThat((Object)ruleEvaluatorFactory.getOrCreate(mvelFMV)).isInstanceOf(MVELExpressionEvaluator.class);
        Assertions.assertThat((Object)ruleEvaluatorFactory.getOrCreate(mvelWithSpacesFMV)).isInstanceOf(MVELExpressionEvaluator.class);
        Assertions.assertThat((Object)ruleEvaluatorFactory.getOrCreate(mvelCollectionExpressionFMV)).isInstanceOf(MVELExpressionEvaluator.class);
        Assertions.assertThat((Object)ruleEvaluatorFactory.getOrCreate(mvelCollectionExpressionWithSpacesFMV)).isInstanceOf(MVELExpressionEvaluator.class);
        Assertions.assertThat((Object)ruleEvaluatorFactory.getOrCreate(mvelCollectionExpressionWitoutMVELEscapeSymbolFMV)).isInstanceOf(BaseExpressionEvaluator.class);
        Assertions.assertThat((Object)dmnEvaluatorFactory.getOrCreate(simpleFMV)).isInstanceOf(DMNFeelExpressionEvaluator.class);
        Assertions.assertThat((Object)dmnEvaluatorFactory.getOrCreate(objectFMV)).isInstanceOf(DMNFeelExpressionEvaluator.class);
        Assertions.assertThat((Object)dmnEvaluatorFactory.getOrCreate(mvelFMV)).isInstanceOf(DMNFeelExpressionEvaluator.class);
        Assertions.assertThat((Object)dmnEvaluatorFactory.getOrCreate(mvelWithSpacesFMV)).isInstanceOf(DMNFeelExpressionEvaluator.class);
        Assertions.assertThat((Object)dmnEvaluatorFactory.getOrCreate(mvelCollectionExpressionFMV)).isInstanceOf(DMNFeelExpressionEvaluator.class);
        Assertions.assertThat((Object)dmnEvaluatorFactory.getOrCreate(mvelCollectionExpressionWithSpacesFMV)).isInstanceOf(DMNFeelExpressionEvaluator.class);
        Assertions.assertThat((Object)dmnEvaluatorFactory.getOrCreate(mvelCollectionExpressionWitoutMVELEscapeSymbolFMV)).isInstanceOf(DMNFeelExpressionEvaluator.class);
    }

    @Test
    public void isAnMVELExpression() {
        ExpressionEvaluatorFactory ruleEvaluatorFactory = ExpressionEvaluatorFactory.create((ClassLoader)this.classLoader, (ScenarioSimulationModel.Type)ScenarioSimulationModel.Type.RULE);
        Assertions.assertThat((boolean)ruleEvaluatorFactory.isAnMVELExpression("10")).isFalse();
        Assertions.assertThat((boolean)ruleEvaluatorFactory.isAnMVELExpression("#10")).isTrue();
        Assertions.assertThat((boolean)ruleEvaluatorFactory.isAnMVELExpression("     # 10")).isTrue();
        Assertions.assertThat((boolean)ruleEvaluatorFactory.isAnMVELExpression(new TextNode("# 10").textValue())).isTrue();
        Assertions.assertThat((boolean)ruleEvaluatorFactory.isAnMVELExpression(new TextNode("     # 10").textValue())).isTrue();
        Assertions.assertThat((boolean)ruleEvaluatorFactory.isAnMVELExpression(new TextNode("10").textValue())).isFalse();
    }
}

