/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.imports.Import;
import org.drools.scenariosimulation.api.utils.ConstantsHolder;
import org.drools.scenariosimulation.backend.TestUtils;
import org.drools.scenariosimulation.backend.util.DOMParserUtil;
import org.drools.scenariosimulation.backend.util.InMemoryMigrationStrategy;
import org.drools.scenariosimulation.backend.util.MigrationStrategy;
import org.drools.scenariosimulation.backend.util.ScenarioSimulationXMLPersistence;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ScenarioSimulationXMLPersistenceTest {
    protected ScenarioSimulationXMLPersistence instance = ScenarioSimulationXMLPersistence.getInstance();
    protected String currentVersion = new ScenarioSimulationModel().getVersion();
    protected MigrationStrategy migrationInstance = new InMemoryMigrationStrategy();

    @Test
    public void noFQCNUsed() {
        ScenarioSimulationModel simulationModel = new ScenarioSimulationModel();
        simulationModel.getImports().addImport(new Import("org.test.Test"));
        String xml = this.instance.marshal(simulationModel);
        Assertions.assertThat((String)xml).doesNotContain(new CharSequence[]{"org.drools.scenariosimulation.api.model", "org.kie.soup.project.datamodel.imports"});
    }

    @Test
    public void versionAttributeExists() {
        String xml = this.instance.marshal(new ScenarioSimulationModel());
        Assertions.assertThat((String)xml).startsWith((CharSequence)("<ScenarioSimulationModel version=\"" + ScenarioSimulationXMLPersistence.getCurrentVersion() + "\">"));
    }

    @Test
    public void migrateIfNecessary_1_0_to_1_1() throws Exception {
        String toMigrate = TestUtils.getFileContent("scesim-1-0.scesim");
        Document document = DOMParserUtil.getDocument((String)toMigrate);
        this.migrationInstance.from1_0to1_1().accept((Object)document);
        Map retrieved = DOMParserUtil.getChildrenNodesMap((Document)document, (String)"expressionIdentifier", (String)"type");
        ((MapAssert)Assertions.assertThat((Map)retrieved).isNotNull()).hasSize(1);
        retrieved.forEach((node, typeNodes) -> {
            Assertions.assertThat((List)typeNodes).hasSize(1);
            Assertions.assertThat((String)((Node)typeNodes.get(0)).getTextContent()).isEqualTo("EXPECT");
        });
        this.commonCheck(toMigrate, document, "1.1");
    }

    @Test
    public void migrateIfNecessary_1_1_to_1_2() throws Exception {
        String toMigrate = TestUtils.getFileContent("scesim-1-1.scesim");
        Document document = DOMParserUtil.getDocument((String)toMigrate);
        this.migrationInstance.from1_1to1_2().accept((Object)document);
        Map retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"dmoSession");
        ((MapAssert)Assertions.assertThat((Map)retrieved).isNotNull()).hasSize(1);
        Assertions.assertThat((List)((List)retrieved.values().iterator().next())).hasSize(1);
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"type");
        this.commonVerifySingleNodeSingleChild(retrieved, "RULE");
        this.commonCheck(toMigrate, document, "1.2");
    }

    @Test
    public void migrateIfNecessary_1_2_to_1_3() throws Exception {
        String toMigrate = TestUtils.getFileContent("scesim-1-2.scesim");
        Document document = DOMParserUtil.getDocument((String)toMigrate);
        this.migrationInstance.from1_2to1_3().accept((Object)document);
        List factMappingsNodes = DOMParserUtil.getNestedChildrenNodesList((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"factMappings");
        ((ListAssert)Assertions.assertThat((List)factMappingsNodes).isNotNull()).hasSize(1);
        List factMappingNodes = DOMParserUtil.getChildrenNodesList((Node)((Node)factMappingsNodes.get(0)), (String)"FactMapping");
        for (Node factMappingNode : factMappingNodes) {
            List expressionElementsNodes = DOMParserUtil.getChildrenNodesList((Node)factMappingNode, (String)"expressionElements");
            Assertions.assertThat((List)expressionElementsNodes).hasSize(1);
            List stepNodes = DOMParserUtil.getNestedChildrenNodesList((Node)((Node)expressionElementsNodes.get(0)), (String)"ExpressionElement", (String)"step");
            Assertions.assertThat((List)stepNodes).hasSize(1);
        }
        this.commonCheck(toMigrate, document, "1.3");
    }

    @Test
    public void migrateIfNecessary_1_3_to_1_4() throws Exception {
        String toMigrate = TestUtils.getFileContent("scesim-1-3-rule.scesim");
        Document document = DOMParserUtil.getDocument((String)toMigrate);
        this.migrationInstance.from1_3to1_4().accept((Object)document);
        Map retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"fileName");
        this.commonVerifySingleNodeSingleChild(retrieved, null);
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"kieSession");
        this.commonVerifySingleNodeSingleChild(retrieved, "default");
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"kieBase");
        this.commonVerifySingleNodeSingleChild(retrieved, "default");
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"ruleFlowGroup");
        this.commonVerifySingleNodeSingleChild(retrieved, "default");
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"dmoSession");
        this.commonVerifySingleNodeSingleChild(retrieved, "default");
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"skipFromBuild");
        this.commonVerifySingleNodeSingleChild(retrieved, "false");
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"type");
        this.commonVerifySingleNodeSingleChild(retrieved, "RULE");
        this.commonCheck(toMigrate, document, "1.4");
        toMigrate = TestUtils.getFileContent("scesim-1-3-dmn_1.scesim");
        document = DOMParserUtil.getDocument((String)toMigrate);
        this.migrationInstance.from1_3to1_4().accept((Object)document);
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"dmnNamespace");
        this.commonVerifySingleNodeSingleChild(retrieved, null);
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"dmnName");
        this.commonVerifySingleNodeSingleChild(retrieved, null);
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"skipFromBuild");
        this.commonVerifySingleNodeSingleChild(retrieved, "false");
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"type");
        this.commonVerifySingleNodeSingleChild(retrieved, "DMN");
        this.commonCheck(toMigrate, document, "1.4");
        toMigrate = TestUtils.getFileContent("scesim-1-3-dmn_2.scesim");
        document = DOMParserUtil.getDocument((String)toMigrate);
        this.migrationInstance.from1_3to1_4().accept((Object)document);
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"dmnNamespace");
        this.commonVerifySingleNodeSingleChild(retrieved, null);
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"dmnName");
        this.commonVerifySingleNodeSingleChild(retrieved, null);
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"skipFromBuild");
        this.commonVerifySingleNodeSingleChild(retrieved, "false");
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"type");
        this.commonVerifySingleNodeSingleChild(retrieved, "DMN");
        this.commonCheck(toMigrate, document, "1.4");
    }

    @Test
    public void migrateIfNecessary_1_4_to_1_5() throws Exception {
        String toMigrate = TestUtils.getFileContent("scesim-1-4-rule.scesim");
        Document document = DOMParserUtil.getDocument((String)toMigrate);
        this.migrationInstance.from1_4to1_5().accept((Object)document);
        List retrieved = DOMParserUtil.getNestedChildrenNodesList((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"dmoSession");
        ((ListAssert)Assertions.assertThat((List)retrieved).isNotNull()).isEmpty();
        this.commonCheck(toMigrate, document, "1.5");
    }

    @Test
    public void migrateIfNecessary_1_5_to_1_6() throws Exception {
        String toMigrate = TestUtils.getFileContent("scesim-1-5-dmn.scesim");
        Document document = DOMParserUtil.getDocument((String)toMigrate);
        this.migrationInstance.from1_5to1_6().accept((Object)document);
        Map retrieved = DOMParserUtil.getAttributeValues((Document)document, (String)"reference");
        ((MapAssert)Assertions.assertThat((Map)retrieved).isNotNull()).isEmpty();
        this.commonCheck(toMigrate, document, "1.6");
    }

    @Test
    public void migrateIfNecessary_1_6_to_1_7() throws Exception {
        double columnWidthDouble;
        String columnWidth;
        List columnWidthNodes;
        String expressionIdentifierName;
        List expressionIdentifierNamesNodes;
        String toMigrate = TestUtils.getFileContent("scesim-1-6-rule.scesim");
        Document document = DOMParserUtil.getDocument((String)toMigrate);
        this.migrationInstance.from1_6to1_7().accept((Object)document);
        List factMappingsNodes = DOMParserUtil.getNestedChildrenNodesList((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"factMappings");
        ((ListAssert)Assertions.assertThat((List)factMappingsNodes).isNotNull()).hasSize(1);
        List factMappingNodes = DOMParserUtil.getChildrenNodesList((Node)((Node)factMappingsNodes.get(0)), (String)"FactMapping");
        for (Node factMappingNode : factMappingNodes) {
            expressionIdentifierNamesNodes = DOMParserUtil.getNestedChildrenNodesList((Node)factMappingNode, (String)"expressionIdentifier", (String)"name");
            expressionIdentifierName = ((Node)expressionIdentifierNamesNodes.get(0)).getTextContent();
            Assertions.assertThat((String)expressionIdentifierName).isNotNull();
            columnWidthNodes = DOMParserUtil.getChildrenNodesList((Node)factMappingNode, (String)"columnWidth");
            Assertions.assertThat((List)columnWidthNodes).hasSize(1);
            columnWidth = ((Node)columnWidthNodes.get(0)).getTextContent();
            ((AbstractStringAssert)Assertions.assertThat((String)columnWidth).isNotNull()).isNotEmpty();
            columnWidthDouble = Double.parseDouble(columnWidth);
            Assertions.assertThat((double)columnWidthDouble).isCloseTo(ScenarioSimulationXMLPersistence.getColumnWidth((String)expressionIdentifierName), Assertions.within((Double)0.0));
        }
        this.commonCheck(toMigrate, document, "1.7");
        toMigrate = TestUtils.getFileContent("scesim-1-6-dmn.scesim");
        document = DOMParserUtil.getDocument((String)toMigrate);
        this.migrationInstance.from1_6to1_7().accept((Object)document);
        factMappingsNodes = DOMParserUtil.getNestedChildrenNodesList((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)"factMappings");
        ((ListAssert)Assertions.assertThat((List)factMappingsNodes).isNotNull()).hasSize(1);
        factMappingNodes = DOMParserUtil.getChildrenNodesList((Node)((Node)factMappingsNodes.get(0)), (String)"FactMapping");
        for (Node factMappingNode : factMappingNodes) {
            expressionIdentifierNamesNodes = DOMParserUtil.getNestedChildrenNodesList((Node)factMappingNode, (String)"expressionIdentifier", (String)"name");
            expressionIdentifierName = ((Node)expressionIdentifierNamesNodes.get(0)).getTextContent();
            Assertions.assertThat((String)expressionIdentifierName).isNotNull();
            columnWidthNodes = DOMParserUtil.getChildrenNodesList((Node)factMappingNode, (String)"columnWidth");
            Assertions.assertThat((List)columnWidthNodes).hasSize(1);
            columnWidth = ((Node)columnWidthNodes.get(0)).getTextContent();
            ((AbstractStringAssert)Assertions.assertThat((String)columnWidth).isNotNull()).isNotEmpty();
            columnWidthDouble = Double.parseDouble(columnWidth);
            Assertions.assertThat((double)columnWidthDouble).isCloseTo(ScenarioSimulationXMLPersistence.getColumnWidth((String)expressionIdentifierName), Assertions.within((Double)0.0));
        }
        this.commonCheck(toMigrate, document, "1.7");
    }

    @Test
    public void migrateIfNecessary_1_7_to_1_8() throws Exception {
        String toMigrate = TestUtils.getFileContent("scesim-1-7-dmn.scesim");
        Document document = DOMParserUtil.getDocument((String)toMigrate);
        this.migrationInstance.from1_7to1_8().accept((Object)document);
        Map retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"ScenarioSimulationModel", (String)"settings", (String)"dmnFilePath");
        this.commonVerifySingleNodeSingleChild(retrieved, "src/main/resources/com/list.dmn");
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"ScenarioSimulationModel", (String)"settings", (String)"type");
        this.commonVerifySingleNodeSingleChild(retrieved, "DMN");
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"ScenarioSimulationModel", (String)"settings", (String)"dmnNamespace");
        this.commonVerifySingleNodeSingleChild(retrieved, "https://github.com/kiegroup/drools/kie-dmn/_CC8924B0-D729-4D70-9588-039B5824FFE9");
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"ScenarioSimulationModel", (String)"settings", (String)"dmnName");
        this.commonVerifySingleNodeSingleChild(retrieved, "a1Collection");
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"ScenarioSimulationModel", (String)"settings", (String)"skipFromBuild");
        this.commonVerifySingleNodeSingleChild(retrieved, "false");
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"ScenarioSimulationModel", (String)"settings", (String)"stateless");
        this.commonVerifySingleNodeSingleChild(retrieved, "false");
        for (String setting : ConstantsHolder.SETTINGS) {
            retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)setting);
            Assertions.assertThat((List)((List)retrieved.values().iterator().next())).isEmpty();
        }
        this.commonCheck(toMigrate, document, "1.8");
        this.commonCheckBackground(document);
        this.commonCheckFactMappingValueType(document, "simulation");
        this.commonCheckFactMappingValueType(document, "background");
        toMigrate = TestUtils.getFileContent("scesim-1-7-rule.scesim");
        document = DOMParserUtil.getDocument((String)toMigrate);
        this.migrationInstance.from1_7to1_8().accept((Object)document);
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"ScenarioSimulationModel", (String)"settings", (String)"type");
        this.commonVerifySingleNodeSingleChild(retrieved, "RULE");
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"ScenarioSimulationModel", (String)"settings", (String)"dmoSession");
        this.commonVerifySingleNodeSingleChild(retrieved, "default");
        retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"ScenarioSimulationModel", (String)"settings", (String)"skipFromBuild");
        this.commonVerifySingleNodeSingleChild(retrieved, "false");
        for (String setting : ConstantsHolder.SETTINGS) {
            retrieved = DOMParserUtil.getNestedChildrenNodesMap((Document)document, (String)"simulation", (String)"simulationDescriptor", (String)setting);
            Assertions.assertThat((List)((List)retrieved.values().iterator().next())).isEmpty();
        }
        this.commonCheck(toMigrate, document, "1.8");
        this.commonCheckBackground(document);
        this.commonCheckFactMappingValueType(document, "simulation");
        this.commonCheckFactMappingValueType(document, "background");
    }

    private void commonCheckFactMappingValueType(Document document, String scesimModel) {
        List factMappingsNodes = DOMParserUtil.getNestedChildrenNodesList((Document)document, (String)scesimModel, (String)"simulationDescriptor", (String)"factMappings");
        ((ListAssert)Assertions.assertThat((List)factMappingsNodes).isNotNull()).hasSize(1);
        List factMappingNodes = DOMParserUtil.getChildrenNodesList((Node)((Node)factMappingsNodes.get(0)), (String)"FactMapping");
        for (Node factMappingNode : factMappingNodes) {
            List factMappingValueTypeNodes = DOMParserUtil.getChildrenNodesList((Node)factMappingNode, (String)"factMappingValueType");
            Assertions.assertThat((List)factMappingValueTypeNodes).hasSize(1);
            String factMappingValueTypeText = ((Node)factMappingValueTypeNodes.get(0)).getTextContent();
            ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)factMappingValueTypeText).isNotNull()).isNotEmpty()).isEqualTo("NOT_EXPRESSION");
        }
    }

    @Test
    public void migrateIfNecessary() throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.instance.migrateIfNecessary("<ScenarioSimulationModel version=\"9999999999.99999999999\" />")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Version 9999999999.99999999999 of the file is not supported. Current version is " + ScenarioSimulationXMLPersistence.getCurrentVersion());
        String noMigrationNeeded = "<ScenarioSimulationModel version=\"" + this.currentVersion + "\" />";
        String afterMigration = this.instance.migrateIfNecessary(noMigrationNeeded);
        Document document = DOMParserUtil.getDocument((String)afterMigration);
        this.commonCheckVersion(document, ScenarioSimulationXMLPersistence.getCurrentVersion());
    }

    @Test
    public void extractVersion() {
        String version = this.instance.extractVersion("<ScenarioSimulationModel version=\"1.0\" version=\"1.1\">");
        Assertions.assertThat((String)version).isEqualTo("1.0");
    }

    @Test
    public void extractVersionWhenXmlPrologIsPresent() {
        String version = this.instance.extractVersion("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ScenarioSimulationModel version=\"1.1\">");
        Assertions.assertThat((String)version).isEqualTo("1.1");
    }

    @Test
    public void extractVersionWhenMoreVersionAttributesArePresent() {
        String version = this.instance.extractVersion("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ScenarioSimulationModel version=\"1.2\">\n<someUnknownTag version=\"1.1\"/>\n</ScenarioSimulationModel>");
        Assertions.assertThat((String)version).isEqualTo("1.2");
    }

    @Test(expected=IllegalArgumentException.class)
    public void unmarshalEmptyContent() throws Exception {
        ScenarioSimulationXMLPersistence.getInstance().unmarshal("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void unmarshalNullContent() throws Exception {
        ScenarioSimulationXMLPersistence.getInstance().unmarshal(null);
    }

    @Test
    public void unmarshalRULE() throws Exception {
        String toUnmarshal = TestUtils.getFileContent("scesim-rule.scesim");
        ScenarioSimulationModel retrieved = ScenarioSimulationXMLPersistence.getInstance().unmarshal(toUnmarshal);
        Assertions.assertThat((Comparable)retrieved.getSettings().getType()).isEqualTo((Object)ScenarioSimulationModel.Type.RULE);
        this.commonCheckSimulation(retrieved);
    }

    @Test
    public void unmarshalDMN() throws Exception {
        String toUnmarshal = TestUtils.getFileContent("scesim-dmn.scesim");
        ScenarioSimulationModel retrieved = ScenarioSimulationXMLPersistence.getInstance().unmarshal(toUnmarshal);
        Assertions.assertThat((Comparable)retrieved.getSettings().getType()).isEqualTo((Object)ScenarioSimulationModel.Type.DMN);
        this.commonCheckSimulation(retrieved);
    }

    private void commonVerifySingleNodeSingleChild(Map<Node, List<Node>> toCheck, String expectedTextContent) {
        ((MapAssert)Assertions.assertThat(toCheck).isNotNull()).hasSize(1);
        Assertions.assertThat(toCheck.values()).isNotNull();
        Assertions.assertThat(toCheck.values().iterator().next()).hasSize(1);
        if (expectedTextContent != null) {
            Assertions.assertThat((String)toCheck.values().iterator().next().get(0).getTextContent()).isEqualTo(expectedTextContent);
        }
    }

    private void commonCheck(String toMigrate, Document document, String expectedVersion) throws Exception {
        this.commonCheckVersion(document, expectedVersion);
        this.commonCheckSimulation(document);
        this.instance.migrateIfNecessary(toMigrate);
    }

    private void commonCheckVersion(Document document, String expectedVersion) {
        Map attributeValues = DOMParserUtil.getAttributeValues((Document)document, (String)"ScenarioSimulationModel", (String)"version");
        ((MapAssert)Assertions.assertThat((Map)attributeValues).isNotNull()).hasSize(1);
        Assertions.assertThat((Object)attributeValues.values().toArray()[0]).isEqualTo((Object)expectedVersion);
    }

    private void commonCheckSimulation(Document toCheck) throws Exception {
        String migrated = DOMParserUtil.getString((Document)toCheck);
        ScenarioSimulationModel scenarioSimulationModel = this.instance.internalUnmarshal(migrated);
        this.commonCheckSimulation(scenarioSimulationModel);
    }

    private void commonCheckSimulation(ScenarioSimulationModel toCheck) {
        Assertions.assertThat((Object)toCheck).isNotNull();
        Assertions.assertThat((Object)toCheck.getSimulation()).isNotNull();
        Assertions.assertThat((Object)toCheck.getSimulation().getScesimModelDescriptor()).isNotNull();
    }

    private void commonCheckBackground(Document toCheck) throws Exception {
        String migrated = DOMParserUtil.getString((Document)toCheck);
        ScenarioSimulationModel scenarioSimulationModel = this.instance.internalUnmarshal(migrated);
        this.commonCheckBackground(scenarioSimulationModel);
    }

    private void commonCheckBackground(ScenarioSimulationModel toCheck) {
        Assertions.assertThat((Object)toCheck).isNotNull();
        Assertions.assertThat((Object)toCheck.getBackground()).isNotNull();
        Assertions.assertThat((Object)toCheck.getBackground().getScesimModelDescriptor()).isNotNull();
        Assertions.assertThat((List)toCheck.getBackground().getUnmodifiableData()).isNotEmpty();
    }
}

