/*
 * Decompiled with CFR 0.152.
 */
package org.drools.serialization.protobuf;

import java.io.IOException;
import java.io.Serializable;
import org.drools.mvel.compiler.Person;
import org.drools.serialization.protobuf.SerializationHelper;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.utils.KieHelper;

public class FactHandleSerializationTest {
    @Test
    public void testFactHandleSerialization() throws IOException, ClassNotFoundException {
        String drl = "import " + Result.class.getCanonicalName() + ";import " + Person.class.getCanonicalName() + ";rule R when\n  $r : Result()\n  $p1 : Person()\n  $p2 : Person(name != \"Mark\", this != $p1, age > $p1.age)\nthen\n  $r.setValue($p2.getName() + \" is older than \" + $p1.getName());\nend";
        KieSession ksession = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        Result result = new Result();
        ksession.insert((Object)result);
        Person mark = new Person("Mark", 37);
        Person edson = new Person("Edson", 35);
        Person mario = new Person("Mario", 40);
        FactHandle markFH = ksession.insert((Object)mark);
        FactHandle edsonFH = ksession.insert((Object)edson);
        FactHandle marioFH = ksession.insert((Object)mario);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"Mario is older than Mark", (Object)result.getValue());
        markFH = SerializationHelper.serializeObject(markFH);
        edsonFH = SerializationHelper.serializeObject(edsonFH);
        marioFH = SerializationHelper.serializeObject(marioFH);
        result.setValue(null);
        ksession.delete(marioFH);
        ksession.fireAllRules();
        Assert.assertNull((Object)result.getValue());
        mark.setAge(34);
        ksession.update(markFH, (Object)mark, new String[]{"age"});
        ksession.fireAllRules();
        Assert.assertEquals((Object)"Edson is older than Mark", (Object)result.getValue());
    }

    public static class Result
    implements Serializable {
        private Object value;

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

