/*
 * Decompiled with CFR 0.152.
 */
package org.drools.serialization.protobuf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.drools.core.ClockType;
import org.drools.core.SessionConfiguration;
import org.drools.core.WorkingMemory;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BaseNode;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.DroolsObjectOutputStream;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.IdentityPlaceholderResolverStrategy;
import org.drools.core.marshalling.impl.RuleBaseNodes;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.MapBackedClassLoader;
import org.drools.core.spi.Consequence;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.time.impl.DurationTimer;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.drools.core.time.impl.Timer;
import org.drools.core.util.KeyStoreHelper;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Address;
import org.drools.mvel.compiler.Cell;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.FactA;
import org.drools.mvel.compiler.FactB;
import org.drools.mvel.compiler.FactC;
import org.drools.mvel.compiler.Message;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.Primitives;
import org.drools.mvel.integrationtests.IteratorToList;
import org.drools.serialization.protobuf.SerializationHelper;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.conf.DeclarativeAgendaOption;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.io.ResourceType;
import org.kie.api.marshalling.KieMarshallers;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.conf.TimedRuleExecutionOption;
import org.kie.api.runtime.conf.TimerJobFactoryOption;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.time.SessionPseudoClock;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.marshalling.MarshallerFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.utils.KieHelper;

public class MarshallingTest
extends CommonTestMethodBase {
    @Test
    public void testSerializable() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Serializable.drl"});
        KiePackage kpkg = (KiePackage)kpkgs.iterator().next();
        kpkg = SerializationHelper.serializeObject(kpkg);
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.loadKnowledgeBase(new String[0]);
        kbase.addPackages(Collections.singleton(kpkg));
        Map map = new HashMap<String, InternalKnowledgeBase>();
        map.put("x", kbase);
        map = SerializationHelper.serializeObject(map);
        kbase = (InternalKnowledgeBase)map.get("x");
        Rule[] rules = ((KiePackage)kbase.getKiePackages().iterator().next()).getRules().toArray(new Rule[0]);
        Assert.assertEquals((long)4L, (long)rules.length);
        Assert.assertEquals((Object)"match Person 1", (Object)rules[0].getName());
        Assert.assertEquals((Object)"match Person 2", (Object)rules[1].getName());
        Assert.assertEquals((Object)"match Person 3", (Object)rules[2].getName());
        Assert.assertEquals((Object)"match Integer", (Object)rules[3].getName());
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        ksession.insert((Object)bob);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Assert.assertEquals((long)1L, (long)ksession.getFactCount());
        Assert.assertEquals((Object)bob, ksession.getObjects().iterator().next());
        Assert.assertEquals((long)2L, (long)((InternalAgenda)ksession.getAgenda()).agendaSize());
        ksession.fireAllRules();
        List list = (List)ksession.getGlobal("list");
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)new Integer(4), list.get(0));
        ArrayList objects = new ArrayList(ksession.getObjects());
        Assert.assertEquals((long)2L, (long)objects.size());
        Assert.assertTrue((boolean)objects.contains(bob));
        Assert.assertTrue((boolean)objects.contains(new Person("help")));
    }

    @Test
    public void testSerializeWorkingMemoryAndRuleBase1() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Serializable.drl"});
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
        KieSession session = kBase.newKieSession();
        Map map = new HashMap<String, InternalKnowledgeBase>();
        map.put("x", kBase);
        map = SerializationHelper.serializeObject(map);
        kBase = (InternalKnowledgeBase)map.get("x");
        kBase.addPackages(kpkgs);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        kBase = SerializationHelper.serializeObject(kBase);
        session.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        session.insert((Object)bob);
        ((InternalWorkingMemory)session).flushPropagations();
        Rule[] rules = kBase.getPackage("org.drools.compiler.test").getRules().toArray(new Rule[0]);
        Assert.assertEquals((long)4L, (long)rules.length);
        Assert.assertEquals((Object)"match Person 1", (Object)rules[0].getName());
        Assert.assertEquals((Object)"match Person 2", (Object)rules[1].getName());
        Assert.assertEquals((Object)"match Person 3", (Object)rules[2].getName());
        Assert.assertEquals((Object)"match Integer", (Object)rules[3].getName());
        Assert.assertEquals((long)1L, (long)session.getObjects().size());
        Assert.assertEquals((Object)bob, IteratorToList.convert(session.getObjects().iterator()).get(0));
        Assert.assertEquals((long)2L, (long)((InternalAgenda)session.getAgenda()).agendaSize());
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        session.fireAllRules();
        List list = (List)session.getGlobal("list");
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)new Integer(4), list.get(0));
        Assert.assertEquals((long)2L, (long)session.getObjects().size());
        Assert.assertTrue((boolean)IteratorToList.convert(session.getObjects().iterator()).contains(bob));
        Assert.assertTrue((boolean)IteratorToList.convert(session.getObjects().iterator()).contains(new Person("help")));
    }

    @Test
    public void testSerializeWorkingMemoryAndRuleBase2() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Serializable.drl"});
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
        Map map = new HashMap<String, InternalKnowledgeBase>();
        map.put("x", kBase);
        map = SerializationHelper.serializeObject(map);
        kBase = (InternalKnowledgeBase)map.get("x");
        kBase.addPackages(kpkgs);
        KieSession session = kBase.newKieSession();
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        session.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        session.insert((Object)bob);
        ((InternalWorkingMemory)session).flushPropagations();
        Rule[] rules = kBase.getPackage("org.drools.compiler.test").getRules().toArray(new Rule[0]);
        Assert.assertEquals((long)4L, (long)rules.length);
        Assert.assertEquals((Object)"match Person 1", (Object)rules[0].getName());
        Assert.assertEquals((Object)"match Person 2", (Object)rules[1].getName());
        Assert.assertEquals((Object)"match Person 3", (Object)rules[2].getName());
        Assert.assertEquals((Object)"match Integer", (Object)rules[3].getName());
        Assert.assertEquals((long)1L, (long)session.getObjects().size());
        Assert.assertEquals((Object)bob, IteratorToList.convert(session.getObjects().iterator()).get(0));
        Assert.assertEquals((long)2L, (long)((InternalAgenda)session.getAgenda()).agendaSize());
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        session.fireAllRules();
        List list = (List)session.getGlobal("list");
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)new Integer(4), list.get(0));
        Assert.assertEquals((long)2L, (long)session.getObjects().size());
        Assert.assertTrue((boolean)IteratorToList.convert(session.getObjects().iterator()).contains(bob));
        Assert.assertTrue((boolean)IteratorToList.convert(session.getObjects().iterator()).contains(new Person("help")));
    }

    @Test
    public void testSerializeWorkingMemoryAndRuleBase3() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Serializable.drl"});
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kBase.addPackages(kpkgs);
        KieSession session = kBase.newKieSession();
        session.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        session.insert((Object)bob);
        Map map = new HashMap<String, InternalKnowledgeBase>();
        map.put("x", kBase);
        map = SerializationHelper.serializeObject(map);
        kBase = (InternalKnowledgeBase)map.get("x");
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        Rule[] rules = kBase.getPackage("org.drools.compiler.test").getRules().toArray(new Rule[0]);
        Assert.assertEquals((long)4L, (long)rules.length);
        Assert.assertEquals((Object)"match Person 1", (Object)rules[0].getName());
        Assert.assertEquals((Object)"match Person 2", (Object)rules[1].getName());
        Assert.assertEquals((Object)"match Person 3", (Object)rules[2].getName());
        Assert.assertEquals((Object)"match Integer", (Object)rules[3].getName());
        Assert.assertEquals((long)1L, (long)session.getObjects().size());
        Assert.assertEquals((Object)bob, IteratorToList.convert(session.getObjects().iterator()).get(0));
        Assert.assertEquals((long)2L, (long)((InternalAgenda)session.getAgenda()).agendaSize());
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        session.fireAllRules();
        List list = (List)session.getGlobal("list");
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)new Integer(4), list.get(0));
        Assert.assertEquals((long)2L, (long)session.getObjects().size());
        Assert.assertTrue((boolean)IteratorToList.convert(session.getObjects().iterator()).contains(bob));
        Assert.assertTrue((boolean)IteratorToList.convert(session.getObjects().iterator()).contains(new Person("help")));
    }

    @Test
    public void testSerializeAdd() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic1.drl"});
        kpkgs = SerializationHelper.serializeObject(kpkgs);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kBase.addPackages(kpkgs);
        kBase = SerializationHelper.serializeObject(kBase);
        KieSession session = kBase.newKieSession();
        List list = new ArrayList();
        session.setGlobal("list", list);
        InternalFactHandle stilton = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        session.fireAllRules();
        Assert.assertEquals((long)list.size(), (long)1L);
        Assert.assertEquals((Object)"stilton", list.get(0));
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        list = (List)session.getGlobal("list");
        Assert.assertNotNull(list);
        Assert.assertEquals((long)list.size(), (long)1L);
        Assert.assertEquals((Object)"stilton", list.get(0));
        kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic3.drl"});
        kpkgs = SerializationHelper.serializeObject(kpkgs);
        kBase.addPackages(kpkgs);
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie2 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        InternalFactHandle bob = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        Assert.assertEquals((long)list.size(), (long)3L);
        Assert.assertEquals((Object)bob.getObject(), list.get(2));
        Assert.assertEquals((Object)"stilton", list.get(1));
        session.dispose();
    }

    @Test
    public void testSerializationOfIndexedWM() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Serializable2.drl"});
        kpkgs = SerializationHelper.serializeObject(kpkgs);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kBase.addPackages(kpkgs);
        kBase = SerializationHelper.serializeObject(kBase);
        Map map = new HashMap<String, InternalKnowledgeBase>();
        map.put("x", kBase);
        map = SerializationHelper.serializeObject(map);
        kBase = (InternalKnowledgeBase)map.get("x");
        Rule[] rules = kBase.getPackage("org.drools.compiler").getRules().toArray(new Rule[0]);
        Assert.assertEquals((long)3L, (long)rules.length);
        KieSession session = kBase.newKieSession();
        session.setGlobal("list", new ArrayList());
        Primitives p = new Primitives();
        p.setBytePrimitive((byte)1);
        p.setShortPrimitive((short)2);
        p.setIntPrimitive(3);
        session.insert((Object)p);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        Assert.assertEquals((long)1L, (long)session.getObjects().size());
        Assert.assertEquals((Object)p, IteratorToList.convert(session.getObjects().iterator()).get(0));
        Assert.assertEquals((long)3L, (long)((InternalAgenda)session.getAgenda()).agendaSize());
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        session.fireAllRules();
        List list = (List)session.getGlobal("list");
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"1", list.get(0));
        Assert.assertEquals((Object)"2", list.get(1));
        Assert.assertEquals((Object)"3", list.get(2));
    }

    @Test
    public void testSerializeAdd2() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic1_0.drl"});
        kpkgs = SerializationHelper.serializeObject(kpkgs);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kBase.addPackages(kpkgs);
        kBase = SerializationHelper.serializeObject(kBase);
        List results = new ArrayList();
        KieSession session = kBase.newKieSession();
        session.setGlobal("results", results);
        InternalFactHandle stilton1 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        session.insert((Object)new Cheese("brie", 10));
        InternalFactHandle bob = (InternalFactHandle)session.insert((Object)new Person("bob", 10));
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)stilton1.getObject(), results.get(0));
        kBase = SerializationHelper.serializeObject(kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic3_0.drl"});
        kBase.addPackages(SerializationHelper.serializeObject(kpkgs));
        kBase = SerializationHelper.serializeObject(kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle mark = (InternalFactHandle)session.insert((Object)new Person("mark", 20));
        session.fireAllRules();
        results = (List)session.getGlobal("results");
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertEquals((Object)stilton2.getObject(), results.get(1));
        Assert.assertEquals((Object)bob.getObject(), results.get(2));
        Assert.assertEquals((Object)mark.getObject(), results.get(3));
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        kBase = SerializationHelper.serializeObject(kBase);
        session.dispose();
    }

    @Test
    public void testSerializeAdd_newRuleNotFiredForNewData() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic1_0.drl"});
        kpkgs = SerializationHelper.serializeObject(kpkgs);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kBase.addPackages(kpkgs);
        kBase = SerializationHelper.serializeObject(kBase);
        ArrayList results = new ArrayList();
        KieSession session = kBase.newKieSession();
        session.setGlobal("results", results);
        InternalFactHandle stilton1 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie1 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        session.fireAllRules();
        kBase = SerializationHelper.serializeObject(kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic1_1.drl"});
        kBase.addPackages(SerializationHelper.serializeObject(kpkgs));
        kBase = SerializationHelper.serializeObject(kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie2 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle brie3 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 30));
        session.fireAllRules();
        Assert.assertEquals((long)5L, (long)results.size());
        Assert.assertEquals((Object)stilton2.getObject(), results.get(1));
        Assert.assertTrue((boolean)results.contains(brie1.getObject()));
        Assert.assertTrue((boolean)results.contains(brie3.getObject()));
        Assert.assertTrue((boolean)results.contains(brie3.getObject()));
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        kBase = SerializationHelper.serializeObject(kBase);
        session.dispose();
    }

    @Test
    public void testSerializeAdd3() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic1_0.drl"});
        kpkgs = SerializationHelper.serializeObject(kpkgs);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kBase.addPackages(kpkgs);
        kBase = SerializationHelper.serializeObject(kBase);
        ArrayList results = new ArrayList();
        KieSession session = kBase.newKieSession();
        session.setGlobal("results", results);
        InternalFactHandle stilton1 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie1 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)stilton1.getObject(), results.get(0));
        kBase = SerializationHelper.serializeObject(kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic3_0.drl"});
        kBase.addPackages(SerializationHelper.serializeObject(kpkgs));
        kBase = SerializationHelper.serializeObject(kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie2 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle bob1 = (InternalFactHandle)session.insert((Object)new Person("bob", 20));
        InternalFactHandle bob2 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertEquals((Object)stilton2.getObject(), results.get(1));
        Assert.assertTrue((boolean)results.contains(bob2.getObject()));
        Assert.assertTrue((boolean)results.contains(bob1.getObject()));
        kBase = SerializationHelper.serializeObject(kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic1_2.drl"});
        kBase.addPackages(SerializationHelper.serializeObject(kpkgs));
        kBase = SerializationHelper.serializeObject(kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        InternalFactHandle stilton3 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 40));
        InternalFactHandle brie3 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 40));
        InternalFactHandle bob3 = (InternalFactHandle)session.insert((Object)new Person("bob", 40));
        InternalFactHandle bob4 = (InternalFactHandle)session.insert((Object)new Person("bob", 40));
        InternalFactHandle addr1 = (InternalFactHandle)session.insert((Object)new Address("bangalore"));
        InternalFactHandle addr2 = (InternalFactHandle)session.insert((Object)new Address("India"));
        session.fireAllRules();
        Assert.assertEquals((long)9L, (long)results.size());
        Assert.assertEquals((Object)stilton3.getObject(), results.get(4));
        Assert.assertEquals((Object)bob4.getObject(), results.get(5));
        Assert.assertEquals((Object)bob3.getObject(), results.get(6));
        Assert.assertTrue((boolean)results.contains(addr2.getObject()));
        Assert.assertTrue((boolean)results.contains(addr1.getObject()));
        kBase = SerializationHelper.serializeObject(kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        InternalFactHandle stilton4 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 50));
        InternalFactHandle brie4 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 50));
        InternalFactHandle bob5 = (InternalFactHandle)session.insert((Object)new Person("bob", 50));
        InternalFactHandle bob6 = (InternalFactHandle)session.insert((Object)new Person("bob", 50));
        InternalFactHandle addr3 = (InternalFactHandle)session.insert((Object)new Address("Tripura"));
        InternalFactHandle addr4 = (InternalFactHandle)session.insert((Object)new Address("Agartala"));
        session.fireAllRules();
        Assert.assertEquals((long)14L, (long)results.size());
        Assert.assertEquals((Object)stilton4.getObject(), results.get(9));
        Assert.assertEquals((Object)bob6.getObject(), results.get(10));
        Assert.assertEquals((Object)bob5.getObject(), results.get(11));
        Assert.assertTrue((boolean)results.contains(addr4.getObject()));
        Assert.assertTrue((boolean)results.contains(addr3.getObject()));
        kBase = SerializationHelper.serializeObject(kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        session.dispose();
    }

    @Test
    public void testSerializeAddRemove_NoClassDefFoundError() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic1_0.drl"});
        kpkgs = SerializationHelper.serializeObject(kpkgs);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kBase.addPackages(kpkgs);
        kBase = SerializationHelper.serializeObject(kBase);
        ArrayList results = new ArrayList();
        KieSession session = kBase.newKieSession();
        session.setGlobal("results", results);
        InternalFactHandle stilton1 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie1 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)stilton1.getObject(), results.get(0));
        kBase = SerializationHelper.serializeObject(kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic3_0.drl"});
        kBase.addPackages(SerializationHelper.serializeObject(kpkgs));
        kBase = SerializationHelper.serializeObject(kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        results.clear();
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie2 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle bob1 = (InternalFactHandle)session.insert((Object)new Person("bob", 20));
        InternalFactHandle bob2 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertEquals((Object)stilton2.getObject(), results.get(0));
        Assert.assertTrue((boolean)results.contains(bob1.getObject()));
        Assert.assertTrue((boolean)results.contains(bob2.getObject()));
        kBase = SerializationHelper.serializeObject(kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        results.clear();
        kBase.removeRule("org.drools.compiler.test", "like stilton");
        InternalFactHandle stilton3 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie3 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle bob3 = (InternalFactHandle)session.insert((Object)new Person("bob", 20));
        InternalFactHandle bob4 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(bob3.getObject()));
        Assert.assertTrue((boolean)results.contains(bob4.getObject()));
        kBase = SerializationHelper.serializeObject(kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        results.clear();
        kBase.removeKiePackage("org.drools.compiler.test");
        InternalFactHandle stilton4 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie4 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle bob5 = (InternalFactHandle)session.insert((Object)new Person("bob", 20));
        InternalFactHandle bob6 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(bob5.getObject()));
        Assert.assertTrue((boolean)results.contains(bob6.getObject()));
        kBase = SerializationHelper.serializeObject(kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        results.clear();
        session.setGlobal("results", results);
        InternalFactHandle stilton5 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 30));
        InternalFactHandle brie5 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 30));
        InternalFactHandle bob7 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        InternalFactHandle bob8 = (InternalFactHandle)session.insert((Object)new Person("bob", 40));
        session.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(bob7.getObject()));
        Assert.assertTrue((boolean)results.contains(bob8.getObject()));
        kBase = SerializationHelper.serializeObject(kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        session.dispose();
    }

    @Test
    public void testSignedSerialization1() throws Exception {
        try {
            this.setPrivateKeyProperties();
            this.setPublicKeyProperties();
            Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic1_0.drl"});
            kpkgs = SerializationHelper.serializeObject(kpkgs);
            InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
            kBase.addPackages(kpkgs);
            InternalKnowledgeBase internalKnowledgeBase = SerializationHelper.serializeObject(kBase);
        }
        finally {
            this.unsetPrivateKeyProperties();
            this.unsetPublicKeyProperties();
        }
    }

    @Test
    public void testSignedSerialization2() throws Exception {
        try {
            this.setPrivateKeyProperties();
            try {
                Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic1_0.drl"});
                Assert.fail((String)"Deserialisation should have failed.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.unsetPrivateKeyProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignedSerialization3() throws Exception {
        try {
            this.setPrivateKeyProperties();
            Collection kpkgs = this.loadKnowledgePackages(null, false, new String[]{"test_Dynamic1_0.drl"});
            InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
            kBase.addPackages(kpkgs);
            try {
                kBase = SerializationHelper.serializeObject(kBase);
                Assert.fail((String)"Deserialisation should have failed.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.unsetPrivateKeyProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignedSerialization4() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(null, false, new String[]{"test_Dynamic1_0.drl"});
        kpkgs = SerializationHelper.serializeObject(kpkgs);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kBase.addPackages(kpkgs);
        kBase = SerializationHelper.serializeObject(kBase);
        try {
            this.setPublicKeyProperties();
            kBase = SerializationHelper.serializeObject(kBase);
            Assert.fail((String)"Should not deserialize an unsigned rulebase on an environment configured to work with signed rulebases.");
        }
        catch (Exception exception) {
        }
        finally {
            this.unsetPublicKeyProperties();
        }
    }

    private void setPublicKeyProperties() {
        URL clientKeyStoreURL = ((Object)((Object)this)).getClass().getResource("droolsClient.keystore");
        System.setProperty("drools.serialization.sign", "true");
        System.setProperty("drools.serialization.public.keyStoreURL", clientKeyStoreURL.toExternalForm());
        System.setProperty("drools.serialization.public.keyStorePwd", "clientpwd");
        KeyStoreHelper.reInit();
    }

    private void unsetPublicKeyProperties() {
        System.setProperty("drools.serialization.sign", "");
        System.setProperty("drools.serialization.public.keyStoreURL", "");
        System.setProperty("drools.serialization.public.keyStorePwd", "");
        KeyStoreHelper.reInit();
    }

    private void setPrivateKeyProperties() {
        URL serverKeyStoreURL = ((Object)((Object)this)).getClass().getResource("droolsServer.keystore");
        System.setProperty("drools.serialization.sign", "true");
        System.setProperty("drools.serialization.private.keyStoreURL", serverKeyStoreURL.toExternalForm());
        System.setProperty("drools.serialization.private.keyStorePwd", "serverpwd");
        System.setProperty("drools.serialization.private.keyAlias", "droolsKey");
        System.setProperty("drools.serialization.private.keyPwd", "keypwd");
        KeyStoreHelper.reInit();
    }

    private void unsetPrivateKeyProperties() {
        System.setProperty("drools.serialization.sign", "");
        System.setProperty("drools.serialization.private.keyStoreURL", "");
        System.setProperty("drools.serialization.private.keyStorePwd", "");
        System.setProperty("drools.serialization.private.keyAlias", "");
        System.setProperty("drools.serialization.private.keyPwd", "");
        KeyStoreHelper.reInit();
    }

    @Test
    public void testSerializabilityWithJarFacts() throws Exception {
        MapBackedClassLoader loader = new MapBackedClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        JarInputStream jis = new JarInputStream(((Object)((Object)this)).getClass().getResourceAsStream("/billasurf.jar"));
        JarEntry entry = null;
        byte[] buf = new byte[1024];
        int len = 0;
        while ((entry = jis.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((len = jis.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
            loader.addResource(entry.getName(), out.toByteArray());
        }
        String drl = "package foo.bar \nimport com.billasurf.Board\nrule 'MyGoodRule' \n dialect 'mvel' \n when    Board() then \n System.err.println(42); \nend\n";
        KnowledgeBuilderConfiguration kbuilderConf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration(null, (ClassLoader[])new ClassLoader[]{loader});
        Collection kpkgs = this.loadKnowledgePackagesFromString(kbuilderConf, new String[]{drl});
        kpkgs = SerializationHelper.serializeObject(kpkgs, (ClassLoader)loader);
    }

    @Test
    public void testEmptyRule() throws Exception {
        String rule = "package org.drools.compiler.test;\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "rule \"Rule 1\"\n";
        rule = rule + "when\n";
        rule = rule + "then\n";
        rule = rule + "    list.add( \"fired\" );\n";
        rule = rule + "end";
        KieBase kBase = this.loadKnowledgeBaseFromString(new String[]{rule});
        Map nodes = RuleBaseNodes.getNodeMap((InternalKnowledgeBase)((InternalKnowledgeBase)kBase));
        Assert.assertEquals((long)2L, (long)nodes.size());
        Assert.assertEquals((Object)"InitialFactImpl", (Object)((ClassObjectType)((ObjectTypeNode)nodes.get(2)).getObjectType()).getClassType().getSimpleName());
        Assert.assertEquals((Object)"Rule 1", (Object)((RuleTerminalNode)nodes.get(4)).getRule().getName());
        KieSession session = kBase.newKieSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, kBase, true);
        session.fireAllRules();
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, kBase, true);
        Assert.assertEquals((long)1L, (long)((List)session.getGlobal("list")).size());
        Assert.assertEquals((Object)"fired", ((List)session.getGlobal("list")).get(0));
    }

    @Test
    public void testDynamicEmptyRule() throws Exception {
        String rule1 = "package org.drools.compiler.test;\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule \"Rule 1\"\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( \"fired1\" );\n";
        rule1 = rule1 + "end";
        String rule2 = "package org.drools.compiler.test;\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule \"Rule 2\"\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "    list.add( \"fired2\" );\n";
        rule2 = rule2 + "end";
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.loadKnowledgeBaseFromString(new String[]{rule1});
        Map nodes = RuleBaseNodes.getNodeMap((InternalKnowledgeBase)kBase);
        Assert.assertEquals((long)2L, (long)nodes.size());
        Assert.assertEquals((Object)"InitialFactImpl", (Object)((ClassObjectType)((ObjectTypeNode)nodes.get(2)).getObjectType()).getClassType().getSimpleName());
        Assert.assertEquals((Object)"Rule 1", (Object)((RuleTerminalNode)nodes.get(4)).getRule().getName());
        KieSession session = kBase.newKieSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        StatefulKnowledgeSession session1 = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, false);
        session1.fireAllRules();
        Assert.assertEquals((long)1L, (long)((List)session1.getGlobal("list")).size());
        StatefulKnowledgeSession session2 = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session1, (KieBase)kBase, false);
        session.dispose();
        session1.dispose();
        Collection kpkgs = this.loadKnowledgePackagesFromString(new String[]{rule2});
        kBase.addPackages(kpkgs);
        session2.fireAllRules();
        System.out.println(session2.getGlobal("list"));
        Assert.assertEquals((long)2L, (long)((List)session2.getGlobal("list")).size());
        Assert.assertEquals((Object)"fired1", ((List)session2.getGlobal("list")).get(0));
        Assert.assertEquals((Object)"fired2", ((List)session2.getGlobal("list")).get(1));
    }

    @Test
    public void testSinglePattern() throws Exception {
        String rule = "package org.drools.compiler.test;\n";
        rule = rule + "import " + Person.class.getCanonicalName() + "\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "rule \"Rule 1\"\n";
        rule = rule + "when\n";
        rule = rule + "    $p : Person( ) \n";
        rule = rule + "then\n";
        rule = rule + "    list.add( $p );\n";
        rule = rule + "end";
        KieBase kBase = this.loadKnowledgeBaseFromString(new String[]{rule});
        Map nodes = RuleBaseNodes.getNodeMap((InternalKnowledgeBase)((InternalKnowledgeBase)kBase));
        Assert.assertEquals((long)3L, (long)nodes.size());
        Assert.assertEquals((Object)"Person", (Object)((ClassObjectType)((ObjectTypeNode)nodes.get(3)).getObjectType()).getClassType().getSimpleName());
        Assert.assertEquals((Object)"Rule 1", (Object)((RuleTerminalNode)nodes.get(5)).getRule().getName());
        KieSession session = kBase.newKieSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Person p = new Person("bobba fet", 32);
        session.insert((Object)p);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, kBase, true);
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)((List)session.getGlobal("list")).size());
        Assert.assertEquals((Object)p, ((List)session.getGlobal("list")).get(0));
    }

    @Test
    public void testSingleRuleSingleJoinNodePattern() throws Exception {
        String rule = "package org.drools.compiler.test;\n";
        rule = rule + "import " + Person.class.getCanonicalName() + "\n";
        rule = rule + "import " + Cheese.class.getCanonicalName() + "\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "rule \"Rule 1\"\n";
        rule = rule + "when\n";
        rule = rule + "    $c : Cheese( ) \n";
        rule = rule + "    $p : Person( cheese == $c ) \n";
        rule = rule + "then\n";
        rule = rule + "    list.add( $p );\n";
        rule = rule + "end";
        KieBase kBase = this.loadKnowledgeBaseFromString(new String[]{rule});
        Map nodes = RuleBaseNodes.getNodeMap((InternalKnowledgeBase)((InternalKnowledgeBase)kBase));
        Assert.assertEquals((long)5L, (long)nodes.size());
        Assert.assertEquals((Object)"Cheese", (Object)((ClassObjectType)((ObjectTypeNode)nodes.get(3)).getObjectType()).getClassType().getSimpleName());
        Assert.assertEquals((Object)"Person", (Object)((ClassObjectType)((ObjectTypeNode)nodes.get(5)).getObjectType()).getClassType().getSimpleName());
        Assert.assertTrue((String)"Should end with JoinNode", (boolean)((BaseNode)nodes.get(6)).getClass().getSimpleName().endsWith("JoinNode"));
        Assert.assertEquals((Object)"Rule 1", (Object)((RuleTerminalNode)nodes.get(7)).getRule().getName());
        KieSession session = kBase.newKieSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 25);
        Cheese brie = new Cheese("brie", 49);
        Person bobba = new Person("bobba fet", 32);
        bobba.setCheese(stilton);
        Person vadar = new Person("darth vadar", 32);
        session.insert((Object)stilton);
        session.insert((Object)bobba);
        session.insert((Object)vadar);
        session.insert((Object)brie);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, kBase, true);
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)((List)session.getGlobal("list")).size());
        Assert.assertEquals((Object)bobba, ((List)session.getGlobal("list")).get(0));
        Person c3po = new Person("c3p0", 32);
        c3po.setCheese(stilton);
        session.insert((Object)c3po);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, kBase, true);
        session.fireAllRules();
        Assert.assertEquals((long)2L, (long)((List)session.getGlobal("list")).size());
        Assert.assertEquals((Object)c3po, ((List)session.getGlobal("list")).get(1));
        Person r2d2 = new Person("r2d2", 32);
        r2d2.setCheese(brie);
        session.insert((Object)r2d2);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, kBase, true);
        session.fireAllRules();
        Assert.assertEquals((long)3L, (long)((List)session.getGlobal("list")).size());
        Assert.assertEquals((Object)r2d2, ((List)session.getGlobal("list")).get(2));
    }

    @Test
    public void testMultiRuleMultiJoinNodePatternsWithHalt() throws Exception {
        String rule1 = "package org.drools.compiler.test;\nimport " + Person.class.getCanonicalName() + "\nimport " + Cheese.class.getCanonicalName() + "\nglobal java.util.List list\nrule \"Rule 1\"\nwhen\n    $c : Cheese( ) \n    $p : Person( cheese == $c ) \nthen\n    list.add( $p );\nend";
        String rule2 = "package org.drools.compiler.test;\nimport " + Person.class.getCanonicalName() + "\nimport " + Cheese.class.getCanonicalName() + "\nimport " + Cell.class.getCanonicalName() + "\nglobal java.util.List list\nrule \"Rule 2\"\nwhen\n    $c : Cheese( ) \n    $p : Person( cheese == $c ) \n    $x : Cell( value == $p.age ) \nthen\n    list.add( $x );\nend";
        String rule3 = "package org.drools.compiler.test;\nimport " + Person.class.getCanonicalName() + "\nimport " + FactA.class.getCanonicalName() + "\nimport " + FactB.class.getCanonicalName() + "\nimport " + FactC.class.getCanonicalName() + "\nglobal java.util.List list\nrule \"Rule 3\"\nwhen\n    $a : FactA( field2 > 10 ) \n    $b : FactB( f2 >= $a.field2 ) \n    $p : Person( name == \"darth vadar\" ) \n    $c : FactC( f2 >= $b.f2 ) \nthen\n    list.add( $c );\n    drools.halt();\nend";
        KieBase kBase = this.loadKnowledgeBaseFromString(new String[]{rule1, rule2, rule3});
        KieSession session = kBase.newKieSession();
        List list = new ArrayList();
        session.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 25);
        Cheese brie = new Cheese("brie", 49);
        Person bobba = new Person("bobba fet", 30);
        bobba.setCheese(stilton);
        Person vadar = new Person("darth vadar", 38);
        Person c3po = new Person("c3p0", 17);
        c3po.setCheese(stilton);
        Person r2d2 = new Person("r2d2", 58);
        r2d2.setCheese(brie);
        session.insert((Object)stilton);
        session.insert((Object)bobba);
        session.insert((Object)vadar);
        session.insert((Object)brie);
        session.insert((Object)c3po);
        session.insert((Object)r2d2);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, kBase, true);
        session.fireAllRules();
        list = (List)session.getGlobal("list");
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(r2d2));
        Assert.assertTrue((boolean)list.contains(c3po));
        Assert.assertTrue((boolean)list.contains(bobba));
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, kBase, true);
        Cell cell30 = new Cell(30);
        session.insert((Object)cell30);
        Cell cell58 = new Cell(58);
        session.insert((Object)cell58);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, kBase, true);
        session.fireAllRules();
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(cell30));
        Assert.assertTrue((boolean)list.contains(cell58));
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, kBase, true);
        session.insert((Object)new FactA(Integer.valueOf(15)));
        session.insert((Object)new FactB(Integer.valueOf(20)));
        FactC factC27 = new FactC(Integer.valueOf(27));
        session.insert((Object)factC27);
        FactC factC52 = new FactC(Integer.valueOf(52));
        session.insert((Object)factC52);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, kBase, true);
        session.fireAllRules();
        session.fireAllRules();
        Assert.assertEquals((long)7L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(factC52));
        Assert.assertTrue((boolean)list.contains(factC27));
    }

    @Test
    public void testNot() throws Exception {
        String header = "package org.drools.compiler.test;\nimport java.util.List;\nimport " + Person.class.getCanonicalName() + "\nimport " + Cheese.class.getCanonicalName() + "\nglobal java.util.List list;\n";
        String rule1 = "rule \"not rule test\"\nsalience 10\nwhen\n    Person()\n    not Cheese( price >= 5 )\nthen\n    list.add( new Integer( 5 ) );\nend\n";
        KieBase kBase = this.loadKnowledgeBaseFromString(new String[]{header + rule1});
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new IdentityPlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        KieSession ksession = kBase.newKieSession(null, env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Person bobba = new Person("bobba fet", 50);
        ksession.insert((Object)bobba);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Person darth = new Person("darth vadar", 200);
        ksession.insert((Object)darth);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Cheese stilton = new Cheese("stilton", 5);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.retract(ksession.getFactHandle((Object)stilton));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Cheese brie = new Cheese("brie", 18);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        ksession.retract(ksession.getFactHandle((Object)stilton));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        ksession.retract(ksession.getFactHandle((Object)bobba));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        ksession.retract(ksession.getFactHandle((Object)brie));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)5L, (long)list.size());
    }

    @Test
    public void testExists() throws Exception {
        String header = "package org.drools.compiler.test;\nimport java.util.List;\nimport " + Person.class.getCanonicalName() + "\nimport " + Cheese.class.getCanonicalName() + "\nglobal java.util.List list;\n";
        String rule1 = "rule \"not rule test\"\nsalience 10\nwhen\n    Person()\n    exists Cheese( price >= 5 )\nthen\n    list.add( new Integer( 5 ) );\nend\n";
        KieBase kBase = this.loadKnowledgeBaseFromString(new String[]{header + rule1});
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new IdentityPlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        KieSession ksession = kBase.newKieSession(null, env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Person bobba = new Person("bobba fet", 50);
        ksession.insert((Object)bobba);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Person darth = new Person("darth vadar", 200);
        ksession.insert((Object)darth);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Cheese stilton = new Cheese("stilton", 5);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.retract(ksession.getFactHandle((Object)stilton));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Cheese brie = new Cheese("brie", 18);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        ksession.retract(ksession.getFactHandle((Object)stilton));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        ksession.retract(ksession.getFactHandle((Object)bobba));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        ksession.retract(ksession.getFactHandle((Object)brie));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.insert((Object)stilton);
        ksession.fireAllRules();
        Assert.assertEquals((long)5L, (long)list.size());
    }

    @Test
    public void testTruthMaintenance() throws Exception {
        String header = "package org.drools.compiler.test;\nimport java.util.List;\nimport " + Person.class.getCanonicalName() + "\nimport " + Cheese.class.getCanonicalName() + "\nglobal Cheese cheese;\nglobal Person person;\nglobal java.util.List list;\n";
        String rule1 = "rule \"not person then cheese\"\nwhen \n    not Person() \nthen \n    if (list.size() < 3) { \n        list.add(new Integer(0)); \n        insertLogical( cheese ); \n    }\n    drools.halt();\nend\n";
        String rule2 = "rule \"if cheese then person\"\nwhen\n    Cheese()\nthen\n    if (list.size() < 3) {\n        list.add(new Integer(0));\n        insertLogical( person );\n    }\n    drools.halt();\nend\n";
        KieBase kBase = this.loadKnowledgeBaseFromString(new String[]{header + rule1 + rule2});
        KieSession ksession = kBase.newKieSession();
        ArrayList list = new ArrayList();
        Person person = new Person("person");
        Cheese cheese = new Cheese("cheese", 0);
        ksession.setGlobal("cheese", (Object)cheese);
        ksession.setGlobal("person", (Object)person);
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testActivationGroups() throws Exception {
        String rule1 = "package org.drools.compiler.test;\n";
        rule1 = rule1 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule \"Rule 1\"\n";
        rule1 = rule1 + "    activation-group \"activation-group-1\"\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    $c : Cheese( ) \n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( \"rule1\" );\n";
        rule1 = rule1 + "    drools.halt();\n";
        rule1 = rule1 + "end";
        String rule2 = "package org.drools.compiler.test;\n";
        rule2 = rule2 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule \"Rule 2\"\n";
        rule2 = rule2 + "    salience 10\n";
        rule2 = rule2 + "    activation-group \"activation-group-1\"\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "    $c : Cheese( ) \n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "    list.add( \"rule2\" );\n";
        rule2 = rule2 + "    drools.halt();\n";
        rule2 = rule2 + "end";
        String rule3 = "package org.drools.compiler.test;\n";
        rule3 = rule3 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule3 = rule3 + "global java.util.List list\n";
        rule3 = rule3 + "rule \"Rule 3\"\n";
        rule3 = rule3 + "    activation-group \"activation-group-1\"\n";
        rule3 = rule3 + "when\n";
        rule3 = rule3 + "    $c : Cheese( ) \n";
        rule3 = rule3 + "then\n";
        rule3 = rule3 + "    list.add( \"rule3\" );\n";
        rule3 = rule3 + "    drools.halt();\n";
        rule3 = rule3 + "end";
        String rule4 = "package org.drools.compiler.test;\n";
        rule4 = rule4 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule4 = rule4 + "global java.util.List list\n";
        rule4 = rule4 + "rule \"Rule 4\"\n";
        rule4 = rule4 + "    activation-group \"activation-group-2\"\n";
        rule4 = rule4 + "when\n";
        rule4 = rule4 + "    $c : Cheese( ) \n";
        rule4 = rule4 + "then\n";
        rule4 = rule4 + "    list.add( \"rule4\" );\n";
        rule4 = rule4 + "    drools.halt();\n";
        rule4 = rule4 + "end";
        KieBase kBase = this.loadKnowledgeBaseFromString(new String[]{rule1, rule2, rule3, rule4});
        KieSession ksession = kBase.newKieSession();
        kBase = SerializationHelper.serializeObject(kBase);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        ksession.insert((Object)brie);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"rule2", list.get(0));
        Assert.assertEquals((Object)"rule4", list.get(1));
    }

    @Test
    public void testAgendaGroups() throws Exception {
        String rule1 = "package org.drools.compiler.test;\n";
        rule1 = rule1 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule \"Rule 1\"\n";
        rule1 = rule1 + "    agenda-group \"agenda-group-1\"\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    $c : Cheese( ) \n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( \"rule1\" );\n";
        rule1 = rule1 + "    drools.halt();\n";
        rule1 = rule1 + "end";
        String rule2 = "package org.drools.compiler.test;\n";
        rule2 = rule2 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule \"Rule 2\"\n";
        rule2 = rule2 + "    salience 10\n";
        rule2 = rule2 + "    agenda-group \"agenda-group-1\"\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "    $c : Cheese( ) \n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "    list.add( \"rule2\" );\n";
        rule2 = rule2 + "    drools.halt();\n";
        rule2 = rule2 + "end";
        String rule3 = "package org.drools.compiler.test;\n";
        rule3 = rule3 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule3 = rule3 + "global java.util.List list\n";
        rule3 = rule3 + "rule \"Rule 3\"\n";
        rule3 = rule3 + "    salience 10\n";
        rule3 = rule3 + "    agenda-group \"agenda-group-2\"\n";
        rule3 = rule3 + "    activation-group \"activation-group-2\"\n";
        rule3 = rule3 + "when\n";
        rule3 = rule3 + "    $c : Cheese( ) \n";
        rule3 = rule3 + "then\n";
        rule3 = rule3 + "    list.add( \"rule3\" );\n";
        rule3 = rule3 + "    drools.halt();\n";
        rule3 = rule3 + "end";
        String rule4 = "package org.drools.compiler.test;\n";
        rule4 = rule4 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule4 = rule4 + "global java.util.List list\n";
        rule4 = rule4 + "rule \"Rule 4\"\n";
        rule4 = rule4 + "    agenda-group \"agenda-group-2\"\n";
        rule4 = rule4 + "    activation-group \"activation-group-2\"\n";
        rule4 = rule4 + "when\n";
        rule4 = rule4 + "    $c : Cheese( ) \n";
        rule4 = rule4 + "then\n";
        rule4 = rule4 + "    list.add( \"rule4\" );\n";
        rule4 = rule4 + "    drools.halt();\n";
        rule4 = rule4 + "end";
        KieBase kBase = this.loadKnowledgeBaseFromString(new String[]{rule1, rule2, rule3, rule4});
        KieSession ksession = kBase.newKieSession();
        kBase = SerializationHelper.serializeObject(kBase);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        ksession.insert((Object)brie);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.getAgenda().getAgendaGroup("agenda-group-1").setFocus();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"rule2", list.get(0));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.getAgenda().getAgendaGroup("agenda-group-2").setFocus();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"rule3", list.get(1));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"rule1", list.get(2));
    }

    @Test
    public void testRuleFlowGroups() throws Exception {
        String rule1 = "package org.drools.compiler.test;\n";
        rule1 = rule1 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule \"Rule 1\"\n";
        rule1 = rule1 + "    ruleflow-group \"ruleflow-group-1\"\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    $c : Cheese( ) \n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( \"rule1\" );\n";
        rule1 = rule1 + "    drools.halt();\n";
        rule1 = rule1 + "end";
        String rule2 = "package org.drools.compiler.test;\n";
        rule2 = rule2 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule \"Rule 2\"\n";
        rule2 = rule2 + "    salience 10\n";
        rule2 = rule2 + "    ruleflow-group \"ruleflow-group-1\"\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "    $c : Cheese( ) \n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "    list.add( \"rule2\" );\n";
        rule2 = rule2 + "    drools.halt();\n";
        rule2 = rule2 + "end";
        String rule3 = "package org.drools.compiler.test;\n";
        rule3 = rule3 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule3 = rule3 + "global java.util.List list\n";
        rule3 = rule3 + "rule \"Rule 3\"\n";
        rule3 = rule3 + "    salience 10\n";
        rule3 = rule3 + "    ruleflow-group \"ruleflow-group-2\"\n";
        rule3 = rule3 + "    activation-group \"activation-group-2\"\n";
        rule3 = rule3 + "when\n";
        rule3 = rule3 + "    $c : Cheese( ) \n";
        rule3 = rule3 + "then\n";
        rule3 = rule3 + "    list.add( \"rule3\" );\n";
        rule3 = rule3 + "    drools.halt();\n";
        rule3 = rule3 + "end";
        String rule4 = "package org.drools.compiler.test;\n";
        rule4 = rule4 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule4 = rule4 + "global java.util.List list\n";
        rule4 = rule4 + "rule \"Rule 4\"\n";
        rule4 = rule4 + "    ruleflow-group \"ruleflow-group-2\"\n";
        rule4 = rule4 + "    activation-group \"activation-group-2\"\n";
        rule4 = rule4 + "when\n";
        rule4 = rule4 + "    $c : Cheese( ) \n";
        rule4 = rule4 + "then\n";
        rule4 = rule4 + "    list.add( \"rule4\" );\n";
        rule4 = rule4 + "    drools.halt();\n";
        rule4 = rule4 + "end";
        KieBase kbase = this.loadKnowledgeBaseFromString(new String[]{rule1, rule2, rule3, rule4});
        StatefulKnowledgeSession ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(kbase.newKieSession(), true);
        kbase = SerializationHelper.serializeObject(kbase);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, true);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        ksession.insert((Object)brie);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, true);
        ((InternalAgenda)ksession.getAgenda()).activateRuleFlowGroup("ruleflow-group-1");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"rule2", list.get(0));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, true);
        ((InternalAgenda)ksession.getAgenda()).activateRuleFlowGroup("ruleflow-group-2");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"rule3", list.get(1));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"rule1", list.get(2));
    }

    @Test
    public void testAccumulate() throws Exception {
        String rule = "package org.drools\nimport " + Message.class.getCanonicalName() + "\nglobal java.util.List results\nrule MyRule\n  when\n    $n : Number( intValue >= 2 ) from accumulate ( m: Message( ), count( m ) )\n  then\n    results.add($n);\nend";
        KieBase kBase = this.loadKnowledgeBaseFromString(new String[]{rule});
        StatefulKnowledgeSession ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(kBase.newKieSession(), true);
        kBase = SerializationHelper.serializeObject(kBase);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, true);
        ksession.setGlobal("results", new ArrayList());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, true);
        ksession.insert((Object)new Message());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, true);
        List results = (List)ksession.getGlobal("results");
        ksession.insert((Object)new Message());
        ksession.insert((Object)new Message());
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)((Number)results.get(0)).intValue());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, true);
        ksession.insert((Object)new Message());
        ksession.insert((Object)new Message());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, true);
        Assert.assertEquals((long)1L, (long)((InternalAgenda)ksession.getAgenda()).agendaSize());
        ksession.fireAllRules();
        Assert.assertEquals((long)5L, (long)((Number)results.get(1)).intValue());
    }

    @Test
    public void testAccumulate2() throws Exception {
        String str = "package org.drools\n\nimport " + Message.class.getCanonicalName() + "\nrule MyRule\n  when\n    Number( intValue >= 5 ) from accumulate ( m: Message( ), count( m ) )\n  then\n    System.out.println(\"Found messages\");\nend\n";
        KieBase kBase = this.loadKnowledgeBaseFromString(new String[]{str});
        KieSession ksession = kBase.newKieSession();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.insert((Object)new Message());
        ksession.insert((Object)new Message());
        ksession.insert((Object)new Message());
        ksession.insert((Object)new Message());
        ksession.insert((Object)new Message());
        ((InternalWorkingMemory)ksession).flushPropagations();
        Assert.assertEquals((long)1L, (long)((InternalAgenda)ksession.getAgenda()).agendaSize());
    }

    @Test
    public void testAccumulateSessionSerialization() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"test_AccumulateSerialization.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Cheese("stilton", 10));
        ksession.insert((Object)new Cheese("brie", 5));
        ksession.insert((Object)new Cheese("provolone", 150));
        ksession.insert((Object)new Cheese("brie", 20));
        ksession.insert((Object)new Person("Bob", "brie"));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)25L, (long)((Number)results.get(0)).intValue());
    }

    @Test
    @Ignore
    public void testDroolsObjectOutputInputStream() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"org/drools/compiler/integrationtests/test_Serializable.drl"});
        KieSession session = kbase.newKieSession();
        Person bob = new Person();
        session.insert((Object)bob);
        Assert.assertSame((String)"these two object references should be same", (Object)bob, session.getObjects().iterator().next());
        Marshaller marshaller = this.createSerializableMarshaller(kbase);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DroolsObjectOutputStream out = new DroolsObjectOutputStream((OutputStream)baos);
        out.writeObject(bob);
        out.writeObject(kbase);
        marshaller.marshall((OutputStream)out, session);
        out.flush();
        out.close();
        DroolsObjectInputStream in = new DroolsObjectInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        Person deserializedBob = (Person)in.readObject();
        kbase = (InternalKnowledgeBase)in.readObject();
        marshaller = this.createSerializableMarshaller(kbase);
        session = (StatefulKnowledgeSession)marshaller.unmarshall((InputStream)in);
        Assert.assertSame((String)"these two object references should be same", (Object)deserializedBob, session.getObjects().iterator().next());
        in.close();
    }

    @Test
    public void testAccumulateSerialization() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"org/drools/serialization/protobuf/test_SerializableAccumulate.drl"});
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("results", new ArrayList());
        Cheese t1 = new Cheese("brie", 10);
        Cheese t2 = new Cheese("brie", 15);
        Cheese t3 = new Cheese("stilton", 20);
        Cheese t4 = new Cheese("brie", 30);
        ksession.insert((Object)t1);
        ksession.insert((Object)t2);
        ksession.insert((Object)t3);
        ksession.insert((Object)t4);
        Marshaller marshaller = this.createSerializableMarshaller(kbase);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DroolsObjectOutputStream out = new DroolsObjectOutputStream((OutputStream)baos);
        out.writeObject(kbase);
        marshaller.marshall((OutputStream)out, ksession);
        out.flush();
        out.close();
        DroolsObjectInputStream in = new DroolsObjectInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        kbase = (InternalKnowledgeBase)in.readObject();
        marshaller = this.createSerializableMarshaller(kbase);
        ksession = (StatefulKnowledgeSession)marshaller.unmarshall((InputStream)in);
        in.close();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Assert.assertNotNull(results);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((List)results.get(0)).size());
    }

    @Test
    public void testMarshallWithNot() throws Exception {
        String str = "import " + ((Object)((Object)this)).getClass().getCanonicalName() + ".*\nrule one\nwhen\n   A()\n   not(B())\nthen\nSystem.out.println(\"a\");\nend\n\nrule two\nwhen\n   A()\nthen\nSystem.out.println(\"b\");\nend\n";
        KieBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KieBase kBase = this.loadKnowledgeBaseFromString(config, new String[]{str});
        KieSession ksession = kBase.newKieSession();
        ksession.insert((Object)new A());
        MarshallerFactory.newMarshaller((KieBase)kBase).marshall((OutputStream)new ByteArrayOutputStream(), ksession);
    }

    @Test
    public void testMarshallEvents() throws Exception {
        String str = "import " + ((Object)((Object)this)).getClass().getCanonicalName() + ".*\ndeclare A\n @role( event )\n @expires( 10m )\nend\ndeclare B\n @role( event )\n @expires( 10m )\nend\nrule one\nwhen\n   $a : A()\n   B(this after $a)\nthen\ninsert(new C());end\n";
        KieBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KieBase kBase = this.loadKnowledgeBaseFromString(config, new String[]{str});
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((KieSessionOption)ClockTypeOption.PSEUDO);
        ksconf.setOption((KieSessionOption)TimerJobFactoryOption.get((String)"trackable"));
        KieSession ksession = kBase.newKieSession(ksconf, null);
        ksession.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        ksession.insert((Object)new B());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)ksession.getObjects().size());
    }

    @Test
    @Ignore(value="This test is suspicious to say the least...")
    public void testScheduledActivation() {
        KnowledgeBaseImpl knowledgeBase = (KnowledgeBaseImpl)KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgePackageImpl impl = new KnowledgePackageImpl("test");
        BuildContext buildContext = new BuildContext((InternalKnowledgeBase)knowledgeBase);
        RuleImpl rule = new RuleImpl("test-rule");
        new RuleTerminalNode(1, (LeftTupleSource)new MockTupleSource(2, buildContext), rule, rule.getLhs(), 0, buildContext);
        final ArrayList fired = new ArrayList();
        rule.setConsequence(new Consequence(){

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) throws Exception {
                fired.add("a");
            }

            public String getName() {
                return "default";
            }
        });
        rule.setTimer((Timer)new DurationTimer(10000L));
        rule.setPackage("test");
        impl.addRule(rule);
        knowledgeBase.addPackages(Collections.singleton(impl));
        SessionConfiguration config = SessionConfiguration.newInstance();
        config.setClockType(ClockType.PSEUDO_CLOCK);
        KieSession ksession = knowledgeBase.newKieSession((KieSessionConfiguration)config, KieServices.get().newEnvironment());
        PseudoClockScheduler scheduler = (PseudoClockScheduler)ksession.getSessionClock();
        Marshaller marshaller = MarshallerFactory.newMarshaller((KieBase)knowledgeBase);
        ksession.insert((Object)"cheese");
        Assert.assertTrue((boolean)fired.isEmpty());
        this.readWrite((KieBase)knowledgeBase, ksession, (KieSessionConfiguration)config);
        Assert.assertTrue((boolean)fired.isEmpty());
        scheduler.advanceTime(12L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)fired.isEmpty());
    }

    @Test
    public void testMarshallEntryPointsWithExpires() throws Exception {
        String str = "package org.domain.test \nimport " + ((Object)((Object)this)).getClass().getCanonicalName() + ".*\nglobal java.util.List list\ndeclare A\n @role( event )\n @expires( 10s )\nend\ndeclare B\n @role( event )\n @expires( 10s )\nend\ndeclare C\n @role( event )\n @expires( 15s )\nend\nrule a1\nwhen\n   $a : A() from entry-point 'a-ep'\nthen\nlist.add( $a );end\nrule b1\nwhen\n   $b : B() from entry-point 'b-ep'\nthen\nlist.add( $b );end\nrule c1\nwhen\n   $c : C() from entry-point 'c-ep'\nthen\nlist.add( $c );end\n";
        KieBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KieBase kBase = this.loadKnowledgeBaseFromString(config, new String[]{str});
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((KieSessionOption)ClockTypeOption.PSEUDO);
        ksconf.setOption((KieSessionOption)TimerJobFactoryOption.get((String)"trackable"));
        KieSession ksession = kBase.newKieSession(ksconf, null);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        EntryPoint aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        EntryPoint bep = ksession.getEntryPoint("b-ep");
        bep.insert((Object)new B());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        EntryPoint cep = ksession.getEntryPoint("c-ep");
        cep.insert((Object)new C());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        ksession.fireAllRules();
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        Assert.assertEquals((long)3L, (long)list.size());
        aep = ksession.getEntryPoint("a-ep");
        Assert.assertEquals((long)1L, (long)aep.getFactHandles().size());
        bep = ksession.getEntryPoint("b-ep");
        Assert.assertEquals((long)1L, (long)bep.getFactHandles().size());
        cep = ksession.getEntryPoint("c-ep");
        Assert.assertEquals((long)1L, (long)cep.getFactHandles().size());
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        timeService.advanceTime(11L, TimeUnit.SECONDS);
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        ksession.fireAllRules();
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        aep = ksession.getEntryPoint("a-ep");
        Assert.assertEquals((long)0L, (long)aep.getFactHandles().size());
        bep = ksession.getEntryPoint("b-ep");
        Assert.assertEquals((long)0L, (long)bep.getFactHandles().size());
        cep = ksession.getEntryPoint("c-ep");
        Assert.assertEquals((long)1L, (long)cep.getFactHandles().size());
    }

    @Test
    public void testMarshallEntryPointsWithNot() throws Exception {
        String str = "package org.domain.test \nimport " + ((Object)((Object)this)).getClass().getCanonicalName() + ".*\nglobal java.util.List list\ndeclare A\n @role( event )\n @expires( 10m )\nend\ndeclare B\n @role( event )\n @expires( 10m )\nend\nrule a1\nwhen\n   $a : A() from entry-point 'a-ep'\n   not B( this after[0s, 10s] $a) from entry-point 'a-ep'\nthen\nlist.add( $a );end\n";
        KieBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KieBase kBase = this.loadKnowledgeBaseFromString(config, new String[]{str});
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((KieSessionOption)ClockTypeOption.PSEUDO);
        ksconf.setOption((KieSessionOption)TimerJobFactoryOption.get((String)"trackable"));
        KieSession ksession = kBase.newKieSession(ksconf, null);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        EntryPoint aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        timeService.advanceTime(3L, TimeUnit.SECONDS);
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        ksession.fireAllRules();
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    @Ignore(value="beta4 phreak")
    public void testMarshallEntryPointsWithSlidingTimeWindow() throws Exception {
        String str = "package org.domain.test \nimport " + ((Object)((Object)this)).getClass().getCanonicalName() + ".*\nimport java.util.List\nglobal java.util.List list\ndeclare A\n @role( event )\n @expires( 10m )\nend\ndeclare B\n @role( event )\n @expires( 10m )\nend\nrule a1\nwhen\n   $l : List() from collect( A()  over window:time(30s) from entry-point 'a-ep') \nthen\n   list.add( $l );end\n";
        KieBaseConfiguration conf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        conf.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KieBase kbase = this.loadKnowledgeBaseFromString(conf, new String[]{str});
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((KieSessionOption)ClockTypeOption.PSEUDO);
        ksconf.setOption((KieSessionOption)TimerJobFactoryOption.get((String)"trackable"));
        KieSession ksession = this.createKnowledgeSession(kbase, ksconf);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        EntryPoint aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        list.clear();
        ksession.fireAllRules();
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        Assert.assertEquals((long)2L, (long)((List)list.get(0)).size());
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        timeService.advanceTime(15L, TimeUnit.SECONDS);
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        list.clear();
        ksession.fireAllRules();
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        Assert.assertEquals((long)4L, (long)((List)list.get(0)).size());
        timeService = (PseudoClockScheduler)ksession.getSessionClock();
        timeService.advanceTime(20L, TimeUnit.SECONDS);
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        list.clear();
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)((List)list.get(0)).size());
    }

    @Test
    public void testMarshallEntryPointsWithSlidingLengthWindow() throws Exception {
        String str = "package org.domain.test \nimport " + ((Object)((Object)this)).getClass().getCanonicalName() + ".*\nimport java.util.List\nglobal java.util.List list\ndeclare A\n @role( event )\n @expires( 10m )\nend\ndeclare B\n @role( event )\n @expires( 10m )\nend\nrule a1\nwhen\n   $l : List() from collect( A()  over window:length(3) from entry-point 'a-ep') \nthen\n   list.add( $l );end\n";
        KieBaseConfiguration conf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        conf.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KieBase kbase = this.loadKnowledgeBaseFromString(conf, new String[]{str});
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((KieSessionOption)ClockTypeOption.PSEUDO);
        ksconf.setOption((KieSessionOption)TimerJobFactoryOption.get((String)"trackable"));
        KieSession ksession = this.createKnowledgeSession(kbase, ksconf);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        EntryPoint aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        list.clear();
        ksession.fireAllRules();
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        Assert.assertEquals((long)2L, (long)((List)list.get(0)).size());
        aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        list.clear();
        ksession.fireAllRules();
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        Assert.assertEquals((long)3L, (long)((List)list.get(0)).size());
    }

    @Test
    public void testMarshalWithProtoBuf() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"test_Serializable.drl"});
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        ksession.insert((Object)bob);
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        Assert.assertEquals((long)1L, (long)ksession.getFactCount());
        Assert.assertEquals((Object)bob, ksession.getObjects().iterator().next());
        int fired = ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)fired);
        List list = (List)ksession.getGlobal("list");
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)new Integer(4), list.get(0));
        Collection facts = ksession.getObjects();
        System.out.println(new ArrayList(facts));
        Assert.assertEquals((long)2L, (long)facts.size());
    }

    private KieSession marsallStatefulKnowledgeSession(KieSession ksession) throws IOException, ClassNotFoundException {
        Globals globals = ksession.getGlobals();
        KieBase kbase = ksession.getKieBase();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MarshallerFactory.newMarshaller((KieBase)kbase).marshall((OutputStream)out, ksession);
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((KieSessionOption)TimerJobFactoryOption.get((String)"trackable"));
        ksconf.setOption((KieSessionOption)ClockTypeOption.PSEUDO);
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.Globals", (Object)globals);
        ksession = MarshallerFactory.newMarshaller((KieBase)kbase).unmarshall((InputStream)new ByteArrayInputStream(out.toByteArray()), ksconf, env);
        return ksession;
    }

    private void readWrite(KieBase knowledgeBase, KieSession ksession, KieSessionConfiguration config) {
        try {
            Marshaller marshaller = MarshallerFactory.newMarshaller((KieBase)knowledgeBase);
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            marshaller.marshall((OutputStream)o, ksession);
            ksession = marshaller.unmarshall((InputStream)new ByteArrayInputStream(o.toByteArray()), config, KieServices.get().newEnvironment());
            ksession.fireAllRules();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Marshaller createSerializableMarshaller(KieBase knowledgeBase) {
        ObjectMarshallingStrategyAcceptor acceptor = MarshallerFactory.newClassFilterAcceptor((String[])new String[]{"*.*"});
        ObjectMarshallingStrategy strategy = MarshallerFactory.newSerializeMarshallingStrategy((ObjectMarshallingStrategyAcceptor)acceptor);
        Marshaller marshaller = MarshallerFactory.newMarshaller((KieBase)knowledgeBase, (ObjectMarshallingStrategy[])new ObjectMarshallingStrategy[]{strategy});
        return marshaller;
    }

    @Test
    public void testMarshallWithCollects() throws Exception {
        String str = "import java.util.Collection\nrule R1 when\n    Collection(empty==false) from collect( Integer() )\n    Collection() from collect( String() )\nthen\nend\nrule R2 when then end\n";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = kbase.newKieSession();
        try {
            Marshaller marshaller = MarshallerFactory.newMarshaller((KieBase)kbase);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            marshaller.marshall((OutputStream)baos, ksession);
            marshaller = MarshallerFactory.newMarshaller((KieBase)kbase);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            baos.close();
            ksession = marshaller.unmarshall((InputStream)bais);
            bais.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("unexpected exception :" + e.getMessage()));
        }
    }

    @Test
    public void testMarshallWithTimedRule() {
        String drl = "rule \"Rule A Timeout\"\nwhen\n    String( this == \"ATrigger\" )\nthen\n   insert (new String( \"A-Timer\") );\nend\n\nrule \"Timer For rule A Timeout\"\n    timer ( int: 5s )\nwhen\n   String( this == \"A-Timer\")\nthen\n   delete ( \"A-Timer\" );\n   delete ( \"ATrigger\" );\nend\n";
        KieBase kbase = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[]{EqualityBehaviorOption.EQUALITY, DeclarativeAgendaOption.ENABLED, EventProcessingOption.STREAM});
        KieSessionConfiguration sessionConfig = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.PSEUDO);
        KieSession ksession = kbase.newKieSession(sessionConfig, null);
        ksession.insert((Object)"ATrigger");
        Assert.assertEquals((long)1L, (long)ksession.getFactCount());
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)ksession.getFactCount());
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(4L, TimeUnit.SECONDS);
        Assert.assertEquals((long)2L, (long)ksession.getFactCount());
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)ksession.getFactCount());
        ksession = MarshallingTest.marshallAndUnmarshall(kbase, ksession, sessionConfig);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(4L, TimeUnit.SECONDS);
        Assert.assertEquals((long)2L, (long)ksession.getFactCount());
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)ksession.getFactCount());
    }

    @Test
    @Ignore(value="Reproduces with pseudoclock. It takes too long with system clock")
    public void testMarshallWithTimedRuleRealClock() {
        String drl = "rule \"Rule A Timeout\"\nwhen\n    String( this == \"ATrigger\" )\nthen\n   insert (new String( \"A-Timer\") );\nend\n\nrule \"Timer For rule A Timeout\"\n    timer ( int: 5s )\nwhen\n   String( this == \"A-Timer\")\nthen\n   delete ( \"A-Timer\" );\n   delete ( \"ATrigger\" );\nend\n";
        KieBase kbase = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[]{EqualityBehaviorOption.EQUALITY, DeclarativeAgendaOption.ENABLED, EventProcessingOption.STREAM});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)"ATrigger");
        Assert.assertEquals((long)1L, (long)ksession.getFactCount());
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)ksession.getFactCount());
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Assert.assertEquals((long)2L, (long)ksession.getFactCount());
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)ksession.getFactCount());
        ksession = MarshallingTest.marshallAndUnmarshall(kbase, ksession, null);
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Assert.assertEquals((long)2L, (long)ksession.getFactCount());
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)ksession.getFactCount());
    }

    public static KieSession marshallAndUnmarshall(KieBase kbase, KieSession ksession, KieSessionConfiguration sessionConfig) {
        return MarshallingTest.marshallAndUnmarshall(kbase, kbase, ksession, sessionConfig);
    }

    public static KieSession marshallAndUnmarshall(KieBase kbase1, KieBase kbase2, KieSession ksession, KieSessionConfiguration sessionConfig) {
        try {
            KieMarshallers kieMarshallers = KieServices.Factory.get().getMarshallers();
            Marshaller marshaller = kieMarshallers.newMarshaller(kbase1);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            marshaller.marshall((OutputStream)baos, ksession);
            marshaller = kieMarshallers.newMarshaller(kbase2);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            baos.close();
            ksession = marshaller.unmarshall((InputStream)bais, sessionConfig, null);
            bais.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("unexpected exception :" + e.getMessage()));
        }
        return ksession;
    }

    @Test
    public void testSnapshotRecoveryScheduledRulesPlain() throws Exception {
        String drl = "package com.drools.restore.reproducer\nglobal java.util.List list;\nglobal java.util.List list2;\nrule R1\n timer (int: 20s)\n when\n   $m : String( this == \"Hello World1\" )\n then\n   list.add( $m );\n   retract( $m );\nend\nrule R2\n timer (int: 30s)\n when\n   $m : String( this == \"Hello World2\" )\n then\n   list2.add( $m );\n   retract( $m );\nend\n";
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        ksconf.setOption((KieSessionOption)TimedRuleExecutionOption.YES);
        ksconf.setOption((KieSessionOption)TimerJobFactoryOption.get((String)"trackable"));
        ksconf.setOption((KieSessionOption)ClockTypeOption.PSEUDO);
        KieBase kbase1 = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[]{EventProcessingOption.STREAM});
        KieSession ksession = kbase1.newKieSession(ksconf, null);
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ArrayList list2 = new ArrayList();
        ksession.setGlobal("list2", list2);
        ksession.insert((Object)"Hello World1");
        ksession.insert((Object)"Hello World2");
        ksession.fireAllRules();
        timeService.advanceTime(10500L, TimeUnit.MILLISECONDS);
        KieBase kbase2 = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[]{EventProcessingOption.STREAM});
        ksession = MarshallingTest.marshallAndUnmarshall(kbase1, kbase2, ksession, ksconf);
        ksession.setGlobal("list", list);
        ksession.setGlobal("list2", list2);
        PseudoClockScheduler timeService2 = (PseudoClockScheduler)ksession.getSessionClock();
        ksession.fireAllRules();
        long accumulatedSleepTime = 0L;
        for (int i = 0; i < 6; ++i) {
            timeService2.advanceTime(5050L, TimeUnit.MILLISECONDS);
            accumulatedSleepTime += 5050L;
            Assert.assertEquals((long)(i < 1 ? 0L : 1L), (long)list.size());
            Assert.assertEquals((long)(i < 3 ? 0L : 1L), (long)list2.size());
        }
    }

    @Test
    public void testKsessionSerializationWithInsertLogical() {
        ArrayList firedRules = new ArrayList();
        String str = "import java.util.Date;\nimport " + Promotion.class.getCanonicalName() + ";\n\ndeclare Person\n\tname : String\n\tdateOfBirth : Date\nend\n\ndeclare Employee extends Person\n\tjob : String\nend\n\nrule \"Insert Alice\"\n\twhen\n\tthen\n\t\tEmployee alice = new Employee(\"Alice\", new Date(1973, 7, 2), \"Vet\");\n\t\tinsert(alice);\n\t\tSystem.out.println(\"Insert Alice\");\nend\n\nrule \"Insert Bob\"\n\twhen\n\t\tPerson(name == \"Alice\")\n\tthen\n\t\tPerson bob = new Person(\"Bob\", new Date(1973, 7, 2));\n\t\tinsertLogical(bob);\n\t\tSystem.out.println(\"InsertLogical Bob\");\nend\n\nrule \"Insert Claire\"\n\twhen\n\t\tPerson(name == \"Bob\")\n\tthen\n\t\tEmployee claire = new Employee(\"Claire\", new Date(1973, 7, 2), \"Student\");\n\t\tinsert(claire);\n\t\tSystem.out.println(\"Insert Claire\");\nend\n\nrule \"Promote\"\n\twhen\n\t\tp : Promotion(n : name, j : job)\n\t\te : Employee(name == n)\n\tthen\n\t\tmodify(e) {\n\t\t\tsetJob(j)\n\t\t}\n\t\tdelete(p);\n\t\tSystem.out.printf(\"Promoted %s to %s%n\", n, j);\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.fireAllRules();
        try {
            Marshaller marshaller = MarshallerFactory.newMarshaller((KieBase)kbase);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            marshaller.marshall((OutputStream)baos, ksession);
            marshaller = MarshallerFactory.newMarshaller((KieBase)kbase);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            baos.close();
            ksession = (StatefulKnowledgeSession)marshaller.unmarshall((InputStream)bais);
            bais.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("unexpected exception :" + e.getMessage()));
        }
        ksession.insert((Object)new Promotion("Claire", "Scientist"));
        int result = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test(timeout=10000L)
    public void testDisposeAfterMarshall() throws InterruptedException, IOException {
        String str = "package com.sample\nrule R when\n  $s : String()\nthen\n  System.out.println($s);\nend\n";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = kbase.newKieSession();
        CountDownLatch latch = new CountDownLatch(1);
        Thread t = new Thread(() -> {
            System.out.println("Firing.");
            latch.countDown();
            ksession.fireUntilHalt();
            System.out.println("Halted.");
        });
        t.start();
        latch.await();
        Thread.sleep(100L);
        ksession.halt();
        KieMarshallers kMarshallers = KieServices.Factory.get().getMarshallers();
        ObjectMarshallingStrategy oms = kMarshallers.newSerializeMarshallingStrategy();
        Marshaller marshaller = kMarshallers.newMarshaller(kbase, new ObjectMarshallingStrategy[]{oms});
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            marshaller.marshall((OutputStream)baos, ksession);
        }
        ksession.dispose();
        ksession.destroy();
        t.join();
    }

    public static class Promotion {
        private String name;
        private String job;

        public Promotion(String name, String job) {
            this.setName(name);
            this.setJob(job);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getJob() {
            return this.job;
        }

        public void setJob(String job) {
            this.job = job;
        }
    }

    public static class C
    implements Serializable {
        public String toString() {
            return "C[]";
        }
    }

    public static class B
    implements Serializable {
        public String toString() {
            return "B[]";
        }
    }

    public static class A
    implements Serializable {
        public String toString() {
            return "A[]";
        }
    }
}

