/*
 * Decompiled with CFR 0.152.
 */
package org.drools.serialization.protobuf;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.drools.core.ClassObjectFilter;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.rule.EntryPointId;
import org.drools.core.util.ObjectHashMap;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.CheeseEqual;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.Sensor;
import org.drools.serialization.protobuf.SerializationHelper;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class TruthMaintenanceTest
extends CommonTestMethodBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogicalInsertionsDynamicRule() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertionsDynamicRule.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        Collection kpkgs = kbuilder.getKnowledgePackages();
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kbase.addPackages(kpkgs);
        KieSession ksession = this.createKnowledgeSession((KieBase)kbase);
        try {
            Cheese c1 = new Cheese("a", 1);
            Cheese c2 = new Cheese("b", 2);
            Cheese c3 = new Cheese("c", 3);
            ksession.insert((Object)c1);
            FactHandle h = ksession.insert((Object)c2);
            ksession.insert((Object)c3);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ArrayList list = new ArrayList(ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)));
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertFalse((boolean)list.contains(new Person(c1.getType())));
            Assert.assertTrue((boolean)list.contains(new Person(c2.getType())));
            Assert.assertTrue((boolean)list.contains(new Person(c3.getType())));
            kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertionsDynamicRule2.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
            if (kbuilder.hasErrors()) {
                Assert.fail((String)kbuilder.getErrors().toString());
            }
            Collection kpkgs2 = kbuilder.getKnowledgePackages();
            kbase.addPackages(kpkgs2);
            kbase = SerializationHelper.serializeObject(kbase);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            kbase = (InternalKnowledgeBase)ksession.getKieBase();
            list = new ArrayList(ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)));
            Assert.assertEquals((long)3L, (long)list.size());
            Assert.assertTrue((boolean)list.contains(new Person(c1.getType())));
            Assert.assertTrue((boolean)list.contains(new Person(c2.getType())));
            Assert.assertTrue((boolean)list.contains(new Person(c3.getType())));
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assert.assertEquals((long)3L, (long)kbase.getKiePackages().size());
            KiePackage test = null;
            KiePackage test2 = null;
            for (KiePackage kpkg : kbase.getKiePackages()) {
                if (kpkg.getName().equals("org.drools.compiler.test")) {
                    test = kpkg;
                    continue;
                }
                if (!kpkg.getName().equals("org.drools.compiler.test2")) continue;
                test2 = kpkg;
            }
            Assert.assertNotNull(test);
            Assert.assertNotNull(test2);
            Assert.assertEquals((Object)"rule1", (Object)((Rule)test.getRules().iterator().next()).getName());
            Assert.assertEquals((Object)"rule2", (Object)((Rule)test2.getRules().iterator().next()).getName());
            kbase.removeRule(test.getName(), ((Rule)test.getRules().iterator().next()).getName());
            for (KiePackage kpkg : kbase.getKiePackages()) {
                if (kpkg.getName().equals("org.drools.compiler.test")) {
                    test = kpkg;
                    continue;
                }
                if (!kpkg.getName().equals("org.drools.compiler.test2")) continue;
                test2 = kpkg;
            }
            Assert.assertNotNull((Object)test);
            Assert.assertNotNull((Object)test2);
            Assert.assertEquals((long)0L, (long)test.getRules().size());
            Assert.assertEquals((long)1L, (long)test2.getRules().size());
            Assert.assertEquals((Object)"rule2", (Object)((Rule)test2.getRules().iterator().next()).getName());
            list = new ArrayList(ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)));
            Assert.assertEquals((String)"removal of the rule should result in retraction of c3's logical assertion", (long)2L, (long)list.size());
            Assert.assertTrue((String)"c1's logical assertion should not be deleted", (boolean)list.contains(new Person(c1.getType())));
            Assert.assertTrue((String)"c2's logical assertion should  not be deleted", (boolean)list.contains(new Person(c2.getType())));
            Assert.assertFalse((String)"c3's logical assertion should be  deleted", (boolean)list.contains(new Person(c3.getType())));
            c2.setPrice(3);
            h = this.getFactHandle(h, ksession);
            ksession.update(h, (Object)c2);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            list = new ArrayList(ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)));
            Assert.assertEquals((String)"c2 now has a higher price, its logical assertion should  be cancelled", (long)1L, (long)list.size());
            Assert.assertFalse((String)"The logical assertion cor c2 should have been deleted", (boolean)list.contains(new Person(c2.getType())));
            Assert.assertTrue((String)"The logical assertion  for c1 should exist", (boolean)list.contains(new Person(c1.getType())));
            for (KiePackage kpkg : kbase.getKiePackages()) {
                if (kpkg.getName().equals("org.drools.compiler.test")) {
                    test = kpkg;
                    continue;
                }
                if (!kpkg.getName().equals("org.drools.compiler.test2")) continue;
                test2 = kpkg;
            }
            Assert.assertNotNull((Object)test);
            Assert.assertNotNull((Object)test2);
            kbase.removeRule(test2.getName(), ((Rule)test2.getRules().iterator().next()).getName());
            kbase = SerializationHelper.serializeObject(kbase);
            for (KiePackage kpkg : kbase.getKiePackages()) {
                if (kpkg.getName().equals("org.drools.compiler.test")) {
                    test = kpkg;
                    continue;
                }
                if (!kpkg.getName().equals("org.drools.compiler.test2")) continue;
                test2 = kpkg;
            }
            Assert.assertNotNull((Object)test);
            Assert.assertNotNull((Object)test2);
            Assert.assertEquals((long)0L, (long)test.getRules().size());
            Assert.assertEquals((long)0L, (long)test2.getRules().size());
            list = new ArrayList(ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)));
            Assert.assertEquals((long)0L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testLogicalInsertions() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertions.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        Collection kpkgs = kbuilder.getKnowledgePackages();
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kpkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        KieSession session = this.createKnowledgeSession((KieBase)kbase);
        try {
            ArrayList list = new ArrayList();
            session.setGlobal("list", list);
            Cheese brie = new Cheese("brie", 12);
            FactHandle brieHandle = session.insert((Object)brie);
            Cheese provolone = new Cheese("provolone", 12);
            FactHandle provoloneHandle = session.insert((Object)provolone);
            session.fireAllRules();
            session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
            System.out.println(list);
            Assert.assertEquals((long)3L, (long)list.size());
            Assert.assertEquals((long)3L, (long)session.getObjects().size());
            brieHandle = this.getFactHandle(brieHandle, session);
            session.delete(brieHandle);
            session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
            Assert.assertEquals((long)2L, (long)session.getObjects().size());
            provoloneHandle = this.getFactHandle(provoloneHandle, session);
            session.delete(provoloneHandle);
            session.fireAllRules();
            Assert.assertEquals((long)0L, (long)session.getObjects().size());
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testLogicalInsertionsBacking() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertionsBacking.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        Collection kpkgs = kbuilder.getKnowledgePackages();
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kpkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        KieSession session = this.createKnowledgeSession((KieBase)kbase);
        try {
            Cheese cheese1 = new Cheese("c", 1);
            Cheese cheese2 = new Cheese(cheese1.getType(), 1);
            FactHandle h1 = session.insert((Object)cheese1);
            session.fireAllRules();
            session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
            Collection list = session.getObjects((ObjectFilter)new ClassObjectFilter(cheese1.getType().getClass()));
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)cheese1.getType(), list.iterator().next());
            FactHandle h2 = session.insert((Object)cheese2);
            session.fireAllRules();
            session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
            list = session.getObjects((ObjectFilter)new ClassObjectFilter(cheese1.getType().getClass()));
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)cheese1.getType(), list.iterator().next());
            Assert.assertEquals((long)3L, (long)session.getObjects().size());
            h1 = this.getFactHandle(h1, session);
            session.delete(h1);
            session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
            session.fireAllRules();
            session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
            list = session.getObjects((ObjectFilter)new ClassObjectFilter(cheese1.getType().getClass()));
            Assert.assertEquals((String)("cheese-type " + cheese1.getType() + " was deleted, but should not. Backed by cheese2 => type."), (long)1L, (long)list.size());
            Assert.assertEquals((String)("cheese-type " + cheese1.getType() + " was deleted, but should not. Backed by cheese2 => type."), (Object)cheese1.getType(), list.iterator().next());
            h2 = this.getFactHandle(h2, session);
            session.delete(h2);
            session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
            session.fireAllRules();
            session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
            list = session.getObjects((ObjectFilter)new ClassObjectFilter(cheese1.getType().getClass()));
            Assert.assertEquals((String)("cheese-type " + cheese1.getType() + " was not deleted, but should have. Neither  cheese1 => type nor cheese2 => type is true."), (long)0L, (long)list.size());
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testLogicalInsertionsWithModify() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"test_LogicalInsertionsWithUpdate.drl"});
        KieSession ksession = kbase.newKieSession();
        try {
            Person p = new Person("person");
            p.setAge(2);
            FactHandle h = ksession.insert((Object)p);
            Assert.assertEquals((long)1L, (long)ksession.getObjects().size());
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, false);
            Assert.assertEquals((long)2L, (long)ksession.getObjects().size());
            Collection l = ksession.getObjects((ObjectFilter)new ClassObjectFilter(CheeseEqual.class));
            Assert.assertEquals((long)1L, (long)l.size());
            Assert.assertEquals((long)2L, (long)((CheeseEqual)l.iterator().next()).getPrice());
            h = this.getFactHandle(h, ksession);
            ksession.delete(h);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, false);
            Assert.assertEquals((long)0L, (long)ksession.getObjects().size());
            TruthMaintenanceSystem tms = ((NamedEntryPoint)ksession.getEntryPoint(EntryPointId.DEFAULT.getEntryPointId())).getTruthMaintenanceSystem();
            Field field = tms.getClass().getDeclaredField("equalityKeyMap");
            field.setAccessible(true);
            ObjectHashMap m = (ObjectHashMap)field.get(tms);
            field.setAccessible(false);
            Assert.assertEquals((String)"assertMap should be empty", (long)0L, (long)m.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testLogicalInsertions2() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"test_LogicalInsertions2.drl"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList events = new ArrayList();
            ksession.setGlobal("events", events);
            Sensor sensor = new Sensor(80, 80);
            FactHandle handle = ksession.insert((Object)sensor);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, false);
            ksession.fireAllRules();
            Collection list = ksession.getObjects();
            Assert.assertEquals((String)"Only sensor is there", (long)1L, (long)list.size());
            Assert.assertEquals((String)"Only one event", (long)1L, (long)events.size());
            sensor.setPressure(200);
            sensor.setTemperature(200);
            handle = this.getFactHandle(handle, ksession);
            ksession.update(handle, (Object)sensor);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.fireAllRules();
            list = ksession.getObjects();
            Assert.assertEquals((String)"Only sensor is there", (long)1L, (long)list.size());
            TruthMaintenanceSystem tms = ((NamedEntryPoint)ksession.getEntryPoint(EntryPointId.DEFAULT.getEntryPointId())).getTruthMaintenanceSystem();
            Assert.assertTrue((boolean)tms.getEqualityKeyMap().isEmpty());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testLogicalInsertionsNot() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"test_LogicalInsertionsNot.drl"});
        KieSession ksession = kbase.newKieSession();
        try {
            Person a = new Person("a");
            Cheese cheese = new Cheese("brie", 1);
            ksession.setGlobal("cheese", (Object)cheese);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Collection list = ksession.getObjects();
            Assert.assertEquals((String)"i was not asserted by not a => i.", (long)1L, (long)list.size());
            Assert.assertEquals((String)"i was not asserted by not a => i.", (Object)cheese, list.iterator().next());
            FactHandle h = ksession.insert((Object)a);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.fireAllRules();
            list = ksession.getObjects();
            Assert.assertEquals((String)"a was not asserted or i not deleted.", (long)1L, (long)list.size());
            Assert.assertEquals((String)"a was asserted.", (Object)a, list.iterator().next());
            Assert.assertFalse((String)"i was not rectracted.", (boolean)list.contains(cheese));
            Assert.assertEquals((String)"agenda should be empty.", (long)0L, (long)((StatefulKnowledgeSessionImpl)ksession).getAgenda().agendaSize());
            h = this.getFactHandle(h, ksession);
            ksession.delete(h);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            list = ksession.getObjects();
            Assert.assertEquals((String)"i was not asserted by not a => i.", (long)1L, (long)list.size());
            Assert.assertEquals((String)"i was not asserted by not a => i.", (Object)cheese, list.iterator().next());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    @Ignore(value="Currently cannot support updates")
    public void testLogicalInsertionsUpdateEqual() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"test_LogicalInsertionsUpdateEqual.drl"});
        KieSession ksession = kbase.newKieSession();
        try {
            Person p = new Person("person");
            p.setAge(2);
            FactHandle h = ksession.insert((Object)p);
            Assert.assertEquals((long)1L, (long)ksession.getObjects().size());
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assert.assertEquals((long)2L, (long)ksession.getObjects().size());
            Collection l = ksession.getObjects((ObjectFilter)new ClassObjectFilter(CheeseEqual.class));
            Assert.assertEquals((long)1L, (long)l.size());
            Assert.assertEquals((long)3L, (long)((CheeseEqual)l.iterator().next()).getPrice());
            h = this.getFactHandle(h, ksession);
            ksession.delete(h);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Collection list = ksession.getObjects();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)new CheeseEqual("person", 3), list.iterator().next());
            FactHandle fh = ksession.getFactHandle(list.iterator().next());
            ksession.delete(fh);
            list = ksession.getObjects();
            Assert.assertEquals((long)0L, (long)list.size());
            TruthMaintenanceSystem tms = ((NamedEntryPoint)ksession.getEntryPoint(EntryPointId.DEFAULT.getEntryPointId())).getTruthMaintenanceSystem();
            Field field = tms.getClass().getDeclaredField("equalityKeyMap");
            field.setAccessible(true);
            ObjectHashMap m = (ObjectHashMap)field.get(tms);
            field.setAccessible(false);
            Assert.assertEquals((String)"assertMap should be empty", (long)0L, (long)m.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testLogicalInsertionsWithExists() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"test_LogicalInsertionWithExists.drl"});
        KieSession ksession = kbase.newKieSession();
        try {
            Person p1 = new Person("p1", "stilton", 20);
            p1.setStatus("europe");
            FactHandle c1FactHandle = ksession.insert((Object)p1);
            Person p2 = new Person("p2", "stilton", 30);
            p2.setStatus("europe");
            FactHandle c2FactHandle = ksession.insert((Object)p2);
            Person p3 = new Person("p3", "stilton", 40);
            p3.setStatus("europe");
            FactHandle c3FactHandle = ksession.insert((Object)p3);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Collection cheeseList = ksession.getObjects((ObjectFilter)new ClassObjectFilter(Cheese.class));
            Assert.assertEquals((long)2L, (long)cheeseList.size());
            p3.setStatus("america");
            c3FactHandle = this.getFactHandle(c3FactHandle, ksession);
            ksession.update(c3FactHandle, (Object)p3);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            cheeseList = ksession.getObjects((ObjectFilter)new ClassObjectFilter(Cheese.class));
            Assert.assertEquals((long)1L, (long)cheeseList.size());
            p2.setStatus("america");
            c2FactHandle = this.getFactHandle(c2FactHandle, ksession);
            ksession.update(c2FactHandle, (Object)p2);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            cheeseList = ksession.getObjects((ObjectFilter)new ClassObjectFilter(Cheese.class));
            Assert.assertEquals((long)1L, (long)cheeseList.size());
            p1.setStatus("america");
            c1FactHandle = this.getFactHandle(c1FactHandle, ksession);
            ksession.update(c1FactHandle, (Object)p1);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            cheeseList = ksession.getObjects((ObjectFilter)new ClassObjectFilter(Cheese.class));
            Assert.assertEquals((long)2L, (long)cheeseList.size());
            p2.setStatus("europe");
            c2FactHandle = this.getFactHandle(c2FactHandle, ksession);
            ksession.update(c2FactHandle, (Object)p2);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            cheeseList = ksession.getObjects((ObjectFilter)new ClassObjectFilter(Cheese.class));
            Assert.assertEquals((long)1L, (long)cheeseList.size());
            p1.setStatus("europe");
            c1FactHandle = this.getFactHandle(c1FactHandle, ksession);
            ksession.update(c1FactHandle, (Object)p1);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            cheeseList = ksession.getObjects((ObjectFilter)new ClassObjectFilter(Cheese.class));
            Assert.assertEquals((long)1L, (long)cheeseList.size());
            p3.setStatus("europe");
            c3FactHandle = this.getFactHandle(c3FactHandle, ksession);
            ksession.update(c3FactHandle, (Object)p3);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            cheeseList = ksession.getObjects((ObjectFilter)new ClassObjectFilter(Cheese.class));
            Assert.assertEquals((long)2L, (long)cheeseList.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testLogicalInsertions3() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"test_logicalInsertions3.drl"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("events", list);
            Sensor sensor = new Sensor(150, 100);
            FactHandle sensorHandle = ksession.insert((Object)sensor);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertEquals((long)2L, (long)ksession.getObjects().size());
            sensor.setTemperature(125);
            sensorHandle = this.getFactHandle(sensorHandle, ksession);
            ksession.update(sensorHandle, (Object)sensor);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assert.assertEquals((long)3L, (long)list.size());
            Assert.assertEquals((long)2L, (long)ksession.getObjects().size());
            sensor.setTemperature(80);
            sensorHandle = this.getFactHandle(sensorHandle, ksession);
            ksession.update(sensorHandle, (Object)sensor);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.fireAllRules();
            Assert.assertEquals((long)3L, (long)list.size());
            Assert.assertEquals((long)1L, (long)ksession.getObjects().size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testLogicalInsertionsAccumulatorPattern() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"test_LogicalInsertionsAccumulatorPattern.drl"});
        kbase = SerializationHelper.serializeObject(kbase);
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.setGlobal("ga", (Object)"a");
            ksession.setGlobal("gb", (Object)"b");
            ksession.setGlobal("gs", (Object)new Short(3));
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            FactHandle h = ksession.insert((Object)new Integer(6));
            Assert.assertEquals((long)1L, (long)ksession.getObjects().size());
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assert.assertEquals((String)"There should be 2 CheeseEqual in Working Memory, 1 justified, 1 stated", (long)2L, (long)ksession.getObjects((ObjectFilter)new ClassObjectFilter(CheeseEqual.class)).size());
            Assert.assertEquals((long)6L, (long)ksession.getObjects().size());
            h = this.getFactHandle(h, ksession);
            ksession.delete(h);
            ksession.fireAllRules();
            for (Object o : ksession.getObjects()) {
                System.out.println(o);
            }
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assert.assertEquals((long)0L, (long)ksession.getObjects((ObjectFilter)new ClassObjectFilter(CheeseEqual.class)).size());
            Assert.assertEquals((long)0L, (long)ksession.getObjects((ObjectFilter)new ClassObjectFilter(Short.class)).size());
            Assert.assertEquals((long)0L, (long)ksession.getObjects().size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testLogicalInsertionsModifySameRuleGivesDifferentLogicalInsertion() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertionsModifySameRuleGivesDifferentLogicalInsertion.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        Collection pkgs = kbuilder.getKnowledgePackages();
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kbase.addPackages(pkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        KieSession session = this.createKnowledgeSession((KieBase)kbase);
        try {
            Sensor sensor1 = new Sensor(100, 0);
            FactHandle sensor1Handle = session.insert((Object)sensor1);
            Sensor sensor2 = new Sensor(200, 0);
            FactHandle sensor2Handle = session.insert((Object)sensor2);
            Sensor sensor3 = new Sensor(200, 0);
            FactHandle sensor3Handle = session.insert((Object)sensor3);
            session.fireAllRules();
            session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
            ArrayList temperatureList = new ArrayList(session.getObjects((ObjectFilter)new ClassObjectFilter(Integer.class)));
            Assert.assertTrue((boolean)temperatureList.contains(100));
            Assert.assertTrue((boolean)temperatureList.contains(200));
            Assert.assertEquals((long)2L, (long)temperatureList.size());
            sensor1.setTemperature(150);
            sensor1Handle = this.getFactHandle(sensor1Handle, session);
            session.update(sensor1Handle, (Object)sensor1);
            session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
            session.fireAllRules();
            temperatureList = new ArrayList(session.getObjects((ObjectFilter)new ClassObjectFilter(Integer.class)));
            Assert.assertFalse((boolean)temperatureList.contains(100));
            Assert.assertTrue((boolean)temperatureList.contains(150));
            Assert.assertTrue((boolean)temperatureList.contains(200));
            Assert.assertEquals((long)2L, (long)temperatureList.size());
        }
        finally {
            session.dispose();
        }
    }

    public InternalFactHandle getFactHandle(FactHandle factHandle, StatefulKnowledgeSessionImpl session) {
        HashMap<Long, FactHandle> handles = new HashMap<Long, FactHandle>();
        for (FactHandle fh : session.getFactHandles()) {
            handles.put(((InternalFactHandle)fh).getId(), fh);
        }
        return (InternalFactHandle)handles.get(((InternalFactHandle)factHandle).getId());
    }

    public InternalFactHandle getFactHandle(FactHandle factHandle, KieSession ksession) {
        HashMap<Long, FactHandle> handles = new HashMap<Long, FactHandle>();
        for (FactHandle fh : ksession.getFactHandles()) {
            handles.put(((InternalFactHandle)fh).getId(), fh);
        }
        return (InternalFactHandle)handles.get(((InternalFactHandle)factHandle).getId());
    }
}

