/*
 * Decompiled with CFR 0.152.
 */
package org.drools.serialization.protobuf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Date;
import org.drools.core.SessionConfiguration;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.marshalling.impl.InputMarshaller;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ObjectMarshallingStrategyStoreImpl;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.builder.NodeFactory;
import org.drools.core.rule.EntryPointId;
import org.drools.mvel.compiler.Person;
import org.drools.serialization.protobuf.MarshallerProviderImpl;
import org.drools.serialization.protobuf.OldOutputMarshallerMethods;
import org.drools.serialization.protobuf.ProtobufMarshallerReaderContext;
import org.drools.serialization.protobuf.ProtobufMarshallerWriteContext;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyStore;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.marshalling.MarshallerFactory;

public class FactHandleMarshallingTest {
    private InternalKnowledgeBase createKnowledgeBase() {
        KieBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((KieBaseOption)EventProcessingOption.STREAM);
        return KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)config);
    }

    private InternalFactHandle createEventFactHandle(StatefulKnowledgeSessionImpl wm, InternalKnowledgeBase kBase) {
        Rete rete = kBase.getRete();
        NodeFactory nFacotry = kBase.getConfiguration().getComponentFactory().getNodeFactoryService();
        RuleBasePartitionId partionId = RuleBasePartitionId.MAIN_PARTITION;
        EntryPointNode entryPointNode = nFacotry.buildEntryPointNode(1, partionId, false, (ObjectSource)rete, EntryPointId.DEFAULT);
        NamedEntryPoint wmEntryPoint = new NamedEntryPoint(EntryPointId.DEFAULT, entryPointNode, wm);
        EventFactHandle factHandle = new EventFactHandle(1L, (Object)new Person(), 0L, new Date().getTime(), 0L, (WorkingMemoryEntryPoint)wmEntryPoint);
        return factHandle;
    }

    private StatefulKnowledgeSessionImpl createWorkingMemory(InternalKnowledgeBase kBase) {
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((KieSessionOption)ClockTypeOption.PSEUDO);
        SessionConfiguration sessionConf = (SessionConfiguration)ksconf;
        StatefulKnowledgeSessionImpl wm = new StatefulKnowledgeSessionImpl(1L, kBase, true, sessionConf, EnvironmentFactory.newEnvironment());
        return wm;
    }

    @Test
    public void backwardsCompatibleEventFactHandleTest() throws IOException, ClassNotFoundException {
        InternalKnowledgeBase kBase = this.createKnowledgeBase();
        StatefulKnowledgeSessionImpl wm = this.createWorkingMemory(kBase);
        InternalFactHandle factHandle = this.createEventFactHandle(wm, kBase);
        ObjectMarshallingStrategy[] strats = new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy(), new MarshallerProviderImpl().newIdentityMarshallingStrategy()};
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ProtobufMarshallerWriteContext outContext = new ProtobufMarshallerWriteContext((OutputStream)baos, null, null, null, (ObjectMarshallingStrategyStore)new ObjectMarshallingStrategyStoreImpl(strats), true, true, null);
        OldOutputMarshallerMethods.writeFactHandle_v1((MarshallerWriteContext)outContext, (ObjectOutputStream)outContext, outContext.getObjectMarshallingStrategyStore(), 2, factHandle);
        outContext.close();
        byte[] byteArray = baos.toByteArray();
        ObjectMarshallingStrategy[] newStrats = new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy()};
        ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
        ProtobufMarshallerReaderContext inContext = new ProtobufMarshallerReaderContext((InputStream)bais, null, null, (ObjectMarshallingStrategyStore)new ObjectMarshallingStrategyStoreImpl(newStrats), Collections.EMPTY_MAP, true, true, null);
        inContext.setWorkingMemory((InternalWorkingMemory)wm);
        InternalFactHandle newFactHandle = InputMarshaller.readFactHandle((MarshallerReaderContext)inContext);
        inContext.close();
        Assert.assertTrue((String)"Serialized FactHandle not the same as the original.", (boolean)this.compareInstances(factHandle, newFactHandle));
    }

    private boolean compareInstances(Object objA, Object objB) {
        boolean same = true;
        if (objA != null && objB != null) {
            if (!objA.getClass().equals(objB.getClass())) {
                return false;
            }
            String className = objA.getClass().getName();
            if (className.startsWith("java")) {
                return objA.equals(objB);
            }
            try {
                Field[] fields = objA.getClass().getDeclaredFields();
                if (fields.length == 0) {
                    same = true;
                }
                for (int i = 0; same && i < fields.length; ++i) {
                    fields[i].setAccessible(true);
                    Object subObjA = fields[i].get(objA);
                    Object subObjB = fields[i].get(objB);
                    if (this.compareInstances(subObjA, subObjB)) continue;
                    return false;
                }
            }
            catch (Exception e) {
                same = false;
                Assert.fail((String)(e.getClass().getSimpleName() + ":" + e.getMessage()));
            }
        } else if (objA != objB) {
            return false;
        }
        return same;
    }
}

