/*
 * Decompiled with CFR 0.152.
 */
package org.drools.serialization.protobuf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.DroolsObjectOutputStream;
import org.drools.mvel.CommonTestMethodBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.kie.api.KieBase;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.KieSession;
import org.kie.internal.marshalling.MarshallerFactory;

public class EventAccessorRestoreTest
extends CommonTestMethodBase {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private File kbaseFile = null;
    private KieBase kbase;

    @Before
    public void setUp() {
        String str = "package org.drools.test;\nglobal java.util.List list; \n\ndeclare Tick @role(event)  \n @timestamp( time ) \n id : int \n time : long \nend \nrule \"Init\" when\n   $i : Integer() \nthen\n   Tick tick = new Tick( $i, new java.util.Date().getTime() ); \n   insert( tick ); \n   System.out.println( tick ); \n   list.add( tick ); \nend\n";
        this.kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        KieSession ksession = this.kbase.newKieSession();
        try {
            this.kbaseFile = this.temp.newFile("test.bin");
            FileOutputStream fos = new FileOutputStream(this.kbaseFile);
            this.saveSession(fos, ksession);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public void saveSession(FileOutputStream output, KieSession ksession) throws IOException {
        DroolsObjectOutputStream droolsOut = new DroolsObjectOutputStream((OutputStream)output);
        Marshaller mas = this.createMarshaller();
        mas.marshall((OutputStream)droolsOut, ksession);
        droolsOut.flush();
        droolsOut.close();
    }

    private Marshaller createMarshaller() {
        ObjectMarshallingStrategyAcceptor acceptor = MarshallerFactory.newClassFilterAcceptor((String[])new String[]{"*.*"});
        ObjectMarshallingStrategy strategy = MarshallerFactory.newSerializeMarshallingStrategy((ObjectMarshallingStrategyAcceptor)acceptor);
        return MarshallerFactory.newMarshaller((KieBase)this.kbase, (ObjectMarshallingStrategy[])new ObjectMarshallingStrategy[]{strategy});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KieSession loadSession(FileInputStream input) throws IOException, ClassNotFoundException {
        KieSession ksession = null;
        try (DroolsObjectInputStream droolsIn = new DroolsObjectInputStream((InputStream)input, ((Object)((Object)this)).getClass().getClassLoader());){
            Marshaller mas = this.createMarshaller();
            ksession = mas.unmarshall((InputStream)droolsIn);
        }
        return ksession;
    }

    @Test
    public void testDeserialization() {
        try {
            FileInputStream fis = new FileInputStream(this.kbaseFile);
            KieSession knowledgeSession = this.loadSession(fis);
            ArrayList list = new ArrayList();
            knowledgeSession.setGlobal("list", list);
            knowledgeSession.insert((Object)30);
            knowledgeSession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)"Tick", (Object)list.get(0).getClass().getSimpleName());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

