/*
 * Decompiled with CFR 0.152.
 */
package org.drools.serialization.protobuf;

import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import org.drools.core.QueryResultsImpl;
import org.drools.core.QueryResultsRowImpl;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.runtime.rule.impl.FlatQueryResultRow;
import org.drools.core.runtime.rule.impl.FlatQueryResults;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Cheese;
import org.drools.serialization.protobuf.SerializationHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;

public class QueryTest
extends CommonTestMethodBase {
    @Rule
    public TestName testName = new TestName();

    @Before
    public void before() {
        System.out.println("] " + this.testName.getMethodName());
    }

    private static QueryResults getQueryResults(KieSession session, String queryName, Object ... arguments) throws Exception {
        QueryResultsImpl results = (QueryResultsImpl)session.getQueryResults(queryName, arguments);
        FlatQueryResults flatResults = new FlatQueryResults(results);
        Assert.assertEquals((String)"Query results size", (long)results.size(), (long)flatResults.size());
        Assert.assertEquals((String)"Query results identifiers", (long)results.getIdentifiers().length, (long)flatResults.getIdentifiers().length);
        TreeSet<String> resultIds = new TreeSet<String>(Arrays.asList(results.getIdentifiers()));
        TreeSet<String> flatIds = new TreeSet<String>(Arrays.asList(flatResults.getIdentifiers()));
        Assert.assertArrayEquals((String)"Flat query results identifiers", (Object[])resultIds.toArray(), (Object[])flatIds.toArray());
        String[] identifiers = results.getIdentifiers();
        Iterator copyFlatIter = flatResults.iterator();
        for (int i = 0; i < results.size(); ++i) {
            QueryResultsRowImpl row = results.get(i);
            Assert.assertTrue((String)"Round-tripped flat query results contain less rows than original query results", (boolean)copyFlatIter.hasNext());
            QueryResultsRow copyRow = (QueryResultsRow)copyFlatIter.next();
            for (String id : identifiers) {
                Object obj = row.get(id);
                if (obj != null) {
                    Object copyObj = copyRow.get(id);
                    Assert.assertTrue((String)("Flat query result [" + i + "] does not contain result: '" + id + "': " + obj + "/" + copyObj), (obj != null && obj.equals(copyObj) ? 1 : 0) != 0);
                }
                FactHandle fh = row.getFactHandle(id);
                FactHandle copyFh = copyRow.getFactHandle(id);
                if (fh == null) continue;
                Assert.assertNotNull((String)("Flat query result [" + i + "] does not contain facthandle: '" + ((InternalFactHandle)fh).getId() + "'"), (Object)copyFh);
                String fhStr = fh.toExternalForm();
                fhStr = fhStr.substring(0, fhStr.lastIndexOf(":"));
                String copyFhStr = copyFh.toExternalForm();
                copyFhStr = copyFhStr.substring(0, copyFhStr.lastIndexOf(":"));
                Assert.assertEquals((String)("Unequal fact handles for fact handle '" + ((InternalFactHandle)fh).getId() + "':"), (Object)fhStr, (Object)copyFhStr);
            }
        }
        TreeSet<String> copyFlatIds = new TreeSet<String>(Arrays.asList(flatResults.getIdentifiers()));
        Assert.assertArrayEquals((String)"Flat query results identifiers", (Object[])flatIds.toArray(), (Object[])copyFlatIds.toArray());
        return flatResults;
    }

    @Test
    public void testQuery() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"simple_query_test.drl"});
        KieSession session = this.createKieSession(kbase);
        Cheese stilton = new Cheese("stinky", 5);
        FactHandle factHandle = session.insert((Object)stilton);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        String queryName = "simple query";
        QueryResults results = QueryTest.getQueryResults(session, queryName, new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        QueryResultsRow row = (QueryResultsRow)results.iterator().next();
        if (row instanceof FlatQueryResultRow) {
            FlatQueryResultRow flatRow = (FlatQueryResultRow)row;
            Assert.assertEquals((long)0L, (long)flatRow.getIdentifiers().size());
        } else if (row instanceof QueryResultsRowImpl) {
            QueryResultsRowImpl rowImpl = (QueryResultsRowImpl)row;
            Assert.assertEquals((long)0L, (long)rowImpl.getDeclarations().size());
        }
    }

    @Test
    public void testQueryRemoval() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"simple_query_test.drl"});
        KieSession session = this.createKieSession(kbase);
        Cheese stilton = new Cheese("stinky", 5);
        session.insert((Object)stilton);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        QueryResults results = session.getQueryResults("simple query", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        org.kie.api.definition.rule.Rule rule = (org.kie.api.definition.rule.Rule)kbase.getKiePackage("org.drools.compiler.test").getRules().iterator().next();
        Assert.assertEquals((Object)"simple query", (Object)rule.getName());
        kbase.removeQuery("org.drools.compiler.test", "simple query");
        Assert.assertTrue((boolean)kbase.getKiePackage("org.drools.compiler.test").getRules().isEmpty());
        try {
            results = session.getQueryResults("simple query", new Object[0]);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("does not exist"));
        }
    }
}

