/*
 * Decompiled with CFR 0.152.
 */
package org.drools.serialization.protobuf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.drools.core.SessionConfiguration;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.RuleBase;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.serialization.protobuf.ProtobufMarshaller;
import org.drools.serialization.protobuf.marshalling.IdentityPlaceholderResolverStrategy;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.marshalling.MarshallerFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class ObjectMarshallingStrategyStoreTest {
    @Test
    public void testThrowErrorWhenExistMultipleMarshallingStrategiesWithSameName() throws IOException, ClassNotFoundException {
        Environment env = EnvironmentFactory.newEnvironment();
        final Thing entityOne = new Thing(1, "Object 1");
        final Thing entityTwo = new Thing(2, "Object 2");
        ArrayList<Thing> srcItems = new ArrayList<Thing>();
        srcItems.add(entityOne);
        srcItems.add(entityTwo);
        ObjectMarshallingStrategy[] strats = new ObjectMarshallingStrategy[]{new IdentityPlaceholderResolverStrategy(new ObjectMarshallingStrategyAcceptor(){

            public boolean accept(Object object) {
                return entityOne.equals(object);
            }
        }, Collections.singletonMap(entityOne.id, entityOne)), new IdentityPlaceholderResolverStrategy(new ObjectMarshallingStrategyAcceptor(){

            public boolean accept(Object object) {
                return entityTwo.equals(object);
            }
        }, Collections.singletonMap(entityTwo.id, entityTwo))};
        env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)strats);
        SessionConfiguration ksc = SessionConfiguration.newInstance();
        KieBaseConfiguration kbconf = RuleBaseFactory.newKnowledgeBaseConfiguration();
        kbconf.setOption((KieBaseOption)EventProcessingOption.STREAM);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((RuleBase)RuleBaseFactory.newRuleBase((KieBaseConfiguration)kbconf));
        KieSession ks = kbase.newKieSession((KieSessionConfiguration)ksc, env);
        ks.insert((Object)entityOne);
        ks.insert((Object)entityTwo);
        try {
            ProtobufMarshaller marshaller = (ProtobufMarshaller)MarshallerFactory.newMarshaller((KieBase)kbase, (ObjectMarshallingStrategy[])strats);
            Assertions.fail((String)"A runtime error must be thrown while found strategies with same name");
        }
        catch (RuntimeException re) {
            Assertions.assertThat((boolean)re.getMessage().contains("Multiple")).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleObjectMarshallingStrategiesOfTheSameClassWithDifferentNames() throws IOException, ClassNotFoundException {
        Environment env = EnvironmentFactory.newEnvironment();
        final Thing entityOne = new Thing(1, "Object 1");
        final Thing entityTwo = new Thing(2, "Object 2");
        ArrayList<Thing> srcItems = new ArrayList<Thing>();
        srcItems.add(entityOne);
        srcItems.add(entityTwo);
        ObjectMarshallingStrategy[] strats = new ObjectMarshallingStrategy[]{new IdentityPlaceholderResolverStrategy("entityOne", new ObjectMarshallingStrategyAcceptor(){

            public boolean accept(Object object) {
                return entityOne.equals(object);
            }
        }, Collections.singletonMap(entityOne.id, entityOne)), new IdentityPlaceholderResolverStrategy("entityTwo", new ObjectMarshallingStrategyAcceptor(){

            public boolean accept(Object object) {
                return entityTwo.equals(object);
            }
        }, Collections.singletonMap(entityTwo.id, entityTwo))};
        env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)strats);
        SessionConfiguration ksc = SessionConfiguration.newInstance();
        KieBaseConfiguration kbconf = RuleBaseFactory.newKnowledgeBaseConfiguration();
        kbconf.setOption((KieBaseOption)EventProcessingOption.STREAM);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((RuleBase)RuleBaseFactory.newRuleBase((KieBaseConfiguration)kbconf));
        KieSession ks = kbase.newKieSession((KieSessionConfiguration)ksc, env);
        ks.insert((Object)entityOne);
        ks.insert((Object)entityTwo);
        ProtobufMarshaller marshaller = (ProtobufMarshaller)MarshallerFactory.newMarshaller((KieBase)kbase, (ObjectMarshallingStrategy[])strats);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        marshaller.marshall((OutputStream)bos, ks, System.currentTimeMillis());
        byte[] b1 = bos.toByteArray();
        bos.close();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(b1);){
            StatefulKnowledgeSession ksession2 = marshaller.unmarshall((InputStream)bais, ks.getSessionConfiguration(), ks.getEnvironment());
            Collection items = ksession2.getFactHandles();
            Assertions.assertThat((items.size() == 2 ? 1 : 0) != 0).isTrue();
            for (Object item : items) {
                FactHandle factHandle = (FactHandle)item;
                Assertions.assertThat((boolean)srcItems.contains(((DefaultFactHandle)factHandle).getObject())).isTrue();
            }
        }
    }

    private class Thing {
        int id;
        String value;

        Thing(int id, String value) {
            this.id = id;
            this.value = value;
        }

        public boolean equals(Object thing) {
            return thing != null && thing instanceof Thing && ((Thing)thing).id == this.id;
        }

        public String toString() {
            return "Thing:" + this.id + "," + this.value;
        }
    }
}

