/*
 * Decompiled with CFR 0.152.
 */
package org.drools.serialization.protobuf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.assertj.core.api.Assertions;
import org.drools.core.impl.RuleBase;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.marshalling.MarshallerFactory;

public class UnmarshallingTest {
    @Test
    public void testMarshallWithNot() throws Exception {
        String whenBenNotVilgaxRule = "import " + this.getClass().getCanonicalName() + ".*\nrule one\nwhen\n   Ben()\n   not(Vilgax())\nthen\n   //System.out.println(\"Ben!\");\nend\n\nrule two\nwhen\n   Ben()\nthen\n   //System.out.println(\"Vilgax..\");\nend\n";
        KieBase knowledgeBase = this.initializeKnowledgeBase(whenBenNotVilgaxRule);
        KieSession ksession = knowledgeBase.newKieSession();
        ksession.insert((Object)new Ben());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MarshallerFactory.newMarshaller((KieBase)knowledgeBase).marshall((OutputStream)baos, ksession);
        ksession.dispose();
        knowledgeBase = this.initializeKnowledgeBase(whenBenNotVilgaxRule);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try {
            ksession = MarshallerFactory.newMarshaller((KieBase)knowledgeBase).unmarshall((InputStream)bais);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assertions.fail((String)(t.getClass().getSimpleName() + " thrown when trying to unmarshall (see stack trace in output)."));
        }
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(2);
    }

    private KieBase initializeKnowledgeBase(String rule) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(rule)), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            throw new RuntimeException(kbuilder.getErrors().toString());
        }
        KieBaseConfiguration config = RuleBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((KieBaseOption)EventProcessingOption.STREAM);
        InternalKnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase((RuleBase)RuleBaseFactory.newRuleBase((KieBaseConfiguration)config));
        knowledgeBase.addPackages(kbuilder.getKnowledgePackages());
        return knowledgeBase;
    }

    @Test
    public void testMarshallWithTimer() throws Exception {
        String drl = "declare String @role(event) end\n\nrule R1 when\n        $s : String( ) over window:time( 5s )\n    then\n        delete( $s );\nend\n";
        KieBase kBase = this.initializeKnowledgeBase(drl);
        KieSession ksession = kBase.newKieSession();
        ksession.insert((Object)"test");
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        Marshaller marshaller = KieServices.get().getMarshallers().newMarshaller(kBase);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        marshaller.marshall((OutputStream)baos, ksession);
        ksession.dispose();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ksession = marshaller.unmarshall((InputStream)bais);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
    }

    public static class Vilgax
    implements Serializable {
        private static final long serialVersionUID = 5337858943537739516L;

        public String toString() {
            return "Vilgax[]";
        }
    }

    public static class Ben
    implements Serializable {
        private static final long serialVersionUID = 9127145048523653863L;

        public String toString() {
            return "Ben[]";
        }
    }
}

