/*
 * Decompiled with CFR 0.152.
 */
package org.drools.serialization.protobuf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Date;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.core.SessionConfiguration;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.QueryElementFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.core.marshalling.MarshallerReaderContext;
import org.drools.core.marshalling.MarshallerWriteContext;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.builder.NodeFactory;
import org.drools.core.rule.EntryPointId;
import org.drools.kiesession.entrypoints.NamedEntryPoint;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.mvel.compiler.Person;
import org.drools.serialization.protobuf.MarshallerProviderImpl;
import org.drools.serialization.protobuf.OldOutputMarshallerMethods;
import org.drools.serialization.protobuf.ProtobufMarshallerReaderContext;
import org.drools.serialization.protobuf.ProtobufMarshallerWriteContext;
import org.drools.serialization.protobuf.marshalling.ObjectMarshallingStrategyStoreImpl;
import org.drools.util.StringUtils;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyStore;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.RuleRuntime;
import org.kie.internal.marshalling.MarshallerFactory;

public class FactHandleMarshallingTest {
    private InternalKnowledgeBase createKnowledgeBase() {
        KieBaseConfiguration config = RuleBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((KieBaseOption)EventProcessingOption.STREAM);
        return KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)config);
    }

    private InternalFactHandle createEventFactHandle(StatefulKnowledgeSessionImpl wm, InternalKnowledgeBase kBase) {
        Rete rete = kBase.getRete();
        NodeFactory nFacotry = CoreComponentFactory.get().getNodeFactoryService();
        RuleBasePartitionId partionId = RuleBasePartitionId.MAIN_PARTITION;
        EntryPointNode entryPointNode = nFacotry.buildEntryPointNode(1, partionId, false, (ObjectSource)rete, EntryPointId.DEFAULT);
        NamedEntryPoint wmEntryPoint = new NamedEntryPoint(EntryPointId.DEFAULT, entryPointNode, (ReteEvaluator)wm);
        EventFactHandle factHandle = new EventFactHandle(1L, (Object)new Person(), 0L, new Date().getTime(), 0L, (WorkingMemoryEntryPoint)wmEntryPoint);
        return factHandle;
    }

    private StatefulKnowledgeSessionImpl createWorkingMemory(InternalKnowledgeBase kBase) {
        KieSessionConfiguration ksconf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((KieSessionOption)ClockTypeOption.PSEUDO);
        SessionConfiguration sessionConf = (SessionConfiguration)ksconf;
        StatefulKnowledgeSessionImpl wm = new StatefulKnowledgeSessionImpl(1L, kBase, true, sessionConf, EnvironmentFactory.newEnvironment());
        return wm;
    }

    @Test
    public void backwardsCompatibleEventFactHandleTest() throws IOException, ClassNotFoundException {
        InternalKnowledgeBase kBase = this.createKnowledgeBase();
        StatefulKnowledgeSessionImpl wm = this.createWorkingMemory(kBase);
        InternalFactHandle factHandle = this.createEventFactHandle(wm, kBase);
        ObjectMarshallingStrategy[] strats = new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy(), new MarshallerProviderImpl().newIdentityMarshallingStrategy()};
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ProtobufMarshallerWriteContext outContext = new ProtobufMarshallerWriteContext((OutputStream)baos, null, null, null, (ObjectMarshallingStrategyStore)new ObjectMarshallingStrategyStoreImpl(strats), true, true, null);
        OldOutputMarshallerMethods.writeFactHandle_v1((MarshallerWriteContext)outContext, (ObjectOutputStream)outContext, outContext.getObjectMarshallingStrategyStore(), 2, factHandle);
        outContext.close();
        byte[] byteArray = baos.toByteArray();
        ObjectMarshallingStrategy[] newStrats = new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy()};
        ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
        ProtobufMarshallerReaderContext inContext = new ProtobufMarshallerReaderContext((InputStream)bais, null, null, (ObjectMarshallingStrategyStore)new ObjectMarshallingStrategyStoreImpl(newStrats), Collections.EMPTY_MAP, true, true, null);
        inContext.setWorkingMemory((InternalWorkingMemory)wm);
        InternalFactHandle newFactHandle = FactHandleMarshallingTest.readFactHandle((MarshallerReaderContext)inContext);
        inContext.close();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.compareInstances(factHandle, newFactHandle)).as("Serialized FactHandle not the same as the original.", new Object[0])).isTrue();
    }

    private static InternalFactHandle readFactHandle(MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        String entryPointId;
        String strategyClassName;
        int type = context.readInt();
        long id = context.readLong();
        long recency = context.readLong();
        long startTimeStamp = 0L;
        long duration = 0L;
        boolean expired = false;
        long activationsCount = 0L;
        if (type == 2) {
            startTimeStamp = context.readLong();
            duration = context.readLong();
            expired = context.readBoolean();
            activationsCount = context.readLong();
        }
        int strategyIndex = context.readInt();
        ObjectMarshallingStrategy strategy = null;
        if (strategyIndex >= 0) {
            strategy = context.getResolverStrategyFactory().getStrategy(strategyIndex);
        } else if (strategyIndex == -2 && !StringUtils.isEmpty((CharSequence)(strategyClassName = context.readUTF())) && (strategy = context.getResolverStrategyFactory().getStrategyObject(strategyClassName)) == null) {
            throw new IllegalStateException("No strategy of type " + strategyClassName + " available.");
        }
        Object object = null;
        if (strategy != null) {
            object = strategy.read((ObjectInputStream)context);
        }
        EntryPoint entryPoint = null;
        if (context.readBoolean() && (entryPointId = context.readUTF()) != null && !entryPointId.equals("")) {
            entryPoint = ((RuleRuntime)context.getWorkingMemory()).getEntryPoint(entryPointId);
        }
        EntryPointId confEP = entryPoint != null ? ((NamedEntryPoint)entryPoint).getEntryPoint() : context.getWorkingMemory().getEntryPoint();
        ObjectTypeConf typeConf = context.getWorkingMemory().getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(confEP, object);
        QueryElementFactHandle handle = null;
        switch (type) {
            case 0: {
                handle = new DefaultFactHandle(id, object, recency, (WorkingMemoryEntryPoint)entryPoint);
                break;
            }
            case 1: {
                handle = new QueryElementFactHandle(object, id, recency);
                break;
            }
            case 2: {
                handle = new EventFactHandle(id, object, recency, startTimeStamp, duration, (WorkingMemoryEntryPoint)entryPoint);
                ((EventFactHandle)handle).setExpired(expired);
                ((EventFactHandle)handle).setActivationsCount(activationsCount);
                break;
            }
            default: {
                throw new IllegalStateException("Unable to marshal FactHandle, as type does not exist:" + type);
            }
        }
        return handle;
    }

    private boolean compareInstances(Object objA, Object objB) {
        boolean same = true;
        if (objA != null && objB != null) {
            if (!objA.getClass().equals(objB.getClass())) {
                return false;
            }
            String className = objA.getClass().getName();
            if (className.startsWith("java")) {
                return objA.equals(objB);
            }
            try {
                Field[] fields = objA.getClass().getDeclaredFields();
                if (fields.length == 0) {
                    same = true;
                }
                for (int i = 0; same && i < fields.length; ++i) {
                    fields[i].setAccessible(true);
                    Object subObjA = fields[i].get(objA);
                    Object subObjB = fields[i].get(objB);
                    if (this.compareInstances(subObjA, subObjB)) continue;
                    return false;
                }
            }
            catch (Exception e) {
                same = false;
                Assertions.fail((String)(e.getClass().getSimpleName() + ":" + e.getMessage()));
            }
        } else if (objA != objB) {
            return false;
        }
        return same;
    }
}

