/*
 * Decompiled with CFR 0.152.
 */
package org.drools.serialization.protobuf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Lists;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.consequence.Activation;
import org.drools.serialization.protobuf.ProtobufOutputMarshaller;
import org.junit.Test;
import org.mockito.Mockito;

public class MarshalledActivationSortTest {
    private static final String TEST_DATA = "ExcChFV:[623, 564, 565]\nExcChFV:[623, 564, 565]\nExcChFV:[623, null, 565]\nExcCh:[579, 565, 564]\nExcCh:[579, null, 564]\nExcCh:[623, 564, 565]\nExcCh:[623, 564, 565]\nExcCh:[623, 564, 565]\nExcCh:[623, null, 565]\nExcChV:[648, 564, 565]\nExcOS:[558, null, null, 534]\nExcOS:[558, null, null, 534]\nExlCo:[551, null, 534]\nExlCo:[551, null, 534]\nExcChHo:[555, 534]\nExcChHo:[555, 534]\nStoreAc:[562, 534]\nStoreAc:[562, 534]\nExcCh:[579, 565, 564]\nExcCh:[579, 564, 564]\nExcCh:[579, 564, 564]\nExcRe:[651, null, 565]\nExlCr:[630, 565, 565]\nExlCr:[630, 564, 565]\nExlCr:[630, 564, 565]\nExcSe:[639, 565, 565]\nExcSe:[639, 564, 565]\nExcSe:[639, 564, 565]\nExcSe:[639, null, 565]\nExlChV:[648, 565, 565]\nExlChV:[648, 564, 565]\nExlChV:[648, 564, 565]";

    @Test
    public void test() throws IOException {
        ArrayList as = Lists.newArrayList();
        for (String text : TEST_DATA.split("\\n")) {
            ActivationEntry line = this.parseLine(text);
            Activation a = this.createActivation(line);
            as.add(a);
        }
        as.sort(ProtobufOutputMarshaller.ActivationsSorter.INSTANCE);
        Assertions.assertThat((String)((Activation)as.get(0)).toString()).isEqualTo("ActivationEntry{ruleName='ExcCh', ids=[579, null, 564]}");
    }

    private Activation createActivation(ActivationEntry line) {
        Activation a = (Activation)Mockito.mock(Activation.class);
        RuleImpl rule = (RuleImpl)Mockito.mock(RuleImpl.class);
        Mockito.when((Object)rule.getName()).thenReturn((Object)line.ruleName);
        Mockito.when((Object)a.getRule()).thenReturn((Object)rule);
        Mockito.when((Object)a.toString()).thenReturn((Object)line.toString());
        Tuple tuple1 = null;
        Tuple tuple2 = null;
        Tuple tuple3 = null;
        Tuple tuple4 = null;
        if (line.ids.size() >= 1) {
            tuple1 = this.mockTuple(line.ids.get(0));
            Mockito.when((Object)a.getTuple()).thenReturn((Object)tuple1);
        }
        if (line.ids.size() >= 2) {
            tuple2 = this.mockTuple(line.ids.get(1));
            Mockito.when((Object)tuple1.getParent()).thenReturn((Object)tuple2);
        }
        if (line.ids.size() >= 3) {
            tuple3 = this.mockTuple(line.ids.get(2));
            Mockito.when((Object)tuple2.getParent()).thenReturn((Object)tuple3);
        }
        if (line.ids.size() >= 4) {
            tuple4 = this.mockTuple(line.ids.get(3));
            Mockito.when((Object)tuple3.getParent()).thenReturn((Object)tuple4);
        }
        Assertions.assertThat((line.ids.size() < 5 ? 1 : 0) != 0).isTrue();
        return a;
    }

    private Tuple mockTuple(Long handleId) {
        Tuple t = (Tuple)Mockito.mock(Tuple.class);
        if (handleId == null) {
            return t;
        }
        InternalFactHandle h = (InternalFactHandle)Mockito.mock(InternalFactHandle.class);
        Mockito.when((Object)h.getId()).thenReturn((Object)handleId);
        Mockito.when((Object)t.getFactHandle()).thenReturn((Object)h);
        return t;
    }

    private ActivationEntry parseLine(String text) {
        String ruleName = StringUtils.substringBefore((String)text, (String)":").trim();
        String idsText = StringUtils.substringAfter((String)text, (String)":").trim();
        idsText = idsText.replaceAll("[\\[\\]]", "");
        List<Long> ids = Stream.of(idsText.split(",")).map(String::trim).map(this::parseLong).collect(Collectors.toList());
        return new ActivationEntry(ruleName, ids);
    }

    private Long parseLong(String value) {
        if ("null".equals(value)) {
            return null;
        }
        return Long.parseLong(value);
    }

    private static class ActivationEntry {
        private final String ruleName;
        private final List<Long> ids;

        private ActivationEntry(String ruleName, List<Long> ids) {
            this.ruleName = ruleName;
            this.ids = ids;
        }

        public String toString() {
            return "ActivationEntry{ruleName='" + this.ruleName + "', ids=" + this.ids + "}";
        }
    }
}

