/*
 * Decompiled with CFR 0.152.
 */
package org.drools.serialization.protobuf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.marshalling.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.SerializablePlaceholderResolverStrategy;
import org.drools.mvel.compiler.Person;
import org.drools.serialization.protobuf.ProtobufMessages;
import org.drools.serialization.protobuf.ReadSessionResult;
import org.drools.serialization.protobuf.SerializationHelper;
import org.drools.serialization.protobuf.marshalling.JavaSerializableResolverStrategy;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.internal.utils.KieHelper;

@RunWith(value=Parameterized.class)
public class MarshallerTest {
    private Environment env = EnvironmentFactory.newEnvironment();

    @Parameterized.Parameters(name="{0}")
    public static Object[] params() {
        return new Object[]{new JavaSerializableResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT), new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)};
    }

    public MarshallerTest(ObjectMarshallingStrategy strategy) {
        this.env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{strategy});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAgendaDoNotSerializeObject() throws Exception {
        KieSession ksession = null;
        try {
            String str = "import java.util.Collection\nrule R1 when\n    String(this == \"x\" || this == \"y\" || this == \"z\")\nthen\nend\n";
            KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
            ksession = kbase.newKieSession(null, this.env);
            ksession.insert((Object)"x");
            ksession.insert((Object)"y");
            ksession.insert((Object)"z");
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(3);
            ReadSessionResult serialisedStatefulKnowledgeSession = SerializationHelper.getSerialisedStatefulKnowledgeSessionWithMessage(ksession, ksession.getKieBase(), true);
            ksession = serialisedStatefulKnowledgeSession.getSession();
            ProtobufMessages.KnowledgeSession deserializedMessage = serialisedStatefulKnowledgeSession.getDeserializedMessage();
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
            Assertions.assertThat((boolean)deserializedMessage.getRuleData().getAgenda().getMatchList().stream().anyMatch(ml -> ml.getTuple().getObjectList().size() > 0)).isFalse();
        }
        finally {
            if (ksession != null) {
                ksession.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFromWithFireBeforeSerialization() throws Exception {
        String str = "import java.util.Collection\nrule R1 when\n    String() from [ \"x\", \"y\", \"z\" ]\nthen\nend\n";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = null;
        try {
            ksession = kbase.newKieSession(null, this.env);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(3);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
        }
        finally {
            if (ksession != null) {
                ksession.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFromWithFireAfterSerialization() throws Exception {
        String str = "import java.util.Collection\nrule R1 when\n    String() from [ \"x\", \"y\", \"z\" ]\nthen\nend\n";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = null;
        try {
            ksession = kbase.newKieSession(null, this.env);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(3);
        }
        finally {
            if (ksession != null) {
                ksession.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFromWithPartialFiring() throws Exception {
        String str = "import java.util.Collection\nrule R1 when\n    String() from [ \"x\", \"y\", \"z\" ]\nthen\nend\n";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = null;
        try {
            ksession = kbase.newKieSession(null, this.env);
            Assertions.assertThat((int)ksession.fireAllRules(2)).isEqualTo(2);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        }
        finally {
            if (ksession != null) {
                ksession.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test2FromsWithPartialFiring() throws Exception {
        String str = "import java.util.Collection\nrule R1 when\n    String() from [ \"x\", \"y\", \"z\" ]\n    String() from [ \"a\", \"b\", \"c\" ]\nthen\nend\n";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = null;
        try {
            ksession = kbase.newKieSession(null, this.env);
            Assertions.assertThat((int)ksession.fireAllRules(5)).isEqualTo(5);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(4);
        }
        finally {
            if (ksession != null) {
                ksession.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFromAndJoinWithPartialFiring() throws Exception {
        String str = "import java.util.Collection\nrule R1 when\n    String() from [ \"x\", \"y\", \"z\" ]\n    Integer()\nthen\nend\n";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = null;
        try {
            ksession = kbase.newKieSession(null, this.env);
            ksession.insert((Object)42);
            Assertions.assertThat((int)ksession.fireAllRules(2)).isEqualTo(2);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        }
        finally {
            if (ksession != null) {
                ksession.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAgendaReconciliationAccumulate() throws Exception {
        String str = "import " + Person.class.getCanonicalName() + ";rule X when\n  accumulate ( $p: Person ( getName().startsWith(\"M\")); \n                $sum : sum($p.getAge())  \n              )                          \nthen\n  insert($sum);\nend";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = null;
        try {
            ksession = kbase.newKieSession(null, this.env);
            ksession.insert((Object)new Person("Mark", 37));
            ksession.insert((Object)new Person("Edson", 35));
            ksession.insert((Object)new Person("Mario", 40));
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
        }
        finally {
            if (ksession != null) {
                ksession.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAgendaReconciliationAccumulate2() throws Exception {
        String str = "import " + Person.class.getCanonicalName() + ";rule X when\n  accumulate ( $p: Person ( getName().startsWith(\"M\")); \n                $sum : sum($p.getAge())  \n              )                          \nthen\n  insert($sum);\nend";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = null;
        try {
            ksession = kbase.newKieSession(null, this.env);
            ksession.insert((Object)new Person("Mark", 37));
            ksession.insert((Object)new Person("Edson", 35));
            ksession.insert((Object)new Person("Mario", 40));
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        }
        finally {
            if (ksession != null) {
                ksession.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiAccumulate() throws Exception {
        String str = "import " + Person.class.getCanonicalName() + ";rule X when\n  accumulate ( Person ( getName().startsWith(\"M\"), $age : age ); \n                $sum : sum( $age ), $max : max( $age )  \n              )                          \nthen\n  insert($sum);\nend";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = null;
        try {
            ksession = kbase.newKieSession(null, this.env);
            ksession.insert((Object)new Person("Mark", 37));
            ksession.insert((Object)new Person("Edson", 35));
            ksession.insert((Object)new Person("Mario", 40));
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
        }
        finally {
            if (ksession != null) {
                ksession.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubnetwork() throws Exception {
        String str = "rule R1 when\n    String()\n    Long()\n    not( Long() and Integer() )\nthen end\n";
        KieBase kbase = new KieHelper().addContent("rule R1 when\n    String()\n    Long()\n    not( Long() and Integer() )\nthen end\n", ResourceType.DRL).build(new KieBaseOption[]{EqualityBehaviorOption.EQUALITY});
        KieSession ksession = null;
        try {
            ksession = kbase.newKieSession(null, this.env);
            ksession.insert((Object)"Luca");
            ksession.insert((Object)2L);
            ksession.insert((Object)10);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.delete(ksession.getFactHandle((Object)10));
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        }
        finally {
            if (ksession != null) {
                ksession.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubnetwork2() throws Exception {
        String str = "rule R1 when\n    String()\n    Long()\n    not( Long() and Integer() )\nthen end\n";
        KieBase kbase = new KieHelper().addContent("rule R1 when\n    String()\n    Long()\n    not( Long() and Integer() )\nthen end\n", ResourceType.DRL).build(new KieBaseOption[]{EqualityBehaviorOption.EQUALITY});
        KieSession ksession = null;
        try {
            ksession = kbase.newKieSession(null, this.env);
            ksession.insert((Object)"Luca");
            ksession.insert((Object)2L);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
            ksession.insert((Object)"Mario");
            ksession.insert((Object)11);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFromJoinWithPartialFiring() throws Exception {
        String str = "import java.util.Collection\nrule R1 when\n    Integer()\n    String() from [ \"x\", \"y\", \"z\" ]\nthen\nend\n";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = null;
        try {
            ksession = kbase.newKieSession(null, this.env);
            InternalFactHandle fh1 = (InternalFactHandle)ksession.insert((Object)1);
            Assertions.assertThat((int)ksession.fireAllRules(2)).isEqualTo(2);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
            InternalFactHandle intFH = (InternalFactHandle)ksession.getFactHandles().iterator().next();
            Assertions.assertThat((long)intFH.getId()).isEqualTo(fh1.getId());
            Assertions.assertThat((long)((InternalFactHandle)ksession.insert((Object)2)).getId()).isEqualTo(fh1.getId() + 4L);
        }
        finally {
            if (ksession != null) {
                ksession.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFromWithInsertLogical() throws Exception {
        String str = "import " + LongFact.class.getCanonicalName() + "\nimport " + LongFacts.class.getCanonicalName() + "\nrule R1 when\n    LongFacts($lfs: facts)\n    $lf: LongFact() from $lfs\nthen\n    insertLogical($lf);end\n";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = null;
        try {
            ksession = kbase.newKieSession(null, this.env);
            String id = UUID.randomUUID().toString();
            LongFacts longFacts = new LongFacts();
            longFacts.getFacts().add(new LongFact(123456L));
            ksession.insert((Object)longFacts);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
        }
        finally {
            if (ksession != null) {
                ksession.dispose();
            }
        }
    }

    public static class LongFacts
    implements Serializable {
        private List<LongFact> facts = new ArrayList<LongFact>();

        public List<LongFact> getFacts() {
            return this.facts;
        }

        public void setFacts(List<LongFact> facts) {
            this.facts = facts;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LongFacts longFacts = (LongFacts)o;
            return Objects.equals(this.facts, longFacts.facts);
        }

        public int hashCode() {
            return Objects.hash(this.facts);
        }
    }

    public static class LongFact
    implements Serializable {
        private long value;

        public LongFact() {
        }

        public LongFact(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        public void setValue(long value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LongFact longFact = (LongFact)o;
            return this.value == longFact.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

