/*
 * Decompiled with CFR 0.152.
 */
package org.drools.serialization.protobuf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.core.ClockType;
import org.drools.core.SessionConfiguration;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BaseNode;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.DroolsObjectOutputStream;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.RuleBase;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.core.marshalling.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.MapBackedClassLoader;
import org.drools.core.rule.consequence.Consequence;
import org.drools.core.rule.consequence.KnowledgeHelper;
import org.drools.core.time.impl.DurationTimer;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.drools.core.time.impl.Timer;
import org.drools.core.util.KeyStoreHelper;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Address;
import org.drools.mvel.compiler.Cell;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.FactA;
import org.drools.mvel.compiler.FactB;
import org.drools.mvel.compiler.FactC;
import org.drools.mvel.compiler.Message;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.Primitives;
import org.drools.mvel.integrationtests.IteratorToList;
import org.drools.serialization.protobuf.SerializationHelper;
import org.drools.serialization.protobuf.marshalling.IdentityPlaceholderResolverStrategy;
import org.drools.serialization.protobuf.marshalling.RuleBaseNodes;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.conf.DeclarativeAgendaOption;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.conf.Option;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.io.ResourceType;
import org.kie.api.marshalling.KieMarshallers;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.TimedRuleExecutionOption;
import org.kie.api.runtime.conf.TimerJobFactoryOption;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.time.SessionPseudoClock;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.marshalling.MarshallerFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.utils.KieHelper;

public class MarshallingTest
extends CommonTestMethodBase {
    @Test
    public void testSerializable() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Serializable.drl"});
        KiePackage kpkg = (KiePackage)kpkgs.iterator().next();
        kpkg = SerializationHelper.serializeObject(kpkg);
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.loadKnowledgeBase(new String[0]);
        kbase.addPackages(Collections.singleton(kpkg));
        Rule[] rules = ((KiePackage)kbase.getKiePackages().iterator().next()).getRules().toArray(new Rule[0]);
        Assertions.assertThat((int)rules.length).isEqualTo(4);
        Assertions.assertThat((String)rules[0].getName()).isEqualTo("match Person 1");
        Assertions.assertThat((String)rules[1].getName()).isEqualTo("match Person 2");
        Assertions.assertThat((String)rules[2].getName()).isEqualTo("match Person 3");
        Assertions.assertThat((String)rules[3].getName()).isEqualTo("match Integer");
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        ksession.insert((Object)bob);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(1L);
        Assertions.assertThat(ksession.getObjects().iterator().next()).isEqualTo((Object)bob);
        Assertions.assertThat((int)((InternalAgenda)ksession.getAgenda()).getAgendaGroupsManager().agendaSize()).isEqualTo(2);
        ksession.fireAllRules();
        List list = (List)ksession.getGlobal("list");
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)4);
        ArrayList objects = new ArrayList(ksession.getObjects());
        Assertions.assertThat((int)objects.size()).isEqualTo(2);
        Assertions.assertThat((boolean)objects.contains(bob)).isTrue();
        Assertions.assertThat((boolean)objects.contains(new Person("help"))).isTrue();
    }

    @Test
    public void testSerializeWorkingMemoryAndRuleBase1() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Serializable.drl"});
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
        KieSession session = kBase.newKieSession();
        kBase.addPackages(kpkgs);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        session.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        session.insert((Object)bob);
        ((InternalWorkingMemory)session).flushPropagations();
        Rule[] rules = kBase.getPackage("org.drools.compiler.test").getRules().toArray(new Rule[0]);
        Assertions.assertThat((int)rules.length).isEqualTo(4);
        Assertions.assertThat((String)rules[0].getName()).isEqualTo("match Person 1");
        Assertions.assertThat((String)rules[1].getName()).isEqualTo("match Person 2");
        Assertions.assertThat((String)rules[2].getName()).isEqualTo("match Person 3");
        Assertions.assertThat((String)rules[3].getName()).isEqualTo("match Integer");
        Assertions.assertThat((int)session.getObjects().size()).isEqualTo(1);
        Assertions.assertThat(IteratorToList.convert(session.getObjects().iterator()).get(0)).isEqualTo((Object)bob);
        Assertions.assertThat((int)((InternalAgenda)session.getAgenda()).getAgendaGroupsManager().agendaSize()).isEqualTo(2);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        session.fireAllRules();
        List list = (List)session.getGlobal("list");
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)4);
        Assertions.assertThat((int)session.getObjects().size()).isEqualTo(2);
        Assertions.assertThat((boolean)IteratorToList.convert(session.getObjects().iterator()).contains(bob)).isTrue();
        Assertions.assertThat((boolean)IteratorToList.convert(session.getObjects().iterator()).contains(new Person("help"))).isTrue();
    }

    @Test
    public void testSerializeWorkingMemoryAndRuleBase2() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Serializable.drl"});
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kBase.addPackages(kpkgs);
        KieSession session = kBase.newKieSession();
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        session.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        session.insert((Object)bob);
        ((InternalWorkingMemory)session).flushPropagations();
        Rule[] rules = kBase.getPackage("org.drools.compiler.test").getRules().toArray(new Rule[0]);
        Assertions.assertThat((int)rules.length).isEqualTo(4);
        Assertions.assertThat((String)rules[0].getName()).isEqualTo("match Person 1");
        Assertions.assertThat((String)rules[1].getName()).isEqualTo("match Person 2");
        Assertions.assertThat((String)rules[2].getName()).isEqualTo("match Person 3");
        Assertions.assertThat((String)rules[3].getName()).isEqualTo("match Integer");
        Assertions.assertThat((int)session.getObjects().size()).isEqualTo(1);
        Assertions.assertThat(IteratorToList.convert(session.getObjects().iterator()).get(0)).isEqualTo((Object)bob);
        Assertions.assertThat((int)((InternalAgenda)session.getAgenda()).getAgendaGroupsManager().agendaSize()).isEqualTo(2);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        session.fireAllRules();
        List list = (List)session.getGlobal("list");
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)4);
        Assertions.assertThat((int)session.getObjects().size()).isEqualTo(2);
        Assertions.assertThat((boolean)IteratorToList.convert(session.getObjects().iterator()).contains(bob)).isTrue();
        Assertions.assertThat((boolean)IteratorToList.convert(session.getObjects().iterator()).contains(new Person("help"))).isTrue();
    }

    @Test
    public void testSerializeWorkingMemoryAndRuleBase3() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Serializable.drl"});
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kBase.addPackages(kpkgs);
        KieSession session = kBase.newKieSession();
        session.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        session.insert((Object)bob);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        Rule[] rules = kBase.getPackage("org.drools.compiler.test").getRules().toArray(new Rule[0]);
        Assertions.assertThat((int)rules.length).isEqualTo(4);
        Assertions.assertThat((String)rules[0].getName()).isEqualTo("match Person 1");
        Assertions.assertThat((String)rules[1].getName()).isEqualTo("match Person 2");
        Assertions.assertThat((String)rules[2].getName()).isEqualTo("match Person 3");
        Assertions.assertThat((String)rules[3].getName()).isEqualTo("match Integer");
        Assertions.assertThat((int)session.getObjects().size()).isEqualTo(1);
        Assertions.assertThat(IteratorToList.convert(session.getObjects().iterator()).get(0)).isEqualTo((Object)bob);
        Assertions.assertThat((int)((InternalAgenda)session.getAgenda()).getAgendaGroupsManager().agendaSize()).isEqualTo(2);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        session.fireAllRules();
        List list = (List)session.getGlobal("list");
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)4);
        Assertions.assertThat((int)session.getObjects().size()).isEqualTo(2);
        Assertions.assertThat((boolean)IteratorToList.convert(session.getObjects().iterator()).contains(bob)).isTrue();
        Assertions.assertThat((boolean)IteratorToList.convert(session.getObjects().iterator()).contains(new Person("help"))).isTrue();
    }

    @Test
    public void testSerializeAdd() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic1.drl"});
        kpkgs = SerializationHelper.serializeObject(kpkgs);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kBase.addPackages(kpkgs);
        KieSession session = kBase.newKieSession();
        List list = new ArrayList();
        session.setGlobal("list", list);
        InternalFactHandle stilton = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        session.fireAllRules();
        Assertions.assertThat((int)1).isEqualTo(list.size());
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"stilton");
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        list = (List)session.getGlobal("list");
        Assertions.assertThat(list).isNotNull();
        Assertions.assertThat((int)1).isEqualTo(list.size());
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"stilton");
        kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic3.drl"});
        kpkgs = SerializationHelper.serializeObject(kpkgs);
        kBase.addPackages(kpkgs);
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie2 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        InternalFactHandle bob = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        Assertions.assertThat((int)3).isEqualTo(list.size());
        Assertions.assertThat(list).contains(new Object[]{bob.getObject(), "stilton"});
        session.dispose();
    }

    @Test
    public void testSerializationOfIndexedWM() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Serializable2.drl"});
        kpkgs = SerializationHelper.serializeObject(kpkgs);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kBase.addPackages(kpkgs);
        Rule[] rules = kBase.getPackage("org.drools.compiler").getRules().toArray(new Rule[0]);
        Assertions.assertThat((int)rules.length).isEqualTo(3);
        KieSession session = kBase.newKieSession();
        session.setGlobal("list", new ArrayList());
        Primitives p = new Primitives();
        p.setBytePrimitive((byte)1);
        p.setShortPrimitive((short)2);
        p.setIntPrimitive(3);
        session.insert((Object)p);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        Assertions.assertThat((int)session.getObjects().size()).isEqualTo(1);
        Assertions.assertThat(IteratorToList.convert(session.getObjects().iterator()).get(0)).isEqualTo((Object)p);
        Assertions.assertThat((int)((InternalAgenda)session.getAgenda()).getAgendaGroupsManager().agendaSize()).isEqualTo(3);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        session.fireAllRules();
        List list = (List)session.getGlobal("list");
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"1");
        Assertions.assertThat(list.get(1)).isEqualTo((Object)"2");
        Assertions.assertThat(list.get(2)).isEqualTo((Object)"3");
    }

    @Test
    public void testSerializeAdd2() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic1_0.drl"});
        kpkgs = SerializationHelper.serializeObject(kpkgs);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kBase.addPackages(kpkgs);
        List results = new ArrayList();
        KieSession session = kBase.newKieSession();
        session.setGlobal("results", results);
        InternalFactHandle stilton1 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        session.insert((Object)new Cheese("brie", 10));
        InternalFactHandle bob = (InternalFactHandle)session.insert((Object)new Person("bob", 10));
        session.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(1);
        Assertions.assertThat(results.get(0)).isEqualTo(stilton1.getObject());
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic3_0.drl"});
        kBase.addPackages(SerializationHelper.serializeObject(kpkgs));
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle mark = (InternalFactHandle)session.insert((Object)new Person("mark", 20));
        session.fireAllRules();
        results = (List)session.getGlobal("results");
        Assertions.assertThat((int)results.size()).isEqualTo(4);
        Assertions.assertThat(results.get(1)).isEqualTo(stilton2.getObject());
        Assertions.assertThat(results.get(2)).isEqualTo(bob.getObject());
        Assertions.assertThat(results.get(3)).isEqualTo(mark.getObject());
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        session.dispose();
    }

    @Test
    public void testSerializeAdd_newRuleNotFiredForNewData() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic1_0.drl"});
        kpkgs = SerializationHelper.serializeObject(kpkgs);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kBase.addPackages(kpkgs);
        ArrayList results = new ArrayList();
        KieSession session = kBase.newKieSession();
        session.setGlobal("results", results);
        InternalFactHandle stilton1 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie1 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        session.fireAllRules();
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic1_1.drl"});
        kBase.addPackages(SerializationHelper.serializeObject(kpkgs));
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie2 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle brie3 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 30));
        session.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(5);
        Assertions.assertThat(results.get(1)).isEqualTo(stilton2.getObject());
        Assertions.assertThat((boolean)results.contains(brie1.getObject())).isTrue();
        Assertions.assertThat((boolean)results.contains(brie3.getObject())).isTrue();
        Assertions.assertThat((boolean)results.contains(brie3.getObject())).isTrue();
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        session.dispose();
    }

    @Test
    public void testSerializeAdd3() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic1_0.drl"});
        kpkgs = SerializationHelper.serializeObject(kpkgs);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kBase.addPackages(kpkgs);
        ArrayList results = new ArrayList();
        KieSession session = kBase.newKieSession();
        session.setGlobal("results", results);
        InternalFactHandle stilton1 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie1 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        session.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(1);
        Assertions.assertThat(results.get(0)).isEqualTo(stilton1.getObject());
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic3_0.drl"});
        kBase.addPackages(SerializationHelper.serializeObject(kpkgs));
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie2 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle bob1 = (InternalFactHandle)session.insert((Object)new Person("bob", 20));
        InternalFactHandle bob2 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(4);
        Assertions.assertThat(results.get(1)).isEqualTo(stilton2.getObject());
        Assertions.assertThat((boolean)results.contains(bob2.getObject())).isTrue();
        Assertions.assertThat((boolean)results.contains(bob1.getObject())).isTrue();
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic1_2.drl"});
        kBase.addPackages(SerializationHelper.serializeObject(kpkgs));
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        InternalFactHandle stilton3 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 40));
        InternalFactHandle brie3 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 40));
        InternalFactHandle bob3 = (InternalFactHandle)session.insert((Object)new Person("bob", 40));
        InternalFactHandle bob4 = (InternalFactHandle)session.insert((Object)new Person("bob", 40));
        InternalFactHandle addr1 = (InternalFactHandle)session.insert((Object)new Address("bangalore"));
        InternalFactHandle addr2 = (InternalFactHandle)session.insert((Object)new Address("India"));
        session.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(9);
        Assertions.assertThat(results.get(4)).isEqualTo(stilton3.getObject());
        Assertions.assertThat(results.get(5)).isEqualTo(bob4.getObject());
        Assertions.assertThat(results.get(6)).isEqualTo(bob3.getObject());
        Assertions.assertThat((boolean)results.contains(addr2.getObject())).isTrue();
        Assertions.assertThat((boolean)results.contains(addr1.getObject())).isTrue();
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        InternalFactHandle stilton4 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 50));
        InternalFactHandle brie4 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 50));
        InternalFactHandle bob5 = (InternalFactHandle)session.insert((Object)new Person("bob", 50));
        InternalFactHandle bob6 = (InternalFactHandle)session.insert((Object)new Person("bob", 50));
        InternalFactHandle addr3 = (InternalFactHandle)session.insert((Object)new Address("Tripura"));
        InternalFactHandle addr4 = (InternalFactHandle)session.insert((Object)new Address("Agartala"));
        session.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(14);
        Assertions.assertThat(results.get(9)).isEqualTo(stilton4.getObject());
        Assertions.assertThat(results.get(10)).isEqualTo(bob6.getObject());
        Assertions.assertThat(results.get(11)).isEqualTo(bob5.getObject());
        Assertions.assertThat((boolean)results.contains(addr4.getObject())).isTrue();
        Assertions.assertThat((boolean)results.contains(addr3.getObject())).isTrue();
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        session.dispose();
    }

    @Test
    public void testSerializeAddRemove_NoClassDefFoundError() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic1_0.drl"});
        kpkgs = SerializationHelper.serializeObject(kpkgs);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kBase.addPackages(kpkgs);
        ArrayList results = new ArrayList();
        KieSession session = kBase.newKieSession();
        session.setGlobal("results", results);
        InternalFactHandle stilton1 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie1 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        session.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(1);
        Assertions.assertThat(results.get(0)).isEqualTo(stilton1.getObject());
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic3_0.drl"});
        kBase.addPackages(SerializationHelper.serializeObject(kpkgs));
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        results.clear();
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie2 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle bob1 = (InternalFactHandle)session.insert((Object)new Person("bob", 20));
        InternalFactHandle bob2 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(3);
        Assertions.assertThat(results.get(0)).isEqualTo(stilton2.getObject());
        Assertions.assertThat((boolean)results.contains(bob1.getObject())).isTrue();
        Assertions.assertThat((boolean)results.contains(bob2.getObject())).isTrue();
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        results.clear();
        kBase.removeRule("org.drools.compiler.test", "like stilton");
        InternalFactHandle stilton3 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie3 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle bob3 = (InternalFactHandle)session.insert((Object)new Person("bob", 20));
        InternalFactHandle bob4 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(2);
        Assertions.assertThat((boolean)results.contains(bob3.getObject())).isTrue();
        Assertions.assertThat((boolean)results.contains(bob4.getObject())).isTrue();
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        results.clear();
        kBase.removeKiePackage("org.drools.compiler.test");
        InternalFactHandle stilton4 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie4 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle bob5 = (InternalFactHandle)session.insert((Object)new Person("bob", 20));
        InternalFactHandle bob6 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(2);
        Assertions.assertThat((boolean)results.contains(bob5.getObject())).isTrue();
        Assertions.assertThat((boolean)results.contains(bob6.getObject())).isTrue();
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        results.clear();
        session.setGlobal("results", results);
        InternalFactHandle stilton5 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 30));
        InternalFactHandle brie5 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 30));
        InternalFactHandle bob7 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        InternalFactHandle bob8 = (InternalFactHandle)session.insert((Object)new Person("bob", 40));
        session.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(2);
        Assertions.assertThat((boolean)results.contains(bob7.getObject())).isTrue();
        Assertions.assertThat((boolean)results.contains(bob8.getObject())).isTrue();
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, true);
        session.dispose();
    }

    @Test
    public void testSignedSerialization1() throws Exception {
        try {
            this.setPrivateKeyProperties();
            this.setPublicKeyProperties();
            Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic1_0.drl"});
            kpkgs = SerializationHelper.serializeObject(kpkgs);
            InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
            kBase.addPackages(kpkgs);
        }
        finally {
            this.unsetPrivateKeyProperties();
            this.unsetPublicKeyProperties();
        }
    }

    @Test
    public void testSignedSerialization2() throws Exception {
        try {
            this.setPrivateKeyProperties();
            try {
                Collection kpkgs = this.loadKnowledgePackages(new String[]{"test_Dynamic1_0.drl"});
                Assertions.fail((String)"Deserialisation should have failed.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.unsetPrivateKeyProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignedSerialization3() throws Exception {
        try {
            this.setPrivateKeyProperties();
            Collection kpkgs = this.loadKnowledgePackages(null, false, new String[]{"test_Dynamic1_0.drl"});
            InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
            kBase.addPackages(kpkgs);
            try {
                kBase = SerializationHelper.serializeObject(kBase);
                Assertions.fail((String)"Deserialisation should have failed.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.unsetPrivateKeyProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignedSerialization4() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(null, false, new String[]{"test_Dynamic1_0.drl"});
        kpkgs = SerializationHelper.serializeObject(kpkgs);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kBase.addPackages(kpkgs);
        try {
            this.setPublicKeyProperties();
            kBase = SerializationHelper.serializeObject(kBase);
            Assertions.fail((String)"Should not deserialize an unsigned rulebase on an environment configured to work with signed rulebases.");
        }
        catch (Exception exception) {
        }
        finally {
            this.unsetPublicKeyProperties();
        }
    }

    private void setPublicKeyProperties() {
        URL clientKeyStoreURL = ((Object)((Object)this)).getClass().getResource("droolsClient.keystore");
        System.setProperty("drools.serialization.sign", "true");
        System.setProperty("drools.serialization.public.keyStoreURL", clientKeyStoreURL.toExternalForm());
        System.setProperty("drools.serialization.public.keyStorePwd", "clientpwd");
        KeyStoreHelper.reInit();
    }

    private void unsetPublicKeyProperties() {
        System.setProperty("drools.serialization.sign", "");
        System.setProperty("drools.serialization.public.keyStoreURL", "");
        System.setProperty("drools.serialization.public.keyStorePwd", "");
        KeyStoreHelper.reInit();
    }

    private void setPrivateKeyProperties() {
        URL serverKeyStoreURL = ((Object)((Object)this)).getClass().getResource("droolsServer.keystore");
        System.setProperty("drools.serialization.sign", "true");
        System.setProperty("drools.serialization.private.keyStoreURL", serverKeyStoreURL.toExternalForm());
        System.setProperty("drools.serialization.private.keyStorePwd", "serverpwd");
        System.setProperty("drools.serialization.private.keyAlias", "droolsKey");
        System.setProperty("drools.serialization.private.keyPwd", "keypwd");
        KeyStoreHelper.reInit();
    }

    private void unsetPrivateKeyProperties() {
        System.setProperty("drools.serialization.sign", "");
        System.setProperty("drools.serialization.private.keyStoreURL", "");
        System.setProperty("drools.serialization.private.keyStorePwd", "");
        System.setProperty("drools.serialization.private.keyAlias", "");
        System.setProperty("drools.serialization.private.keyPwd", "");
        KeyStoreHelper.reInit();
    }

    @Test
    public void testSerializabilityWithJarFacts() throws Exception {
        MapBackedClassLoader loader = new MapBackedClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        JarInputStream jis = new JarInputStream(((Object)((Object)this)).getClass().getResourceAsStream("/billasurf.jar"));
        JarEntry entry = null;
        byte[] buf = new byte[1024];
        int len = 0;
        while ((entry = jis.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((len = jis.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
            loader.addResource(entry.getName(), out.toByteArray());
        }
        String drl = "package foo.bar \nimport com.billasurf.Board\nrule 'MyGoodRule' \n dialect 'mvel' \n when    Board() then \n System.err.println(42); \nend\n";
        KnowledgeBuilderConfiguration kbuilderConf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration(null, (ClassLoader)loader);
        Collection kpkgs = this.loadKnowledgePackagesFromString(kbuilderConf, new String[]{drl});
        kpkgs = SerializationHelper.serializeObject(kpkgs, (ClassLoader)loader);
    }

    @Test
    public void testEmptyRule() throws Exception {
        Object rule = "package org.drools.compiler.test;\n";
        rule = (String)rule + "global java.util.List list\n";
        rule = (String)rule + "rule \"Rule 1\"\n";
        rule = (String)rule + "when\n";
        rule = (String)rule + "then\n";
        rule = (String)rule + "    list.add( \"fired\" );\n";
        rule = (String)rule + "end";
        KieBase kBase = this.loadKnowledgeBaseFromString(new String[]{rule});
        Map nodes = RuleBaseNodes.getNodeMap((RuleBase)((InternalKnowledgeBase)kBase));
        Assertions.assertThat((int)nodes.size()).isEqualTo(2);
        Assertions.assertThat((String)((ClassObjectType)((ObjectTypeNode)nodes.get(2)).getObjectType()).getClassType().getSimpleName()).isEqualTo("InitialFactImpl");
        Assertions.assertThat((String)((RuleTerminalNode)nodes.get(4)).getRule().getName()).isEqualTo("Rule 1");
        KieSession session = kBase.newKieSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, kBase, true);
        Assertions.assertThat((int)session.fireAllRules()).isEqualTo(1);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, kBase, true);
        Assertions.assertThat((int)((List)session.getGlobal("list")).size()).isEqualTo(1);
        Assertions.assertThat(((List)session.getGlobal("list")).get(0)).isEqualTo((Object)"fired");
    }

    @Test
    public void testDynamicEmptyRule() throws Exception {
        Object rule1 = "package org.drools.compiler.test;\n";
        rule1 = (String)rule1 + "global java.util.List list\n";
        rule1 = (String)rule1 + "rule \"Rule 1\"\n";
        rule1 = (String)rule1 + "when\n";
        rule1 = (String)rule1 + "then\n";
        rule1 = (String)rule1 + "    list.add( \"fired1\" );\n";
        rule1 = (String)rule1 + "end";
        Object rule2 = "package org.drools.compiler.test;\n";
        rule2 = (String)rule2 + "global java.util.List list\n";
        rule2 = (String)rule2 + "rule \"Rule 2\"\n";
        rule2 = (String)rule2 + "when\n";
        rule2 = (String)rule2 + "then\n";
        rule2 = (String)rule2 + "    list.add( \"fired2\" );\n";
        rule2 = (String)rule2 + "end";
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)this.loadKnowledgeBaseFromString(new String[]{rule1});
        Map nodes = RuleBaseNodes.getNodeMap((RuleBase)kBase);
        Assertions.assertThat((int)nodes.size()).isEqualTo(2);
        Assertions.assertThat((String)((ClassObjectType)((ObjectTypeNode)nodes.get(2)).getObjectType()).getClassType().getSimpleName()).isEqualTo("InitialFactImpl");
        Assertions.assertThat((String)((RuleTerminalNode)nodes.get(4)).getRule().getName()).isEqualTo("Rule 1");
        KieSession session = kBase.newKieSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        StatefulKnowledgeSession session1 = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, (KieBase)kBase, false);
        session1.fireAllRules();
        Assertions.assertThat((int)((List)session1.getGlobal("list")).size()).isEqualTo(1);
        StatefulKnowledgeSession session2 = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session1, (KieBase)kBase, false);
        session.dispose();
        session1.dispose();
        Collection kpkgs = this.loadKnowledgePackagesFromString(new String[]{rule2});
        kBase.addPackages(kpkgs);
        session2.fireAllRules();
        System.out.println(session2.getGlobal("list"));
        Assertions.assertThat((int)((List)session2.getGlobal("list")).size()).isEqualTo(2);
        Assertions.assertThat(((List)session2.getGlobal("list")).get(0)).isEqualTo((Object)"fired1");
        Assertions.assertThat(((List)session2.getGlobal("list")).get(1)).isEqualTo((Object)"fired2");
    }

    @Test
    public void testSinglePattern() throws Exception {
        Object rule = "package org.drools.compiler.test;\n";
        rule = (String)rule + "import " + Person.class.getCanonicalName() + "\n";
        rule = (String)rule + "global java.util.List list\n";
        rule = (String)rule + "rule \"Rule 1\"\n";
        rule = (String)rule + "when\n";
        rule = (String)rule + "    $p : Person( ) \n";
        rule = (String)rule + "then\n";
        rule = (String)rule + "    list.add( $p );\n";
        rule = (String)rule + "end";
        KieBase kBase = this.loadKnowledgeBaseFromString(new String[]{rule});
        Map nodes = RuleBaseNodes.getNodeMap((RuleBase)((InternalKnowledgeBase)kBase));
        Assertions.assertThat((int)nodes.size()).isEqualTo(3);
        Assertions.assertThat((String)((ClassObjectType)((ObjectTypeNode)nodes.get(3)).getObjectType()).getClassType().getSimpleName()).isEqualTo("Person");
        Assertions.assertThat((String)((RuleTerminalNode)nodes.get(5)).getRule().getName()).isEqualTo("Rule 1");
        KieSession session = kBase.newKieSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Person p = new Person("bobba fet", 32);
        session.insert((Object)p);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, kBase, true);
        session.fireAllRules();
        Assertions.assertThat((int)((List)session.getGlobal("list")).size()).isEqualTo(1);
        Assertions.assertThat(((List)session.getGlobal("list")).get(0)).isEqualTo((Object)p);
    }

    @Test
    public void testSingleRuleSingleJoinNodePattern() throws Exception {
        Object rule = "package org.drools.compiler.test;\n";
        rule = (String)rule + "import " + Person.class.getCanonicalName() + "\n";
        rule = (String)rule + "import " + Cheese.class.getCanonicalName() + "\n";
        rule = (String)rule + "global java.util.List list\n";
        rule = (String)rule + "rule \"Rule 1\"\n";
        rule = (String)rule + "when\n";
        rule = (String)rule + "    $c : Cheese( ) \n";
        rule = (String)rule + "    $p : Person( cheese == $c ) \n";
        rule = (String)rule + "then\n";
        rule = (String)rule + "    list.add( $p );\n";
        rule = (String)rule + "end";
        KieBase kBase = this.loadKnowledgeBaseFromString(new String[]{rule});
        Map nodes = RuleBaseNodes.getNodeMap((RuleBase)((InternalKnowledgeBase)kBase));
        Assertions.assertThat((int)nodes.size()).isEqualTo(5);
        Assertions.assertThat((String)((ClassObjectType)((ObjectTypeNode)nodes.get(3)).getObjectType()).getClassType().getSimpleName()).isEqualTo("Cheese");
        Assertions.assertThat((String)((ClassObjectType)((ObjectTypeNode)nodes.get(5)).getObjectType()).getClassType().getSimpleName()).isEqualTo("Person");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((BaseNode)nodes.get(6)).getClass().getSimpleName().endsWith("JoinNode")).as("Should end with JoinNode", new Object[0])).isTrue();
        Assertions.assertThat((String)((RuleTerminalNode)nodes.get(7)).getRule().getName()).isEqualTo("Rule 1");
        KieSession session = kBase.newKieSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 25);
        Cheese brie = new Cheese("brie", 49);
        Person bobba = new Person("bobba fet", 32);
        bobba.setCheese(stilton);
        Person vadar = new Person("darth vadar", 32);
        session.insert((Object)stilton);
        session.insert((Object)bobba);
        session.insert((Object)vadar);
        session.insert((Object)brie);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, kBase, true);
        session.fireAllRules();
        Assertions.assertThat((int)((List)session.getGlobal("list")).size()).isEqualTo(1);
        Assertions.assertThat(((List)session.getGlobal("list")).get(0)).isEqualTo((Object)bobba);
        Person c3po = new Person("c3p0", 32);
        c3po.setCheese(stilton);
        session.insert((Object)c3po);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, kBase, true);
        session.fireAllRules();
        Assertions.assertThat((int)((List)session.getGlobal("list")).size()).isEqualTo(2);
        Assertions.assertThat(((List)session.getGlobal("list")).get(1)).isEqualTo((Object)c3po);
        Person r2d2 = new Person("r2d2", 32);
        r2d2.setCheese(brie);
        session.insert((Object)r2d2);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, kBase, true);
        session.fireAllRules();
        Assertions.assertThat((int)((List)session.getGlobal("list")).size()).isEqualTo(3);
        Assertions.assertThat(((List)session.getGlobal("list")).get(2)).isEqualTo((Object)r2d2);
    }

    @Test
    public void testMultiRuleMultiJoinNodePatternsWithHalt() throws Exception {
        String rule1 = "package org.drools.compiler.test;\nimport " + Person.class.getCanonicalName() + "\nimport " + Cheese.class.getCanonicalName() + "\nglobal java.util.List list\nrule \"Rule 1\"\nwhen\n    $c : Cheese( ) \n    $p : Person( cheese == $c ) \nthen\n    list.add( $p );\nend";
        String rule2 = "package org.drools.compiler.test;\nimport " + Person.class.getCanonicalName() + "\nimport " + Cheese.class.getCanonicalName() + "\nimport " + Cell.class.getCanonicalName() + "\nglobal java.util.List list\nrule \"Rule 2\"\nwhen\n    $c : Cheese( ) \n    $p : Person( cheese == $c ) \n    $x : Cell( value == $p.age ) \nthen\n    list.add( $x );\nend";
        String rule3 = "package org.drools.compiler.test;\nimport " + Person.class.getCanonicalName() + "\nimport " + FactA.class.getCanonicalName() + "\nimport " + FactB.class.getCanonicalName() + "\nimport " + FactC.class.getCanonicalName() + "\nglobal java.util.List list\nrule \"Rule 3\"\nwhen\n    $a : FactA( field2 > 10 ) \n    $b : FactB( f2 >= $a.field2 ) \n    $p : Person( name == \"darth vadar\" ) \n    $c : FactC( f2 >= $b.f2 ) \nthen\n    list.add( $c );\n    drools.halt();\nend";
        KieBase kBase = this.loadKnowledgeBaseFromString(new String[]{rule1, rule2, rule3});
        KieSession session = kBase.newKieSession();
        List list = new ArrayList();
        session.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 25);
        Cheese brie = new Cheese("brie", 49);
        Person bobba = new Person("bobba fet", 30);
        bobba.setCheese(stilton);
        Person vadar = new Person("darth vadar", 38);
        Person c3po = new Person("c3p0", 17);
        c3po.setCheese(stilton);
        Person r2d2 = new Person("r2d2", 58);
        r2d2.setCheese(brie);
        session.insert((Object)stilton);
        session.insert((Object)bobba);
        session.insert((Object)vadar);
        session.insert((Object)brie);
        session.insert((Object)c3po);
        session.insert((Object)r2d2);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, kBase, true);
        session.fireAllRules();
        list = (List)session.getGlobal("list");
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat((boolean)list.contains(r2d2)).isTrue();
        Assertions.assertThat((boolean)list.contains(c3po)).isTrue();
        Assertions.assertThat((boolean)list.contains(bobba)).isTrue();
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, kBase, true);
        Cell cell30 = new Cell(30);
        session.insert((Object)cell30);
        Cell cell58 = new Cell(58);
        session.insert((Object)cell58);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, kBase, true);
        session.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(5);
        Assertions.assertThat((boolean)list.contains(cell30)).isTrue();
        Assertions.assertThat((boolean)list.contains(cell58)).isTrue();
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, kBase, true);
        session.insert((Object)new FactA(Integer.valueOf(15)));
        session.insert((Object)new FactB(Integer.valueOf(20)));
        FactC factC27 = new FactC(Integer.valueOf(27));
        session.insert((Object)factC27);
        FactC factC52 = new FactC(Integer.valueOf(52));
        session.insert((Object)factC52);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, kBase, true);
        session.fireAllRules();
        session.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(7);
        Assertions.assertThat((boolean)list.contains(factC52)).isTrue();
        Assertions.assertThat((boolean)list.contains(factC27)).isTrue();
    }

    @Test
    public void testNot() throws Exception {
        String header = "package org.drools.compiler.test;\nimport java.util.List;\nimport " + Person.class.getCanonicalName() + "\nimport " + Cheese.class.getCanonicalName() + "\nglobal java.util.List list;\n";
        String rule1 = "rule \"not rule test\"\nsalience 10\nwhen\n    Person()\n    not Cheese( price >= 5 )\nthen\n    list.add( new Integer( 5 ) );\nend\n";
        KieBase kBase = this.loadKnowledgeBaseFromString(new String[]{header + rule1});
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new IdentityPlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        KieSession ksession = kBase.newKieSession(null, env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Person bobba = new Person("bobba fet", 50);
        ksession.insert((Object)bobba);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Person darth = new Person("darth vadar", 200);
        ksession.insert((Object)darth);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Cheese stilton = new Cheese("stilton", 5);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.retract(ksession.getFactHandle((Object)stilton));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Cheese brie = new Cheese("brie", 18);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        ksession.retract(ksession.getFactHandle((Object)stilton));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        ksession.retract(ksession.getFactHandle((Object)bobba));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        ksession.retract(ksession.getFactHandle((Object)brie));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(5);
    }

    @Test
    public void testExists() throws Exception {
        String header = "package org.drools.compiler.test;\nimport java.util.List;\nimport " + Person.class.getCanonicalName() + "\nimport " + Cheese.class.getCanonicalName() + "\nglobal java.util.List list;\n";
        String rule1 = "rule \"not rule test\"\nsalience 10\nwhen\n    Person()\n    exists Cheese( price >= 5 )\nthen\n    list.add( new Integer( 5 ) );\nend\n";
        KieBase kBase = this.loadKnowledgeBaseFromString(new String[]{header + rule1});
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new IdentityPlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        KieSession ksession = kBase.newKieSession(null, env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Person bobba = new Person("bobba fet", 50);
        ksession.insert((Object)bobba);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Person darth = new Person("darth vadar", 200);
        ksession.insert((Object)darth);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Cheese stilton = new Cheese("stilton", 5);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.retract(ksession.getFactHandle((Object)stilton));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Cheese brie = new Cheese("brie", 18);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        ksession.retract(ksession.getFactHandle((Object)stilton));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        ksession.retract(ksession.getFactHandle((Object)bobba));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        ksession.retract(ksession.getFactHandle((Object)brie));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.insert((Object)stilton);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(5);
    }

    @Test
    public void testTruthMaintenance() throws Exception {
        String header = "package org.drools.compiler.test;\nimport java.util.List;\nimport " + Person.class.getCanonicalName() + "\nimport " + Cheese.class.getCanonicalName() + "\nglobal Cheese cheese;\nglobal Person person;\nglobal java.util.List list;\n";
        String rule1 = "rule \"not person then cheese\"\nwhen \n    not Person() \nthen \n    if (list.size() < 3) { \n        list.add(new Integer(0)); \n        insertLogical( cheese ); \n    }\n    drools.halt();\nend\n";
        String rule2 = "rule \"if cheese then person\"\nwhen\n    Cheese()\nthen\n    if (list.size() < 3) {\n        list.add(new Integer(0));\n        insertLogical( person );\n    }\n    drools.halt();\nend\n";
        KieBase kBase = this.loadKnowledgeBaseFromString(new String[]{header + rule1 + rule2});
        KieSession ksession = kBase.newKieSession();
        ArrayList list = new ArrayList();
        Person person = new Person("person");
        Cheese cheese = new Cheese("cheese", 0);
        ksession.setGlobal("cheese", (Object)cheese);
        ksession.setGlobal("person", (Object)person);
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
    }

    @Test
    public void testActivationGroups() throws Exception {
        Object rule1 = "package org.drools.compiler.test;\n";
        rule1 = (String)rule1 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule1 = (String)rule1 + "global java.util.List list\n";
        rule1 = (String)rule1 + "rule \"Rule 1\"\n";
        rule1 = (String)rule1 + "    activation-group \"activation-group-1\"\n";
        rule1 = (String)rule1 + "when\n";
        rule1 = (String)rule1 + "    $c : Cheese( ) \n";
        rule1 = (String)rule1 + "then\n";
        rule1 = (String)rule1 + "    list.add( \"rule1\" );\n";
        rule1 = (String)rule1 + "    drools.halt();\n";
        rule1 = (String)rule1 + "end";
        Object rule2 = "package org.drools.compiler.test;\n";
        rule2 = (String)rule2 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule2 = (String)rule2 + "global java.util.List list\n";
        rule2 = (String)rule2 + "rule \"Rule 2\"\n";
        rule2 = (String)rule2 + "    salience 10\n";
        rule2 = (String)rule2 + "    activation-group \"activation-group-1\"\n";
        rule2 = (String)rule2 + "when\n";
        rule2 = (String)rule2 + "    $c : Cheese( ) \n";
        rule2 = (String)rule2 + "then\n";
        rule2 = (String)rule2 + "    list.add( \"rule2\" );\n";
        rule2 = (String)rule2 + "    drools.halt();\n";
        rule2 = (String)rule2 + "end";
        Object rule3 = "package org.drools.compiler.test;\n";
        rule3 = (String)rule3 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule3 = (String)rule3 + "global java.util.List list\n";
        rule3 = (String)rule3 + "rule \"Rule 3\"\n";
        rule3 = (String)rule3 + "    activation-group \"activation-group-1\"\n";
        rule3 = (String)rule3 + "when\n";
        rule3 = (String)rule3 + "    $c : Cheese( ) \n";
        rule3 = (String)rule3 + "then\n";
        rule3 = (String)rule3 + "    list.add( \"rule3\" );\n";
        rule3 = (String)rule3 + "    drools.halt();\n";
        rule3 = (String)rule3 + "end";
        Object rule4 = "package org.drools.compiler.test;\n";
        rule4 = (String)rule4 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule4 = (String)rule4 + "global java.util.List list\n";
        rule4 = (String)rule4 + "rule \"Rule 4\"\n";
        rule4 = (String)rule4 + "    activation-group \"activation-group-2\"\n";
        rule4 = (String)rule4 + "when\n";
        rule4 = (String)rule4 + "    $c : Cheese( ) \n";
        rule4 = (String)rule4 + "then\n";
        rule4 = (String)rule4 + "    list.add( \"rule4\" );\n";
        rule4 = (String)rule4 + "    drools.halt();\n";
        rule4 = (String)rule4 + "end";
        KieBase kBase = this.loadKnowledgeBaseFromString(new String[]{rule1, rule2, rule3, rule4});
        KieSession ksession = kBase.newKieSession();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        ksession.insert((Object)brie);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"rule2");
        Assertions.assertThat(list.get(1)).isEqualTo((Object)"rule4");
    }

    @Test
    public void testAgendaGroups() throws Exception {
        Object rule1 = "package org.drools.compiler.test;\n";
        rule1 = (String)rule1 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule1 = (String)rule1 + "global java.util.List list\n";
        rule1 = (String)rule1 + "rule \"Rule 1\"\n";
        rule1 = (String)rule1 + "    agenda-group \"agenda-group-1\"\n";
        rule1 = (String)rule1 + "when\n";
        rule1 = (String)rule1 + "    $c : Cheese( ) \n";
        rule1 = (String)rule1 + "then\n";
        rule1 = (String)rule1 + "    list.add( \"rule1\" );\n";
        rule1 = (String)rule1 + "    drools.halt();\n";
        rule1 = (String)rule1 + "end";
        Object rule2 = "package org.drools.compiler.test;\n";
        rule2 = (String)rule2 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule2 = (String)rule2 + "global java.util.List list\n";
        rule2 = (String)rule2 + "rule \"Rule 2\"\n";
        rule2 = (String)rule2 + "    salience 10\n";
        rule2 = (String)rule2 + "    agenda-group \"agenda-group-1\"\n";
        rule2 = (String)rule2 + "when\n";
        rule2 = (String)rule2 + "    $c : Cheese( ) \n";
        rule2 = (String)rule2 + "then\n";
        rule2 = (String)rule2 + "    list.add( \"rule2\" );\n";
        rule2 = (String)rule2 + "    drools.halt();\n";
        rule2 = (String)rule2 + "end";
        Object rule3 = "package org.drools.compiler.test;\n";
        rule3 = (String)rule3 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule3 = (String)rule3 + "global java.util.List list\n";
        rule3 = (String)rule3 + "rule \"Rule 3\"\n";
        rule3 = (String)rule3 + "    salience 10\n";
        rule3 = (String)rule3 + "    agenda-group \"agenda-group-2\"\n";
        rule3 = (String)rule3 + "    activation-group \"activation-group-2\"\n";
        rule3 = (String)rule3 + "when\n";
        rule3 = (String)rule3 + "    $c : Cheese( ) \n";
        rule3 = (String)rule3 + "then\n";
        rule3 = (String)rule3 + "    list.add( \"rule3\" );\n";
        rule3 = (String)rule3 + "    drools.halt();\n";
        rule3 = (String)rule3 + "end";
        Object rule4 = "package org.drools.compiler.test;\n";
        rule4 = (String)rule4 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule4 = (String)rule4 + "global java.util.List list\n";
        rule4 = (String)rule4 + "rule \"Rule 4\"\n";
        rule4 = (String)rule4 + "    agenda-group \"agenda-group-2\"\n";
        rule4 = (String)rule4 + "    activation-group \"activation-group-2\"\n";
        rule4 = (String)rule4 + "when\n";
        rule4 = (String)rule4 + "    $c : Cheese( ) \n";
        rule4 = (String)rule4 + "then\n";
        rule4 = (String)rule4 + "    list.add( \"rule4\" );\n";
        rule4 = (String)rule4 + "    drools.halt();\n";
        rule4 = (String)rule4 + "end";
        KieBase kBase = this.loadKnowledgeBaseFromString(new String[]{rule1, rule2, rule3, rule4});
        KieSession ksession = kBase.newKieSession();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        ksession.insert((Object)brie);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.getAgenda().getAgendaGroup("agenda-group-1").setFocus();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"rule2");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.getAgenda().getAgendaGroup("agenda-group-2").setFocus();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat(list.get(1)).isEqualTo((Object)"rule3");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat(list.get(2)).isEqualTo((Object)"rule1");
    }

    @Test
    public void testRuleFlowGroups() throws Exception {
        Object rule1 = "package org.drools.compiler.test;\n";
        rule1 = (String)rule1 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule1 = (String)rule1 + "global java.util.List list\n";
        rule1 = (String)rule1 + "rule \"Rule 1\"\n";
        rule1 = (String)rule1 + "    ruleflow-group \"ruleflow-group-1\"\n";
        rule1 = (String)rule1 + "when\n";
        rule1 = (String)rule1 + "    $c : Cheese( ) \n";
        rule1 = (String)rule1 + "then\n";
        rule1 = (String)rule1 + "    list.add( \"rule1\" );\n";
        rule1 = (String)rule1 + "    drools.halt();\n";
        rule1 = (String)rule1 + "end";
        Object rule2 = "package org.drools.compiler.test;\n";
        rule2 = (String)rule2 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule2 = (String)rule2 + "global java.util.List list\n";
        rule2 = (String)rule2 + "rule \"Rule 2\"\n";
        rule2 = (String)rule2 + "    salience 10\n";
        rule2 = (String)rule2 + "    ruleflow-group \"ruleflow-group-1\"\n";
        rule2 = (String)rule2 + "when\n";
        rule2 = (String)rule2 + "    $c : Cheese( ) \n";
        rule2 = (String)rule2 + "then\n";
        rule2 = (String)rule2 + "    list.add( \"rule2\" );\n";
        rule2 = (String)rule2 + "    drools.halt();\n";
        rule2 = (String)rule2 + "end";
        Object rule3 = "package org.drools.compiler.test;\n";
        rule3 = (String)rule3 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule3 = (String)rule3 + "global java.util.List list\n";
        rule3 = (String)rule3 + "rule \"Rule 3\"\n";
        rule3 = (String)rule3 + "    salience 10\n";
        rule3 = (String)rule3 + "    ruleflow-group \"ruleflow-group-2\"\n";
        rule3 = (String)rule3 + "    activation-group \"activation-group-2\"\n";
        rule3 = (String)rule3 + "when\n";
        rule3 = (String)rule3 + "    $c : Cheese( ) \n";
        rule3 = (String)rule3 + "then\n";
        rule3 = (String)rule3 + "    list.add( \"rule3\" );\n";
        rule3 = (String)rule3 + "    drools.halt();\n";
        rule3 = (String)rule3 + "end";
        Object rule4 = "package org.drools.compiler.test;\n";
        rule4 = (String)rule4 + "import " + Cheese.class.getCanonicalName() + "\n";
        rule4 = (String)rule4 + "global java.util.List list\n";
        rule4 = (String)rule4 + "rule \"Rule 4\"\n";
        rule4 = (String)rule4 + "    ruleflow-group \"ruleflow-group-2\"\n";
        rule4 = (String)rule4 + "    activation-group \"activation-group-2\"\n";
        rule4 = (String)rule4 + "when\n";
        rule4 = (String)rule4 + "    $c : Cheese( ) \n";
        rule4 = (String)rule4 + "then\n";
        rule4 = (String)rule4 + "    list.add( \"rule4\" );\n";
        rule4 = (String)rule4 + "    drools.halt();\n";
        rule4 = (String)rule4 + "end";
        KieBase kbase = this.loadKnowledgeBaseFromString(new String[]{rule1, rule2, rule3, rule4});
        StatefulKnowledgeSession ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(kbase.newKieSession(), true);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, true);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        ksession.insert((Object)brie);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, true);
        ((InternalAgenda)ksession.getAgenda()).activateRuleFlowGroup("ruleflow-group-1");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"rule2");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, true);
        ((InternalAgenda)ksession.getAgenda()).activateRuleFlowGroup("ruleflow-group-2");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat(list.get(1)).isEqualTo((Object)"rule3");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat(list.get(2)).isEqualTo((Object)"rule1");
    }

    @Test
    public void testAccumulate() throws Exception {
        String rule = "package org.drools\nimport " + Message.class.getCanonicalName() + "\nglobal java.util.List results\nrule MyRule\n  when\n    $n : Number( intValue >= 2 ) from accumulate ( m: Message( ), count( m ) )\n  then\n    results.add($n);\nend";
        KieBase kBase = this.loadKnowledgeBaseFromString(new String[]{rule});
        StatefulKnowledgeSession ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(kBase.newKieSession(), true);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, true);
        ksession.setGlobal("results", new ArrayList());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, true);
        ksession.insert((Object)new Message());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, true);
        List results = (List)ksession.getGlobal("results");
        ksession.insert((Object)new Message());
        ksession.insert((Object)new Message());
        ksession.fireAllRules();
        Assertions.assertThat((int)((Number)results.get(0)).intValue()).isEqualTo(3);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, true);
        ksession.insert((Object)new Message());
        ksession.insert((Object)new Message());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, true);
        Assertions.assertThat((int)((InternalAgenda)ksession.getAgenda()).getAgendaGroupsManager().agendaSize()).isEqualTo(1);
        ksession.fireAllRules();
        Assertions.assertThat((int)((Number)results.get(1)).intValue()).isEqualTo(5);
    }

    @Test
    public void testAccumulate2() throws Exception {
        String str = "package org.drools\n\nimport " + Message.class.getCanonicalName() + "\nrule MyRule\n  when\n    Number( intValue >= 5 ) from accumulate ( m: Message( ), count( m ) )\n  then\n    System.out.println(\"Found messages\");\nend\n";
        KieBase kBase = this.loadKnowledgeBaseFromString(new String[]{str});
        KieSession ksession = kBase.newKieSession();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.insert((Object)new Message());
        ksession.insert((Object)new Message());
        ksession.insert((Object)new Message());
        ksession.insert((Object)new Message());
        ksession.insert((Object)new Message());
        ((InternalWorkingMemory)ksession).flushPropagations();
        Assertions.assertThat((int)((InternalAgenda)ksession.getAgenda()).getAgendaGroupsManager().agendaSize()).isEqualTo(1);
    }

    @Test
    public void testAccumulateSessionSerialization() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"test_AccumulateSerialization.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Cheese("stilton", 10));
        ksession.insert((Object)new Cheese("brie", 5));
        ksession.insert((Object)new Cheese("provolone", 150));
        ksession.insert((Object)new Cheese("brie", 20));
        ksession.insert((Object)new Person("Bob", "brie"));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(1);
        Assertions.assertThat((int)((Number)results.get(0)).intValue()).isEqualTo(25);
    }

    @Test
    @Ignore
    public void testDroolsObjectOutputInputStream() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"org/drools/compiler/integrationtests/test_Serializable.drl"});
        KieSession session = kbase.newKieSession();
        Person bob = new Person();
        session.insert((Object)bob);
        ((ObjectAssert)Assertions.assertThat((Object)bob).as("these two object references should be same", new Object[0])).isSameAs(session.getObjects().iterator().next());
        Marshaller marshaller = this.createSerializableMarshaller(kbase);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DroolsObjectOutputStream out = new DroolsObjectOutputStream((OutputStream)baos);
        out.writeObject(bob);
        out.writeObject(kbase);
        marshaller.marshall((OutputStream)out, session);
        out.flush();
        out.close();
        DroolsObjectInputStream in = new DroolsObjectInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        Person deserializedBob = (Person)in.readObject();
        kbase = (InternalKnowledgeBase)in.readObject();
        marshaller = this.createSerializableMarshaller(kbase);
        session = marshaller.unmarshall((InputStream)in);
        ((ObjectAssert)Assertions.assertThat((Object)deserializedBob).as("these two object references should be same", new Object[0])).isSameAs(session.getObjects().iterator().next());
        in.close();
    }

    @Test
    public void testAccumulateSerialization() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"org/drools/serialization/protobuf/test_SerializableAccumulate.drl"});
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("results", new ArrayList());
        Cheese t1 = new Cheese("brie", 10);
        Cheese t2 = new Cheese("brie", 15);
        Cheese t3 = new Cheese("stilton", 20);
        Cheese t4 = new Cheese("brie", 30);
        ksession.insert((Object)t1);
        ksession.insert((Object)t2);
        ksession.insert((Object)t3);
        ksession.insert((Object)t4);
        Marshaller marshaller = this.createSerializableMarshaller(kbase);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DroolsObjectOutputStream out = new DroolsObjectOutputStream((OutputStream)baos);
        marshaller.marshall((OutputStream)out, ksession);
        out.flush();
        out.close();
        DroolsObjectInputStream in = new DroolsObjectInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        marshaller = this.createSerializableMarshaller(kbase);
        ksession = marshaller.unmarshall((InputStream)in);
        in.close();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Assertions.assertThat(results).isNotNull();
        ksession.fireAllRules();
        ksession.dispose();
        Assertions.assertThat((int)results.size()).isEqualTo(1);
        Assertions.assertThat((int)((List)results.get(0)).size()).isEqualTo(3);
    }

    @Test
    public void testMarshallWithNot() throws Exception {
        String str = "import " + ((Object)((Object)this)).getClass().getCanonicalName() + ".*\nrule one\nwhen\n   A()\n   not(B())\nthen\nSystem.out.println(\"a\");\nend\n\nrule two\nwhen\n   A()\nthen\nSystem.out.println(\"b\");\nend\n";
        KieBaseConfiguration config = RuleBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((Option)EventProcessingOption.STREAM);
        KieBase kBase = this.loadKnowledgeBaseFromString(config, new String[]{str});
        KieSession ksession = kBase.newKieSession();
        ksession.insert((Object)new A());
        MarshallerFactory.newMarshaller((KieBase)kBase).marshall((OutputStream)new ByteArrayOutputStream(), ksession);
    }

    @Test
    public void testMarshallEvents() throws Exception {
        String str = "import " + ((Object)((Object)this)).getClass().getCanonicalName() + ".*\ndeclare A\n @role( event )\n @expires( 10m )\nend\ndeclare B\n @role( event )\n @expires( 10m )\nend\nrule one\nwhen\n   $a : A()\n   B(this after $a)\nthen\ninsert(new C());end\n";
        KieBaseConfiguration config = RuleBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((Option)EventProcessingOption.STREAM);
        KieBase kBase = this.loadKnowledgeBaseFromString(config, new String[]{str});
        KieSessionConfiguration ksconf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((Option)ClockTypeOption.PSEUDO);
        ksconf.setOption((Option)TimerJobFactoryOption.get((String)"trackable"));
        KieSession ksession = kBase.newKieSession(ksconf, null);
        ksession.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        ksession.insert((Object)new B());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(2);
    }

    @Test
    @Ignore(value="This test is suspicious to say the least...")
    public void testScheduledActivation() {
        InternalKnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        InternalKnowledgePackage impl = CoreComponentFactory.get().createKnowledgePackage("test");
        BuildContext buildContext = new BuildContext((RuleBase)knowledgeBase, Collections.emptyList());
        RuleImpl rule = new RuleImpl("test-rule");
        new RuleTerminalNode(1, (LeftTupleSource)new MockTupleSource(2, buildContext), rule, rule.getLhs(), 0, buildContext);
        final ArrayList fired = new ArrayList();
        rule.setConsequence(new Consequence(){

            public void evaluate(KnowledgeHelper knowledgeHelper, ReteEvaluator reteEvaluator) throws Exception {
                fired.add("a");
            }

            public String getName() {
                return "default";
            }
        });
        rule.setTimer((Timer)new DurationTimer(10000L));
        rule.setPackage("test");
        impl.addRule(rule);
        knowledgeBase.addPackages(Collections.singleton(impl));
        SessionConfiguration config = (SessionConfiguration)KieServices.get().newKieSessionConfiguration().as(SessionConfiguration.KEY);
        config.setClockType(ClockType.PSEUDO_CLOCK);
        KieSession ksession = knowledgeBase.newKieSession((KieSessionConfiguration)config, KieServices.get().newEnvironment());
        PseudoClockScheduler scheduler = (PseudoClockScheduler)ksession.getSessionClock();
        Marshaller marshaller = MarshallerFactory.newMarshaller((KieBase)knowledgeBase);
        ksession.insert((Object)"cheese");
        Assertions.assertThat((boolean)fired.isEmpty()).isTrue();
        this.readWrite((KieBase)knowledgeBase, ksession, (KieSessionConfiguration)config);
        Assertions.assertThat((boolean)fired.isEmpty()).isTrue();
        scheduler.advanceTime(12L, TimeUnit.SECONDS);
        Assertions.assertThat((boolean)fired.isEmpty()).isFalse();
    }

    @Test
    public void testMarshallEntryPointsWithExpires() throws Exception {
        String str = "package org.domain.test \nimport " + ((Object)((Object)this)).getClass().getCanonicalName() + ".*\nglobal java.util.List list\ndeclare A\n @role( event )\n @expires( 10s )\nend\ndeclare B\n @role( event )\n @expires( 10s )\nend\ndeclare C\n @role( event )\n @expires( 15s )\nend\nrule a1\nwhen\n   $a : A() from entry-point 'a-ep'\nthen\nlist.add( $a );end\nrule b1\nwhen\n   $b : B() from entry-point 'b-ep'\nthen\nlist.add( $b );end\nrule c1\nwhen\n   $c : C() from entry-point 'c-ep'\nthen\nlist.add( $c );end\n";
        KieBaseConfiguration config = RuleBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((Option)EventProcessingOption.STREAM);
        KieBase kBase = this.loadKnowledgeBaseFromString(config, new String[]{str});
        KieSessionConfiguration ksconf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((Option)ClockTypeOption.PSEUDO);
        ksconf.setOption((Option)TimerJobFactoryOption.get((String)"trackable"));
        KieSession ksession = kBase.newKieSession(ksconf, null);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        EntryPoint aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        EntryPoint bep = ksession.getEntryPoint("b-ep");
        bep.insert((Object)new B());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        EntryPoint cep = ksession.getEntryPoint("c-ep");
        cep.insert((Object)new C());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        ksession.fireAllRules();
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        aep = ksession.getEntryPoint("a-ep");
        Assertions.assertThat((int)aep.getFactHandles().size()).isEqualTo(1);
        bep = ksession.getEntryPoint("b-ep");
        Assertions.assertThat((int)bep.getFactHandles().size()).isEqualTo(1);
        cep = ksession.getEntryPoint("c-ep");
        Assertions.assertThat((int)cep.getFactHandles().size()).isEqualTo(1);
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        timeService.advanceTime(11L, TimeUnit.SECONDS);
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        ksession.fireAllRules();
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        aep = ksession.getEntryPoint("a-ep");
        Assertions.assertThat((int)aep.getFactHandles().size()).isEqualTo(0);
        bep = ksession.getEntryPoint("b-ep");
        Assertions.assertThat((int)bep.getFactHandles().size()).isEqualTo(0);
        cep = ksession.getEntryPoint("c-ep");
        Assertions.assertThat((int)cep.getFactHandles().size()).isEqualTo(1);
    }

    @Test
    public void testMarshallEntryPointsWithNot() throws Exception {
        String str = "package org.domain.test \nimport " + ((Object)((Object)this)).getClass().getCanonicalName() + ".*\nglobal java.util.List list\ndeclare A\n @role( event )\n @expires( 10m )\nend\ndeclare B\n @role( event )\n @expires( 10m )\nend\nrule a1\nwhen\n   $a : A() from entry-point 'a-ep'\n   not B( this after[0s, 10s] $a) from entry-point 'a-ep'\nthen\nlist.add( $a );end\n";
        KieBaseConfiguration config = RuleBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((Option)EventProcessingOption.STREAM);
        KieBase kBase = this.loadKnowledgeBaseFromString(config, new String[]{str});
        KieSessionConfiguration ksconf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((Option)ClockTypeOption.PSEUDO);
        ksconf.setOption((Option)TimerJobFactoryOption.get((String)"trackable"));
        KieSession ksession = kBase.newKieSession(ksconf, null);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        EntryPoint aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        timeService.advanceTime(3L, TimeUnit.SECONDS);
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        ksession.fireAllRules();
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        Assertions.assertThat((int)list.size()).isEqualTo(0);
    }

    @Test
    @Ignore(value="beta4 phreak")
    public void testMarshallEntryPointsWithSlidingTimeWindow() throws Exception {
        String str = "package org.domain.test \nimport " + ((Object)((Object)this)).getClass().getCanonicalName() + ".*\nimport java.util.List\nglobal java.util.List list\ndeclare A\n @role( event )\n @expires( 10m )\nend\ndeclare B\n @role( event )\n @expires( 10m )\nend\nrule a1\nwhen\n   $l : List() from collect( A()  over window:time(30s) from entry-point 'a-ep') \nthen\n   list.add( $l );end\n";
        KieBaseConfiguration conf = RuleBaseFactory.newKnowledgeBaseConfiguration();
        conf.setOption((Option)EventProcessingOption.STREAM);
        KieBase kbase = this.loadKnowledgeBaseFromString(conf, new String[]{str});
        KieSessionConfiguration ksconf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((Option)ClockTypeOption.PSEUDO);
        ksconf.setOption((Option)TimerJobFactoryOption.get((String)"trackable"));
        KieSession ksession = this.createKnowledgeSession(kbase, ksconf);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        EntryPoint aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        list.clear();
        ksession.fireAllRules();
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        Assertions.assertThat((int)((List)list.get(0)).size()).isEqualTo(2);
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        timeService.advanceTime(15L, TimeUnit.SECONDS);
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        list.clear();
        ksession.fireAllRules();
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        Assertions.assertThat((int)((List)list.get(0)).size()).isEqualTo(4);
        timeService = (PseudoClockScheduler)ksession.getSessionClock();
        timeService.advanceTime(20L, TimeUnit.SECONDS);
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        list.clear();
        ksession.fireAllRules();
        Assertions.assertThat((int)((List)list.get(0)).size()).isEqualTo(2);
    }

    @Test
    public void testMarshallEntryPointsWithSlidingLengthWindow() throws Exception {
        String str = "package org.domain.test \nimport " + ((Object)((Object)this)).getClass().getCanonicalName() + ".*\nimport java.util.List\nglobal java.util.List list\ndeclare A\n @role( event )\n @expires( 10m )\nend\ndeclare B\n @role( event )\n @expires( 10m )\nend\nrule a1\nwhen\n   $l : List() from collect( A()  over window:length(3) from entry-point 'a-ep') \nthen\n   list.add( $l );end\n";
        KieBaseConfiguration conf = RuleBaseFactory.newKnowledgeBaseConfiguration();
        conf.setOption((Option)EventProcessingOption.STREAM);
        KieBase kbase = this.loadKnowledgeBaseFromString(conf, new String[]{str});
        KieSessionConfiguration ksconf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((Option)ClockTypeOption.PSEUDO);
        ksconf.setOption((Option)TimerJobFactoryOption.get((String)"trackable"));
        KieSession ksession = this.createKnowledgeSession(kbase, ksconf);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        EntryPoint aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        list.clear();
        ksession.fireAllRules();
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        Assertions.assertThat((int)((List)list.get(0)).size()).isEqualTo(2);
        aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        list.clear();
        ksession.fireAllRules();
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        Assertions.assertThat((int)((List)list.get(0)).size()).isEqualTo(3);
    }

    @Test
    public void testMarshalWithProtoBuf() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"test_Serializable.drl"});
        KieSession ksession = kbase.newKieSession();
        ksession.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        ksession.insert((Object)bob);
        ksession = this.marsallStatefulKnowledgeSession(ksession);
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(1L);
        Assertions.assertThat(ksession.getObjects().iterator().next()).isEqualTo((Object)bob);
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(3);
        List list = (List)ksession.getGlobal("list");
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)4);
        Collection facts = ksession.getObjects();
        System.out.println(new ArrayList(facts));
        Assertions.assertThat((int)facts.size()).isEqualTo(2);
    }

    private KieSession marsallStatefulKnowledgeSession(KieSession ksession) throws IOException, ClassNotFoundException {
        Globals globals = ksession.getGlobals();
        KieBase kbase = ksession.getKieBase();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MarshallerFactory.newMarshaller((KieBase)kbase).marshall((OutputStream)out, ksession);
        KieSessionConfiguration ksconf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((Option)TimerJobFactoryOption.get((String)"trackable"));
        ksconf.setOption((Option)ClockTypeOption.PSEUDO);
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.Globals", (Object)globals);
        ksession = MarshallerFactory.newMarshaller((KieBase)kbase).unmarshall((InputStream)new ByteArrayInputStream(out.toByteArray()), ksconf, env);
        return ksession;
    }

    private void readWrite(KieBase knowledgeBase, KieSession ksession, KieSessionConfiguration config) {
        try {
            Marshaller marshaller = MarshallerFactory.newMarshaller((KieBase)knowledgeBase);
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            marshaller.marshall((OutputStream)o, ksession);
            ksession = marshaller.unmarshall((InputStream)new ByteArrayInputStream(o.toByteArray()), config, KieServices.get().newEnvironment());
            ksession.fireAllRules();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Marshaller createSerializableMarshaller(KieBase knowledgeBase) {
        ObjectMarshallingStrategyAcceptor acceptor = MarshallerFactory.newClassFilterAcceptor((String[])new String[]{"*.*"});
        ObjectMarshallingStrategy strategy = MarshallerFactory.newSerializeMarshallingStrategy((ObjectMarshallingStrategyAcceptor)acceptor);
        Marshaller marshaller = MarshallerFactory.newMarshaller((KieBase)knowledgeBase, (ObjectMarshallingStrategy[])new ObjectMarshallingStrategy[]{strategy});
        return marshaller;
    }

    @Test
    public void testMarshallWithCollects() throws Exception {
        String str = "import java.util.Collection\nrule R1 when\n    Collection(empty==false) from collect( Integer() )\n    Collection() from collect( String() )\nthen\nend\nrule R2 when then end\n";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = kbase.newKieSession();
        try {
            Marshaller marshaller = MarshallerFactory.newMarshaller((KieBase)kbase);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            marshaller.marshall((OutputStream)baos, ksession);
            marshaller = MarshallerFactory.newMarshaller((KieBase)kbase);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            baos.close();
            ksession = marshaller.unmarshall((InputStream)bais);
            bais.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("unexpected exception :" + e.getMessage()));
        }
    }

    @Test
    public void testMarshallWithTimedRule() {
        String drl = "rule \"Rule A Timeout\"\nwhen\n    String( this == \"ATrigger\" )\nthen\n   insert (new String( \"A-Timer\") );\nend\n\nrule \"Timer For rule A Timeout\"\n    timer ( int: 5s )\nwhen\n   String( this == \"A-Timer\")\nthen\n   delete ( \"A-Timer\" );\n   delete ( \"ATrigger\" );\nend\n";
        KieBase kbase = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[]{EqualityBehaviorOption.EQUALITY, DeclarativeAgendaOption.ENABLED, EventProcessingOption.STREAM});
        KieSessionConfiguration sessionConfig = RuleBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((Option)ClockTypeOption.PSEUDO);
        KieSession ksession = kbase.newKieSession(sessionConfig, null);
        ksession.insert((Object)"ATrigger");
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(1L);
        ksession.fireAllRules();
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(2L);
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(4L, TimeUnit.SECONDS);
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(2L);
        ksession.fireAllRules();
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(2L);
        ksession = MarshallingTest.marshallAndUnmarshall(kbase, ksession, sessionConfig);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(4L, TimeUnit.SECONDS);
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(2L);
        ksession.fireAllRules();
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(0L);
    }

    @Test
    @Ignore(value="Reproduces with pseudoclock. It takes too long with system clock")
    public void testMarshallWithTimedRuleRealClock() {
        String drl = "rule \"Rule A Timeout\"\nwhen\n    String( this == \"ATrigger\" )\nthen\n   insert (new String( \"A-Timer\") );\nend\n\nrule \"Timer For rule A Timeout\"\n    timer ( int: 5s )\nwhen\n   String( this == \"A-Timer\")\nthen\n   delete ( \"A-Timer\" );\n   delete ( \"ATrigger\" );\nend\n";
        KieBase kbase = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[]{EqualityBehaviorOption.EQUALITY, DeclarativeAgendaOption.ENABLED, EventProcessingOption.STREAM});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)"ATrigger");
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(1L);
        ksession.fireAllRules();
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(2L);
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(2L);
        ksession.fireAllRules();
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(2L);
        ksession = MarshallingTest.marshallAndUnmarshall(kbase, ksession, null);
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(2L);
        ksession.fireAllRules();
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(0L);
    }

    public static KieSession marshallAndUnmarshall(KieBase kbase, KieSession ksession, KieSessionConfiguration sessionConfig) {
        return MarshallingTest.marshallAndUnmarshall(kbase, kbase, ksession, sessionConfig);
    }

    public static KieSession marshallAndUnmarshall(KieBase kbase1, KieBase kbase2, KieSession ksession, KieSessionConfiguration sessionConfig) {
        try {
            KieMarshallers kieMarshallers = KieServices.Factory.get().getMarshallers();
            Marshaller marshaller = kieMarshallers.newMarshaller(kbase1);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            marshaller.marshall((OutputStream)baos, ksession);
            marshaller = kieMarshallers.newMarshaller(kbase2);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            baos.close();
            ksession = marshaller.unmarshall((InputStream)bais, sessionConfig, null);
            bais.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("unexpected exception :" + e.getMessage()));
        }
        return ksession;
    }

    @Test
    public void testSnapshotRecoveryScheduledRulesPlain() throws Exception {
        String drl = "package com.drools.restore.reproducer\nglobal java.util.List list;\nglobal java.util.List list2;\nrule R1\n timer (int: 20s)\n when\n   $m : String( this == \"Hello World1\" )\n then\n   list.add( $m );\n   retract( $m );\nend\nrule R2\n timer (int: 30s)\n when\n   $m : String( this == \"Hello World2\" )\n then\n   list2.add( $m );\n   retract( $m );\nend\n";
        KieSessionConfiguration ksconf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((Option)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        ksconf.setOption((Option)TimedRuleExecutionOption.YES);
        ksconf.setOption((Option)TimerJobFactoryOption.get((String)"trackable"));
        ksconf.setOption((Option)ClockTypeOption.PSEUDO);
        KieBase kbase1 = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[]{EventProcessingOption.STREAM});
        KieSession ksession = kbase1.newKieSession(ksconf, null);
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ArrayList list2 = new ArrayList();
        ksession.setGlobal("list2", list2);
        ksession.insert((Object)"Hello World1");
        ksession.insert((Object)"Hello World2");
        ksession.fireAllRules();
        timeService.advanceTime(10500L, TimeUnit.MILLISECONDS);
        KieBase kbase2 = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[]{EventProcessingOption.STREAM});
        ksession = MarshallingTest.marshallAndUnmarshall(kbase1, kbase2, ksession, ksconf);
        ksession.setGlobal("list", list);
        ksession.setGlobal("list2", list2);
        PseudoClockScheduler timeService2 = (PseudoClockScheduler)ksession.getSessionClock();
        ksession.fireAllRules();
        long accumulatedSleepTime = 0L;
        for (int i = 0; i < 6; ++i) {
            timeService2.advanceTime(5050L, TimeUnit.MILLISECONDS);
            accumulatedSleepTime += 5050L;
            Assertions.assertThat((int)list.size()).isEqualTo(i < 1 ? 0 : 1);
            Assertions.assertThat((int)list2.size()).isEqualTo(i < 3 ? 0 : 1);
        }
    }

    @Test
    public void testKsessionSerializationWithInsertLogical() {
        ArrayList firedRules = new ArrayList();
        String str = "import java.util.Date;\nimport " + Promotion.class.getCanonicalName() + ";\n\ndeclare Person\n\tname : String\n\tdateOfBirth : Date\nend\n\ndeclare Employee extends Person\n\tjob : String\nend\n\nrule \"Insert Alice\"\n\twhen\n\tthen\n\t\tEmployee alice = new Employee(\"Alice\", new Date(1973, 7, 2), \"Vet\");\n\t\tinsert(alice);\n\t\tSystem.out.println(\"Insert Alice\");\nend\n\nrule \"Insert Bob\"\n\twhen\n\t\tPerson(name == \"Alice\")\n\tthen\n\t\tPerson bob = new Person(\"Bob\", new Date(1973, 7, 2));\n\t\tinsertLogical(bob);\n\t\tSystem.out.println(\"InsertLogical Bob\");\nend\n\nrule \"Insert Claire\"\n\twhen\n\t\tPerson(name == \"Bob\")\n\tthen\n\t\tEmployee claire = new Employee(\"Claire\", new Date(1973, 7, 2), \"Student\");\n\t\tinsert(claire);\n\t\tSystem.out.println(\"Insert Claire\");\nend\n\nrule \"Promote\"\n\twhen\n\t\tp : Promotion(n : name, j : job)\n\t\te : Employee(name == n)\n\tthen\n\t\tmodify(e) {\n\t\t\tsetJob(j)\n\t\t}\n\t\tdelete(p);\n\t\tSystem.out.printf(\"Promoted %s to %s%n\", n, j);\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.fireAllRules();
        try {
            Marshaller marshaller = MarshallerFactory.newMarshaller((KieBase)kbase);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            marshaller.marshall((OutputStream)baos, ksession);
            marshaller = MarshallerFactory.newMarshaller((KieBase)kbase);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            baos.close();
            ksession = marshaller.unmarshall((InputStream)bais);
            bais.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("unexpected exception :" + e.getMessage()));
        }
        ksession.insert((Object)new Promotion("Claire", "Scientist"));
        int result = ksession.fireAllRules();
        Assertions.assertThat((int)result).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testDisposeAfterMarshall() throws InterruptedException, IOException {
        String str = "package com.sample\nrule R when\n  $s : String()\nthen\n  System.out.println($s);\nend\n";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = kbase.newKieSession();
        CountDownLatch latch = new CountDownLatch(1);
        Thread t = new Thread(() -> {
            System.out.println("Firing.");
            latch.countDown();
            ksession.fireUntilHalt();
            System.out.println("Halted.");
        });
        t.start();
        latch.await();
        Thread.sleep(100L);
        ksession.halt();
        KieMarshallers kMarshallers = KieServices.Factory.get().getMarshallers();
        ObjectMarshallingStrategy oms = kMarshallers.newSerializeMarshallingStrategy();
        Marshaller marshaller = kMarshallers.newMarshaller(kbase, new ObjectMarshallingStrategy[]{oms});
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            marshaller.marshall((OutputStream)baos, ksession);
        }
        ksession.dispose();
        ksession.destroy();
        t.join();
    }

    public static class Promotion {
        private String name;
        private String job;

        public Promotion(String name, String job) {
            this.setName(name);
            this.setJob(job);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getJob() {
            return this.job;
        }

        public void setJob(String job) {
            this.job = job;
        }
    }

    public static class C
    implements Serializable {
        public String toString() {
            return "C[]";
        }
    }

    public static class B
    implements Serializable {
        public String toString() {
            return "B[]";
        }
    }

    public static class A
    implements Serializable {
        public String toString() {
            return "A[]";
        }
    }
}

