/*
 * Decompiled with CFR 0.152.
 */
package org.drools.serialization.protobuf;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.core.ClassObjectFilter;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.common.TruthMaintenanceSystemFactory;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.CheeseEqual;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.Sensor;
import org.drools.serialization.protobuf.SerializationHelper;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class TruthMaintenanceTest
extends CommonTestMethodBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogicalInsertionsDynamicRule() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertionsDynamicRule.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
        Collection kpkgs = kbuilder.getKnowledgePackages();
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kbase.addPackages(kpkgs);
        KieSession ksession = this.createKnowledgeSession((KieBase)kbase);
        try {
            Cheese c1 = new Cheese("a", 1);
            Cheese c2 = new Cheese("b", 2);
            Cheese c3 = new Cheese("c", 3);
            ksession.insert((Object)c1);
            FactHandle h = ksession.insert((Object)c2);
            ksession.insert((Object)c3);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ArrayList list = new ArrayList(ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)));
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            Assertions.assertThat((boolean)list.contains(new Person(c1.getType()))).isFalse();
            Assertions.assertThat((boolean)list.contains(new Person(c2.getType()))).isTrue();
            Assertions.assertThat((boolean)list.contains(new Person(c3.getType()))).isTrue();
            kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertionsDynamicRule2.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
            if (kbuilder.hasErrors()) {
                Assertions.fail((String)kbuilder.getErrors().toString());
            }
            Collection kpkgs2 = kbuilder.getKnowledgePackages();
            kbase.addPackages(kpkgs2);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            kbase = (InternalKnowledgeBase)ksession.getKieBase();
            list = new ArrayList(ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)));
            Assertions.assertThat((int)list.size()).isEqualTo(3);
            Assertions.assertThat((boolean)list.contains(new Person(c1.getType()))).isTrue();
            Assertions.assertThat((boolean)list.contains(new Person(c2.getType()))).isTrue();
            Assertions.assertThat((boolean)list.contains(new Person(c3.getType()))).isTrue();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assertions.assertThat((int)kbase.getKiePackages().size()).isEqualTo(3);
            KiePackage test = null;
            KiePackage test2 = null;
            for (KiePackage kpkg : kbase.getKiePackages()) {
                if (kpkg.getName().equals("org.drools.compiler.test")) {
                    test = kpkg;
                    continue;
                }
                if (!kpkg.getName().equals("org.drools.compiler.test2")) continue;
                test2 = kpkg;
            }
            Assertions.assertThat(test).isNotNull();
            Assertions.assertThat(test2).isNotNull();
            Assertions.assertThat((String)((Rule)test.getRules().iterator().next()).getName()).isEqualTo("rule1");
            Assertions.assertThat((String)((Rule)test2.getRules().iterator().next()).getName()).isEqualTo("rule2");
            kbase.removeRule(test.getName(), ((Rule)test.getRules().iterator().next()).getName());
            for (KiePackage kpkg : kbase.getKiePackages()) {
                if (kpkg.getName().equals("org.drools.compiler.test")) {
                    test = kpkg;
                    continue;
                }
                if (!kpkg.getName().equals("org.drools.compiler.test2")) continue;
                test2 = kpkg;
            }
            Assertions.assertThat((Object)test).isNotNull();
            Assertions.assertThat((Object)test2).isNotNull();
            Assertions.assertThat((int)test.getRules().size()).isEqualTo(0);
            Assertions.assertThat((int)test2.getRules().size()).isEqualTo(1);
            Assertions.assertThat((String)((Rule)test2.getRules().iterator().next()).getName()).isEqualTo("rule2");
            list = new ArrayList(ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)));
            ((AbstractIntegerAssert)Assertions.assertThat((int)list.size()).as("removal of the rule should result in retraction of c3's logical assertion", new Object[0])).isEqualTo(2);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)list.contains(new Person(c1.getType()))).as("c1's logical assertion should not be deleted", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)list.contains(new Person(c2.getType()))).as("c2's logical assertion should  not be deleted", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)list.contains(new Person(c3.getType()))).as("c3's logical assertion should be  deleted", new Object[0])).isFalse();
            c2.setPrice(3);
            h = this.getFactHandle(h, ksession);
            ksession.update(h, (Object)c2);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            list = new ArrayList(ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)));
            ((AbstractIntegerAssert)Assertions.assertThat((int)list.size()).as("c2 now has a higher price, its logical assertion should  be cancelled", new Object[0])).isEqualTo(1);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)list.contains(new Person(c2.getType()))).as("The logical assertion cor c2 should have been deleted", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)list.contains(new Person(c1.getType()))).as("The logical assertion  for c1 should exist", new Object[0])).isTrue();
            for (KiePackage kpkg : kbase.getKiePackages()) {
                if (kpkg.getName().equals("org.drools.compiler.test")) {
                    test = kpkg;
                    continue;
                }
                if (!kpkg.getName().equals("org.drools.compiler.test2")) continue;
                test2 = kpkg;
            }
            Assertions.assertThat((Object)test).isNotNull();
            Assertions.assertThat((Object)test2).isNotNull();
            kbase.removeRule(test2.getName(), ((Rule)test2.getRules().iterator().next()).getName());
            for (KiePackage kpkg : kbase.getKiePackages()) {
                if (kpkg.getName().equals("org.drools.compiler.test")) {
                    test = kpkg;
                    continue;
                }
                if (!kpkg.getName().equals("org.drools.compiler.test2")) continue;
                test2 = kpkg;
            }
            Assertions.assertThat((Object)test).isNotNull();
            Assertions.assertThat((Object)test2).isNotNull();
            Assertions.assertThat((int)test.getRules().size()).isEqualTo(0);
            Assertions.assertThat((int)test2.getRules().size()).isEqualTo(0);
            list = new ArrayList(ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)));
            Assertions.assertThat((int)list.size()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testLogicalInsertions() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertions.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        Collection kpkgs = kbuilder.getKnowledgePackages();
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kpkgs);
        KieSession session = this.createKnowledgeSession((KieBase)kbase);
        try {
            ArrayList list = new ArrayList();
            session.setGlobal("list", list);
            Cheese brie = new Cheese("brie", 12);
            FactHandle brieHandle = session.insert((Object)brie);
            Cheese provolone = new Cheese("provolone", 12);
            FactHandle provoloneHandle = session.insert((Object)provolone);
            session.fireAllRules();
            session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
            System.out.println(list);
            Assertions.assertThat((int)list.size()).isEqualTo(3);
            Assertions.assertThat((int)session.getObjects().size()).isEqualTo(3);
            brieHandle = this.getFactHandle(brieHandle, session);
            session.delete(brieHandle);
            session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
            Assertions.assertThat((int)session.getObjects().size()).isEqualTo(2);
            provoloneHandle = this.getFactHandle(provoloneHandle, session);
            session.delete(provoloneHandle);
            session.fireAllRules();
            Assertions.assertThat((int)session.getObjects().size()).isEqualTo(0);
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testLogicalInsertionsBacking() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertionsBacking.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        Collection kpkgs = kbuilder.getKnowledgePackages();
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kpkgs);
        KieSession session = this.createKnowledgeSession((KieBase)kbase);
        try {
            Cheese cheese1 = new Cheese("c", 1);
            Cheese cheese2 = new Cheese(cheese1.getType(), 1);
            FactHandle h1 = session.insert((Object)cheese1);
            session.fireAllRules();
            session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
            Collection list = session.getObjects((ObjectFilter)new ClassObjectFilter(cheese1.getType().getClass()));
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat(list.iterator().next()).isEqualTo((Object)cheese1.getType());
            FactHandle h2 = session.insert((Object)cheese2);
            session.fireAllRules();
            session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
            list = session.getObjects((ObjectFilter)new ClassObjectFilter(cheese1.getType().getClass()));
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat(list.iterator().next()).isEqualTo((Object)cheese1.getType());
            Assertions.assertThat((int)session.getObjects().size()).isEqualTo(3);
            h1 = this.getFactHandle(h1, session);
            session.delete(h1);
            session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
            session.fireAllRules();
            session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
            list = session.getObjects((ObjectFilter)new ClassObjectFilter(cheese1.getType().getClass()));
            ((AbstractIntegerAssert)Assertions.assertThat((int)list.size()).as("cheese-type " + cheese1.getType() + " was deleted, but should not. Backed by cheese2 => type.", new Object[0])).isEqualTo(1);
            ((ObjectAssert)Assertions.assertThat(list.iterator().next()).as("cheese-type " + cheese1.getType() + " was deleted, but should not. Backed by cheese2 => type.", new Object[0])).isEqualTo((Object)cheese1.getType());
            h2 = this.getFactHandle(h2, session);
            session.delete(h2);
            session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
            session.fireAllRules();
            session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
            list = session.getObjects((ObjectFilter)new ClassObjectFilter(cheese1.getType().getClass()));
            ((AbstractIntegerAssert)Assertions.assertThat((int)list.size()).as("cheese-type " + cheese1.getType() + " was not deleted, but should have. Neither  cheese1 => type nor cheese2 => type is true.", new Object[0])).isEqualTo(0);
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testLogicalInsertionsWithModify() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"test_LogicalInsertionsWithUpdate.drl"});
        KieSession ksession = kbase.newKieSession();
        try {
            Person p = new Person("person");
            p.setAge(2);
            FactHandle h = ksession.insert((Object)p);
            Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(1);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, false);
            Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(2);
            Collection l = ksession.getObjects((ObjectFilter)new ClassObjectFilter(CheeseEqual.class));
            Assertions.assertThat((int)l.size()).isEqualTo(1);
            Assertions.assertThat((int)((CheeseEqual)l.iterator().next()).getPrice()).isEqualTo(2);
            h = this.getFactHandle(h, ksession);
            ksession.delete(h);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, false);
            Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(0);
            TruthMaintenanceSystem tms = TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((ReteEvaluator)ksession);
            Field field = tms.getClass().getDeclaredField("equalityKeyMap");
            field.setAccessible(true);
            Map m = (Map)field.get(tms);
            field.setAccessible(false);
            ((AbstractIntegerAssert)Assertions.assertThat((int)m.size()).as("assertMap should be empty", new Object[0])).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testLogicalInsertions2() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"test_LogicalInsertions2.drl"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList events = new ArrayList();
            ksession.setGlobal("events", events);
            Sensor sensor = new Sensor(80, 80);
            FactHandle handle = ksession.insert((Object)sensor);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, false);
            ksession.fireAllRules();
            Collection list = ksession.getObjects();
            ((AbstractIntegerAssert)Assertions.assertThat((int)list.size()).as("Only sensor is there", new Object[0])).isEqualTo(1);
            ((AbstractIntegerAssert)Assertions.assertThat((int)events.size()).as("Only one event", new Object[0])).isEqualTo(1);
            sensor.setPressure(200);
            sensor.setTemperature(200);
            handle = this.getFactHandle(handle, ksession);
            ksession.update(handle, (Object)sensor);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.fireAllRules();
            list = ksession.getObjects();
            ((AbstractIntegerAssert)Assertions.assertThat((int)list.size()).as("Only sensor is there", new Object[0])).isEqualTo(1);
            TruthMaintenanceSystem tms = TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((ReteEvaluator)ksession);
            Assertions.assertThat((int)tms.getEqualityKeysSize()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testLogicalInsertionsNot() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"test_LogicalInsertionsNot.drl"});
        KieSession ksession = kbase.newKieSession();
        try {
            Person a = new Person("a");
            Cheese cheese = new Cheese("brie", 1);
            ksession.setGlobal("cheese", (Object)cheese);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Collection list = ksession.getObjects();
            ((AbstractIntegerAssert)Assertions.assertThat((int)list.size()).as("i was not asserted by not a => i.", new Object[0])).isEqualTo(1);
            ((ObjectAssert)Assertions.assertThat(list.iterator().next()).as("i was not asserted by not a => i.", new Object[0])).isEqualTo((Object)cheese);
            FactHandle h = ksession.insert((Object)a);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.fireAllRules();
            list = ksession.getObjects();
            ((AbstractIntegerAssert)Assertions.assertThat((int)list.size()).as("a was not asserted or i not deleted.", new Object[0])).isEqualTo(1);
            ((ObjectAssert)Assertions.assertThat(list.iterator().next()).as("a was asserted.", new Object[0])).isEqualTo((Object)a);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)list.contains(cheese)).as("i was not rectracted.", new Object[0])).isFalse();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((StatefulKnowledgeSessionImpl)ksession).getAgenda().getAgendaGroupsManager().agendaSize()).as("agenda should be empty.", new Object[0])).isEqualTo(0);
            h = this.getFactHandle(h, ksession);
            ksession.delete(h);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            list = ksession.getObjects();
            ((AbstractIntegerAssert)Assertions.assertThat((int)list.size()).as("i was not asserted by not a => i.", new Object[0])).isEqualTo(1);
            ((ObjectAssert)Assertions.assertThat(list.iterator().next()).as("i was not asserted by not a => i.", new Object[0])).isEqualTo((Object)cheese);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    @Ignore(value="Currently cannot support updates")
    public void testLogicalInsertionsUpdateEqual() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"test_LogicalInsertionsUpdateEqual.drl"});
        KieSession ksession = kbase.newKieSession();
        try {
            Person p = new Person("person");
            p.setAge(2);
            FactHandle h = ksession.insert((Object)p);
            Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(1);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(2);
            Collection l = ksession.getObjects((ObjectFilter)new ClassObjectFilter(CheeseEqual.class));
            Assertions.assertThat((int)l.size()).isEqualTo(1);
            Assertions.assertThat((int)((CheeseEqual)l.iterator().next()).getPrice()).isEqualTo(3);
            h = this.getFactHandle(h, ksession);
            ksession.delete(h);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Collection list = ksession.getObjects();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat(list.iterator().next()).isEqualTo((Object)new CheeseEqual("person", 3));
            FactHandle fh = ksession.getFactHandle(list.iterator().next());
            ksession.delete(fh);
            list = ksession.getObjects();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            TruthMaintenanceSystem tms = TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((ReteEvaluator)ksession);
            Field field = tms.getClass().getDeclaredField("equalityKeyMap");
            field.setAccessible(true);
            Map m = (Map)field.get(tms);
            field.setAccessible(false);
            ((AbstractIntegerAssert)Assertions.assertThat((int)m.size()).as("assertMap should be empty", new Object[0])).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testLogicalInsertionsWithExists() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"test_LogicalInsertionWithExists.drl"});
        KieSession ksession = kbase.newKieSession();
        try {
            Person p1 = new Person("p1", "stilton", 20);
            p1.setStatus("europe");
            FactHandle c1FactHandle = ksession.insert((Object)p1);
            Person p2 = new Person("p2", "stilton", 30);
            p2.setStatus("europe");
            FactHandle c2FactHandle = ksession.insert((Object)p2);
            Person p3 = new Person("p3", "stilton", 40);
            p3.setStatus("europe");
            FactHandle c3FactHandle = ksession.insert((Object)p3);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Collection cheeseList = ksession.getObjects((ObjectFilter)new ClassObjectFilter(Cheese.class));
            Assertions.assertThat((int)cheeseList.size()).isEqualTo(2);
            p3.setStatus("america");
            c3FactHandle = this.getFactHandle(c3FactHandle, ksession);
            ksession.update(c3FactHandle, (Object)p3);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            cheeseList = ksession.getObjects((ObjectFilter)new ClassObjectFilter(Cheese.class));
            Assertions.assertThat((int)cheeseList.size()).isEqualTo(1);
            p2.setStatus("america");
            c2FactHandle = this.getFactHandle(c2FactHandle, ksession);
            ksession.update(c2FactHandle, (Object)p2);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            cheeseList = ksession.getObjects((ObjectFilter)new ClassObjectFilter(Cheese.class));
            Assertions.assertThat((int)cheeseList.size()).isEqualTo(1);
            p1.setStatus("america");
            c1FactHandle = this.getFactHandle(c1FactHandle, ksession);
            ksession.update(c1FactHandle, (Object)p1);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            cheeseList = ksession.getObjects((ObjectFilter)new ClassObjectFilter(Cheese.class));
            Assertions.assertThat((int)cheeseList.size()).isEqualTo(2);
            p2.setStatus("europe");
            c2FactHandle = this.getFactHandle(c2FactHandle, ksession);
            ksession.update(c2FactHandle, (Object)p2);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            cheeseList = ksession.getObjects((ObjectFilter)new ClassObjectFilter(Cheese.class));
            Assertions.assertThat((int)cheeseList.size()).isEqualTo(1);
            p1.setStatus("europe");
            c1FactHandle = this.getFactHandle(c1FactHandle, ksession);
            ksession.update(c1FactHandle, (Object)p1);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            cheeseList = ksession.getObjects((ObjectFilter)new ClassObjectFilter(Cheese.class));
            Assertions.assertThat((int)cheeseList.size()).isEqualTo(1);
            p3.setStatus("europe");
            c3FactHandle = this.getFactHandle(c3FactHandle, ksession);
            ksession.update(c3FactHandle, (Object)p3);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            cheeseList = ksession.getObjects((ObjectFilter)new ClassObjectFilter(Cheese.class));
            Assertions.assertThat((int)cheeseList.size()).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testLogicalInsertions3() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"test_logicalInsertions3.drl"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("events", list);
            Sensor sensor = new Sensor(150, 100);
            FactHandle sensorHandle = ksession.insert((Object)sensor);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(2);
            sensor.setTemperature(125);
            sensorHandle = this.getFactHandle(sensorHandle, ksession);
            ksession.update(sensorHandle, (Object)sensor);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assertions.assertThat((int)list.size()).isEqualTo(3);
            Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(2);
            sensor.setTemperature(80);
            sensorHandle = this.getFactHandle(sensorHandle, ksession);
            ksession.update(sensorHandle, (Object)sensor);
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(3);
            Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testLogicalInsertionsAccumulatorPattern() throws Exception {
        KieBase kbase = this.loadKnowledgeBase(new String[]{"test_LogicalInsertionsAccumulatorPattern.drl"});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.setGlobal("ga", (Object)"a");
            ksession.setGlobal("gb", (Object)"b");
            ksession.setGlobal("gs", (Object)3);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            FactHandle h = ksession.insert((Object)6);
            Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(1);
            ksession.fireAllRules();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            ((AbstractIntegerAssert)Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(CheeseEqual.class)).size()).as("There should be 2 CheeseEqual in Working Memory, 1 justified, 1 stated", new Object[0])).isEqualTo(2);
            Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(6);
            h = this.getFactHandle(h, ksession);
            ksession.delete(h);
            ksession.fireAllRules();
            for (Object o : ksession.getObjects()) {
                System.out.println(o);
            }
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
            Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(CheeseEqual.class)).size()).isEqualTo(0);
            Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(Short.class)).size()).isEqualTo(0);
            Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testLogicalInsertionsModifySameRuleGivesDifferentLogicalInsertion() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertionsModifySameRuleGivesDifferentLogicalInsertion.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        Collection pkgs = kbuilder.getKnowledgePackages();
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kbase.addPackages(pkgs);
        KieSession session = this.createKnowledgeSession((KieBase)kbase);
        try {
            Sensor sensor1 = new Sensor(100, 0);
            FactHandle sensor1Handle = session.insert((Object)sensor1);
            Sensor sensor2 = new Sensor(200, 0);
            FactHandle sensor2Handle = session.insert((Object)sensor2);
            Sensor sensor3 = new Sensor(200, 0);
            FactHandle sensor3Handle = session.insert((Object)sensor3);
            session.fireAllRules();
            session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
            ArrayList temperatureList = new ArrayList(session.getObjects((ObjectFilter)new ClassObjectFilter(Integer.class)));
            Assertions.assertThat((boolean)temperatureList.contains(100)).isTrue();
            Assertions.assertThat((boolean)temperatureList.contains(200)).isTrue();
            Assertions.assertThat((int)temperatureList.size()).isEqualTo(2);
            sensor1.setTemperature(150);
            sensor1Handle = this.getFactHandle(sensor1Handle, session);
            session.update(sensor1Handle, (Object)sensor1);
            session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
            session.fireAllRules();
            temperatureList = new ArrayList(session.getObjects((ObjectFilter)new ClassObjectFilter(Integer.class)));
            Assertions.assertThat((boolean)temperatureList.contains(100)).isFalse();
            Assertions.assertThat((boolean)temperatureList.contains(150)).isTrue();
            Assertions.assertThat((boolean)temperatureList.contains(200)).isTrue();
            Assertions.assertThat((int)temperatureList.size()).isEqualTo(2);
        }
        finally {
            session.dispose();
        }
    }

    public InternalFactHandle getFactHandle(FactHandle factHandle, StatefulKnowledgeSessionImpl session) {
        HashMap<Long, FactHandle> handles = new HashMap<Long, FactHandle>();
        for (FactHandle fh : session.getFactHandles()) {
            handles.put(((InternalFactHandle)fh).getId(), fh);
        }
        return (InternalFactHandle)handles.get(((InternalFactHandle)factHandle).getId());
    }

    public InternalFactHandle getFactHandle(FactHandle factHandle, KieSession ksession) {
        HashMap<Long, FactHandle> handles = new HashMap<Long, FactHandle>();
        for (FactHandle fh : ksession.getFactHandles()) {
            handles.put(((InternalFactHandle)fh).getId(), fh);
        }
        return (InternalFactHandle)handles.get(((InternalFactHandle)factHandle).getId());
    }
}

