/*
 * Decompiled with CFR 0.152.
 */
package org.drools.simulation.impl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.drools.command.Command;
import org.drools.command.Context;
import org.drools.command.ContextManager;
import org.drools.command.KnowledgeContextResolveFromContextCommand;
import org.drools.command.NewStatefulKnowledgeSessionCommand;
import org.drools.command.impl.ContextImpl;
import org.drools.command.impl.GenericCommand;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.simulation.Path;
import org.drools.simulation.Simulation;
import org.drools.simulation.Step;
import org.drools.simulation.impl.PathImpl;
import org.drools.simulation.impl.SimulationImpl;
import org.drools.simulation.impl.StepImpl;
import org.drools.time.SessionPseudoClock;

public class Simulator
implements ContextManager {
    private PriorityQueue<Step> queue;
    private SimulationImpl simulation;
    private long startTime;
    private Context root;
    private Map<String, Context> contexts;
    private String ROOT = "ROOT";
    private Set<StatefulKnowledgeSession> ksessions;
    private CommandExecutionHandler executionHandler = new DefaultCommandExecutionHandler();

    public Simulator(Simulation simulation, long startTime) {
        this.ksessions = new HashSet<StatefulKnowledgeSession>();
        this.startTime = startTime;
        this.simulation = (SimulationImpl)simulation;
        this.root = new ContextImpl(this.ROOT, (ContextManager)this);
        this.contexts = new HashMap<String, Context>();
        this.contexts.put(this.ROOT, this.root);
        Map<String, Path> paths = this.simulation.getPaths();
        int capacity = 0;
        for (Path path : paths.values()) {
            this.contexts.put(path.getName(), (Context)new ContextImpl(path.getName(), (ContextManager)this, this.root));
            capacity += path.getSteps().size();
        }
        if (capacity == 0) {
            return;
        }
        this.queue = new PriorityQueue<Step>(capacity, new Comparator<Step>(){

            @Override
            public int compare(Step s1, Step s2) {
                return (int)(s1.getTemporalDistance() - s2.getTemporalDistance());
            }
        });
        for (Path path : paths.values()) {
            for (Step step : path.getSteps()) {
                this.queue.add(step);
            }
        }
    }

    public void run() {
        Step step;
        while ((step = this.executeNextStep()) != null) {
        }
    }

    public Step executeNextStep() {
        if (this.queue.isEmpty()) {
            return null;
        }
        StepImpl step = (StepImpl)this.queue.remove();
        PathImpl path = (PathImpl)step.getPath();
        Context pathContext = this.contexts.get(path.getName());
        for (StatefulKnowledgeSession ksession : this.ksessions) {
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            long newTime = this.startTime + step.getTemporalDistance();
            long currentTime = clock.getCurrentTime();
            clock.advanceTime(currentTime + (newTime - currentTime), TimeUnit.MICROSECONDS);
        }
        for (Command cmd : step.getCommands()) {
            if (cmd instanceof KnowledgeContextResolveFromContextCommand) {
                if (((KnowledgeContextResolveFromContextCommand)cmd).getCommand() instanceof NewStatefulKnowledgeSessionCommand) {
                    StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)this.executionHandler.execute((GenericCommand)cmd, pathContext);
                    if (ksession == null) continue;
                    SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
                    if (clock.getCurrentTime() == 0L) {
                        clock.advanceTime(this.startTime, TimeUnit.MILLISECONDS);
                    }
                    this.ksessions.add(ksession);
                    continue;
                }
                if (!(cmd instanceof GenericCommand)) continue;
                this.executionHandler.execute((GenericCommand)cmd, pathContext);
                continue;
            }
            if (!(cmd instanceof GenericCommand)) continue;
            this.executionHandler.execute((GenericCommand)cmd, pathContext);
        }
        return step;
    }

    public void setCommandExecutionHandler(CommandExecutionHandler executionHandler) {
        this.executionHandler = executionHandler;
    }

    public Context getContext(String identifier) {
        return this.contexts.get(identifier);
    }

    public Context getDefaultContext() {
        return this.root;
    }

    public Simulation getSimulation() {
        return this.simulation;
    }

    public static class DefaultCommandExecutionHandler
    implements CommandExecutionHandler {
        public Object execute(GenericCommand command, Context context) {
            return command.execute(context);
        }
    }

    public static interface CommandExecutionHandler {
        public Object execute(GenericCommand var1, Context var2);
    }
}

