/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.drools.Address;
import org.drools.Cheese;
import org.drools.PersonInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Person
implements Serializable,
PersonInterface {
    private static final long serialVersionUID = 510L;
    private String name;
    private String likes;
    private int age;
    private BigDecimal bigDecimal;
    private BigInteger bigInteger;
    private String hair;
    private char sex;
    private boolean alive;
    private String status;
    private Cheese cheese;
    private List<Address> addresses = new ArrayList<Address>();

    public Person() {
    }

    public Person(String name, int age) {
        this.name = name;
        this.age = age;
    }

    public Person(String name) {
        this(name, "", 0);
    }

    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public void addAddress(Address address) {
        this.addresses.add(address);
    }

    public Person(String name, String likes) {
        this(name, likes, 0);
    }

    public Person(String name, String likes, int age) {
        this.name = name;
        this.likes = likes;
        this.age = age;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String getLikes() {
        return this.likes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    @Override
    public boolean isAlive() {
        return this.alive;
    }

    @Override
    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    @Override
    public char getSex() {
        return this.sex;
    }

    @Override
    public void setSex(char sex) {
        this.sex = sex;
    }

    public String getHair() {
        return this.hair;
    }

    public void setHair(String hair) {
        this.hair = hair;
    }

    public String toString() {
        return "[Person name='" + this.name + "']";
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.age;
        result = 31 * result + (this.alive ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.sex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Person other = (Person)obj;
        if (this.age != other.age) {
            return false;
        }
        if (this.alive != other.alive) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.sex == other.sex;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return this.bigDecimal;
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) {
        this.bigDecimal = bigDecimal;
    }

    @Override
    public BigInteger getBigInteger() {
        return this.bigInteger;
    }

    @Override
    public void setBigInteger(BigInteger bigInteger) {
        this.bigInteger = bigInteger;
    }

    public void setLikes(String likes) {
        this.likes = likes;
    }

    public Cheese getCheese() {
        return this.cheese;
    }

    public void setCheese(Cheese cheese) {
        this.cheese = cheese;
    }
}

