/*
 * Decompiled with CFR 0.152.
 */
package org.drools.simulation.impl.command;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.event.rule.ActivationCancelledEvent;
import org.drools.event.rule.ActivationCreatedEvent;
import org.drools.event.rule.AfterActivationFiredEvent;
import org.drools.event.rule.AgendaEventListener;
import org.drools.event.rule.AgendaGroupPoppedEvent;
import org.drools.event.rule.AgendaGroupPushedEvent;
import org.drools.event.rule.BeforeActivationFiredEvent;
import org.drools.event.rule.RuleFlowGroupActivatedEvent;
import org.drools.event.rule.RuleFlowGroupDeactivatedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FiredRuleCounter
implements AgendaEventListener {
    private List<String> inclusiveRuleNameList = null;
    private List<String> exclusiveRuleNameList = null;
    private Map<String, Integer> ruleNameToFireCountMap = new HashMap<String, Integer>();

    public List<String> getInclusiveRuleNameList() {
        return this.inclusiveRuleNameList;
    }

    public void setInclusiveRuleNameList(List<String> inclusiveRuleNameList) {
        this.inclusiveRuleNameList = inclusiveRuleNameList;
    }

    public List<String> getExclusiveRuleNameList() {
        return this.exclusiveRuleNameList;
    }

    public void setExclusiveRuleNameList(List<String> exclusiveRuleNameList) {
        this.exclusiveRuleNameList = exclusiveRuleNameList;
    }

    public void activationCreated(ActivationCreatedEvent event) {
    }

    public void activationCancelled(ActivationCancelledEvent event) {
    }

    public void beforeActivationFired(BeforeActivationFiredEvent event) {
    }

    public void afterActivationFired(AfterActivationFiredEvent event) {
        String ruleName = event.getActivation().getRule().getName();
        if (this.acceptRuleName(ruleName)) {
            this.incrementFireCount(ruleName);
        }
    }

    private boolean acceptRuleName(String ruleName) {
        if (this.inclusiveRuleNameList != null && !this.inclusiveRuleNameList.contains(ruleName)) {
            return false;
        }
        return this.exclusiveRuleNameList == null || !this.exclusiveRuleNameList.contains(ruleName);
    }

    private void incrementFireCount(String ruleName) {
        Integer fireCount = this.ruleNameToFireCountMap.get(ruleName);
        if (fireCount == null) {
            fireCount = 1;
        } else {
            Integer n = fireCount;
            Integer n2 = fireCount = Integer.valueOf(fireCount + 1);
        }
        this.ruleNameToFireCountMap.put(ruleName, fireCount);
    }

    public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
    }

    public void agendaGroupPushed(AgendaGroupPushedEvent event) {
    }

    public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
    }

    public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
    }

    public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
    }

    public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
    }

    public int getRuleNameFireCount(String ruleName) {
        Integer fireCount = this.ruleNameToFireCountMap.get(ruleName);
        return fireCount == null ? 0 : fireCount;
    }
}

