/*
 * Decompiled with CFR 0.152.
 */
package org.drools.simulation.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.command.Command;
import org.drools.command.Context;
import org.drools.command.impl.GenericCommand;
import org.drools.simulation.Simulation;
import org.drools.simulation.SimulationPath;
import org.drools.simulation.SimulationStep;
import org.drools.simulation.impl.Simulator;
import org.drools.simulation.impl.TestGroupCommand;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class JUnitSimulationRunner
extends Runner {
    private Description descr;
    private Map<String, Description> testGroups = new HashMap<String, Description>();
    private List<Simulation> simulations = new ArrayList<Simulation>();

    public JUnitSimulationRunner(Class cls) {
        this.descr = Description.createSuiteDescription((Class)cls);
        Object object = null;
        try {
            object = cls.newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : cls.getDeclaredMethods()) {
            if (!method.getReturnType().equals(Simulation.class) || method.getAnnotation(Test.class) == null) continue;
            methods.add(method);
        }
        try {
            for (Method method : methods) {
                Simulation simulation = (Simulation)method.invoke(object, null);
                for (SimulationPath path : simulation.getPaths().values()) {
                    for (SimulationStep step : path.getSteps()) {
                        for (Command command : step.getCommands()) {
                            if (!(command instanceof TestGroupCommand)) continue;
                            String testName = ((TestGroupCommand)command).getName();
                            Description testGroupDescr = Description.createTestDescription((Class)cls, (String)testName);
                            this.descr.addChild(testGroupDescr);
                            this.testGroups.put(testName, testGroupDescr);
                        }
                    }
                }
                this.simulations.add(simulation);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public Description getDescription() {
        return this.descr;
    }

    public void run(RunNotifier notifier) {
        JunitCommandExecutionHandler executionHandler = new JunitCommandExecutionHandler(notifier, this.testGroups);
        for (Simulation simulation : this.simulations) {
            Simulator simulator = new Simulator(simulation, System.currentTimeMillis());
            simulator.setCommandExecutionHandler(executionHandler);
            simulator.run();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JunitCommandExecutionHandler
    implements Simulator.CommandExecutionHandler {
        private RunNotifier notifier;
        private Map<String, Description> testGroups;

        public JunitCommandExecutionHandler(RunNotifier notifier, Map<String, Description> testGroups) {
            this.notifier = notifier;
            this.testGroups = testGroups;
        }

        @Override
        public Object execute(GenericCommand command, Context context) {
            if (command instanceof TestGroupCommand) {
                TestGroupCommand testGroupCmd = (TestGroupCommand)command;
                Description descr = this.testGroups.get(testGroupCmd.getName());
                this.notifier.fireTestStarted(descr);
                try {
                    command.execute(context);
                    this.notifier.fireTestFinished(descr);
                    return null;
                }
                catch (Exception e) {
                    this.notifier.fireTestFailure(new Failure(descr, (Throwable)e));
                    return null;
                }
            }
            return command.execute(context);
        }
    }
}

