/*
 * Copyright 2011 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.fluent.knowledge.impl;

import org.drools.command.KnowledgeBaseAddKnowledgePackagesCommand;
import org.drools.command.SetVariableCommandFromLastReturn;
import org.drools.command.builder.KnowledgeBuilderAddCommand;
import org.drools.fluent.knowledge.KnowledgeBaseSimFluent;
import org.drools.fluent.simulation.SimulationFluent;
import org.drools.fluent.test.impl.AbstractTestableFluent;
import org.kie.command.Command;
import org.kie.io.Resource;
import org.kie.io.ResourceConfiguration;
import org.kie.io.ResourceType;

public class DefaultKnowledgeBaseSimFluent extends AbstractTestableFluent<KnowledgeBaseSimFluent>
        implements KnowledgeBaseSimFluent {

    private SimulationFluent simulationFluent;
    
    public DefaultKnowledgeBaseSimFluent(SimulationFluent simulationFluent) {
        this.simulationFluent = simulationFluent;
    }

    protected KnowledgeBaseSimFluent addCommand(Command command) {
        simulationFluent.addCommand(command);
        return this;
    }
    
    public KnowledgeBaseSimFluent addKnowledgePackages() {
        addCommand(new KnowledgeBaseAddKnowledgePackagesCommand());
        return this;
    }
    
    public KnowledgeBaseSimFluent addKnowledgePackages(Resource resource,
                                                            ResourceType type) {
        addCommand(new KnowledgeBuilderAddCommand(resource,
                type,
                null));
        return this;
    }

    public KnowledgeBaseSimFluent addKnowledgePackages(Resource resource,
                                                            ResourceType type,
                                                            ResourceConfiguration configuration) {
        addCommand(new KnowledgeBuilderAddCommand(resource,
                type,
                configuration));
        
        return this;
    }

    public SimulationFluent end(String context, String name) {
        addCommand(new SetVariableCommandFromLastReturn(context, name));
        return simulationFluent;
    }

    public SimulationFluent end(String name) {
        addCommand(new SetVariableCommandFromLastReturn(name));
        return simulationFluent;
    }

    public SimulationFluent end() {
        return simulationFluent;
    }

}
