/*
 * Decompiled with CFR 0.152.
 */
package org.drools.simulation.impl;

import java.util.ArrayList;
import org.drools.command.runtime.BatchExecutionCommandImpl;
import org.drools.fluent.batch.FluentBatchExecution;
import org.drools.fluent.batch.imp.FluentBatchExecutionImpl;
import org.drools.io.impl.ByteArrayResource;
import org.drools.simulation.impl.Person;
import org.junit.Assert;
import org.junit.Test;
import org.kie.KnowledgeBase;
import org.kie.KnowledgeBaseFactory;
import org.kie.builder.KnowledgeBuilder;
import org.kie.builder.KnowledgeBuilderFactory;
import org.kie.command.BatchExecutionCommand;
import org.kie.command.Command;
import org.kie.io.Resource;
import org.kie.io.ResourceType;
import org.kie.runtime.ExecutionResults;
import org.kie.runtime.StatelessKnowledgeSession;

public class BatchFluentTest {
    @Test
    public void testBatchSimple() {
        FluentBatchExecutionImpl f = new FluentBatchExecutionImpl();
        ArrayList list = new ArrayList();
        BatchExecutionCommand cmd = ((FluentBatchExecution)((FluentBatchExecution)((FluentBatchExecution)((FluentBatchExecution)((FluentBatchExecution)((FluentBatchExecution)f.newBatchExecution().setGlobal("list", list)).insert((Object)new Person("yoda", 150))).set("y")).insert((Object)new Person("salaboy", 28))).set("x")).fireAllRules()).getBatchExecution();
        Assert.assertEquals((long)4L, (long)((BatchExecutionCommandImpl)cmd).getCommands().size());
        ExecutionResults results = (ExecutionResults)this.createStatelessSession().execute((Command)cmd);
        Assert.assertEquals((long)2L, (long)results.getIdentifiers().size());
        Assert.assertEquals((Object)"y", (Object)((String)results.getIdentifiers().toArray()[0]));
        Assert.assertEquals((Object)"x", (Object)((String)results.getIdentifiers().toArray()[1]));
    }

    @Test
    public void testBatchSimpleWithSetInGlobal() {
        FluentBatchExecutionImpl f = new FluentBatchExecutionImpl();
        ArrayList list = new ArrayList();
        BatchExecutionCommand cmd = ((FluentBatchExecution)((FluentBatchExecution)((FluentBatchExecution)((FluentBatchExecution)((FluentBatchExecution)((FluentBatchExecution)((FluentBatchExecution)f.newBatchExecution().setGlobal("list", list)).set("myGlobal")).insert((Object)new Person("yoda", 150))).set("y")).insert((Object)new Person("salaboy", 28))).set("x")).fireAllRules()).getBatchExecution();
        Assert.assertEquals((long)4L, (long)((BatchExecutionCommandImpl)cmd).getCommands().size());
        ExecutionResults results = (ExecutionResults)this.createStatelessSession().execute((Command)cmd);
        Assert.assertEquals((long)3L, (long)results.getIdentifiers().size());
        Assert.assertEquals((Object)"myGlobal", (Object)((String)results.getIdentifiers().toArray()[0]));
        Assert.assertEquals((Object)"y", (Object)((String)results.getIdentifiers().toArray()[1]));
        Assert.assertEquals((Object)"x", (Object)((String)results.getIdentifiers().toArray()[2]));
    }

    private StatelessKnowledgeSession createStatelessSession() {
        String str = "package org.drools.simulation.test\nimport " + Person.class.getName() + "\n" + "global java.util.List list\n" + "rule updateAge no-loop\n" + "  when\n" + "    $p : Person()\n" + "  then\n" + "    modify( $p ) { setAge( $p.getAge() + 10 ) };\n" + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(str.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase.newStatelessKnowledgeSession();
    }
}

