/*
 * Decompiled with CFR 0.152.
 */
package org.drools.simulation.impl.command;

import java.util.HashMap;
import java.util.Map;
import org.drools.command.impl.GenericCommand;
import org.drools.simulation.impl.command.FiredRuleCounter;
import org.junit.Assert;
import org.kie.command.Context;

public class AssertRulesFiredCommand
implements GenericCommand<Object> {
    private FiredRuleCounter firedRuleCounter;
    private Map<String, Integer> ruleNameToExpectedFireCountMap = new HashMap<String, Integer>();

    public AssertRulesFiredCommand() {
    }

    public AssertRulesFiredCommand(FiredRuleCounter firedRuleCounter) {
        this.firedRuleCounter = firedRuleCounter;
    }

    public FiredRuleCounter getFiredRuleCounter() {
        return this.firedRuleCounter;
    }

    public void setFiredRuleCounter(FiredRuleCounter firedRuleCounter) {
        this.firedRuleCounter = firedRuleCounter;
    }

    public void addAssertRuleFired(String ruleName, int fireCount) {
        this.ruleNameToExpectedFireCountMap.put(ruleName, fireCount);
    }

    public void addAssertRuleNotFired(String ruleName) {
        this.addAssertRuleFired(ruleName, 0);
    }

    public Object execute(Context context) {
        for (Map.Entry<String, Integer> entry : this.ruleNameToExpectedFireCountMap.entrySet()) {
            String ruleName = entry.getKey();
            int expectedFireCount = entry.getValue();
            int actualFireCount = this.firedRuleCounter.getRuleNameFireCount(ruleName);
            Assert.assertEquals((String)("The rule (" + ruleName + ")'s fireCount is incorrect."), (long)expectedFireCount, (long)actualFireCount);
        }
        return null;
    }
}

