/*
 * Decompiled with CFR 0.152.
 */
package org.drools.simulation.impl;

import java.io.IOException;
import java.util.ArrayList;
import org.drools.simulation.fluent.session.KieSessionSimulationFluent;
import org.drools.simulation.fluent.simulation.SimulateTestBase;
import org.drools.simulation.fluent.simulation.SimulationFluent;
import org.drools.simulation.fluent.simulation.impl.DefaultSimulationFluent;
import org.drools.simulation.fluent.test.impl.ReflectiveMatcherFactory;
import org.drools.simulation.impl.Person;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.builder.ReleaseId;
import org.kie.internal.fluent.VariableContext;

public class CompactFluentTest
extends SimulateTestBase {
    @Test
    public void testSimpleForAllAssertionsTypes() throws IOException {
        DefaultSimulationFluent f = new DefaultSimulationFluent();
        VariableContext pc = f.getVariableContext();
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("org.junit.Assert.assertThat");
        imports.add("org.hamcrest.CoreMatchers.is");
        imports.add("org.hamcrest.CoreMatchers.equalTo");
        imports.add("org.hamcrest.CoreMatchers.allOf");
        ReflectiveMatcherFactory rf = new ReflectiveMatcherFactory(imports);
        String str = "package org.drools.simulation.test\nimport " + Person.class.getName() + "\n" + "rule updateAge no-loop when  $p : Person() then modify( $p ) { setAge( $p.getAge() + 10 ) }; end\n";
        ReleaseId releaseId = this.createKJar("org.test.KBase1", str);
        ((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)f.newKieSession(releaseId, "org.test.KBase1.KSession1").insert((Object)new Person("yoda", 150))).set("y")).fireAllRules()).test("y.name == 'yoda'")).test("y.age == 160")).test(rf.assertThat("y.name", ReflectiveMatcherFactory.matcher((String)"equalTo", (Object)"'yoda'")))).test(rf.assertThat("y.name, equalTo('yoda')"))).test(rf.assertThat("y.age", ReflectiveMatcherFactory.matcher((String)"equalTo", (Object)"160")))).test(rf.assertThat("y.age, equalTo(160)"))).end()).test("y.name == 'yoda'")).test("y.age == 160")).test(rf.assertThat("y.name", ReflectiveMatcherFactory.matcher((String)"equalTo", (Object)"'yoda'")))).test(rf.assertThat("y.age", ReflectiveMatcherFactory.matcher((String)"equalTo", (Object)"160")))).runSimulation();
    }

    @Test
    public void testAssertionsFail() throws IOException {
        DefaultSimulationFluent f = new DefaultSimulationFluent();
        VariableContext pc = f.getVariableContext();
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("org.junit.Assert.assertThat");
        imports.add("org.hamcrest.CoreMatchers.is");
        imports.add("org.hamcrest.CoreMatchers.equalTo");
        imports.add("org.hamcrest.CoreMatchers.allOf");
        ReflectiveMatcherFactory rf = new ReflectiveMatcherFactory(imports);
        String str = "package org.drools.simulation.test\nimport " + Person.class.getName() + "\n" + "rule updateAge no-loop when  $p : Person() then modify( $p ) { setAge( $p.getAge() + 10 ) }; end\n";
        ReleaseId releaseId = this.createKJar("org.test.KBase1", str);
        ((KieSessionSimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)f.newKieSession(releaseId, "org.test.KBase1.KSession1").insert((Object)new Person("yoda", 150))).set("y")).fireAllRules()).test("y.age == 110");
        boolean fail = false;
        try {
            f.runSimulation();
        }
        catch (AssertionError e) {
            fail = true;
        }
        Assert.assertTrue((String)"Assertion should have failed", (boolean)fail);
        f = new DefaultSimulationFluent();
        ((KieSessionSimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)f.newKieSession(releaseId, "org.test.KBase1.KSession1").insert((Object)new Person("yoda", 150))).set("y")).fireAllRules()).test(rf.assertThat("y.age", ReflectiveMatcherFactory.matcher((String)"equalTo", (Object)"120")))).test(rf.assertThat("y.age, equalTo(120)"));
        fail = false;
        try {
            f.runSimulation();
        }
        catch (AssertionError e) {
            fail = true;
        }
        Assert.assertTrue((String)"Assertion should have failed", (boolean)fail);
    }

    @Test
    @Ignore(value="Doing newKSession on the same path twice doesn't make the second one the active one")
    public void testMultipleKsessionsWithSteps() throws IOException {
        DefaultSimulationFluent f = new DefaultSimulationFluent();
        VariableContext pc = f.getVariableContext();
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("org.junit.Assert.assertThat");
        imports.add("org.hamcrest.CoreMatchers.is");
        imports.add("org.hamcrest.CoreMatchers.equalTo");
        imports.add("org.hamcrest.CoreMatchers.allOf");
        ReflectiveMatcherFactory rf = new ReflectiveMatcherFactory(imports);
        String str1 = "package org.drools.simulation.test\nimport " + Person.class.getName() + "\n" + "rule updateAge1 no-loop when  $p : Person() then modify( $p ) { setAge( $p.getAge() + 10 ) }; end\n";
        String str2 = "package org.drools.simulation.test\nimport " + Person.class.getName() + "\n" + "rule updateAge2 no-loop when  $p : Person() then modify( $p ) { setAge( $p.getAge() + 20 ) }; end\n";
        ReleaseId releaseId = this.createKJar("org.test.KBase1", str1, "org.test.KBase2", str2);
        ((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)((SimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)((KieSessionSimulationFluent)((SimulationFluent)f.newRelativeStep(100L)).newKieSession(releaseId, "org.test.KBase1.KSession1").insert((Object)new Person("yoda1", 150))).set("y1")).fireAllRules()).newRelativeStep(200L)).insert((Object)new Person("darth1", 70))).set("d1")).fireAllRules()).end()).test("y1.age == 160")).test("d1.age == 80")).newRelativeStep(100L)).newKieSession(releaseId, "org.test.KBase2.KSession1").insert((Object)new Person("yoda2", 150))).set("y2")).fireAllRules()).newRelativeStep(200L)).insert((Object)new Person("darth2", 70))).set("d2")).fireAllRules()).end()).test("y2.age == 170")).test("d2.age == 90")).test("y1 == null")).test("d1 == null")).runSimulation();
    }
}

